
;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

undoreset			
 
	movlw	b'11111011'	; configure FET_Gate_Port  as output GPIO0,1,3 are input
	TRIS 	TRISGPIO
	movlw	B'11001000'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 64:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO

	call	undoreset
		
	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	goto 	MAIN
;******************************************************************************
;MORSE CODE
;******************************************************************************

GETCODE	       movwf TemP 		;w:= morsecode[w] for w in [0..9,A..Z,".",",","?"]
		skpne "." 	
		 GOTO fullstp
		movfw TemP 	
		skpne "," 	
		 GOTO comma
		movfw TemP 	
		skpne "?"	
		 GOTO query
		movfw TemP
		skpl "9"
		 GOTO larger9
numeric	       movlw	aln_bin+1
		addwf	Temp,F
		movlw "0"		;PCLoffset in TemP
		subwf TemP,F
		movlw	.26
		addwf	Temp,W
		goto	aln_bin
		
larger9        	movlw	aln_bin+1
		addwf	Temp,F
		movlw "A"
		subwf TemP,W
	
	
aln_bin	movwf PCL		; coding : 0= dot 1=dash  5 dot/dash + 3bytes length
alpha	retlw b'01000001'  ; A .-
	retlw b'10000011'  ; B -...
	retlw b'10100011'  ; C -.-.
	retlw b'10000010'  ; D -..
	retlw b'00000000'  ; E .
	retlw b'00100011'  ; F ..-.
	retlw b'11000010'  ; G --.
	retlw b'00000011'  ; H ....
	retlw b'00000001'  ; I ..
	retlw b'01110011'  ; J .---
	retlw b'10100010'  ; K -.-
	retlw b'01000011'  ; L .-..
	retlw b'11000001'  ; M --
	retlw b'10000001'  ; N -.
	retlw b'11100010'  ; O ---
	retlw b'01100011'  ; P .--.
	retlw b'11010011'  ; Q --.-
	retlw b'01000010'  ; R .-.
	retlw b'00000010'  ; S ...
	retlw b'10000000'  ; T -
	retlw b'00100010'  ; U ..-
	retlw b'00010011'  ; V ...-
	retlw b'01100010'  ; W .--
	retlw b'10010011'  ; X -..-
	retlw b'10110011'  ; Y -.--
	retlw b'11000011'  ; Z --..

numset	retlw b'11111100'  ; 0 -----
	retlw b'01111100'  ; 1 .----
	retlw b'00111100'  ; 2 ..---
	retlw b'00011100'  ; 3 ...--
	retlw b'00001100'  ; 4 ....-
	retlw b'00000100'  ; 5 .....
	retlw b'10000100'  ; 6 -....
	retlw b'11000100'  ; 7 --...
	retlw b'11100100'  ; 8 ---..
	retlw b'11110100'  ; 9 ----.

fullstp retlw b'01010101'  ; ;Fullstop .-.-.- discrete char
comma	retlw b'11001110'  ; ;Comma --..--    discrete char
query	retlw b'00110111'  ; ;Query   ..--..   discrete char

;**********************************************************************
#define 	startsending 	0x01	; 
zeroAF		movwf 	PCL
		dt 	"0123456789ABCDEF",0	;textstring to output, 0 for endstring
	
MORSE_OUTPUT	movf	NextEntry,F
		skpNZ
		 RETURN
		bsf	Beep_Event
		mov	NextEntry,Temp

		movlw	m_o+1
		addwf	Temp, W
m_o		movwf	PCL
		GOTO	nomorebeep
		GOTO	start_sending		;entry = 1
		GOTO	nextlet			;2
		GOTO	here			;3
		GOTO	morbits			;4
		GOTO	nextchar		; entry=5

nomorebeep     bcf 	Beep_Event
		clrf	NextEntry
		RETURN
;**************************ENTRYPOINT********************************************
start_sending  movfw	TextNmbr		; start events	
		clrf	TextLetter			; next_ entry = nextlet
;**************************ENTRYPOINT********************************************

nextlet	       movlw	zeroAF+1
		addwf	Letter,W
		call	zeroAF
		skpne	0			; zero
		 GOTO 	loopend			; RETURN no event; next entry = RETURN
;		addlw	1x00 - " "
;		skpZ				; check for 'space'
;		 GOTO	numlet
;		movlw	wrd_pause
;		movwf	PauseLen
;		clrf	BeepLen
;		GOTO	nextchar		; RETURN there
;
numlet	       ;addlw	" "
		call	GETCODE				;morse code in W
		movwf	TempOut
		andlw	b'00000111'
		movwf	TempIndexI			;  
		clrf	IndxI			; IndxI:=0  =7th bit
noshift	       movlw	0x03	
		movwf	NextEntry	; next entry = here
		btfsC	TempOut,7
		 GOTO	dash		; 
dot	       movlw	dot_time		;RETURN event = dot/dash +pause
		movwf	PauseLen
		movwf	BeepLen
		RETURN			
dash	       movlw	dot_time		;RETURN event = dot/dash +pause
		movwf	PauseLen
		movlw	dash_time
		movwf	BeepLen
		RETURN
;**************************ENTRYPOINT********************************************
	
here	       movfw	TempIndexI			; 
		subwf	IndxI,W
		skpNZ				; IndxI=bits to do?
		 GOTO	nextchar
		movfw	IndxI
		sublw	4			; IndxI=4?
		skpZ	
		 GOTO	morbits			; produce nextevent
		movlw	0x5
		movwf	NextEntry	; next entry = nextchar
		movfw	TempIndexI
		sublw	5		; TempIndexI=5?
		skpNZ	
		 GOTO	dash
		movfw	TempIndexI
		sublw	6		; TempIndexI=6?
		skpNZ	
		 GOTO	dash
		GOTO	dot		; TempIndexI = 7
;**************************ENTRYPOINT********************************************
morbits	       incf	IndxI,F
		rlf	TempOut,F
		GOTO noshift
;**************************ENTRYPOINT********************************************
nextchar       movlw	0x02	
		movwf	NextEntry
		incf	TextLetter,F
		movlw	dot_time	;RETURN event = dot pause
		movwf	PauseLen
		clrf    BeepLen
		RETURN  		; NextEntry = nextlet

loopend        movlw	wrd_pause
		movwf	PauseLen
		clrf	BeepLen		; NextEntry = 0 nomore
		clrf	NextEntry
		RETURN
