	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_ON


;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206
#define ram0_end 	0x1F			; 
#define ram0_length 	ram0_end - ram0_start + 1

	cblock RAM0_START
	AL,AH
	TimerFlag,TMR0Temp,Tmr0Tick,Ms4Tick,SeC,MiN,HouR,DaY
	EndCycle,MaxMinusDuty
	endc

#define	Tmr0_Max	.122
#define Sec_Max 	.60
#define Min_Max		.60
#define H_Max		.24

#define 	Ms4_Event	TimerFlag,0 ; 

#define 	Sec_Event	TimerFlag,1 ;

#define 	Min_Event 	TimerFlag,2 ;

#define 	Hour_Event	TimerFlag,3 ;
#define 	Day_Event	TimerFlag,4 ;
#define 	Plus_Minus	TimerFlag,5 ;
#define 	Plus_Minus_Bit	0x20 ;

#define 	Full_Activity	TimerFlag,7 
#define 	Pwm_Output	GPIO,2 ;
#define 	Freq		.2000; Hz
;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	andlw	b'11111110'	;bit 0 FOSC4: INTOSC/4 Output Enable bit(1)
	;iorwl	b'00000001'
	movwf   OSCCAL          ; update register with factory cal value 

init

#define 	TRISGPIO 	6

io	movlw	B'00001000'	; set direction bits 
	TRIS 	TRISGPIO		; GPIO3 is input (high-z) GPIO0:2 are output
timr	movlw	B'11000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			;

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	aftersleep


	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202
	

	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO
	GOTO	RESET		; GOTO RESET skip subroutines when boot.



#define 	Ms32_Bit 	0x08 ; 

MSEC4EVENT:	bcf	Ms4_Event
		incf	Ms4Tick,W
		xorwf	Ms4Tick,w
		andlw	Ms32_Bit
		skpNZ
	         goto	no32msjob

		movlw	B'00000010'	; toggle GP1
		xorwf	GPIO,F
;*
no32msjob    	
	  	btfss	Sec_Event
		 goto	osxit
		bcf	Sec_Event
		movlw	B'00000001'
		xorwf	GPIO,F		; toggle GP0

dutest		movf	MaxMinusDuty,F
		skpnz
		 bcf	Plus_Minus	; test subseq
		movlw	.32000 / Freq	; duty cycles	
		subwf	MaxMinusDuty,W
                skpnz
		 bsf	Plus_Minus
		movlw	0x01
		btfsc	Plus_Minus
		 movlw	0xFF
		addwf	MaxMinusDuty,F
					;goto 	dutest	
osxit		

ms4xit	     
		RETLW	0

add_processtime movfw	TMR0Temp
		subwf	TMR0,W		; w := TMR0-TMR0Temp
					; 256*32 instructions 
		addwf	Tmr0Tick,F
		skpC
		 goto	xit         ; 122* 32us = 3.9025msec

		movlw	1x00-Tmr0_Max
		addwf	Tmr0Tick,F
		movlw	1
		bsf	Ms4_Event
		goto	addms4

add_sleeptime	movlw	.61		
		subwf	Tmr0Tick,F	; 
		skpNC
		 goto	add_slpms4
		movlw	.61 * .4
		addwf	Tmr0Tick,F
		movlw	.3
		goto	$+2
add_slpms4	movlw	.5		;  trigger
	       bsf	Ms4_Event
addms4		addwf	Ms4Tick,F	; Msec4Event
		skpC
		 goto xit
		bsf	Sec_Event

inc_sec		incfsz	SeC,F
		 goto	xit
		movlw	1x00-Sec_Max
		addwf	SeC,F
		bsf	Min_Event
		incfsz	MiN,F
		 goto	xit
		movlw	1x00-Min_Max
		addwf	MiN,F
		bsf	Hour_Event
		incfsz	HouR,F
		 goto	xit
		movlw	1x00-H_Max
		addwf	HouR,F
		bsf	Day_Event
		incf	DaY,F
xit		movfw	TMR0
		movwf	TMR0Temp
		Retlw	0

init_time	movlw	0xFF
		movwf	SeC
		movwf	MiN
		movwf	HouR
		movwf	DaY
		goto	inc_sec

		

#define Startduty .50;%


RESET		call	init_time
		clrf	TimerFlag
		bsf	Min_Event
		bsf 	Full_Activity
		movlw	(.32000 - .320*Startduty )/Freq
		movwf	MaxMinusDuty
	
N_LOOP		btfss	Full_Activity
		 goto	nopwm
		movfw	EndCycle
		subwf	TMR0,w
		andlw	b'11111100'
		bnz	test_endpwm	
		movlw	.32000 / Freq
		addwf	TMR0,W
		movwf	EndCycle
					;movlw	(1x00*Freq - .32000) /Freq
					;movwf	TMR0		;clears prescaler
					;movwf	TMR0Temp
					;decf	TMR0Temp,F	;TMR0 is compromised
		;movfw	EndCycle
		subwf	MaxMinusDuty,w
		addwf	TMR0,w		;to prevent 'spike'
		skpC			;MaxMi >= Freq
		 bsf	Pwm_Output	;PWM not switched on
test_endpwm	movfw	EndCycle	;
		subwf	MaxMinusDuty,W
		addwf	TMR0,w
		skpnC
		 bcf	Pwm_Output

nopwm
		btfsc	Ms4_Event
		 call	MSEC4EVENT	;next Ms4Bit to flip
		call 	add_processtime
		clrwdt			;prevent reset
		btfsc	Full_Activity
		 goto	N_LOOP
		sleep			;force reset
aftersleep	call add_sleeptime

		goto	N_LOOP
	END
