	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_ON


;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206
#define ram0_end 	0x1F			; 
#define ram0_length 	ram0_end - ram0_start + 1

	cblock RAM0_START
	AL,AH
	TimerFlag,TMR0Temp,Tmr0Tick,Ms4Tick,SeC,MiN,HouR,DaY
	EndCycle,MaxMinusDuty,Skip4msSteps,LatenCy
	endc

#define	Tmr0_Max	.122
#define Sec_Max 	.60
#define Min_Max		.60
#define H_Max		.24

#define 	Ms4_Event	TimerFlag,0 ; 

#define 	Sec_Event	TimerFlag,1 ;

#define 	Min_Event 	TimerFlag,2 ;

#define 	Hour_Event	TimerFlag,3 ;
#define 	Day_Event	TimerFlag,4 ;
#define 	Up_Down		TimerFlag,5 ;
#define 	Up_Down_Bit	0x20 ;
#define		Ramp_Running	TimerFlag,6
#define 	Full_Activity	TimerFlag,7 


#define 	Indi_Output	GPIO,0;
;#define 	Indi_Output_Bit	b'00000010' ;
#define 	Pwm_Output	GPIO,1 ;
;#define 	Pwm_Output_Bit	b'00000001' ;
#define 	Input_Port	GPIO,3 ;
#define		inputactivelow	0	;active high
#define		outputactivelow	0	;active high
#define 	Freq		.1000; Hz


	variable 	Freqascount = .32000 / Freq	
#define	Uprampstart 	.5;%
#define	Uprampend	.100;%
#define	Upramptime	.4000;msec
#define	Up4msstep	Upramptime * .100 / (Uprampend-Uprampstart) / Freqascount/.4
#define Up_start_mm 	(.32000 - .320*Uprampstart )/Freq
#define Up_end_mm 	(.32000 - .320*Uprampend )/Freq

#define Latencytime	.15;sec

#define	Downrampstart 	.100;%
#define	Downrampend	.0;%
#define	Downramptime	.4000;msec
#define	Down4msstep	Downramptime *.100 / (Downrampstart-Downrampend) / Freqascount / .4
#define Down_start_mm 	(.32000 - .320*Downrampstart )/Freq
#define Down_end_mm 	(.32000 - .320*Downrampend )/Freq

;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	andlw	b'11111110'	;bit 0 FOSC4: INTOSC/4 Output Enable bit(1)
	;iorwl	b'00000001'
	movwf   OSCCAL          ; update register with factory cal value 


#define 	TRISGPIO 	6

io	movlw	B'00001000'	; set direction bits 
	TRIS 	TRISGPIO		; GPIO3 is input (high-z) GPIO0:2 are output
timr	movlw	B'11000100'	
				; Timer0 internal clock, 1:32 prescale
	OPTION			; wakeup, weak pullup disabled

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	aftersleep


	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202
	

	movlw	b'00000000'	; set all Outputs to Low Voltage
	
	if outputactivelow
	 iorlw	Pwm_Output_Bit	
	 iorlw	Indi_Output_Bit	; inverted Output
	endif
	movwf	GPIO		; 
	GOTO	RESET		; GOTO RESET skip subroutines when boot.

indicatoron	macro
		if outputactivelow
		 bcf	Indi_Output	;on =inverted output
		else
		 bsf	Indi_Output
		endif
		endm
indicatoroff	macro
		if outputactivelow
		 bsf	Indi_Output	;on =inverted output
		else
		 bcf	Indi_Output
		endif
		endm

skpifnoinput macro
		if inputactivelow 
		 btfss	Input_Port
		else 		
		 btfsc	Input_Port
		endif
	     endm

skpifinput  macro
		if inputactivelow 
		 btfsc	Input_Port
		else 		
		 btfss	Input_Port
		endif
	    endm

pwmon	    macro		
		if outputactivelow
		 bcf	Pwm_Output	;PWM switched on: inverted output
		else
		 bsf	Pwm_Output
		endif
	    endm

pwmoff	    macro		
		if outputactivelow
		 bsf	Pwm_Output	;PWM switched off: inverted output
		else
		 bcf	Pwm_Output
		endif
	    endm


#define 	Ms32_Bit 	0x08 ; 

MSEC4EVENT:	bcf	Ms4_Event
		movf	LatenCy,F
		skpz
		 goto	otherslices	; Latency is running
		btfss	Ramp_Running	
		 goto  endramp		; 
		decfsz	Skip4msSteps,F  ;ramp is running
		 goto	endramp
		btfss	Up_Down		; all msecs are clear
		 goto	down

		movlw	Up_end_mm
		subwf	MaxMinusDuty,W
		skpnZ
		 goto	upfinish
		skpC
		 goto	upfinish
		decf	MaxMinusDuty,F
		movlw	Up4msstep
		movwf	Skip4msSteps
		goto	endramp
upfinish	bcf	Ramp_Running
		movlw	Latencytime
		movwf	LatenCy
		goto	endramp
down		skpifnoinput
		 goto	upagain
		movlw	Down_end_mm
		subwf	MaxMinusDuty,w
		skpNC
		 goto	downfinish
		movlw	Down4msstep
		movwf	Skip4msSteps
		incf	MaxMinusDuty,F
		goto	endramp
downfinish	bcf	Ramp_Running
		bcf	Full_Activity
endramp		
		skpifinput
		 goto 	otherslices
		btfsc	Ramp_Running	
		 goto  	otherslices	
		movf	LatenCy,F
		skpZ
		 goto	otherslices	;	 Port is active
		movlw	Up_start_mm 
		movwf	MaxMinusDuty
		movlw	Up4msstep
		movwf	Skip4msSteps
		movlw	1
		addwf	TMR0,W
		movwf	EndCycle
upagain		indicatoron
		bsf	Ramp_Running	; bsf GP0
		bsf	Full_Activity
		bsf	Up_Down	
		clrf	LatenCy
		goto	otherslices
active		
otherslices		incf	Ms4Tick,W
		xorwf	Ms4Tick,w
		andlw	Ms32_Bit
		skpNZ
	         goto	no32msjob
		
		 goto	no32msjob


		;		movlw	B'00000010'	; toggle GP1
		;		xorwf	GPIO,F
				;*
no32msjob   
	  	btfss	Sec_Event
		 goto	osxit
		bcf	Sec_Event
	;	movlw	Indi_Output_Bit
	;	xorwf	GPIO,F		; toggle GP0
		movf	LatenCy,F
		skpNZ
		 goto	osxit
		skpifinput
		 goto	osnoinput
		movlw	Latencytime	;case3 bsf GP0
		movwf	LatenCy
		indicatoron
		goto	osxit
osnoinput	indicatoroff
		decfsz	LatenCy,F	;bcf GP0
		 goto	osxit
		;btfsc	Ramp_Running
		 ;GOTO	osxit
		bcf	Up_Down		;case 4 
		bsf	Ramp_Running	; set Downramp running
		movlw	Down4msstep
		movwf	Skip4msSteps
		movlw	Freqascount
		addwf	TMR0,W
		movwf	EndCycle
		
osxit
		

ms4xit	     
		RETLW	0

add_processtime movfw	TMR0Temp
		subwf	TMR0,W		; w := TMR0-TMR0Temp
					; 256*32 instructions 
		addwf	Tmr0Tick,F
		skpC
		 goto	xit         ; 122* 32us = 3.9025msec

		movlw	1x00-Tmr0_Max
		addwf	Tmr0Tick,F
		movlw	1

		goto	addms4

add_sleeptime	movlw	.61		
		subwf	Tmr0Tick,F	; 
		skpNC
		 goto	add_slpms4
		movlw	.61 * .4
		addwf	Tmr0Tick,F
		movlw	.3
		goto	$+2
add_slpms4	movlw	.5		;  trigger
	       
addms4		bsf	Ms4_Event
		addwf	Ms4Tick,F	; Msec4Event
		skpC
		 goto xit
		bsf	Sec_Event

inc_sec		incfsz	SeC,F
		 goto	xit
		movlw	1x00-Sec_Max
		addwf	SeC,F
		bsf	Min_Event
		incfsz	MiN,F
		 goto	xit
		movlw	1x00-Min_Max
		addwf	MiN,F
		bsf	Hour_Event
		incfsz	HouR,F
		 goto	xit
		movlw	1x00-H_Max
		addwf	HouR,F
		bsf	Day_Event
		incf	DaY,F
xit		movfw	TMR0
		movwf	TMR0Temp
		Retlw	0

init_time	movlw	0xFF
		movwf	SeC
		movwf	MiN
		movwf	HouR
		movwf	DaY
		goto	inc_sec

		

#define Startduty .50;%


RESET		call	init_time
		clrf	TimerFlag
		clrf	LatenCy
		;bsf 	Full_Activity
		movlw	Freqascount
		movwf	MaxMinusDuty
		addwf	TMR0,W
		movwf	EndCycle

N_LOOP		btfss	Full_Activity
		 goto	nopwm
		movfw	EndCycle
		subwf	TMR0,w
		andlw	b'11111100'
		bnz	test_endpwm
		
		movlw	Freqascount
		addwf	TMR0,W
		movwf	EndCycle
					;movlw	(1x00*Freq - .32000) /Freq
					;movwf	TMR0		;clears prescaler
					;movwf	TMR0Temp
					;decf	TMR0Temp,F	;TMR0 is compromised
					;movfw	EndCycle
		movlw	Freqascount
		subwf	MaxMinusDuty,w	;to prevent 'spike'
		skpC			;MaxMi >= Freq
		 pwmon
test_endpwm	movfw	MaxMinusDuty		
		subwf	EndCycle,w
		subwf	TMR0,w
		andlw	b'11111100'
		skpNZ
		 pwmoff
nopwm
		btfsc	Ms4_Event
		 call	MSEC4EVENT	;next Ms4Bit to flip
		call 	add_processtime
		clrwdt			;prevent reset
		btfsc	Full_Activity
		 goto	N_LOOP
		sleep			;force reset
aftersleep	call add_sleeptime

		goto	N_LOOP
	END
