	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The lables following the directive are located in the respective .inc file. 
; See respective data sheet for additional information on configuration word.




;***** VARIABLE DEFINITIONS
;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206

	cblock RAM0_START
	AL,AH
	SeeD,RanD
	DiviDend,DiviSor,DiviTemp
	endc
;**********************************************************************
	ORG     0xFF            ; processor reset vector
				; method 1

; Internal RC calibration value is placed at location 0xFF by Microchip
; as a movlw k, where the k is a literal value.

	ORG     0x000           ; start coding 
	nop			; needed for ICDebugger
	movwf   OSCCAL          ; update register with factory cal value 


	bcf OSCCAL,FOSC4 	;bit 0 FOSC4: INTOSC/4 Output Enable bit(1)
				;             1 = INTOSC/4 output onto GP2
				;	      0 = GP2/T0CKI/COUT applied to GP2
	;bsf OSCCAL,FOSC4	;uncomment to see processor working with oscilloscop

init
io	movlw	B'00001000'	; set direction bits 
	TRIS 	6		; GPIO3 is input (high-z) GPIO0:2 are output

timr	movlw	B'11000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			; set option register for Timer0 functions
	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202

	GOTO	RESET		; GOTO RESET skip subroutines when boot.

	
PRBS8	movlw	8
	movwf	AL
loop8	setC
	btfsc SeeD,7	
	 clrC
	rlf 	SeeD,w
	rrf	RanD,F
        XORWF  SeeD,F
        XORWF  SeeD,W
        XORWF  SeeD,F
        
	andlw   b'10000011'
       	xorwf	SeeD,F
	decfsz	AL,F
	 goto	loop8
	RETLW	0

RESET	call	PRBS8
	
	movfw	RanD
	movwf	DiviDend
	call	PRBS8
	clrC
	rrf	RanD,W
	movwf	DiviSor
	movf	DiviSor,F	; division by Zero
	bZ	RESET
mod8	movfw	DiviSor
	movwf	DiviTemp
	subwf	DiviDend,W
	bNC	finish
	movwf	DiviDend
rrTemp	clrC	
	rlf	DiviTemp,F	; rrf = *2
	movfw	DiviTemp
	subwf	DiviDend,W
	bnC	mod8		; unsucessful sub	
	movwf	DiviDend
	goto	rrTemp
finish  movfw	DiviDend		
	andlw	b'00000111'
	movwf   GPIO
	
	goto	RESET           

	END                       
