	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The lables following the directive are located in the respective .inc file. 
; See respective data sheet for additional information on configuration word.




;***** VARIABLE DEFINITIONS
AL	EQU     0x10        ;example variable definition
AH	EQU     0x11        ;example variable definition



;**********************************************************************
	ORG     0xFF            ; processor reset vector
				; will rollover to 0x00
				; Internal RC calibration value is placed at location 0xFF by Microchip
				; as a movlw k, where the k is a literal value.
	ORG     0x000           ; start coding 
	nop			; needed for ICDebugger
	movwf   OSCCAL          ; update register with factory cal value 

	
	bcf OSCCAL,FOSC4 	;bit 0 FOSC4: INTOSC/4 Output Enable bit(1)
				;             1 = INTOSC/4 output onto GP2
				;	      0 = GP2/T0CKI/COUT applied to GP2
	;bsf OSCCAL,FOSC4	;uncomment to see processor working with oscilloscop

init
io	movlw	B'00001000'	; set direction bits 
	TRIS 	6		; GPIO3 is input (high-z) GPIO0:2 are output

timr	movlw	B'11000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			; set option register for Timer0 functions
	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202

	GOTO	RESET		; GOTO RESET skip subroutines when boot.

	

RESET	movlw	b'00000000'
	movwf	GPIO
loop	movlw	0x01
	addwf	AL,F                     
	skpZ
	  goto	loop		;loop until AL overflow
	addwf	AH,F                        
	skpZ
	  goto	loop		;loop until BL overflow
 	incf	GPIO,F
	movlw	b'00000111'
	andwf	GPIO,F
	goto	loop

	END                     ; directive 'end of program'
