; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;==============================================================================
;File name: 10HSI_aka_morse.asm
;
;This program demonstrates how Human Serial Interface also known as 
;Morse Code with a buzzer and a pushbutton can be achieved. 
;
;
;
;==============================================================================
;author:	Gerhard Michael Drygas
;company:	Michaels Prototype
;date:		01-11-2006
;MPLAB version:	7.41
;
;==============================================================================        

	list      p=10F202	; list directive to define processor
	#include <p10f202.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _WDT_OFF & _MCLRE_OFF 


;*** register bank limits
#define ram0_start 	0x10
#define ram0_end 	0x1f			; 7f 16P627
#define ram0_length 	ram0_end - ram0_start + 1

;==========================================================================
;       Variable Definition
;==========================================================================
	cblock ram0_start
	AL,AH
	endc

#define		Beeper_Port	GPIO,2	;PORTB,7
#define		Beeper_Port_Bit b'00000100'

;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

undoreset			
 
	movlw	b'11111011'	; configure FET_Gate_Port  as output GPIO0,1,3 are input
	TRIS 	TRISGPIO
	
	movlw	B'11000100'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 32:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO

	call	undoreset
		
	IFDEF __10F204	
	movlw	b'11110011'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
	IFDEF __10F206	
	movlw	b'11110011'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif
afterwdt	
afterpin	
	goto 		RESET		;GOTO RESET routine when boot.

RESET	movlw	Beeper_Port_Bit	; toggle Beeper
	xorwf	GPIO,F
	decfsz	AL,F
	 goto	$-1
	decfsz	AH,F
	 goto	$-3
	goto	RESET
	
	END
