	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_ON


;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206
#define ram0_end 	0x1F			; 
#define ram0_length 	ram0_end - ram0_start + 1

	cblock RAM0_START
	AL,AH
	TimerFlag,TMR0Temp,Tmr0Tick,Ms4Tick,SeC,MiN,HouR,DaY
	endc

#define	Tmr0_Max	.122
#define Sec_Max 	.60
#define Min_Max		.60
#define H_Max		.24

#define 	Ms4_Flag 	TimerFlag,0 ; 
#define 	Ms4_Flag_Bit 	0x01 ; 

#define 	Sec_Flag 	TimerFlag,1 ;
#define 	Sec_Flag_Bit 	0x02 ; 

#define 	Ms32_Flag 	TimerFlag,2 ;
#define 	Ms32_Flag_Bit 	0x04 ; 

#define 	Min_Flag 	TimerFlag,3 ;
#define 	Min_Flag_Bit 	0x08 ; 


#define 	Full_Activity 	TimerFlag,4

;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	andlw	b'11111110'	;bit 0 FOSC4: INTOSC/4 Output Enable bit(1)
	;iorwl	b'00000001'
	movwf   OSCCAL          ; update register with factory cal value 

init

#define 	TRISGPIO 	6

io	movlw	B'00001000'	; set direction bits 
	TRIS 	TRISGPIO		; GPIO3 is input (high-z) GPIO0:2 are output
timr	movlw	B'11000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			;

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	aftersleep


	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202
	

	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO
	GOTO	RESET		; GOTO RESET skip subroutines when boot.



#define 	Ms32_Bit 	0x08 ; 

MSEC4EVENT:	movlw	0x00
		btfsc	Ms32_Flag
		 movlw 	Ms32_Bit
		xorwf	Ms4Tick,w
		andlw	Ms32_Bit
		skpNZ
	         goto	no32msjob
		movlw	Ms32_Flag_Bit
		xorwf	TimerFlag,F
		movlw	B'00000010'	; toggle GP1
		xorwf	GPIO,F
;*
no32msjob     


#define 	Sec_Bit 	0x01 ; 

		
ONESECEVENT:  	movlw	0x00
		btfsc	Sec_Flag
		 movlw 	Sec_Bit
		xorwf	SeC,w
		andlw	Sec_Bit
		skpNZ
	         goto	osxit
		movlw	Sec_Flag_Bit
		xorwf	TimerFlag,F
		movlw	B'00000001'
		xorwf	GPIO,F		; toggle GP0
		
#define 	Min_Bit 	0x01 ;

		bcf	GPIO,2		; off GP2
		movlw	0x00
		btfsc	Min_Flag
		 movlw 	Min_Bit
		xorwf	MiN,w
		andlw	Min_Bit
		skpNZ
	         goto	osxit
		movlw	Min_Flag_Bit
		xorwf	TimerFlag,F
		bsf	GPIO,2		; GP2 on every minute
osxit		

ms4xit	     
		RETLW	0

add_processtime movfw	TMR0Temp
		subwf	TMR0,W		; w := TMR0-TMR0Temp
					; 256*32 instructions 
		addwf	Tmr0Tick,F
		movlw	0
		skpC
		 goto	addms4          ; 122* 32us = 3.9025msec
		movlw	1x00-Tmr0_Max
		addwf	Tmr0Tick,F
		movlw	1
		goto	addms4

add_sleeptime	movlw	.61		
		subwf	Tmr0Tick,F	; 
		skpNC
		 goto	add_slpms4
		movlw	.61 * .4
		addwf	Tmr0Tick,F
		movlw	.3
		goto	$+2
add_slpms4	movlw	.5		; has to be odd to trigger
addms4		addwf	Ms4Tick,F	; Msec4Event
		skpC
		 goto xit

inc_sec		incfsz	SeC,F
		 goto	xit
		movlw	1x00-Sec_Max
		addwf	SeC,F
		incfsz	MiN,F
		 goto	xit
		movlw	1x00-Min_Max
		addwf	MiN,F
		incfsz	HouR,F
		 goto	xit
		movlw	1x00-H_Max
		addwf	HouR,F
		incf	DaY,F
xit		movfw	TMR0
		movwf	TMR0Temp
		Retlw	0

init_time	movlw	0xFF
		movwf	SeC
		movwf	MiN
		movwf	HouR
		movwf	DaY
		goto	inc_sec

		



RESET		call	init_time
		clrf	TimerFlag
		bsf	Min_Flag
		;bsf 	Full_Activity
N_LOOP		movlw	0x00
		btfsc	Ms4_Flag
		 movlw 	Ms4_Flag_Bit
		xorwf	Ms4Tick,w
		andlw	Ms4_Flag_Bit
		skpNZ
		 goto $+3
		xorwf	TimerFlag,F	;flip flag wait until
		call	MSEC4EVENT	;next Ms4Bit to flip
		call 	add_processtime
		clrwdt			;prevent reset
		btfsc	Full_Activity
		 goto	N_LOOP
		sleep			;force reset
aftersleep	call add_sleeptime

		goto	N_LOOP
	END
