	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF


;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206
#define ram0_end 	0x1F			; 
#define ram0_length 	ram0_end - ram0_start + 1

	cblock RAM0_START
		AL,AH
		Tmr0Tick,Ms4Tick,TimerFlag
	endc
#define 	Sec_Flag 	AH,7


;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	nop			; needed for ICDebugger
	movwf   OSCCAL          ; update register with factory cal value 
	; ORG     0x000         ; method 2 retrieve factory calibration value
	; call    0xFF      	; comment instruction if using simulator, ICD2,	 or ICE2000
	; movwf   OSCCAL	; update register with factory cal value 
	bcf OSCCAL,FOSC4 	;bit 0 FOSC4: INTOSC/4 Output Enable bit(1)
	;bsf OSCCAL,FOSC4	;uncomment to see processor working with oscilloscop

init
io	movlw	B'00001000'	; set direction bits 
	TRIS 	6		; GPIO3 is input (high-z) GPIO0:2 are output

timr	movlw	B'11000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			; 
	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202
	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO
	GOTO	RESET		; GOTO RESET skip subroutines when boot.

ONESECEVENT:  macro
		; bcf	Sec_Flag
		movlw	B'00000001'
		xorwf	GPIO,F		; toggle GP0
	      endm ;	RETLW 0

MSEC4EVENT:	movlw	0x01
		addwf	Ms4Tick,W
		xorwf	Ms4Tick,W
		andlw	B'00010000'	; filter any bit 7:0
		skpnZ
		 goto	no64msjob
;*
		movlw	B'00000010'	; toggle GP1
		xorwf	GPIO,F
;*
no64msjob      
		decfsz	Ms4Tick,F	; new Ms4Tick
		 GOTO	ms4xit
		;movlw	.250		; 256 * 3,906 ms = 1sec
		;movwf	Ms4Tick

;*
		ONESECEVENT 		;bsf Sec_Flag
;*
ms4xit	       movlw	.122		; 122* 32us = 3,906 msec
		addwf	Tmr0Tick,F
		RETLW 0	





RESET		
N_LOOP		movlw	B'00000100'	; toggle GP2
		xorwf	GPIO,F
		movfw	Tmr0Tick	
		subwf	TMR0,W		;w=TimerTick-TMR0
		andlw	0xC0		;slack 63*32 cycles
		skpNZ
		 call	MSEC4EVENT	;frequent jobs to be done in 4ms 
		;BTFSC	Sec_Flag
		 ;call	ONESECEVENT	;occasional jobs to be done
		goto	N_LOOP
	END
