	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions
	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF
	;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206
#define ram0_end 	0x1F			; 


	cblock RAM0_START
	AL,AH,BL
	TimeE,TimeD		;arithmetic
	MotEvent,MotonLen
	Tmr0Tick,Ms4Tick,TimerFlag,PauseLen, BeepLen
	endc
#define 	Input_Priority	TimerFlag,0
#define 	Os_Case4force	TimerFlag,1

#define 	Button_Down	TimerFlag,3
#define 	Pause_Pending	TimerFlag,4
#define 	Flip_Target	TimerFlag,5
#define 	FlipTarget	b'00100000'

#define		Motor_Enable	TimerFlag,6


#define 	Button_Port 	GPIO,3  ;	

#define		Beeper_Port	GPIO,0	;
#define		Motor_Forward	GPIO,1
#define		Motor_Reverse	GPIO,2
	
#define		dash_time	.20	; 
#define		dash_thresh	.10	; 

pulseskip  macro
		btfsc	Beeper_Port
		 goto	clrport
		movfw	AH		; AH>=AL ?
		subwf	AL,W
		skpC
 	         bsf 	Beeper_Port	; Pulse skipped if no BORROW
		decfsz	AH,F		; 
		 goto	endonesec	; 
		call	setPWM		
		goto 	endpulse
clrport	       bcf	Beeper_Port
endpulse
	  endm

;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	nop			; needed for ICDebugger
	movwf   OSCCAL          ; update register with factory cal value 
	bcf OSCCAL,FOSC4 	; bit 0 FOSC4: INTOSC/4 Output Enable bit(1)

init
io	movlw	B'00001000'	; set direction bits 
	TRIS 	6		; GPIO3 is input (high-z) GPIO0:2 are output

timr	movlw	B'10000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			; bit 6 GPPU: Enable Weak Pull-ups bit (GP0, GP1, GP3)
				;            1 = Disabled
				;  	     0 = Enabled

	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202
	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO
	GOTO	RESET		; GOTO RESET skip subroutines when boot.

setPWM	macro	movlw	.10		; PWM Cylces
		movwf	AH		
	endm			;	RETLW	0

MOTOR_OUTPUT	btfsS	Motor_Enable	; Moton/pause to work off?
		 RETLW	0
		movf	MotonLen,F
		skpnz			; Motonlen != 0 ?
		 goto moo
		decf	MotonLen,F
		retlw	0
moo		movfw	MotEvent	
		
		addwf 	PCL,F
		 goto 	event0		;0
		 goto 	event1		;1
		 goto	event2		;2
		 goto	event3		;3
		 goto	event4
event0		
		btfsC	Button_Port
		 RETLW 0
		incf	MotEvent,F
		RETLW 0

event1 	       bsf	Motor_Forward
		movfw	TimeD
		movwf	MotonLen
	;		movfw	TimeD+1
	;		movwf	MotonLen+1

		incf	MotEvent,F
		RETLW 0
event2	       bcf	Motor_Forward	;
		movlw 	dash_time
		movwf	MotonLen

		incf	MotEvent,F
		RETLW 0		
event3	       bsf	Motor_Reverse	;
		movfw	TimeE
		movwf	MotonLen
	;		movfw	TimE+1
	;		movwf	MotonLen+1

		incf	MotEvent,F
		RETLW 0		
event4	       bcf	Motor_Reverse;		
		clrf	MotEvent
		RETLW 0


	

MSEC4EVENT:	movlw	0x01
		addwf	Ms4Tick,W
		xorwf	Ms4Tick,W
		andlw	B'10000000'
		skpZ
		 call	MOTOR_OUTPUT
		movlw	0x01
		addwf	Ms4Tick,W
		xorwf	Ms4Tick,W
		
		andlw	B'00001000'	; filter any bit 7:0 16ms
		skpnZ
		 goto	no64msjob
		btfsc	Motor_Enable	; 
		 goto	no64msjob

;* case of
;* Pause    Button_   Button_
;*  Pending   Down 	Port
;*      0	0	0	case 0  no action
;*	0	0	1	case 1  clr BL, set B_D, clr P_P
;*	0	1	1	case 2  inc BL
;*	0	1	0	case 3  clr PL, clr B_D, set P_P
;*	1	0	0	case 4  inc PL, if overflow transfer to target
;*	1	0	1	case 5  transfer to target, goto case 1 	
;*
input		btfsc	Pause_Pending	; 
		 goto	cases_4_5
		
		btfss	Button_Down	; 
		 goto	cases_0_1
		
		incfSZ	BeepLen,F       ; case 2+3
		  GOTO	$+2		; *
		decf	BeepLen,F	; ! max beeplen=255* 16ms= 4 sec

		btfss	Button_Port	; * test if button closed?  bit set = 5V = WPU
		 goto	endbtn 		; case 2 finished 
					;
		clrf	PauseLen	; case 3			
	        bcf	Button_Down
		bsf	Pause_Pending
		bcf	Beeper_Port 	; switch off Beeper
		goto	endbtn

cases_0_1	btfsc	Button_Port	; * test if button
		 goto	endbtn		; case 0
  				
case_1		clrf	BeepLen
		bsf	Button_Down	; case 1: new beep detected
		bcf	Pause_Pending	;
		bsf	Input_Priority  ; Input is now running 
		bsf	Beeper_Port
					; switch on Beeper
		goto	endbtn

cases_4_5	btfss	Button_Port	; * test if button
		 goto	case_5
					; case 5: a pause is counting
		incfsz	PauseLen,F
		 GOTO	endbtn		; and PauseLen not overflown 
					; max PauseLen 255*16 ms = 4 sec
case_5					; goto	CLR_BEEP_PAUSE	

CLR_BEEP_PAUSE	movlw	dash_thresh
		subwf	BeepLen,W
		skpC
		 goto $+3
		movlw	.4
		addwf	AL,F
	       incf	AL,F
		movf	PauseLen,F
		skpZ
		 goto	case_1
		bcf 	Pause_Pending	; target finished
		bcf	Input_Priority
		movfw	AL
		movwf	AH		; copy of AL
		movwf	TimeE	
		btfss	Flip_Target
		 movwf	TimeD
		clrf	AL
		movlw	FlipTarget
		xorwf	TimerFlag,F
		btfss	Flip_Target
		 bsf	Motor_Enable
		movlw	.2
		movwf	BL
endbtn					;*end button cases

no64msjob      decfsz	Ms4Tick,F	; new Ms4Tick
		 GOTO	ms4xit		; 256 * 3,906 ms = 1sec
					;*
ONESECEVENT: 	btfsc	Input_Priority
		 goto	os_exit
		;btfsc	Motor_Enable
		 ;goto	os_exit
;case 0: AH=0 BL>0		decrement BL	
;
;case 1: AH=0 BL=0		copy AL to AH; BL=15
;
;case 2: AH>0 Port_Lo		>Port_Hi
;
;case 3a: AH>=5 Port_Hi		AH -= 5  force case 4
;      b: AH<5			AH -= 1 >Port_Lo
;
;case 4:                        >Port_Lo
;
		btfsc	Os_Case4force
		 goto	os_case4
		movf	AH,F		; AH = 0?
		skpZ
		 goto	os_cases2_3
		movf	BL,F		; then 
		skpZ
		 goto	os_case0
		;	movfw	TimeE
		;	movwf	AH	if repetition wanted
		;	movlw	.15
		;	movwf	BL
		goto	os_exit
os_case0	decf	BL,F
		goto	os_exit

os_cases2_3	btfsc	Beeper_Port
		 goto	os_case3
		bsf	Beeper_Port
		goto	os_exit
os_case3	movlw	5
		subwf	AH,W
		skpC
		 goto	os_case3b
		movwf	AH
		bsf	Os_Case4force
		goto	os_exit
os_case3b	decf	AH,F
os_case4	bcf	Os_Case4force
		bcf	Beeper_Port
os_exit	
	
;*
ms4xit	       movlw	.122		; 122* 32us = 3,906 msec
		addwf	Tmr0Tick,F
		RETLW 0	





RESET		movlw	AL	; clr 16 bytes of RAM
		movwf	FSR	; will look silly: .240 or F0
		clrf	INDF
		incf	FSR,F
		btfsC	FSR,4
		 goto	$-3
N_LOOP	
		movfw	Tmr0Tick	
		subwf	TMR0,W		;w=TimerTick-TMR0
		andlw	0xC0		;slack 63*32 cycles
		skpNZ
		 call	MSEC4EVENT	;frequent jobs to be done in 4ms 
		
		goto	N_LOOP
	END
