	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions
	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF
	;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206
#define ram0_end 	0x1F			; 
#define ram0_length 	ram0_end - ram0_start + 1

	cblock RAM0_START
	AL,AH
	Tmr0Tick,Ms4Tick,TimerFlag,PauseLen, BeepLen
	NextEntry,TempOut,TempIndexI,IndxI
	SecondsL,SecondsH
	endc

#define 	Repeat_Send	TimerFlag,0
#define 	Beep_On		TimerFlag,1
#define 	Input_Priority	TimerFlag,2
#define 	Beep_Event	TimerFlag,3
#define 	Pause_Pending	TimerFlag,4
#define 	Button_Down	TimerFlag,5



#define 	Button_Port 	GPIO,3  ;	

#define		Beeper_Port	GPIO,2	;

#define		wrd_pause	.15	; 
#define		dot_time	.3	; 
#define		dash_time	.12	; 
#define		dash_thresh	.6	; 

;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	nop			; needed for ICDebugger
	movwf   OSCCAL          ; update register with factory cal value 
	bcf OSCCAL,FOSC4 	; bit 0 FOSC4: INTOSC/4 Output Enable bit(1)

init
io	movlw	B'00001000'	; set direction bits 
	TRIS 	6		; GPIO3 is input (high-z) GPIO0:2 are output

timr	movlw	B'10000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			; bit 6 GPPU: Enable Weak Pull-ups bit (GP0, GP1, GP3)
				;            1 = Disabled
				;  	     0 = Enabled

	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202
	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO
	GOTO	RESET		; GOTO RESET skip subroutines when boot.
 
ONESECEVENT:  ;macro
	
		btfsc	Input_Priority	; no countdown if Input 
	movlw	0xFF			;countdown by adding 
	addwf	SecondsL,F
	skpC
	 addwf	SecondsH,F
	bC    endonesec	; 
		movlw	0x04		; L and H = 255 after countdown!
		movwf	AL		
		movlw	0x01		; start sending!
		movwf	NextEntry
endonesec	goto ms4xit
	;endm 				;	RETLW 0


INPUTJOB: ;macro

;* case of
;* Pause    Button_   Button_
;*  Pending   Down 	Port
;*      0	0	0	case 0  no action
;*	0	0	1	case 1  clr BL, set B_D, clr P_P
;*	0	1	1	case 2  inc BL
;*	0	1	0	case 3  clr PL, clr B_D, set P_P
;*	1	0	0	case 4  inc PL, if overflow transfer to target
;*	1	0	1	case 5  transfer to target, goto case 1 	
;*
		btfsc	Pause_Pending	; 
		 goto	cases_4_5
		
		btfss	Button_Down	; 
		 goto	cases_0_1
		
		movlw	0x0F
		subwf	BeepLen,W
		skpZ
		 incf	BeepLen,F       ; case 2+3
					; ! max beeplen=15 

		btfss	Button_Port	; * test if button closed?  bit set = 5V = WPU
		 goto	endbtn 		; case 2 finished 
					;
		clrf	PauseLen	; case 3			
	        bcf	Button_Down
		bsf	Pause_Pending
		movlw	B'11111101'	; switch off GP2
		andwf	GPIO,F
		goto	endbtn

cases_0_1	btfsc	Button_Port	; * test of button
		 goto	endbtn		; case 0
  				
case_1		clrf	BeepLen
		bsf	Button_Down	; case 1 new beep
		bcf	Pause_Pending	;
		clrf	AL		; target
		bsf	Input_Priority 
		movlw	B'00000010'	; switch on GP2
		iorwf	GPIO,F
		goto	endbtn

cases_4_5	btfss	Button_Port	; * test of button
		 goto	case_5
		movlw	b'00010000'	; case 5: a pause is counting
		addwf	PauseLen,F
		skpC
		 GOTO	endbtn		; and PauseLen not overflown 

case_5		;goto	CLR_BEEP_PAUSE	
		
	

CLR_BEEP_PAUSE	
		incf	AL,F
;		movlw   dash_thresh	; BeepLen > dash_tresh ?
;
;		subwf	BeepLen,W
;		skpNC 
;		 GOTO 	was_dot
;		movlw	0x80		;was dash
;		movwf	AH
;		movfw	AL
;		andlw	0x07
;		skpNZ
;		 GOTO 	nextx
;					;decf	IndxI,F
;		movwf	IndxI
;rotc	       rrf	AH,F
;		decfsz	IndxI,F
;		 GOTO rotc
;nextx	       movfw	AH
;		iorwf	AL,F		
was_dot	       movf	PauseLen,F
		skpZ
		 goto	case_1
		bcf 	Pause_Pending	; target finished
		bcf	Input_Priority
		clrf	SecondsL
		clrf	SecondsH
		movlw	.60
		addwf	SecondsL,F
		addcf	SecondsH,F
		decfsz AL,F
		 goto $-3
		
endbtn		goto betest
 	;endm	

MSEC4EVENT:	movlw	0x01
		addwf	Ms4Tick,W
		xorwf	Ms4Tick,W
		andlw	B'00001000'	; filter any bit 7:0
		skpnZ
		 goto	no64msjob

		goto INPUTJOB

betest	       btfsS	Beep_Event		; if not already sending beeps
		 GOTO	nobeep
		btfsC	Input_Priority		; if not waiting for input
		 GOTO	nobeep
		movf	BeepLen,F		; beeplen != 0 ?
		skpNZ
		 GOTO	bedone
		btfsS	Beep_On
		 bsf	Beeper_Port		; buzzer on
		bsf	Beep_On
		decfsz	BeepLen,F		; BeepLen expired ?
		 GOTO	nobeep
		bcf	Beeper_Port
		bcf	Beep_On			; buzzer off
bedone	       movf	PauseLen,F		; pause to work off?
		skpNZ
		 GOTO	clrbeep	
		decfsz	PauseLen,F
		 GOTO	nobeep
clrbeep		bcf	Beep_Event
nobeep

;*
no64msjob      
		decfsz	Ms4Tick,F	; new Ms4Tick
		 GOTO	ms4xit
		;movlw	.250		; 256 * 3,906 ms = 1sec
		;movwf	Ms4Tick

;*
		goto ONESECEVENT 		;bsf Sec_Flag
;*
ms4xit	       movlw	.122		; 122* 32us = 3,906 msec
		addwf	Tmr0Tick,F
		RETLW 0	

OUTDOTS:	btfsc	Input_Priority
		 RETLW	0
		bsf	Beep_Event
		movfw	NextEntry
		addwf	PCL,F
		GOTO	nomorebeep
		GOTO	start_sending		;entry = 1
		GOTO	nextlet			;2
		GOTO	here			;3
		GOTO	morbits			;4
		GOTO	nextchar		; entry=5

nomorebeep     bcf 	Beep_Event
		clrf	NextEntry
		RETLW 0
;**************************ENTRYPOINT********************************************
start_sending  ;movfw	TextNmbr		; start events	
		;clrf	TextLetter			; next_ entry = nextlet
;**************************ENTRYPOINT********************************************

nextlet	       ;movfw	TextNmbr
;		tcall	text
;		addlw	0			; zero
;		skpNZ
;		 GOTO 	loopend			; RETURN no event; next entry = RETURN
;		addlw	1x00 - " "
;		skpZ				; check for 'space'
;		 GOTO	numlet
;		movlw	wrd_pause
;		movwf	PauseLen
;		clrf	BeepLen
;		GOTO	nextchar		; RETURN there
;
;numlet	       addlw	" "
;		call	GETCODE				;morse code in W
		movfw	AL
		movwf	TempOut
		andlw	b'00000111'
		movwf	TempIndexI			;  
		clrf	IndxI			; IndxI:=0  =7th bit
noshift	       movlw	0x03	
		movwf	NextEntry	; next entry = here
;		btfsC	TempOut,7
;		 GOTO	dash		; 
;dot	       movlw	dot_time		;RETURN event = dot/dash +pause
;		movwf	PauseLen
;		movwf	BeepLen
;		RETURN			
dash	       movlw	dot_time		;RETURN event = dot/dash +pause
		movwf	PauseLen
		movlw	dash_time
		movwf	BeepLen
		RETLW	0
;**************************ENTRYPOINT********************************************
	
here	       movfw	TempIndexI			; 
		subwf	IndxI,W
		skpNZ				; IndxI=bits to do?
		 GOTO	nextchar
		movlw	4			; IndxI=4?
		subwf	IndxI,W
		skpZ	
		 GOTO	morbits			; produce nextevent
		movlw	0x5
		movwf	NextEntry	; next entry = nextchar
;		movlw	5		; TempIndexI=5?
;		subwf	TempIndexI
;		skpNZ	
;		 GOTO	dash
;		movlw	6		; TempIndexI=6?
;		subwf	TempIndexI
;		skpNZ	
		 GOTO	dash
;		GOTO	dot		; TempIndexI = 7
;**************************ENTRYPOINT********************************************
morbits	       incf	IndxI,F
		rlf	TempOut,F
		GOTO noshift
;**************************ENTRYPOINT********************************************
nextchar       movlw	0x02	
;		movwf	NextEntry
;		incf	TextLetter,F
;		movlw	dot_time	;RETURN event = dot pause
;		movwf	PauseLen
;		clrf    BeepLen
;		RETURN  		; NextEntry = nextlet
; 
loopend        movlw	wrd_pause
;		movwf	PauseLen
;		clrf	BeepLen		; NextEntry = 0 nomore
		clrf	NextEntry
		RETLW	0




RESET		clrf	TimerFlag
		clrf	NextEntry
N_LOOP		btfsS Beep_Event
		 call OUTDOTS
		movfw	Tmr0Tick	
		subwf	TMR0,W		;w=TimerTick-TMR0
		andlw	0xC0		;slack 63*32 cycles
		skpNZ
		 call	MSEC4EVENT	;frequent jobs to be done in 4ms 
		;BTFSC	Sec_Flag
		 ;call	ONESECEVENT	;occasional jobs to be done
		goto	N_LOOP
	END
