

#define		inputactivelow	0	;active high
#define		outputactivelow	0	;active high


	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions
	#include <10F204init.asm> 

	cblock Ram0_Start
	 	AL,AH,BL
		TimerFlag,TMR0Temp,Tmr0Tick,Ms4Tick,SeC,MiN,HouR,DaY
		BeepLen,PauseLen:2,TarGet
	endc
#define		dash_thresh	.75	; *4ms=300ms 
#define		Tmr0_Max	.122
#define 	Sec_Max 	.60
#define 	Min_Max		.60
#define 	H_Max		.24

#define 	Ms4_Event	TimerFlag,0 ; 

#define 	Sec_Event	TimerFlag,1 ;

#define 	Min_Event 	TimerFlag,2 ;

#define 	Hour_Event	TimerFlag,3 ;
#define 	Day_Event	TimerFlag,3 ;
#define 	Button_Down	TimerFlag,4
#define 	Pause_Pending	TimerFlag,5

#define 	Input_Priority	TimerFlag,6 

#define 	Full_Activity	TimerFlag,7 


#define 	Indi_Output	GPIO,0;
#define 	Indi_Output_Bit	b'00000001' ;
#define 	Pwm_Output	GPIO,1 ;
;#define 	Pwm_Output_Bit	b'00000010' ;
#define 	Alarm_Output	GPIO,2 ;
;#define 	Alarm_Output_Bit b'00000100' ;
#define 	Beeper_Port	GPIO,2 ;
#define 	Button_Port	GPIO,3 ;
#define 	Input_Port	GPIO,3 ;


indicatoron	macro
		if outputactivelow
		 bcf	Indi_Output	;on =inverted output
		else
		 bsf	Indi_Output
		endif
		endm
indicatoroff	macro
		if outputactivelow
		 bsf	Indi_Output	;on =inverted output
		else
		 bcf	Indi_Output
		endif
		endm

skpifnoinput macro
		if inputactivelow 
		 btfss	Input_Port
		else 		
		 btfsc	Input_Port
		endif
	     endm

skpifinput  macro
		if inputactivelow 
		 btfsc	Input_Port
		else 		
		 btfss	Input_Port
		endif
	    endm

pwmon	    macro		
		if outputactivelow
		 bcf	Pwm_Output	;PWM switched on: inverted output
		else
		 bsf	Pwm_Output
		endif
	    endm

pwmoff	    macro		
		if outputactivelow
		 bsf	Pwm_Output	;PWM switched off: inverted output
		else
		 bcf	Pwm_Output
		endif
	    endm
mov16	macro Source, Target
		movfw	Source
		movwf	Target
		movfw	Source+1
		movwf	Target+1
	endm
sub16	macro	Diff, SubEnd, SubTor
		movfw	SubTor
		subwf	SubEnd,W
		movwf	Diff
		
		movfw	SubTor+1
		skpC	
		 incf	SubTor+1,W
		subwf	SubEnd+1,W
		movwf	Diff+1
	endm
shr16	macro	Target, shifts
		movlw	shifts
		movwf	BL
		clrC
		rrf	Target+1,F
		rrf	Target,F
		decfsz	BL,F
		 goto	$-4
	endm
;
;TB040
;DS91040A-page 2 Preliminary ? 2000 Microchip Technology Inc.
;EXAMPLE 1: 8-BIT EXAMPLE
;A = v0xCF48
;A2 = 0xCF48
;or
;Step
;1	1000 0000 (0x80)	this squared is less than 0xCF48, start next cycle with a new bit

;2
;3
;4
;5
;6
;7
;8
;9
;A
;
;new bit
;1100 0000 (0xC0)
;new bit
;1110 0000 (0xE0)
;new bit
;1111 0000 (0xF0)
;shifted bit
;1110 1000 (0xE8)
;shifted bit
;1110 0100 (0xE4)
;new bit
;1110 0110 (0xE6)
;new bit
;1110 0111 (0xE7)
;bit shifted out
;1110 0110 (0xE6)
;Description
;;this squared is less than 0xCF48, start next cycle with a new bit
;this squared is less than 0xCF48, start next cycle with a new bit
;this is greater than 0xCF48, shift bit right
;this is greater than 0xCF48, shift bit right
;this squared is less than 0xCF48, start next cycle with a new bit
;this squared is less than 0xCF48, start next cycle with a new bit
;this is greater than 0xCF48, shift right
;right-most bit is thrown away for the integer approximation and the
;process is finished; otherwise, this could keep going for more accurate
;fractional approximation

#define 	Ms32_Bit 	0x08 ; 

	
;* case of
;* Pause    Button_   Button_
;*  Pending   Down 	Port
;*      0	0	0	case 0  no action
;*	0	0	1	case 1  clr BL, set B_D, clr P_P
;*	0	1	1	case 2  inc BL
;*	0	1	0	case 3  clr PL, clr B_D, set P_P
;*	1	0	0	case 4  inc PL, if overflow transfer to target
;*	1	0	1	case 5  transfer to target, goto case 1 	
;*
		
MSEC4EVENT:	bcf	Ms4_Event
		btfsc	Pause_Pending	; 
		 goto	cases_4_5
		
		btfss	Button_Down	; 
		 goto	cases_0_1
cases_2_3				; ! max beeplen=255* 16ms= 4 sec

		skpifnoinput		; * test if button closed?  bit set = 5V = WPU
		 goto	endbtn 		; case 2  
					;
		sub16	AL, Ms4Tick, AL 
		movfw	AL
		movf	AH,F
		skpz
		 movlw	0xff		; max beeplen = 1 sec
		movwf	BeepLen
		mov16	Ms4Tick, AL	; case 3			
	        bcf	Button_Down
		bsf	Pause_Pending
		indicatoroff	; switch off Beeper
		goto	endbtn

cases_0_1	skpifinput		; * test if button
		 goto	endbtn		; case 0
  				
case_1		movfw	Ms4Tick
		movwf	AL		; save Timer
		movfw	SeC
		movwf	AH
		bsf	Button_Down	; case 1: new beep detected
		bcf	Pause_Pending	;
		bsf	Input_Priority  ; Input is now running 
		indicatoron
					; switch on Beeper
		goto	endbtn

cases_4_5	skpifnoinput		; * test if button
		 goto	case_5
					; case 5: a pause is counting
		sub16	PauseLen, Ms4Tick, AL
		shr16	PauseLen, .1
		movf	PauseLen+1,F
		skpnz	
		 GOTO	endbtn		; and PauseLen not overflown 
					; max PauseLen 255*4*2 ms = 2. sec
case_5		goto	CLR_BEEP_PAUSE	

CLR_BEEP_PAUSE	movlw	dash_thresh
		subwf	BeepLen,W
		skpC
		 goto $+3
		movlw	.4
		addwf	TarGet,F
		incf	TarGet,F
		movf	PauseLen+1,F
		skpnZ
		 goto	case_1
		bcf 	Pause_Pending	; target finished
		bcf	Input_Priority
		movlw	1x00-Sec_Max	;reset seC, AL
		movwf	SeC
endbtn					;*end button cases
	  	btfss	Sec_Event
		 goto	osxit
		bcf	Sec_Event
		movlw	Indi_Output_Bit	; toggle Indicator
		xorwf	GPIO,F
				;*
osxit		btfss	Min_Event
		 goto	ms4xit
		bcf	Min_Event
		btfsc	Input_Priority
		 goto	ms4xit
		decfsz	TarGet,f
		 goto ms4xit
		bsf	Alarm_Output
ms4xit	     
		RETLW	0

add_processtime movfw	TMR0Temp
		subwf	TMR0,W		; w := TMR0-TMR0Temp
					; 256*32 instructions 
		addwf	Tmr0Tick,F
		skpC
		 goto	xit         ; 122* 32us = 3.9025msec

		movlw	1x00-Tmr0_Max
		addwf	Tmr0Tick,F
		movlw	1

		goto	addms4

add_sleeptime	movlw	.61		
		subwf	Tmr0Tick,F	; 
		skpNC
		 goto	add_slpms4
		movlw	.61 * .4
		addwf	Tmr0Tick,F
		movlw	.3
		goto	$+2
add_slpms4	movlw	.5		;  trigger
	       
addms4		bsf	Ms4_Event
		addwf	Ms4Tick,F	; Msec4Event
		skpC
		 goto xit
		bsf	Sec_Event

inc_sec		incfsz	SeC,F
		 goto	xit
		movlw	1x00-Sec_Max
		addwf	SeC,F
		bsf	Min_Event
		incfsz	MiN,F
		 goto	xit
		movlw	1x00-Min_Max
		addwf	MiN,F
		bsf	Hour_Event
		incfsz	HouR,F
		 goto	xit
		movlw	1x00-H_Max
		addwf	HouR,F
		bsf	Day_Event
		incf	DaY,F
xit		movfw	TMR0
		movwf	TMR0Temp
		Retlw	0

init_time	movlw	0xFF
		movwf	SeC
		movwf	MiN
		movwf	HouR
		movwf	DaY
		goto	inc_sec

		


INIT
RESET		call	init_time
		clrf	TimerFlag
		bsf	Input_Priority
		;bsf 	Full_Activity
	
N_LOOP	
		btfsc	Ms4_Event
		 call	MSEC4EVENT	;next Ms4Bit to flip
		call 	add_processtime
		clrwdt			;prevent reset
		btfsc	Full_Activity
		 goto	N_LOOP
		sleep			;force reset
aftersleep	call add_sleeptime

		goto	N_LOOP
	END
