	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions
	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF
;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	nop			; needed for ICDebugger
	movwf   OSCCAL          ; update register with factory cal value 
	bcf OSCCAL,FOSC4 	; bit 0 FOSC4: INTOSC/4 Output Enable bit(1)

init
io	movlw	B'00001000'	; set direction bits 
	TRIS 	6		; GPIO3 is input (high-z) GPIO0:2 are output

timr	movlw	B'10000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			; bit 6 GPPU: Enable Weak Pull-ups bit (GP0, GP1, GP3)
				;            1 = Disabled
				;  	     0 = Enabled

	
comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; comment instruction for PIC10F200 /202
	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO
	GOTO	RESET		; GOTO RESET skip subroutines when boot.





	;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206
#define ram0_end 	0x1F			; 
#define ram0_length 	ram0_end - ram0_start + 1

	cblock RAM0_START
	AL,AH,BL,BH
	Tmr0Tick,Ms4Tick,TimerFlag,PauseLen, BeepLen
	NextEntry,TempOut,TempIndexI,IndxI,LastNumber
	SecondsL,SecondsH
	endc

#define 	Leading_Zeros	TimerFlag,0
#define 	Beep_On		TimerFlag,1
#define 	Input_Priority	TimerFlag,2
#define 	Beep_Event	TimerFlag,3
#define 	Pause_Pending	TimerFlag,4
#define 	Button_Down	TimerFlag,5



#define 	Button_Port 	GPIO,3  ;	

#define		Beeper_Port	GPIO,2	;

#define		wrd_pause	.15	; 
#define		dot_time	.3	; 
#define		dash_time	.12	; 
#define		dash_thresh	.6	; 

ONESECEVENT:  ;macro
		;movlw	B'00000001'
		;xorwf	GPIO,F		; toggle GP0
		btfsc	Input_Priority	; no countdown if Input 
		 goto  endonesec
		movlw	0xFF			;countdown by adding 
	addwf	SecondsL,F
	skpC
	 addwf	SecondsH,F
	bC    endonesec	; 
 

		movlw	0x01		; start sending!
		movwf	NextEntry	;
		;movlw	.30
		;movwf	SecondsL        ; repeat sending in 30 sec
		
endonesec      goto ms4xit
	;endm 				;	RETLW 0

clr2f	macro	var
		clrf	var
		clrf	var+1
	endm

movl2	macro   var, hex1
		movlw	hex1 & 0xFF
		movwf	var
		movlw	hex1 >>D'08'
		movwf	var+1
	endm
add2	macro	var1, var2
		movfw	var1
		addwf	var2,F
		addcf	var2+1,F
		movfw	var1+1
		addwf	var2+1,F
	endm		
shl2	macro 	var
		clrc
		rlf	var,F
		rlf	var+1,F
	endm
#define 	DiviSor		BL
#define 	DiviDend	BH
#define 	DiviTemp	TempOut

modulo10 macro
		movlw	.10
		movwf	DiviSor
		clrf	AH
mod8	       movlw	1
		movwf	AL
		movfw	DiviSor
		movwf	DiviTemp
		subwf	DiviDend,W
		bNC	finish
		movwf	DiviDend
		movfw	AL
		addwf	AH,F
rrTemp	       clrC	
		rlf	DiviTemp,F	; rrf = *2
		rlf	AL,F
		movfw	DiviTemp
		subwf	DiviDend,W
		bnC	mod8		; unsucessful sub	
		movwf	DiviDend
		movfw	AL
		addwf	AH,F
		goto	rrTemp
finish         movfw	AH
		movwf	DiviSor		;decimal result in BL, BH 	
		endm

mul8x8.8 macro MultiplAnd, MultConstant
		clr2f	BL		; result in BL
		movl2	AL, MultConstant ;0x0064	; decimal .100
moreadd	        btfss	MultiplAnd,0
		 goto	noadd
		add2	AL, BL		; B= A+B
noadd	       shl2	AL		; A= A * 2
		clrc
		rrf	MultiplAnd,F	; more bits to work with?
		movf	MultiplAnd,F
		bnz	moreadd
	endm				; result in BL,BH


INPUTJOB: ;macro

;* case of
;* Pause    Button_   Button_
;*  Pending   Down 	Port
;*      0	0	0	case 0  no action
;*	0	0	1	case 1  clr BL, set B_D, clr P_P
;*	0	1	1	case 2  inc BL
;*	0	1	0	case 3  clr PL, clr B_D, set P_P
;*	1	0	0	case 4  inc PL, if overflow transfer to target
;*	1	0	1	case 5  transfer to target, goto case 1 	
;*
		btfsc	Pause_Pending	; 
		 goto	cases_4_5
		
		btfss	Button_Down	; 
		 goto	cases_0_1
		
		movlw	0x0F
		subwf	BeepLen,W
		skpZ
		 incf	BeepLen,F       ; case 2+3
					; ! max beeplen=15 

		btfss	Button_Port	; * test if button closed?  bit set = 5V = WPU
		 goto	endbtn 		; case 2 finished 
					;
		clrf	PauseLen	; case 3			
	        bcf	Button_Down
		bsf	Pause_Pending
		movlw	B'11111101'	; switch off GP2
		andwf	GPIO,F
		goto	endbtn

cases_0_1	btfsc	Button_Port	; * test of button
		 goto	endbtn		; case 0
  				
case_1		clrf	BeepLen
		bsf	Button_Down	; case 1 new beep
		bcf	Pause_Pending	;
		clrf	AL		; target
		bsf	Input_Priority 
		movlw	B'00000010'	; switch on GP2
		iorwf	GPIO,F
		goto	endbtn

cases_4_5	btfss	Button_Port	; * test of button
		 goto	case_5
		movlw	b'00010000'	; case 5: a pause is counting
		addwf	PauseLen,F
		skpC
		 GOTO	endbtn		; and PauseLen not overflown 
case_5
		
	

CLR_BEEP_PAUSE	
		
		bcf	Input_Priority
			;calculation
FIND_TARGET	clrf	IndxI
nexti	       movlw	.36
		subwf 	IndxI,W		;while IndxI<36
		skpNC
		 GOTO ffail
		movfw	IndxI
		call	NUMERIC
		subwf	BH,W
		skpNZ
		 GOTO	fsucess
		incf	IndxI,F
		GOTO	nexti
ffail
fsucess	       movfw	IndxI
		movwf	BH		; result = Beeplen * 100/255 
		movlw	.3
		movwf	SecondsL	; start sending in 3 sec
		;endcalculation		
endbtn		goto betest
 	;endm	

MSEC4EVENT:	movlw	0x01
		addwf	Ms4Tick,W
		xorwf	Ms4Tick,W
		andlw	B'00010000'	; filter any bit 7:0
		skpnZ
		 goto	no64msjob

		goto INPUTJOB

betest	       btfsS	Beep_Event		; if not already sending beeps
		 GOTO	nobeep
		btfsC	Input_Priority		; if not waiting for input
		 GOTO	nobeep
		movf	BeepLen,F		; beeplen != 0 ?
		skpNZ
		 GOTO	bedone
		btfsS	Beep_On
		 bsf	Beeper_Port		; buzzer on
		bsf	Beep_On
		decfsz	BeepLen,F		; BeepLen expired ?
		 GOTO	nobeep
		bcf	Beeper_Port
		bcf	Beep_On			; buzzer off
bedone	       movf	PauseLen,F		; pause to work off?
		skpNZ
		 GOTO	clrbeep	
		decfsz	PauseLen,F
		 GOTO	nobeep
clrbeep		bcf	Beep_Event
nobeep

;*
no64msjob      
		decfsz	Ms4Tick,F	; new Ms4Tick
		 GOTO	ms4xit
					; 256 * 3,906 ms = 1sec
	
		goto ONESECEVENT 	;
;*
ms4xit	       movlw	.122		; 122* 32us = 3,906 msec
		addwf	Tmr0Tick,F
		RETLW 0	

NUMERIC		addwf	PCL,F

		retlw b'11111100'  ; 0 -----
		retlw b'01111100'  ; 1 .----
		retlw b'00111100'  ; 2 ..---
		retlw b'00011100'  ; 3 ...--
		retlw b'00001100'  ; 4 ....-
		retlw b'00000100'  ; 5 .....
		retlw b'10000100'  ; 6 -....
		retlw b'11000100'  ; 7 --...
		retlw b'11100100'  ; 8 ---..
		retlw b'11110100'  ; 9 ----.
alpha	retlw b'01000001'  ; A .-
	retlw b'10000011'  ; B -...
	retlw b'10100011'  ; C -.-.
	retlw b'10000010'  ; D -..
	retlw b'00000000'  ; E .
	retlw b'00100011'  ; F ..-.
	retlw b'11000010'  ; G --.
	retlw b'00000011'  ; H ....
	retlw b'00000001'  ; I ..
	retlw b'01110011'  ; J .---
	retlw b'10100010'  ; K -.-
	retlw b'01000011'  ; L .-..
	retlw b'11000001'  ; M --
	retlw b'10000001'  ; N -.
	retlw b'11100010'  ; O ---
	retlw b'01100011'  ; P .--.
	retlw b'11010011'  ; Q --.-
	retlw b'01000010'  ; R .-.
	retlw b'00000010'  ; S ...
	retlw b'10000000'  ; T -
	retlw b'00100010'  ; U ..-
	retlw b'00010011'  ; V ...-
	retlw b'01100010'  ; W .--
	retlw b'10010011'  ; X -..-
	retlw b'10110011'  ; Y -.--
	retlw b'11000011'  ; Z --..
fullstp retlw b'01010101'  ; ;Fullstop .-.-.- discrete char
comma	retlw b'11001110'  ; ;Comma --..--    discrete char
query	retlw b'00110111'  ; ;Query   ..--..   discrete char
	
	

OUTDOTS:	btfsc	Input_Priority
		 RETLW	0
		bsf	Beep_Event
		movfw	NextEntry
		addwf	PCL,F
		GOTO	nomorebeep
		GOTO	start_sending		;entry = 1
		GOTO	nextlet			;2
		GOTO	here			;3
		GOTO	morbits			;4
		GOTO	nextchar		; entry=5

nomorebeep     bcf 	Beep_Event
		clrf	NextEntry
		RETLW 0
;**************************ENTRYPOINT********************************************
start_sending  	
	
;**************************ENTRYPOINT********************************************

nextlet	       	movfw	BH
numlet		call	NUMERIC			;morse code in W
	 	movwf	TempOut
		andlw	b'00000111'
		movwf	TempIndexI		;  
		clrf	IndxI			; IndxI:=0  =7th bit
noshift	       movlw	0x03	
		movwf	NextEntry	; next entry = here
		btfsC	TempOut,7
		 GOTO	dash		; 
dot	       movlw	dot_time	;RETURN event = dot+pause
		movwf	PauseLen
		movwf	BeepLen
		RETLW 0			
dash	       movlw	dot_time	;RETURN event = dash +pause
		movwf	PauseLen
		movlw	dash_time
		movwf	BeepLen
		RETLW	0
;**************************ENTRYPOINT********************************************
	
here	       movfw	TempIndexI	; 
		subwf	IndxI,W
		skpNZ			; IndxI=bits to do?
		 GOTO	nextchar
		movlw	4		; IndxI=4?
		subwf	IndxI,W
		skpZ	
		 GOTO	morbits		; produce nextevent
		movlw	0x5
		movwf	NextEntry	; next entry = nextchar

;**************************ENTRYPOINT********************************************
morbits	       incf	IndxI,F
		rlf	TempOut,F
		GOTO noshift
;**************************ENTRYPOINT********************************************
nextchar       ;movlw	0x02	
		;movwf	NextEntry
		;ACTION
	 	goto loopend		; all letters/numbers sent

	
		movlw	dot_time	; RETURN event = dot pause
		movwf	PauseLen
		clrf    BeepLen
		RETLW 	0  		; NextEntry = nextlet
; 
loopend       				; movlw	wrd_pause
;		movwf	PauseLen
;		clrf	BeepLen		; NextEntry = 0 nomore
		clrf	NextEntry
		RETLW	0




RESET		clrf	TimerFlag
		clrf	NextEntry
		clrf	SecondsL
		clrf	SecondsH
N_LOOP		btfsS Beep_Event
		 call OUTDOTS
		movfw	Tmr0Tick	
		subwf	TMR0,W		;w=TimerTick-TMR0
		andlw	0xC0		;slack 63*32 cycles
		skpNZ
		 call	MSEC4EVENT	;frequent jobs to be done in 4ms 
		;BTFSC	Sec_Flag
		 ;call	ONESECEVENT	;occasional jobs to be done
		goto	N_LOOP
	END
