	list      p=10F204            ; list directive to define processor
	#include <p10F204.inc>        ; processor specific variable definitions

	__CONFIG   _MCLRE_OFF & _CP_OFF & _WDT_OFF


;***** VARIABLE DEFINITIONS
#define RAM0_START 	0x10			; 0x08 for 202 and 206

	cblock RAM0_START
	AL,AH
	Tmr0Tick,Ms4Tick
	SecondsL,SecondsH
	endc



;**********************************************************************
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	nop			; needed for ICDebugger
	movwf   OSCCAL          ; update register with factory cal value 
	bcf OSCCAL,FOSC4 	;bit 0 FOSC4: INTOSC/4 Output Enable bit(1)
	;bsf OSCCAL,FOSC4	;uncomment to see processor working with oscilloscop

init
io	movlw	B'00001000'	; set direction bits 
	TRIS 	6		; GPIO3 is input (high-z) GPIO0:2 are output

timr	movlw	B'11000100'	; Timer0 internal clock, 1:32 prescale
	OPTION			; 
	
comp	movlw	b'11110111'     ; configure comparator inputs as analog Inputs
	movwf	CMCON0		; 
	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO
;	GOTO	RESET		; GOTO RESET skip subroutines when boot.

setwait macro minsec
		movlw ((minsec & 0xFF) + 60*(minsec>>8 ))& 0xFF
		movwf	SecondsL
		movlw ((minsec &0xFF) +  60*(minsec>>8))>>8
		movwf	SecondsH
	endm;
RESET		
N_LOOP		
		movfw	Tmr0Tick	
		subwf	TMR0,W		;w=TimerTick-TMR0
		andlw	0xC0		;slack 63*32 cycles
		skpZ
		 goto	N_LOOP
MSEC4EVENT
		decfsz	Ms4Tick,F	; new Ms4Tick
		 GOTO	ms4xit		; 256 * 3,906 ms = 1sec


;*
ONESECEVENT 	movfw	SecondsL	; L and Hi =0
		iorwf	SecondsH,W
		bz     	 testhi
		movlw	0x01
		subwf	SecondsL,F	; L  or H not zero		
		skpC
		 decf	SecondsH,F
		goto	ms4xit
		movlw	b'11111111'     ; configure comparator inputs as analog Inputs
testhi		movwf	CMCON0		; external ref :upper limit
		btfss	CMCON0,CMPOUT	; if CIN+ >2.7V		
		 goto	testlo	
		bcf	GPIO,2
		setwait 0x0500
		goto ms4xit
testlo		movlw	b'11111011'     ; configure comparator inputs as analog Inputs
		movwf	CMCON0		; internal ref :lower limit
		btfsc	CMCON0,CMPOUT	; if CIN+ > 0.6V		
		 goto	ms4xit
		bsf	GPIO,2
		setwait 0x0100

ms4xit	       movlw	.122		; 122* 32us = 3,906 msec
		addwf	Tmr0Tick,F
		goto	N_LOOP
	END
