	list      p=12f629       
	#include <p12f629.inc>        
	errorlevel  -302		; suppress message 302 from list file

	__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT  

;GENERAL PURPOSE REGISTERS
TIMER1          EQU     H'20'   ;Timer 1, Used for general delay.		
TIMER2          EQU     H'21'   ;Timer 2, used for delay !

;**********************************************************************
;Reset Vector
;**********************************************************************
	ORG     0x000            
	call	0x3FF      	; Retrieve Factory Calibration Value
	BANKSEL	OSCCAL	    	; BANK1
	movwf   OSCCAL      	; Load OSCCAL
	goto    INIT            
;*************************************************************************************************************************	
;EEREAD(W) - Address To Read Is Contained In W When This Function Is Called
;***************************************************************************************************************
EEREAD
	BANKSEL	EEADR		;BANK1
	movwf	EEADR
	bsf		EECON1,RD
	movf	EEDATA,W
	BANKSEL	GPIO		;BANK0
	return	

;**********************************************************************************************************
;EEWRITE(W) - Address To Read Is Contained In W When This Function Is Called
;           - EEDATA Is Loaded Prior To This Function Call
;           - BANK1 must be selected before this function is called
;****************************************************************************************************	
EEWRITE
	movwf	EEADR		
	bsf		EECON1,WREN
	bcf		INTCON,GIE
	movlw	0x55
	movwf	EECON2
	movlw	0xAA
	movwf	EECON2
	bsf		EECON1,WR
EECOMPLETE
	btfsc	EECON1,WR
	goto	EECOMPLETE
	bcf		EECON1,WREN	
	return
	
;***********************************************************************
;Initialization
;***********************************************************************
		
;		**************************
;               *        delay  routine: *
;               **************************
DELAY		CLRWDT
		MOVLW   D'255'          ;*
                MOVWF   TIMER1          ;*
                ;
DELAY2		MOVLW	D'255'
		MOVWF	TIMER2
		DECFSZ  TIMER2,F        ;*
                GOTO    $-1             ;*
                
		DECFSZ	TIMER1,F
		GOTO	DELAY2	
		RETLW   0


INIT
	movlw	b'00111110'	;GP0-OUTPUT, GP1-Input, GP2-Input, GP3-input, GP4-input,GP5-input
	movwf	TRISIO		
				;	clrf	ANSEL		
	clrf	VRCON		;Turn Off VREF
	BANKSEL	GPIO		;BANK 0

	movlw	.7		;Turn Off comparator
	movwf	CMCON

	BANKSEL	OPTION_REG	;BANK 1	
	movlw	b'01001000'	;Pull Ups Enabled, Rising Edge, Assigned to WDT , Prescaler is 1:1 WDT
	movwf	OPTION_REG	
	bsf	WPU,2		;GP2 - Pullup Enabled	
	bsf	WPU,1		;GP1 - Pullup Enabled
	BANKSEL	GPIO		;BANK0
	clrf	GPIO

LOOP		
		MOVLW	B'00000001'
		xorwf	GPIO,f
		CALL	DELAY
		

		GOTO	LOOP

	  	end
