
	list      p=12F629	; list directive to define processor
	#include <p12f629.inc>	; processor specific variable definitions
	#include <12f629init.asm>
	

	cblock Ram0_Start
		AL,AH
		Tmr0Tick,Ms4Tick,TimerFlag,PauseLen, BeepLen
	endc
#define 	Input_Priority	TimerFlag,0
#define 	Button_Down	TimerFlag,3
#define 	Pause_Pending	TimerFlag,4



#define 	Button_Port 	GPIO,3  ;	

#define		Beeper_Port	GPIO,2	;

;******************************************************************************
;Subroutines & Functions
;******************************************************************************
setPWM		movlw	.10		; PWM Cylces
		movwf	AH		
		RETLW	0	

MSEC4EVENT:	movlw	0x01
		addwf	Ms4Tick,W
		xorwf	Ms4Tick,W
		andlw	B'00001000'	; filter any bit 7:0 16ms
		skpnZ
		 goto	no64msjob
;* case of
;* Pause    Button_   Button_
;*  Pending   Down 	Port
;*      0	0	0	case 0  no action
;*	0	0	1	case 1  clr BL, set B_D, clr P_P
;*	0	1	1	case 2  inc BL
;*	0	1	0	case 3  clr PL, clr B_D, set P_P
;*	1	0	0	case 4  inc PL, if overflow transfer to target
;*	1	0	1	case 5  transfer to target, goto case 1 	
;*
		btfsc	Pause_Pending	; 
		 goto	cases_4_5
		
		btfss	Button_Down	; 
		 goto	cases_0_1
		
		incfSZ	BeepLen,F       ; case 2+3
		  GOTO	$+2		; *
		decf	BeepLen,F	; ! max beeplen=255* 16ms= 4 sec

		btfss	Button_Port	; * test if button closed?  bit set = 5V = WPU
		 goto	endbtn 		; case 2 finished 
					;
		clrf	PauseLen	; case 3			
	        bcf	Button_Down
		bsf	Pause_Pending
		bcf	Beeper_Port 	; switch off Beeper
		goto	endbtn

cases_0_1	btfsc	Button_Port	; * test if button
		 goto	endbtn		; case 0
  				
case_1		clrf	BeepLen
		bsf	Button_Down	; case 1: new beep detected
		bcf	Pause_Pending	;
		bsf	Input_Priority  ; Input is now running 
		bsf	Beeper_Port
					; switch on Beeper
		goto	endbtn

cases_4_5	btfss	Button_Port	; * test if button
		 goto	case_5
					; case 5: a pause is counting
		incfsz	PauseLen,F
		 GOTO	endbtn		; and PauseLen not overflown 
					; max PauseLen 255*16 ms = 4 sec
case_5		goto	CLR_BEEP_PAUSE	

CLR_BEEP_PAUSE	
		incf	AL,F
		movf	PauseLen,F
		skpZ
		 goto	case_1
		bcf 	Pause_Pending	; target finished
		bcf	Input_Priority
		call	setPWM
		goto endbtn
		
	
endbtn		
;*
no64msjob      decfsz	Ms4Tick,F	; new Ms4Tick
		 GOTO	ms4xit		; 256 * 3,906 ms = 1sec
					;*
ONESECEVENT: 	btfsc	Input_Priority
		 goto	endonesec
		btfsc	Beeper_Port
		 goto	clrport
		movfw	AH		; AH>=AL ?
		subwf	AL,W
		skpC
 	         bsf 	Beeper_Port	; Pulse skipped if no BORROW
		decfsz	AH,F		; 
		 goto	endonesec	; 
		call	setPWM		
		goto 	endonesec
clrport	       bcf	Beeper_Port
		
endonesec 				;	RETLW 0

		;ONESECEVENT 		
;*
ms4xit	       movlw	.122		; 122* 32us = 3,906 msec
		addwf	Tmr0Tick,F
		RETLW 0	





RESET		clrf	AL
		clrf	TimerFlag
		call	setPWM
		clrf	GPIO
N_LOOP	
		movfw	Tmr0Tick	
		subwf	TMR0,W		;w=TimerTick-TMR0
		andlw	0xC0		;slack 63*32 cycles
		skpNZ
		 call	MSEC4EVENT	;frequent jobs to be done in 4ms 
		
		goto	N_LOOP
	END
