	list      p=12F629            ; list directive to define processor
	#include <p12F629.inc>        ; processor specific variable definitions
	
	__CONFIG  _CP_OFF & _CPD_OFF & _BODEN_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT  

#define		inputactivelow	1	;active low
#define		outputactivelow	0	;active high


	#include <12F629init.asm> 
	
	cblock Ram0_Start
	 	AL,AH,BL
		TimerFlag,TF1,TMR0Temp,Tmr0Tick,Ms4Tick,SeC,MiN,HouR,DaY,Slice200Tick
		BeepLen,PauseLen:2,TarGet,TMirror
	endc
#define		dash_thresh	.75	; *4ms=300ms 
#define		Tmr0_Max	.122
#define 	Sec_Max 	.60
#define 	Min_Max		.60
#define 	H_Max		.24

#define 	Ms4_Event	TimerFlag,0 ; 

#define 	Sec_Event	TimerFlag,1 ;

#define 	Min_Event 	TimerFlag,2 ;

#define 	Hour_Event	TimerFlag,3 ;
#define 	Day_Event	TimerFlag,3 ;
#define 	Button_Down	TimerFlag,4
#define 	Pause_Pending	TimerFlag,5

#define 	Input_Priority	TimerFlag,6 

#define 	Full_Activity	TimerFlag,7 
#define		Os_Case4force	TF1,0

#define 	Indi_Output	GPIO,2;
#define 	Indi_Output_Bit	b'00000100' ;
#define 	Pwm_Output	GPIO,1 ;
;#define 	Pwm_Output_Bit	b'00000010' ;
#define 	Alarm_Output	GPIO,2 ;
;#define 	Alarm_Output_Bit b'00000100' ;

#define 	Beeper_Port	GPIO,2 ;
#define 	Input_Port	GPIO,3 ;

	movlw	b'00000000'	; set all Outputs to Low Voltage
	if outputactivelow
	 iorlw	Pwm_Output_Bit	
	 iorlw	Indi_Output_Bit	; inverted Output
	endif
	movwf	GPIO		; 
	goto	RESET


indicatoron	macro	
		if outputactivelow
		 bcf	Indi_Output	;on =inverted output
		else
		 bsf	Indi_Output
		endif
		endm
indicatoroff	macro
		if outputactivelow
		 bsf	Indi_Output	;on =inverted output
		else
		 bcf	Indi_Output
		endif
		endm


skpifnoinput macro
		if inputactivelow 
		 btfss	Input_Port
		else 		
		 btfsc	Input_Port
		endif
	     endm

skpifinput  macro
		if inputactivelow 
		 btfsc	Input_Port
		else 		
		 btfss	Input_Port
		endif
	    endm
mov16	macro Source, Target
		movfw	Source
		movwf	Target
		movfw	Source+1
		movwf	Target+1
	endm
sub16	macro	Diff, SubEnd, SubTor
		movfw	SubTor
		subwf	SubEnd,W
		movwf	Diff
		
		movfw	SubTor+1
		skpC	
		 incf	SubTor+1,W
		subwf	SubEnd+1,W
		movwf	Diff+1
	endm
shr16	macro	Target, shifts
		movlw	shifts
		movwf	BL
		clrC
		rrf	Target+1,F
		rrf	Target,F
		decfsz	BL,F
		 goto	$-4
	endm

#define 	Ms32_Bit 	0x08 ; 

	
;* case of
;* Pause    Button_   Button_
;*  Pending   Down 	Port
;*      0	0	0	case 0  no action
;*	0	0	1	case 1  clr BL, set B_D, clr P_P
;*	0	1	1	case 2  inc BL
;*	0	1	0	case 3  clr PL, clr B_D, set P_P
;*	1	0	0	case 4  inc PL, if overflow transfer to target
;*	1	0	1	case 5  transfer to target, goto case 1 	
;*
		
MSEC4EVENT:	bcf	Ms4_Event
		btfsc	Pause_Pending	; 
		 goto	cases_4_5
		
		btfss	Button_Down	; 
		 goto	cases_0_1
cases_2_3				; ! max beeplen=255* 16ms= 4 sec

		skpifnoinput		; * test if button closed?  bit set = 5V = WPU
		 goto	endbtn 		; case 2  
					;
		sub16	AL, Ms4Tick, AL 
		movfw	AL
		movf	AH,F
		skpz
		 movlw	0xff		; max beeplen = 1 sec
		movwf	BeepLen
		mov16	Ms4Tick, AL	; case 3			
	        bcf	Button_Down
		bsf	Pause_Pending
		indicatoroff	; switch off Beeper
		goto	endbtn

cases_0_1	skpifinput		; * test if button
		 goto	endbtn		; case 0
  				
case_1		movfw	Ms4Tick
		movwf	AL		; save Timer
		movfw	SeC
		movwf	AH
		bsf	Button_Down	; case 1: new beep detected
		bcf	Pause_Pending	;
		btfss	Input_Priority	; clear Target if breaking countdown
		 clrf	TarGet
		bsf	Input_Priority  ; Input is now running 
		indicatoron		; switch on Beeper
		goto	endbtn

cases_4_5	skpifnoinput		; * test if button
		 goto	case_5
					; case 5: a pause is counting
		sub16	PauseLen, Ms4Tick, AL
		shr16	PauseLen, .1
		movf	PauseLen+1,F
		skpnz	
		 GOTO	endbtn		; and PauseLen not overflown 
					; max PauseLen 255*4*2 ms = 2. sec
case_5		;goto	CLR_BEEP_PAUSE	

CLR_BEEP_PAUSE	movlw	dash_thresh
		subwf	BeepLen,W
		skpC
		 goto $+3
		movlw	.4
		addwf	TarGet,F
		incf	TarGet,F
		movf	PauseLen+1,F
		skpnZ
		 goto	case_1
		bcf 	Pause_Pending	; target finished
		bcf	Input_Priority
		movlw	1x00-Sec_Max	;reset seC, AL
		movwf	SeC
		clrf	PauseLen
endbtn		movfw	Slice200Tick	
		subwf	Ms4Tick,W	;w=Tick-TMR0
		andlw	b'11111000'	;slack 8*32 cycles
		skpZ		
		 goto nobeep
		movlw	.50
		addwf	Slice200Tick,F

		btfsc	Input_Priority		; dont display until input clr
		 goto	os_exit
		movf	TarGet,F
		skpnz
		 goto	os_exit
;case 0: PauseLen>0		decrement PauseLen	
;
;case 1: TMirror=0 PauseLen=0		copy Target to TMirror; PauseLen=100
;
;case 2: TMirror>0 Port_Lo		>Port_Hi
;
;case 3a: TMirror>=5 Port_Hi		TMirror -= 5  force case 3c
;      b: TMirror<5			TMirror -= 1 >Port_Lo
;      c: 				clr case3c	force case4 ;triple length beep
;case 4:                        >Port_Lo
;
		btfsc	Os_Case4force
		 goto	os_case4
		movf	TMirror,F		; TMirror = 0?
		skpZ
		 goto	os_cases2_3
		movf	PauseLen,F
		skpZ
		 goto	os_case0
		movfw	TarGet
		movwf	TMirror

		goto	os_exit
os_case0	decf	PauseLen,F
		goto	os_exit

os_cases2_3	btfsc	Beeper_Port
		 goto	os_case3
		bsf	Beeper_Port
		goto	os_exit
os_case3	movlw	5
		subwf	TMirror,W
		skpC
		 goto	os_case3b
		movwf	TMirror
		bsf	Os_Case4force
		goto	os_exit
os_case3b	decf	TMirror,F
os_case4	bcf	Os_Case4force
		bcf	Beeper_Port
		movf	TMirror,F
		skpz
		 goto	os_exit
		movlw	.75
		movwf	PauseLen
os_exit			

nobeep	btfss	Sec_Event
		 goto	osxit
		bcf	Sec_Event
	
		;movlw	Indi_Output_Bit	; toggle Indicator
		;xorwf	GPIO,F
				;*
osxit		btfss	Min_Event
		 goto	ms4xit
		bcf	Min_Event
		btfsc	Input_Priority
		 goto	ms4xit
		movf	TarGet,F
		skpnz
		 goto	ms4xit		; no targetcount
		decfsz	TarGet,f
		 goto ms4xit
		bsf	Alarm_Output
ms4xit	     
		RETLW	0

add_processtime movfw	TMR0Temp
		subwf	TMR0,W		; w := TMR0-TMR0Temp
					; 256*32 instructions 
		addwf	Tmr0Tick,F
		skpC
		 goto	xit         ; 122* 32us = 3.9025msec

		movlw	1x00-Tmr0_Max
		addwf	Tmr0Tick,F
		movlw	1

		goto	addms4

add_sleeptime	movlw	.61		; 61 * 32us
		addwf	Tmr0Tick,F	; +
		movlw	.5		; 4 * 3,9ms  =18ms
		skpC			; 3 Volt
		 goto addms4
		movlw	1x00-Tmr0_Max
		addwf	Tmr0Tick,F
		movlw	.6		; 3Volt

	       
addms4		bsf	Ms4_Event
		addwf	Ms4Tick,F	; Msec4Event
		skpC			
		 goto xit		
		bsf	Sec_Event	; 255*3,9ms  = 1sec

inc_sec		incfsz	SeC,F
		 goto	xit
		movlw	1x00-Sec_Max
		addwf	SeC,F
		bsf	Min_Event
		incfsz	MiN,F
		 goto	xit
		movlw	1x00-Min_Max
		addwf	MiN,F
		bsf	Hour_Event
		incfsz	HouR,F
		 goto	xit
		movlw	1x00-H_Max
		addwf	HouR,F
		bsf	Day_Event
		incf	DaY,F
xit		movfw	TMR0
		movwf	TMR0Temp
		Retlw	0

init_time	movlw	0xFF
		movwf	SeC
		movwf	MiN
		movwf	HouR
		movwf	DaY
		goto	inc_sec

		



RESET		movlw	Ram0_Start
		movwf	FSR
clrmore		movlw	Ram0_End
		subwf	FSR,W
		skpnz
		 goto clrend
		clrf	INDF
		incf	FSR,F
		goto	clrmore
clrend		call	init_time
		;bsf	Input_Priority
		;bsf 	Full_Activity
	
N_LOOP	
		btfsc	Ms4_Event
		 call	MSEC4EVENT	;next Ms4Bit to flip
		call 	add_processtime
		clrwdt			;prevent reset
		btfsc	Full_Activity
		 goto	N_LOOP
		sleep			;force reset
aftersleep	call add_sleeptime

		goto	N_LOOP
	END
