
	list      p=12F683	; list directive to define processor
	#include <p12f683.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define switch		GPIO,3
#define	LED0TRIS	b'11001111'
#define	LED1TRIS	b'11001111'
#define	LED2TRIS	b'11101011'
#define	LED3TRIS	b'11101011'
#define	LED4TRIS	b'11011011'
#define	LED5TRIS	b'11011011'
#define	LED6TRIS	b'11111001'
#define	LED7TRIS	b'11111001'
#define LED0ON		b'00010000'
#define	LED1ON		b'00100000'
#define	LED2ON		b'00010000'
#define	LED3ON		b'00000100'
#define	LED4ON		b'00100000'
#define	LED5ON		b'00000100'
#define	LED6ON		b'00000100'
#define	LED7ON		b'00000010'
#define LTRIS 		LED5TRIS
#define	LEDON		LED5ON



;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000		; processor reset vector
	nop			; required by in circuit debugger
	goto    Init		; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG     0x004
	return			; interrupt trap - return without re-enabling 

;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1		; BANK1
	
	movlw	LTRIS	; set direction bits 
	movwf	TRISIO		; 
	movlw	B'11010100'	; Timer0 internal clock, 1:32 prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
	clrf	ANSEL		; configure A/D I/O as digital
	movlw	b'01100001'
	movwf	OSCCON		; 4MHz
	banksel	Bank0		; switch back to PORT memory bank
	movlw	b'00000111'     ; CM2 | CM1 | CM0 ; configure comparator inputs as digital I/O
	movwf	CMCON0	
	movlw	b'00000000'
	movwf	INTCON		;


;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	AL,AH,FilterCount		; debounce filter counter
	endc
	
;******************************************************************************
;Main 
;******************************************************************************
Main	movlw	LEDON
	movwf	GPIO
loop	movlw	0x01
	addwf	AL,F                     
	skpZ
	  goto	loop		;loop until AL overflow
	addwf	AH,F                        
	skpZ
	  goto	loop		;loop until BL overflow
 	movlw	LEDON
	xorwf 	GPIO,F

	goto	loop
;******************************************************************************
;Subroutines & Functions
;******************************************************************************

;******************************************************************************
;TestSwitch - Test switch state and take action when filter count saturates
;******************************************************************************
TestSwitch
	btfss	switch		; test for switch closure
	goto	SwitchClosed

SwitchOpen
; When switch is open - decrement count if not already saturated
	movf	FilterCount,f	; move affects zero flag
	btfsc	STATUS,Z	; test filter count for zero
	return			; count was already zero - no further action

; drive LED0 on when switch is open and count saturates at zero	

	decfsz	FilterCount,f	; decrement filter count
	return			; not zero - return to monitor loop
	
	call	LED0		; light LED0
	return			; return to monitor loop
	
SwitchClosed
; When switch is closed - increment count if not already saturated
	btfsc	FilterCount,4	; 16 count saturation if bit 4 is high
	return			; already saturated - return to monitor loop

; drive LED1 when switch is closed and count saturates at 16
	
	incf	FilterCount,f	; count up when switch is closed
	btfsc	FilterCount,4	; 16 count saturation when bit 4 goes high
	call	LED1		; light LED1
	
	return			; return to monitor loop

;******************************************************************************
;LED0 - Drive I/O port to turn D0 on
;******************************************************************************
LED0
	movlw	LEDON		; data to forward bias LED0 and reverse bias LED1
	movwf	GPIO		; send data to GPIO port
	return			; return to calling routine
	
;******************************************************************************
;LED1 - Drive I/O port to turn D1 on
;******************************************************************************
LED1
	movlw	0x00		; data to forward bias LED1 and reverse bias LED0
	movwf	GPIO		; send data to GPIO port
	return			; return to calling routine
	
	END
