
	list      p=12F683	; list directive to define processor
	#include <p12f683.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define switch		GPIO,3
#define	LED0TRIS	b'11001111'
#define	LED1TRIS	b'11001111'
#define	LED2TRIS	b'11101011'
#define	LED3TRIS	b'11101011'
#define	LED4TRIS	b'11011011'
#define	LED5TRIS	b'11011011'
#define	LED6TRIS	b'11111001'
#define	LED7TRIS	b'11111001'
#define LED0ON		b'00010000'
#define	LED1ON		b'00100000'
#define	LED2ON		b'00010000'
#define	LED3ON		b'00000100'
#define	LED4ON		b'00100000'
#define	LED5ON		b'00000100'
#define	LED6ON		b'00000100'
#define	LED7ON		b'00000010'
#define LTRIS 		LED5TRIS
#define	LEDON		LED5ON



;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000		; processor reset vector
	nop			; required by in circuit debugger
	goto    Init		; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG     0x004
	return			; interrupt trap - return without re-enabling 

;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1		; BANK1
	
	movlw	LTRIS	; set direction bits 
	movwf	TRISIO		; 
	movlw	B'11010100'	; Timer0 internal clock, 1:32 prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
	clrf	ANSEL		; configure A/D I/O as digital
	movlw	b'01100001'
	movwf	OSCCON		; 4MHz
	banksel	Bank0		; switch back to PORT memory bank
	movlw	b'00000111'     ; CM2 | CM1 | CM0 ; configure comparator inputs as digital I/O
	movwf	CMCON0	
	movlw	b'00000000'
	movwf	INTCON		;
	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO

	goto	RESET

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************
#define RAM0_START 	0x20			;
#define ram0_end 	0x7F			; 

	cblock RAM0_START
	AL,AH,BL,BH
	Tmr0Tick,Ms4Tick,TimerFlag,PauseLen, BeepLen
	TempOut,TempIndexI,IndxI,LastNumber
	SecondsL,SecondsH
	endc

#define 	Leading_Zeros	TimerFlag,0
#define 	Beep_On		TimerFlag,1
#define 	Input_Priority	TimerFlag,2
#define 	Beep_Event	TimerFlag,3
#define 	Pause_Pending	TimerFlag,4
#define 	Button_Down	TimerFlag,5

#define 	Next_En1	TempIndexI,3
#define 	Next_En2	TempIndexI,4
#define 	Next_En3	TempIndexI,5
#define 	Next_En4	TempIndexI,6
#define 	Next_En5	TempIndexI,7



#define 	Button_Port 	GPIO,3  ;	

#define		Beeper_Port	GPIO,2	;

#define		wrd_pause	.15	; 
#define		dot_time	.3	; 
#define		dash_time	.12	; 
#define		dash_thresh	.6	; 

ONESECEVENT:  ;macro
		;movlw	B'00000001'
		;xorwf	GPIO,F		; toggle GP0
		btfsc	Input_Priority	; no countdown if Input 
		 goto  endonesec
		;movfw	SecondsL
		;iorwf	SecondsH,W
		;bz     	endonesec
		movlw	0x01
		subwf	SecondsL,F	; L  or H not zero		
		skpC
		 decf	SecondsH,F
		movfw	SecondsL
		iorwf	SecondsH,W
		bnz    endonesec	; 
		bsf	Next_En1	; start sending!
		;movlw	0x01		
		;movwf	NextEntry	;
		;movlw	.30
		;movwf	SecondsL        ; repeat sending in 30 sec
		
endonesec      goto ms4xit
	;endm 				;	RETLW 0

clr2f	macro	var
		clrf	var
		clrf	var+1
	endm

movl2	macro   var, hex1
		movlw	hex1 & 0xFF
		movwf	var
		movlw	hex1 >>D'08'
		movwf	var+1
	endm
add2	macro	var1, var2
		movfw	var1
		addwf	var2,F
		addcf	var2+1,F
		movfw	var1+1
		addwf	var2+1,F
	endm		
shl2	macro 	var
		clrc
		rlf	var,F
		rlf	var+1,F
	endm
#define 	DiviSor		BL
#define 	DiviDend	BH
#define 	DiviTemp	TempOut

modulo10 macro
		movlw	.10
		movwf	DiviSor
		clrf	AH
mod8	       movlw	1
		movwf	AL
		movfw	DiviSor
		movwf	DiviTemp
		subwf	DiviDend,W
		bNC	finish
		movwf	DiviDend
		movfw	AL
		addwf	AH,F
rrTemp	       clrC	
		rlf	DiviTemp,F	; rrf = *2
		rlf	AL,F
		movfw	DiviTemp
		subwf	DiviDend,W
		bnC	mod8		; unsucessful sub	
		movwf	DiviDend
		movfw	AL
		addwf	AH,F
		goto	rrTemp
finish         movfw	AH
		movwf	DiviSor		;decimal result in BL, BH 	
		endm

mul8x8.8 macro MultiplAnd, MultConstant
		clr2f	BL		; result in BL
		movl2	AL, MultConstant ;0x0064	; decimal .100
moreadd	        btfss	MultiplAnd,0
		 goto	noadd
		add2	AL, BL		; B= A+B
noadd	       shl2	AL		; A= A * 2
		clrc
		rrf	MultiplAnd,F	; more bits to work with?
		movf	MultiplAnd,F
		bnz	moreadd
	endm				; result in BL,BH


INPUTJOB: ;macro

;* case of
;* Pause    Button_   Button_
;*  Pending   Down 	Port
;*      0	0	0	case 0  no action
;*	0	0	1	case 1  clr BL, set B_D, clr P_P
;*	0	1	1	case 2  inc BL
;*	0	1	0	case 3  clr PL, clr B_D, set P_P
;*	1	0	0	case 4  inc PL, if overflow transfer to target
;*	1	0	1	case 5  transfer to target, goto case 1 	
;*
		btfsc	Pause_Pending	; 
		 goto	cases_4_5
		
		btfss	Button_Down	; 
		 goto	cases_0_1
		
		movlw	0x0F
		subwf	BeepLen,W
		skpZ
		 incf	BeepLen,F       ; case 2+3
					; ! max beeplen=15 

		btfss	Button_Port	; * test if button closed?  bit set = 5V = WPU
		 goto	endbtn 		; case 2 finished 
					;
		clrf	PauseLen	; case 3			
	        bcf	Button_Down
		bsf	Pause_Pending
		movlw	B'11111101'	; switch off GP2
		andwf	GPIO,F
		goto	endbtn

cases_0_1	btfsc	Button_Port	; * test of button
		 goto	endbtn		; case 0
  				
case_1		clrf	BeepLen
		bsf	Button_Down	; case 1 new beep
		bcf	Pause_Pending	;
		clrf	AL		; target
		bsf	Input_Priority 
		movlw	B'00000010'	; switch on GP2
		iorwf	GPIO,F
		goto	endbtn

cases_4_5	btfss	Button_Port	; * test of button
		 goto	case_5
		movlw	b'00010000'	; case 5: a pause is counting
		addwf	PauseLen,F
		skpC
		 GOTO	endbtn		; and PauseLen not overflown 
case_5
		
	

CLR_BEEP_PAUSE	
		
		bcf	Input_Priority
			;calculation
FIND_TARGET	clrf	IndxI
nexti	       movlw	.36
		subwf 	IndxI,W		;while IndxI<36
		skpNC
		 GOTO ffail
		movfw	IndxI
		call	NUMERIC
		subwf	BH,W
		skpNZ
		 GOTO	fsucess
		incf	IndxI,F
		GOTO	nexti
ffail
fsucess	       movfw	IndxI
		movwf	BH		; result = Beeplen * 100/255 
		movlw	.3
		movwf	SecondsL	; start sending in 3 sec
		;endcalculation		
endbtn		goto betest
 	;endm	

MSEC4EVENT:	movlw	0x01
		addwf	Ms4Tick,W
		xorwf	Ms4Tick,W
		andlw	B'00010000'	; filter any bit 7:0
		skpnZ
		 goto	no64msjob

		goto INPUTJOB

betest	       btfsS	Beep_Event		; if not already sending beeps
		 GOTO	nobeep
		btfsC	Input_Priority		; if not waiting for input
		 GOTO	nobeep
		movf	BeepLen,F		; beeplen != 0 ?
		skpNZ
		 GOTO	bedone
		btfsS	Beep_On
		 bsf	Beeper_Port		; buzzer on
		bsf	Beep_On
		decfsz	BeepLen,F		; BeepLen expired ?
		 GOTO	nobeep
		bcf	Beeper_Port
		bcf	Beep_On			; buzzer off
bedone	       movf	PauseLen,F		; pause to work off?
		skpNZ
		 GOTO	clrbeep	
		decfsz	PauseLen,F
		 GOTO	nobeep
clrbeep		bcf	Beep_Event
nobeep

;*
no64msjob      
		decfsz	Ms4Tick,F	; new Ms4Tick
		 GOTO	ms4xit
					; 256 * 3,906 ms = 1sec
	
		goto ONESECEVENT 	;
;*
ms4xit	       movlw	.122		; 122* 32us = 3,906 msec
		addwf	Tmr0Tick,F
		RETLW 0	


NUMERIC	       addwf	PCL,F

	retlw b'11111100'  ;  1: 0 -----
	retlw b'01111100'  ;  2:1 .----
	retlw b'00111100'  ;  3:2 ..---
	retlw b'00011100'  ;  4:3 ...--
	retlw b'00001100'  ;  5:4 ....-
	retlw b'00000100'  ;  6:5 .....
	retlw b'10000100'  ;  7:6 -....
	retlw b'11000100'  ;  8:7 --...
	retlw b'11100100'  ;  9:8 ---..
	retlw b'11110100'  ;  10:9 ----.
alpha	retlw b'01000001'  ;  1:A .-
	retlw b'10000011'  ; B -...
	retlw b'10100011'  ; C -.-.
	retlw b'10000010'  ; D -..
	retlw b'00000000'  ; E .
	retlw b'00100011'  ; F ..-.
	retlw b'11000010'  ; G --.
	retlw b'00000011'  ; H ....
	retlw b'00000001'  ; I ..
	retlw b'01110011'  ; J .---
	retlw b'10100010'  ; K -.-
	retlw b'01000011'  ; L .-..
	retlw b'11000001'  ; M --
	retlw b'10000001'  ; N -.
	retlw b'11100010'  ; O ---
	retlw b'01100011'  ; P .--.
	retlw b'11010011'  ; Q --.-
	retlw b'01000010'  ; R .-.
	retlw b'00000010'  ; S ...
	retlw b'10000000'  ; T -
	retlw b'00100010'  ; U ..-
	retlw b'00010011'  ; V ...-
	retlw b'01100010'  ; W .--
	retlw b'10010011'  ; X -..-
	retlw b'10110011'  ; Y -.--
	retlw b'11000011'  ; Z --..
fullstp retlw b'01010101'  ; ;Fullstop .-.-.- discrete char
comma	retlw b'11001110'  ; ;Comma --..--    discrete char
query	retlw b'00110111'  ; ;Query   ..--..   discrete char
	
	

OUTDOTS:	btfsc	Input_Priority
		 RETLW	0
		bsf	Beep_Event
		;movfw	NextEntry
		;addwf	PCL,F
		;GOTO	nomorebeep
		btfsc	Next_En1
		 GOTO	start_sending		;entry = 1
		btfsc	Next_En2
		 GOTO	nextlet			;2
		btfsc	Next_En3
		 GOTO	here			;3
		btfsc	Next_En4
		 GOTO	morbits			;4
		btfsc	Next_En5
		 GOTO	nextchar		; entry=5

nomorebeep     bcf 	Beep_Event
		;clrf	NextEntry
		RETLW 0
;**************************ENTRYPOINT********************************************
start_sending  	bcf	Next_En1
	
;**************************ENTRYPOINT********************************************

nextlet	       	bcf	Next_En2
		movfw	BH
numlet		call	NUMERIC		; morse code in W
	 	movwf	TempOut		; 5 bits relevant
		andlw	b'00000111'
		movwf	TempIndexI	; 3 bits relevant  
		clrf	IndxI		; IndxI:=0  =7th bit
noshift	       bsf	Next_En3	
		;movwf	NextEntry	; next entry = here
		btfsC	TempOut,7
		 GOTO	dash		; 
dot	       movlw	dot_time	; RETURN event = dot+pause
		movwf	PauseLen
		movwf	BeepLen
		RETLW 0			
dash	       movlw	dot_time	;RETURN event = dash +pause
		movwf	PauseLen
		movlw	dash_time
		movwf	BeepLen
		RETLW	0
;**************************ENTRYPOINT********************************************
	
here	       bcf	Next_En3
 	        movfw	TempIndexI	;
		andlw	b'00000111' 
		subwf	IndxI,W
		skpNZ			; IndxI=bits to do?
		 GOTO	nextchar
		movlw	4		; IndxI=4?
		subwf	IndxI,W
		skpZ	
		 GOTO	morbits		; produce nextevent
		;movlw	0x5
		;movwf	NextEntry	; next entry = nextchar
		bsf	Next_En5
		movfw	TempIndexI
		andlw	0x07
		sublw	0x05			; TempIndexI=5?
		skpNZ	
		 GOTO	dash
		movwf	IndxI
		decfsz	IndxI,F			; TempIndexI=6?
		 goto	dot		; TempIndexI = 7
		GOTO	dash	
	
;**************************ENTRYPOINT********************************************
morbits	       incf	IndxI,F
		rlf	TempOut,F
		GOTO noshift
;**************************ENTRYPOINT********************************************
nextchar       	bcf	Next_En5
		;movlw	0x02	
		;movwf	NextEntry
		;ACTION
	 	goto loopend		; all letters/numbers sent

	
		movlw	dot_time	; RETURN event = dot pause
		movwf	PauseLen
		clrf    BeepLen
		RETLW 	0  		; NextEntry = nextlet
; 
loopend       	; movlw	wrd_pause
;		movwf	PauseLen
;		clrf	BeepLen		; NextEntry = 0 nomore
		;clrf	NextEntry
		RETLW	0




RESET		clrf	TimerFlag
		clrf	TempIndexI
		clrf	SecondsL
		clrf	SecondsH
N_LOOP		btfsS Beep_Event
		 call OUTDOTS
		movfw	Tmr0Tick	
		subwf	TMR0,W		;w=TimerTick-TMR0
		andlw	0xC0		;slack 63*32 cycles
		skpNZ
		 call	MSEC4EVENT	;frequent jobs to be done in 4ms 
		;BTFSC	Sec_Flag
		 ;call	ONESECEVENT	;occasional jobs to be done
		goto	N_LOOP
	END

