
	list      p=12F683	; list directive to define processor
	#include <p12f683.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

	ERRORLEVEL -302				; Get rid of banking messages...

;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define switch		GPIO,3
;#define	LED0TRIS	b'11001111'
;#define	LED1TRIS	b'11001111'
;#define	LED2TRIS	b'11101011'
;#define	LED3TRIS	b'11101011'
;#define	LED4TRIS	b'11011011'
;#define	LED5TRIS	b'11011011'
;#define	LED6TRIS	b'11111001'
;#define	LED7TRIS	b'11111001'
;#define LED0ON		b'00010000'
;#define	LED1ON		b'00100000'
;#define	LED2ON		b'00010000'
;#define	LED3ON		b'00000100'
;#define	LED4ON		b'00100000'
;#define	LED5ON		b'00000100'
;#define	LED6ON		b'00000100'
;#define	LED7ON		b'00000010'
;#define LTRIS 		LED5TRIS
;#define	LEDON		LED4ON
;

eeq 	    macro var, val
 		movlw	val & 0xFF
 		movwf	var
 		movlw	val>>8
 		movwf	var+1
 	    endm

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000		; processor reset vector
	nop			; required by in circuit debugger
	goto    Init		; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG     0x004
	return			; interrupt trap - return without re-enabling 

;******************************************************************************
;Initialization
;******************************************************************************
Init	movlw	b'00000000'	; all GPIO Low
	movwf	GPIO
	BANKSEL	Bank1		; BANK1
	
	movlw	b'11001011'     ; set direction bits 
	movwf	TRISIO		;
				; GP5	outp 
				; GP4	outp
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	inp
 
	movlw	B'11011000'	; Timer0 internal clock, 1:32 prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
				;OPTION_REG  OPTION REGISTER (ADDRESS: 81h)
				;Note: To achieve a 1:1 prescaler assignment for
				;TMR0, assign the prescaler to the WDT by
				;setting PSA bit to 1 (Option<3>). See
				;Section 5.4 Prescaler.
				;R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1
				;GPPU INTEDG T0CS  T0SE   PSA   PS2   PS1   PS0
				;  7     6     5     4      3    2     1     0
				;bit 7 GPPU: GPIO Pull-up Enable bit
				;1 = GPIO pull-ups are disabled
				;0 = GPIO pull-ups are enabled by individual port latch values in WPU register
				;
				;bit 6 INTEDG: Interrupt Edge Select bit
				;1 = Interrupt on rising edge of GP2/INT pin
				;0 = Interrupt on falling edge of GP2/INT pin
				;
				;bit 5 T0CS: TMR0 Clock Source Select bit
				;1 = Transition on GP2/T0CKI pin
				;0 = Internal instruction cycle clock (CLKOUT)
				;
				;bit 4 T0SE: TMR0 Source Edge Select bit
				;1 = Increment on high-to-low transition on GP2/T0CKI pin
				;0 = Increment on low-to-high transition on GP2/T0CKI pin
				;
				;bit 3 PSA: Prescaler Assignment bit
				;1 = Prescaler is assigned to the WDT
				;0 = Prescaler is assigned to the Timer0 module
				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
				;Note 1: A dedicated 16-bit WDT postscaler is available for the PIC12F683. See
				;Section 12.6 Watchdog Timer (WDT) for more information.
				;Legend:
				;R = Readable bit W = Writable bit U = Unimplemented bit, read as 0
				;- n = Value at POR 1 = Bit is set 0 = Bit is cleared x = Bit is unknown
				;Bit Value   TMR0 Rate 	   WDT Rate(1)
				;000		1:2		1:1	
				;001		1:4		1 : 2
				;010		1:8		1:4
				;011		1:16		1:8
				;100		1:32		1:16
				;101		1:64		1:32
				;110		1:128		1:64
				;111		1:256		1:128
				;
	;	

	movlw	b'00010011'
	movwf	ANSEL		; configure A/D  GP0 and GP1 analog
				;ANSEL  ANALOG SELECT REGISTER (ADDRESS: 9Fh)
				;U-0 R/W-0 R/W-0 R/W-0 R/W-1 R/W-1 R/W-1 R/W-1
				;   ADCS2 ADCS1 ADCS0  ANS3  ANS2  ANS1  ANS0
				; 7     6    5     4     3      2     1  bit 0
				;bit 7 Unimplemented: Read as 0
				;bit 6-4 ADCS<2:0>: A/D Conversion Clock Select bits
				;000 = FOSC/2
				;001 = FOSC/8
				;010 = FOSC/32
				;x11 = FRC (clock derived from a dedicated internal oscillator = 500 kHz max)
				;100 = FOSC/4
				;101 = FOSC/16
				;110 = FOSC/64
				;bit 3-0 ANS<3:0>: Analog Select bits
				;Analog select between analog or digital function on pins ANS<3:0>, respectively.
				;1 = Analog input. Pin is assigned as analog input(1).
				;0 = Digital I/O. Pin is assigned to port or special function.
				;Note 1: Setting a pin to an analog input automatically disables the digital input circuitry,
				;weak pull-ups and interrupt-on-change if available. The corresponding TRISIO bit
				;must be set to input mode in order to allow external control of the voltage on the pin.
 
	movlw	b'01100001'
	movwf	OSCCON		; 4MHz
				;OSCCON  OSCILLATOR CONTROL REGISTER (ADDRESS: 8Fh)
				;Note: Due to the wide range of oscillator start-up
				;times, the Fail-Safe circuit is not active
				;during oscillator start-up (i.e., after exiting
				;Reset or Sleep). After an appropriate
				;amount of time, the user should check the
				;OSTS bit (OSCCON<3>) to verify the
				;oscillator start-up and system clock
				;switchover has successfully completed.
				;U-0 R/W-1 R/W-1 R/W-0  R-1    R-0 R-0 R/W-0
				;   IRCF2 IRCF1 IRCF0 OSTS(1) HTS LTS SCS
				; 7    6     5     4     3      2   1   0
				;bit 7 Unimplemented: Read as 0
				;
				;bit 6-4 IRCF<2:0>: Internal Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
				;
				;bit 3 OSTS: Oscillator Start-up Time-out Status bit
				;1 = Device is running from the external system clock defined by FOSC<2:0>
				;0 = Device is running from the internal system clock (HFINTOSC or LFINTOSC)
				;
				;bit 2 HTS: HFINTOSC (High Frequency  8 MHz to 125 kHz) Status bit
				;1 = HFINTOSC is stable
				;0 = HFINTOSC is not stable
				;
				;bit 1 LTS: LFINTOSC (Low Frequency  31 kHz) Stable bit
				;1 = LFINTOSC is stable
				;0 = LFINTOSC is not stable
				;
				;bit 0 SCS: System Clock Select bit
				;1 = Internal oscillator is used for system clock
				;0 = Clock source defined by FOSC<2:0>
				;Note 1: Bit resets to 0 with Two-Speed Start-up and LP, XT or HS selected as the oscillator
				;mode or Fail-Safe mode is enabled.

	banksel	Bank0		; switch back to PORT memory bank
	movlw	b'00000110'     
	movwf	CMCON0		; comparator enable input GP1 - Internal reference
				;CMCON0  COMPARATOR CONTROL REGISTER 0 (ADDRESS: 19h)
				;U-0 R-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;   COUT    CINV  CIS   CM2   CM1   CM0
				; 7    6  5     4    3     2     1     0
				;
				;bit 6 COUT: Comparator Output bit
				;When CINV = 0:
				;1 = VIN+ > VIN-
				;0 = VIN+ < VIN-
				;When CINV = 1:
				;1 = VIN+ < VIN-
				;0 = VIN+ > VINbit
				;
				;bit 4 CINV: Comparator Output Inversion bit
				;1 = Output inverted
				;0 = Output not inverted
				;
				;bit 3 CIS: Comparator Input Switch bit
				;When CM<2:0> = 110 or 101:
				;1 = VIN- connects to CIN+   GP0
				;0 = VIN- connects to CINbit GP1
				;
				;2 CM<2:0>: Comparator Mode bits
				;
				;FIGURE 8-3: COMPARATOR I/O OPERATING MODES
				;Note: Comparator interrupts should be disabled
				;during a Comparator mode change.
				;Otherwise, a false interrupt may occur.
				;Comparator Reset (POR Default Value  Low Power)         	Comparator Off (Lowest Power)
				;CM<2:0> = 000                                                 	CM<2:0> = 111
				;
				;Comparator without Output                                	Comparator w/o Output and with Internal Reference
				;CM<2:0> = 010 							CM<2:0> = 100
				;
				;Comparator with Output and Internal Reference 			Multiplexed Input with Internal Reference and Output
				;CM<2:0> = 011 							CM<2:0> = 101
				;
				;Comparator with Output 					Multiplexed Input with Internal Reference
				;CM<2:0> = 001 							CM<2:0> = 110
				;
	movlw	b'00010101'	; 1 seconds
	movwf	WDTCON
	clrwdt
				;WDTCON  WATCHDOG TIMER CONTROL REGISTER (ADDRESS: 18h)
				;TABLE 12-8: SUMMARY OF WATCHDOG TIMER REGISTERS
				;U-0 U-0 U-0 R/W-0  R/W-1  R/W-0  R/W-0  R/W-0
				;         WDTPS3 WDTPS2 WDTPS1 WDTPS0 SWDTEN
				; 7   6   5     4     3       2     1      0
				;bit 7-5 Unimplemented: Read as 0
				;bit 4-1 WDTPS<3:0>: Watchdog Timer Period Select bits
				;Bit Value = Prescale Rate
				;0000 = 1:32
				;0001 = 1:64
				;0010 = 1:128
				;0011 = 1:256
				;0100 = 1:512 (Reset value)  = 16ms
				;0101 = 1:1024               = 32
				;0110 = 1:2048                 64
				;0111 = 1:4096                 128
				;1000 = 1:8192		       256
				;1001 = 1:16384			512
				;1010 = 1:32768			1024
				;1011 = 1:65536			2048
				;1100 = Reserved
				;1101 = Reserved
				;1110 = Reserved
				;1111 = Reserved
				;bit 0 SWDTEN: Software Enable or Disable the Watchdog Timer(1)
				;1 = WDT is turned on
				;0 = WDT is turned off (Reset value)
				;Note 1: If WDTE configuration bit = 1, then WDT is always enabled, irrespective of this
				;control bit. If WDTE configuration bit = 0, then it is possible to turn WDT on/off with
				;this control bit.
				
	movlw	b'00000000'
	movwf	INTCON		;


;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	AL,AH,FilterCount		; debounce filter counter
	endc
	
;******************************************************************************
;Main 
;******************************************************************************
Main	movlw	5
	movwf	AL
	movlw	b'00000100'

loop	sleep		; one second
;	incfsz	AL,F                     
;	 goto   $-1
;	incfsz	AH,F
;	 goto	$-3	;loop until AL:AH overflow
	xorwf 	GPIO,F
	decfsz	AL,F
	 goto	loop
	bcf	GPIO,2
	Banksel	Bank1
	movlw	B'11011000'	; Timer0 internal clock, WDT 1:1 prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
	Banksel	Bank0
;******************************************************************************
;Subroutines & Functions
;******************************************************************************
#define		VREF_HI 	b'10001111' ;3.75V @ 5V	high voltage setpoint, vref = vdd/4 + 15/32*Vdd
#define		VREF_3.28	b'10001101' ;3.28V 
#define		VREF_2.65	b'10001010'
#define		VREF_3.1	b'10001100'
#define		VREF_MID 	b'10000111' ;2.5V  mid voltage setpoint, vref =  vdd/4 + 7/32*Vdd
#define		VREF_LO 	b'10000000' ; 1.25V low voltage setpoint, vref = vdd/4


;**********************************************************************
check_batt
;		movlw	0x0A		; NiMH	12.2V- 13.7V = 1.2-2.7V
;		movwf	TIMEOUT_H	; = 1.5 / 0.166
;
		
;	banksel	VRCON	;Switch to register bank 1
;	movlw 	VREF_3.28	;setpoint , hi range
				;VRCON  VOLTAGE REFERENCE CONTROL REGISTER (ADDRESS: 99h)
				;  7    6    5     4     3    2      1     0 
				;R/W-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;VREN      VRR        VR3   VR2   VR1   VR0
				;
				;bit 7 VREN: CVREF Enable bit
				;1 = CVREF circuit powered on
				;0 = CVREF circuit powered down, no IDD drain and CVREF = VSS
				;bit 6 Unimplemented: Read as 0
				;bit 5 VRR: CVREF Range Selection bit
				;1 = Low range
				;0 = High range
				;bit 4 Unimplemented: Read as 0
				;bit 3-0 VR<3:0>: CVREF Value Selection 0 = VR <3:0> = 15
				;When VRR = 1: CVREF = (VR<3:0>/24) * VDD
				;When VRR = 0: CVREF = VDD/4 + (VR<3:0>/32) * VDD			
;		movwf	VRCON
;		banksel	CMCON0
;		nop
;**********************************************************************

test		sleep		; one second
		movlw 	VREF_3.1	;setpoint VREF, hi range
		banksel	VRCON		;Switch to register bank 1
		
		movwf	VRCON
		banksel	CMCON0
		bsf 	CMCON0,CIS 
					;movlw	b'00001110'     ; comparator enable input GP0 - Internal reference
		nop
		
		btfss	CMCON0,COUT
		 goto	test
		btfss	GPIO,3
		 goto	strthi
under31		movlw 	VREF_2.65	;setpoint VREF, hi range
		banksel	VRCON		;Switch to register bank 1
		
		movwf	VRCON
		banksel	CMCON0
		bsf 	CMCON0,CIS 
		;movlw	b'00001110'     ; comparator enable input GP0 - Internal reference
		nop
		
		btfsc	CMCON0,COUT
		 goto	under27
		bcf	GPIO,2
		goto	test
under27		
		movlw	b'00000100'
		xorwf	GPIO,F
		goto 	test
		

strthi		bsf	GPIO,4
		bcf	GPIO,2
		eeq	AL,.900+0x0101
		
hitest		sleep
		movlw 	VREF_3.28	;setpoint VREF, hi range
		banksel	VRCON		;Switch to register bank 1
		movwf	VRCON
		banksel	CMCON0
		bcf 	CMCON0,CIS 
		nop
		btfss	CMCON0,COUT
		 goto shtdown
		decfsz	AL,F		;timeout
		 goto hitest
		decfsz	AH,F
		 goto	hitest
shtdown		bcf	GPIO,4

	banksel	Bank1	;Switch to register bank 1		
	movlw	B'11011100'	; Timer0 internal clock, 1:16 WDT prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
	banksel	Bank0		;Switch to register bank 0


		sleep			; 16 second
		bsf	GPIO,5
	banksel	OPTION_REG	;Switch to register bank 1
	movlw	B'11011110'	; Timer0 internal clock, 1:64 WDT prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
	banksel	GPIO		;Switch to register bank 0

		sleep		;64 sec
		bcf	GPIO,5
		goto Init
;**********************************************************************
morevolts	nop		
		banksel VRCON
		incf	VRCON,f
		banksel	CMCON0
		nop
		btfsc	CMCON0,COUT
		 goto	time_found
;		decfsz	TIMEOUT_H,f
;		 goto	morevolts
	
time_found
;******************************************************************************
;TestSwitch - Test switch state and take action when filter count saturates
;******************************************************************************
TestSwitch
	btfss	switch		; test for switch closure
	goto	SwitchClosed

SwitchOpen
; When switch is open - decrement count if not already saturated
	movf	FilterCount,f	; move affects zero flag
	btfsc	STATUS,Z	; test filter count for zero
	return			; count was already zero - no further action

; drive LED0 on when switch is open and count saturates at zero	

	decfsz	FilterCount,f	; decrement filter count
	return			; not zero - return to monitor loop
	
	call	LED0		; light LED0
	return			; return to monitor loop
	
SwitchClosed
; When switch is closed - increment count if not already saturated
	btfsc	FilterCount,4	; 16 count saturation if bit 4 is high
	return			; already saturated - return to monitor loop

; drive LED1 when switch is closed and count saturates at 16
	
	incf	FilterCount,f	; count up when switch is closed
	btfsc	FilterCount,4	; 16 count saturation when bit 4 goes high
	call	LED1		; light LED1
	
	return			; return to monitor loop

;******************************************************************************
;LED0 - Drive I/O port to turn D0 on
;******************************************************************************
LED0
	movlw	b'00010000'	; data to forward bias LED0 and reverse bias LED1
	movwf	GPIO		; send data to GPIO port
	return			; return to calling routine
	
;******************************************************************************
;LED1 - Drive I/O port to turn D1 on
;******************************************************************************
LED1
	movlw	0x00		; data to forward bias LED1 and reverse bias LED0
	movwf	GPIO		; send data to GPIO port
	return			; return to calling routine
	
	END
