;**********************************************************************
;                    Software License Agreement                       *
;                                                                     *
; The software supplied herewith by Microchip Technology Incorporated *
; (the "Company") is intended and supplied to you, the Company's      *
; customer, for use solely and exclusively on Microchip products.     *
; The software is owned by the Company and/or its supplier, and is    *
; protected under applicable copyright laws. All rights are reserved. *
; Any use in violation of the foregoing restrictions may subject the  *
; user to criminal sanctions under applicable laws, as well as to     *
; civil liability for the breach of the terms and conditions of this  *
; license.                                                            *
;                                                                     *
; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,   *
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED   *
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A         *
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,   *
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR          *
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                   *
;                                                                     *
;**********************************************************************
;**********************************************************************
;                                                                     *
;    Filename:	      main.asm                                         *
;    Date:          10/13/2000                                        *
;    File Version:  1.0                                               *
;                                                                     *
;    Author:        Joseph Julicher                                   *
;    Company:       Microchip Technology                              *
;                                                                     * 
;**********************************************************************

	list      p=12F629		; list directive to define processor
	#include <p12F629.inc>	; processor specific variable definitions
	errorlevel  -302		; suppress message 302 from list file

	__CONFIG   _CP_OFF & _WDT_OFF & _MCLRE_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT 


;***** VARIABLE DEFINITIONS
w_temp		EQU	0x50		; variable used for context saving 
status_temp	EQU	0x51		; variable used for context saving

tsr		EQU	0x52		; transmit shift register
bitcount	EQU	0x53		; transmit bit counter
led		EQU	0x54		; LED brightness
counter		EQU	0x55		; LED PWM counter
temp		EQU	0x56		; holding for PWM status

;***** CONSTANTS DEFINITIONS
speed		EQU	0xDf		; PWM period constant

;***** PIN DEFINITIONS
holdcap	EQU	0x02		; GPIO pin for the hold cap
coil		EQU	0x01		; GPIO pin for the coil
pwm		EQU	0x04		; GPIO pin for the pwm (LED brightness)

;**********************************************************************
		ORG     0x000		; processor reset vector
		goto    main		; go to beginning of program


		ORG     0x004		; interrupt vector location
		movwf   w_temp		; save off current W register contents
		movf	STATUS,w	; move status register into W register
		movwf	status_temp	; save off contents of STATUS register

		incf	counter,w	; PWM routine
		addwf	led,w
		btfss	STATUS,C
		bcf	GPIO,pwm
		btfsc	STATUS,C
		bsf	GPIO,pwm
		movwf	counter

		bcf	INTCON,T0IF	; clear the TMR0 flag
		bsf	INTCON,T0IE	; reenable TMR0 interrupt

		movlw	speed
		movwf	TMR0

		movf    status_temp,w	; retrieve copy of STATUS register
		movwf	STATUS		; restore pre-isr STATUS register contents
		movf	w_temp,w	; restore W register
		retfie			; return from interrupt

main
		call    0x7FF		; retrieve factory calibration value
		bsf     STATUS,RP0	; set file register bank to 1 
		movwf   OSCCAL		; update register with factory cal value 
		bcf     STATUS,RP0	; set file register bank to 0

		clrf	TMR0		; clear the timer
		clrf	counter
		clrf	led

; setup GPIO
		clrf	GPIO		; set all I/O's to 0
		clrf	INTCON		; clear all flags and enables
		bsf	INTCON,T0IE	; enable TMR0 interrupt
		bsf	INTCON,GIE	; enable all interrupts

		bsf	STATUS, RP0	; Select Page 1
		clrf	OPTION_REG	; clear all options
		bsf	OPTION_REG,NOT_GPPU	; Turn off weak pullup

		movlw	B'00001001'	; GPIO 0 is Input
					; GPIO 1 is Output
					; GPIO 2 is Output
					; GPIO 3 is Input
					; GPIO 4 is Output
					; GPIO 5 is Output
		movwf	TRISIO
		
		;movlw	B'00000110'	; GP0 is analog, VREF is Vdd
		;movwf	ADCON1		; Configure A/D Inputs
		
		;bcf	PIE1,ADIE	; disable A/D Interrupts
		
		bcf	STATUS, RP0	; Select Page 0
		movlw	B'01000001'	; 8 Tosc clock, A/D is on, Channel 0 is selected
		movwf	ADCON0		;
		bcf	PIR1, ADIF	; Clear A/D interrupt flag bit

repeat		call	measure		; make a measurement
		movwf	led		; set the LED brightness
		movlw	D'56'		; wait 200 loops or 1ms
delay		nop			;
		addlw	D'1'		; 
		btfss	STATUS,Z	; 
		goto	delay		;  
		goto	repeat		

measure		; do the measurement
		bcf	INTCON,GIE	; disable all interrupts
		bsf	GPIO,holdcap	; arm the cap
		bsf	GPIO,coil	; charge the coil
		nop
		bcf	GPIO,coil	; Turn off coil
					; wait for the inductor collapse to finish
		bsf	ADCON0,GO	; start ADC
		btfsc	ADCON0,GO	; wait for ADC to finish
		goto	$-1		; go back if not finished yet
		bcf	GPIO,holdcap	; dump the cap
		bsf	INTCON,GIE	; enable all interrupts
		movf	ADRES,W		; move the result to W
		return			; all done

		END
