; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;==============================================================================
;File name: HSI_Motorcontrol.asm
;
;This program demonstrates how Human Serial Interface also known as 
;Morse Code with a buzzer and a pushbutton can be achieved. 
;
;
;
;==============================================================================
;author:	Gerhard Michael Drygas
;company:	Michaels Prototype
;date:		25/10/2006
;MPLAB version:	7.41
;
;==============================================================================        

;	list      p=12F675	; list directive to define processor
;	#include <p12f675.inc>	; processor specific variable definitions

;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.
	LIST P = 16F627, F=INHX8M
	#include<p16F627.inc>


	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT


;*** register bank limits
#define ram0_start 	0x20
#define ram0_end 	0x7f			; 5f 12P625
#define ram0_length 	ram0_end - ram0_start + 1

;==========================================================================
;       Variable Definition
;==========================================================================
		cblock ram0_start

TimerTick, msTick, TimerFlag 	;Used in delay routine	

PCLoffset, TemP,FsrStore	; local var, not to be used outside call

Target, TextNmbr, TextLetter
NextEntry, PauseLen, BeepLen 
IndxI, TempIndexI, TempOut
ErrorCode			;MORSE CODE VAR

V1:3,V2:3,SpeeD,TimE:2,TimeD:2		;arithmetic
MotEvent,MotonLen:2
Seconds, Minutes		
OutputString			; LAST VAR
		endc		
WTemp        	EQU     ram0_end-0x01   ; variable used for context saving 
StatusTemp   	EQU     ram0_end        ; variable used for context saving

#define		wrd_pause	.240	; 
#define		dot_time	.48	; 
#define		dash_time	.152	; 
#define		dash_thresh	.102	; 
#define		pwm_start	.117	; 



#define 	Motor_Event	TimerFlag,0
#define 	Beep_On		TimerFlag,1
#define 	Beep_Event	TimerFlag,2
#define 	Button_Down	TimerFlag,3
#define 	Pause_Pending	TimerFlag,4
#define 	Fin_Target	TimerFlag,5
#define 	Msec_Flag 	TimerFlag,6
#define 	Sec_Flag 	TimerFlag,7


#define 	Button_Port 	PORTA,3	;GPIO,3 	

#define		Beeper_Port	PORTB,7	;GPIO,0	
#define		Motor_Forward	PORTB,0
#define		Motor_Reverse	PORTB,1
	ORG	0			;Reset vector address
		nop
		GOTO	RESET		;GOTO RESET routine when boot.

;******************************************************************************
;INTERRUPT
;******************************************************************************


	ORG     0x004             	; interrupt vector location
		movwf   WTemp           ; save off current W register contents
		movf	STATUS,W        ; move status register into W register
		movwf	StatusTemp      ; save off contents of STATUS register


	; isr code can go here or be located as a call subroutine elsewhere


		movf    StatusTemp,W    ; retrieve copy of STATUS register
		movwf	STATUS          ; restore pre-isr STATUS register contents
		swapf   WTemp,F		; restore pre-isr W register contents
		swapf   WTemp,W         ; without changing Z Flag
		retfie                  ; RETURN from interrupt


;******************************************************************************
;MACRO
;******************************************************************************
;******************************************************************************
;any page table call
;******************************************************************************
tcall	macro	adress
					
	addlw 	low (adress+1)
	movwf	PCLoffset
	movlw	high (adress+1)
	skpNC
	 addlw 0x01
	movwf	PCLATH
	movfw	PCLoffset
	call	adress	
	endm
;******************************************************************************
;page 0 table call
;******************************************************************************
	
p0call	macro	adress
	
	clrf PCLATH	
	addlw	(low adress+1)
	call	adress
	endm

SWAPWF  MACRO  REG
        XORWF  REG,F
        XORWF  REG,W
        XORWF  REG,F
        ENDM
CLRF3	MACRO	REG
	CLRF	REG
	CLRF	REG+1
	CLRF	REG+2
	ENDM
;******************************************************************************
;Subroutines & Functions
;******************************************************************************

;******************************************************************************
;tables to call
;******************************************************************************

zeroAF	       movwf 	PCL
		dt 	"0123456789ABCDEF",0	;textstring to output, 0 for endstring


text	       movwf 	PCL
		retlw	0
		GOTO	msg1
		GOTO	msg2
		GOTO	msg3
		retlw	0

msg1	       movfw	TextLetter		; fixed string 
		addwf 	PCL,F
		dt 	"TEST OK.",0		;textstring to output, 0 for endstring

msg2		movfw	TextLetter		;fixed string with added letter
		addwf 	PCL,F
		dt 	"SOS "			;textstring to output, 0 for endstring
		GOTO	ret_ErrorCode
		retlw	0
ret_ErrorCode  movfw	ErrorCode
		RETURN
msg3	       movlw	OutputString		; run time defined string
		addwf	TextLetter,W
		movwf	FSR
		movfw	INDF
		RETURN			
#include<HSI_core.asm>

;******************************************************************************
;3byte fixed point arithmetic
;******************************************************************************
;DEC_VAR3		movwf	FSR	;w ->VAR 2:0
;		incf	FSR,W	;skip frctions
;		movwf	FsrStore
;		movwf	FSR
;		movfw	INDF
;		andlw	0xF0
;		movwf	TemP
;		movlw	0x10
;		subwf	TemP,F
;		skpNZ	
;		 GOTO	zeroset
;		skpNC
;		 goto 	store
;		incf	FSR	;repeat if 9byte ari
;		decf	INDF,F
;		movlw	0xF0
;		movwf	TemP
;store		movfw	FsrStore
;		movwf	FSR
;		movfw	INDF
;		andlw	0x0F
;		iorwf	TemP,W
;		movwf	INDF
;		RETURN
DEC_VAR2	movwf	FSR
		incf	FSR,W		;V1+1
		movwf	FSR
		movwf	FsrStore
		decf	INDF,F
		skpNC
		 goto	testzero
		incf	FSR,F
		decf	INDF,F
testzero	movfw	FsrStore
		movwf	FSR
		movf	INDF,F
		skpZ
		 RETURN		;ZERO not set
		incf	FSR,F
		movf	INDF,F
		RETURN		;ZERO set
	

RRF_VAR		movwf	FsrStore
		movwf	FSR
		incf	FSR,F		;V1+1
		incf	FSR,F
		CLRC
		rrf	INDF,F
		decf	FSR,F
		rrf	INDF,F
		decf	FSR,F
		movfw	INDF
		andlw	B'00000011'
		movwf	TemP
		rrf	INDF,F
		movlw	B'11111100'
		andwf	INDF,F
 		movf	INDF,F
		skpZ
		 GOTO	rrf_end
	
rrf_end		movfw	FsrStore
		movwf	FSR
		movfw	TemP
		bcf	TemP,7
		skpNZ
		 bsf	TemP,7
		iorwf	INDF,F
		CLRZ
		btfsc	TemP,7
		 SETZ
		RETURN
ADD_V1_V2_3	movfw	V2
		andlw	b'11111100'
		SWAPWF	V1
		addwf	V1,F
		addcf	V1+1,F
		movfw	V2+1
		addwf	V1+1,F
		addcf	V1+2,F
		movfw	V2+2
		addwf	V1+2,F
		RETURN
MULT_OUT	movlw	"A"
		subwf	OutputString,W
		movwf	TemP
		skpNZ
		 GOTO 	$+4
		call	ADD_V1_V2_3
		decf	TemP,F
		GOTO	$-4
		RETURN
CALC_PWM	CLRF3	V1
		clrf	V2+2
		movlw	0x05	
		movwf	V2+1
		movlw	0x80
		movwf	V2
		call	MULT_OUT
		movlw	pwm_start
		movwf	V2+1
		call	ADD_V1_V2_3
		movfw	V1+1	
		movwf CCPR1L
		movwf	SpeeD 	
		RETURN	
CALC_TIME	CLRF3	V1
		movlw	.75
		movwf	V1+1
		clrf	V2+2
		clrf	V2
		movlw	.25
		movwf	V2+1
		call	MULT_OUT
		movfw	V1+1
		moVWF	TimE
		movfw	V1+2
		movwf	TimE+1
		RETURN	
;**********************************************************************
FIND_TARGET	clrf	IndxI
nexti	       movfw	IndxI		;while IndxI<36
		sublw	.36
		skpNZ
		 GOTO ffail
		movfw	IndxI
		tcall	aln_bin
		subwf	Target,W
		skpNZ
		 GOTO	fsucess
		incf	IndxI,F
		GOTO	nexti
fsucess	       movfw	IndxI
		sublw	.25
		skpC	
		 GOTO	fnum
		movfw	IndxI
		addlw	"A"
		RETURN
fnum	       movfw	IndxI
		addlw	"0"-.26
		RETURN
ffail	       movlw 	"."
		RETURN
;******************************************************************************
		
CLR_BEEP_PAUSE	incf	Target,F
		movfw	BeepLen
		sublw   dash_thresh	; BeepLen > dash_tresh ?
		skpNC 
		 GOTO 	was_dot
		movlw	0x80		;was dash
		movwf	TempIndexI
		movfw	Target
		andlw	0x07
		skpNZ
		 GOTO 	nextx
					;decf	IndxI,F
		movwf	IndxI
rotc	       rrf	TempIndexI,F
		decfsz	IndxI,F
		 GOTO rotc
nextx	       movfw	TempIndexI
		iorwf	Target,F		
was_dot	       movf	PauseLen,F
		skpZ
		 RETURN
		movfw	Target
		call	FIND_TARGET		;
		movwf	OutputString
		clrf	Target			; conversion finished
		decf	Target,F
		bsf	Fin_Target
		RETURN
;**********************************************************************
;pushbutton input
;******************************************************************************

DE_BOUNCE	movfw	TMR0
		addlw	.6
		movwf	TemP		;button up for 200us?
wait	       movfw	TemP
		btfSC	Button_Port
		 GOTO 	fail
		subwf	TMR0,W
		skpZ
		 GOTO wait
		bcf	Button_Down
		bcf	Beeper_Port
fail	       RETURN

UPDE_BOUNCE	movfw	TMR0		;button down for 100us ?
		addlw	.3
		movwf	TemP
upwait		movfw	TemP
		btfsS	Button_Port
		 GOTO	upfail
		subwf	TMR0,W
		skpZ
		 GOTO 	upwait
		bsf	Button_Down
		bsf	Beeper_Port
		bcf	Beep_Event	; prevent sending
		clrf	NextEntry	;prevent more code to come
		RETURN
upfail	       bcf	Button_Down
		RETURN
;******************************************************************************
;time event routines
;******************************************************************************

MSEC_EVENT	movlw	.125		; 125* 32us = 4msec
		addwf	TimerTick,F
		bsf	Msec_Flag
		RETURN

TEST_MSEC_JOB   bcf	Msec_Flag
		btfsS	Pause_Pending
		 GOTO	tst_btn_d
		incfsz	PauseLen,F
		 GOTO	tst_btn_d
		bcf	Pause_Pending
		GOTO	CLR_BEEP_PAUSE	; RETURN from there
		RETURN

	
tst_btn_d      btfsS	Button_Down
		 GOTO	betest
		incfSZ	BeepLen,F
		 GOTO	$+2
		decf	BeepLen,F		; max beeplen=255
		btfsC	Button_Port
		 GOTO	nobeep
		call	DE_BOUNCE		; glitch?
		btfsC	Button_Down
		 GOTO	nobeep
						; no glitch, button has gone up
		bsf	Pause_Pending
		clrf	PauseLen
			
betest	       btfsS	Beep_Event		; if not already sending beeps
		 GOTO	nobeep
		btfsC	Pause_Pending		; if not waiting for input
		 GOTO	nobeep
		movf	BeepLen,F		; beeplen != 0 ?
		skpNZ
		 GOTO	bedone
		btfsS	Beep_On
		 bsf	Beeper_Port		; buzzer on
		bsf	Beep_On
		decfsz	BeepLen,F		; BeepLen expired ?
		 GOTO	nobeep
		bcf	Beeper_Port
		bcf	Beep_On			; buzzer off
bedone	       movf	PauseLen,F		; pause to work off?
		skpNZ
		 GOTO	clrbeep	
		decfsz	PauseLen,F
		 GOTO	nobeep
clrbeep		bcf	Beep_Event


nobeep	       decfsz	msTick,F	;main job of MSJOB
		 RETURN
		movlw	.250		; 250 * 4ms = 1sec
		movwf	msTick
		bsf 	Sec_Flag
		RETURN
TEST_ONESECJOB	bcf	Sec_Flag	
		incf	Seconds,F
		skpZ
		 RETURN		
		incf	Minutes,F
		movlw	.195		;		
		movwf	Seconds		;60 sec for next send

		RETURN


		btfsC	Button_Down
		 RETURN
		btfsC	Pause_Pending
		 RETURN
		btfsC	Beep_Event
		 RETURN
		movlw	OutputString	;produce two letter string
		movwf	FSR		;from byte Minutes
		movfw	Minutes
		andlw	0xF0
		skpNZ
		 GOTO	oneletter
		movwf	TemP
		swapf	TemP,W			
		tcall	zeroAF
		movwf	INDF
		incf	FSR,F
oneletter      movfw	Minutes
		andlw	0x0F
		tcall	zeroAF
		movwf	INDF
		incf	FSR,F
		clrf	INDF
		movlw	3
		movwf	TextNmbr
		movlw	1
		movwf	NextEntry	;start sending Minutes 
		
		RETURN

;**********************************************************************

TEST		movlw	"S"
		movwf	OutputString
;		movlw	"9"
;		movwf	OutputString+1
		clrf	OutputString+1
		movlw	startsending
		movwf   NextEntry
		movlw	0x03
		movwf	TextNmbr
READMORSE
test_loop	btfsC	Fin_Target
		 GOTO	finish		; exit after 1 letter
		
		btfsS	Beep_Event
		 call	MORSE_OUTPUT
		movfw	TimerTick	
		subwf	TMR0,W		;w=TimerTick-timr0
		andlw	0C0H		;slack 63*32 cycles
		SKPNZ
		 call	MSEC_EVENT	; 125 timerticks more
		btfsC	Msec_Flag
		 call	TEST_MSEC_JOB		;frequent jobs to be done in 4ms 
		btfsC	Sec_Flag
		 call	TEST_ONESECJOB	;
 
		;GOTO	test_loop	;test

		btfsS	Button_Down	;if Button_Down, let it clear by MSEC_JOB
		 btfsS	Button_Port	
		GOTO	test_loop
		btfsS	Pause_Pending	; unrecognized Button_Down
		 GOTO	new_beep	; was pause running?
		call	UPDE_BOUNCE	; glitch?
		btfsS	Button_Down
		 GOTO	test_loop

		call	CLR_BEEP_PAUSE	; no glitch, remove previous beep/pause
		bcf	Pause_Pending	; into Target
		clrf	BeepLen
		GOTO	test_loop

new_beep       call	UPDE_BOUNCE	
		btfsC	Button_Down
		 clrf	BeepLen
		GOTO	test_loop

finish	       clrf	OutputString+1
		movlw	startsending	;prepare to repeat to output
		movwf   NextEntry
		movlw	0x03
		movwf	TextNmbr
		bcf	Fin_Target
		RETURN


MOTOR_OUTPUT	movfw	MotEvent	
		tcall	moo
		return
moo		movwf 	PCL
		 goto 	event0		;0
		 goto 	event1		;1
		 goto	event2		;2
		 goto	event3		;3
		 goto	event4
event0		btfsS	Button_Down	; no button down recognized
		 return
		btfsC	Button_Port
		 RETURN
		call	DE_BOUNCE	; glitch?
		btfsC	Button_Down
		 RETURN
		incf	MotEvent,F
		RETURN

event1 	       bsf	Motor_Forward
		movfw	TimeD
		movwf	MotonLen
		movfw	TimeD+1
		movwf	MotonLen+1
		bsf	Motor_Event
		incf	MotEvent,F
		return
event2	       bcf	Motor_Forward	;
		movlw 	dot_time
		movwf	MotonLen
		bsf	Motor_Event
		incf	MotEvent,F
		return		
event3	       bsf	Motor_Reverse	;
		movfw	TimE
		movwf	MotonLen
		movfw	TimE+1
		movwf	MotonLen+1
		bsf	Motor_Event
		clrC
		;rrf	MotonLen+1,F	; div 2
		;rrf	MotonLen,F
		incf	MotEvent,F
		return		
event4	       bcf	Motor_Reverse;		
		clrf	MotEvent
		return
;**********************************************************************
MSEC_JOB   	bcf	Msec_Flag
		btfsS	Motor_Event	; Moton/pause to work off?
		 goto tst_b
		movf	MotonLen,F	; Motonlen != 0 ?
		skpZ
		 goto dec_moto
		movf	MotonLen+1,F
		skpZ
		 goto $+3
		bcf	Motor_Event			
		goto tst_b
		decf	MotonLen+1,F
dec_moto	decf	MotonLen,F
tst_b	       	btfsS	Beep_Event	; beep/pause to work off?
		 GOTO	msnobeep
		movf	BeepLen,F	; beeplen != 0 ?
		skpNZ
		 GOTO	msbedone
		btfsS	Beep_On
		 bsf	Beeper_Port	; motor on
		bsf	Beep_On
		decfsz	BeepLen,F	; BeepLen expired ?
		 GOTO	msnobeep
		bcf	Beeper_Port
		bcf	Beep_On		; buzzer off
msbedone       movf	PauseLen,F	; pause to work off?
		skpNZ
		 GOTO	$+3	
		decfsz	PauseLen,F	; PauseLen expired ?
		 GOTO	msnobeep
	       bcf	Beep_Event	; make next beep/pause


msnobeep       decfsz	msTick,F	; main job of MSEC_JOB
		 RETURN
		movlw	.250		; 250 * 4ms = 1sec
		movwf	msTick
		bsf 	Sec_Flag
		RETURN

ONESECJOB			
		bcf	Sec_Flag
		RETURN

;******************************************************************************
;
;******************************************************************************
;#define D0_1Tris	B'11001111'
;#define D0On		B'00010000'
;LED0
;	movlw	D0On		; data to forward bias LED0 and reverse bias LED1
;	movwf	GPIO		; send data to GPIO port
;	RETURN			; RETURN to calling routine
;
;	movlw	D0On
;	xorwf	GPIO,F
;

;**********************************************************************


;**********************************************************************

INIT_GPR	movlw	.250
		movwf	Seconds		; 5 sec to overflow
		clrf	Minutes
		movlw	.250		; 250 * 4ms = 1sec
		movwf	msTick
		clrf	NextEntry
		clrf	PauseLen
		clrf	BeepLen
		clrf	TimerTick
	
		clrf	TimerFlag	; reset all flags
		clrf	Target
		decf	Target,F	
		RETURN
;******************************************************************************
;MAIN PROGRAM
;******************************************************************************


RESET
io_config	MOVLW	B'00000111'	;Disable Comparator module's
		MOVWF	CMCON
	;	movlw 	b'00000010' 	;AN0 to C1, AN1 to C2, Internal VREF
	;	movwf 	CMCON
					; 00 c2inv =0 c1inv=0 cis=0 2comps muxed
		banksel	OPTION_REG	;Switch to register bank 1
	;	movlw 	VREF_LO 	;setpoint is vref_LOW			
	;	movwf	VRCON
					;Disable pull-ups
					;INT on rising edge
					;TMR0 to CLKOUT (internal)
					;TMR0 Incr low2high trans.
					;Prescaler assign to Timer0
					;Prescaler rate is 1:32
		MOVLW	B'11010100'	;Set PIC options (See datasheet).
		MOVWF	OPTION_REG	;Write the OPTION register.
		;
		CLRF	INTCON		;Disable interrupts
		MOVLW	B'00000000'
		MOVWF	TRISB		;RB7 & RB6 are outputs.
					;RB5...RB0 are outputs.
		MOVLW	B'11111111'	;all RA ports are inputs
		MOVWF	TRISA
		banksel	PORTB	;Switch Back to reg. Bank 0
		CLRF	PORTB	
;---------------------------------------
;--- pwm_config()
;---------------------------------------
pwm_config			;
		banksel	PR2	 	; *** bank=1
		movlw 0xff 		;
		movwf PR2 		; minimum frequency
		banksel CCPR1L		; *** bank=0
		movlw pwm_start		;start duty 
		movwf CCPR1L 		;
					;60*4 + 8 = 248 /256 max duty
					; postscaler 1:1 
					; TMR2 prescaler 16:1
		movlw b'00000110' 	; enable timer2 (TMR2ON)
		movwf T2CON 		;
		movlw b'00001100' 	; set "pwm" mode CCP1M3,2,1,0
		movwf CCP1CON 		;	bit 4+5 for 10bit res
	
;---------------------------------------

					;if P==12P625
					;
					;Init
					;	call    0x3FF      ; retrieve factory calibration value
					;	; comment instruction if using simulator, ICD2, or ICE2000
					;	BANKSEL	OSCCAL		; BANK1
					;	movwf   OSCCAL		; update register with factory cal value 
					;	movlw	B'00001000'	; set direction bits 
					;	movwf	TRISIO		; all others are inputs (high-z)
					;	movlw	B'11010100'	; Timer0 internal clock, 1:32 prescale
					;	movwf	OPTION_REG	; set option register for Timer0 functions
					;	clrf	ANSEL		; configure A/D I/O as digital
					;	banksel	CMCON		; switch back to PORT memory bank
					;	movlw	CM2 | CM1 | CM0 ; configure comparator inputs as digital I/O
					;	movwf	CMCON		;
					;	
					;		
;**********************************************************************
startagain	CLRF 	PORTB		; GPIO
	
		call INIT_GPR
			
		call TEST		; repeated to read pushbutton
;TESTRESET	movlw	"Z"
;		movwf	OutputString
		;call CALC_PWM			;	calculate PWM
		;call READMORSE		; repeat output previous letter
		call CALC_TIME			; calculate Time
		movfw	TimE
		movwf	TimeD
		movfw	TimE+1
		movwf	TimeD+1
		call READMORSE
		call CALC_TIME			; calculate Time
		call READMORSE
		movfw	OutputString	;
		sublw	"E"		; output E=yes T=no

		skpZ
		 GOTO	startagain
;**********************************************************************

normal_loop	btfsS	Beep_Event
		 call	MORSE_OUTPUT		
		btfsS	Motor_Event
		 call	MOTOR_OUTPUT		

		movfw	TimerTick	
		subwf	TMR0,W		;w=TimerTick-timr0
		andlw	0C0H		;slack 63*32 cycles
		SKPNZ
		 call	MSEC_EVENT	; 125 timerticks more
		btfsC	Msec_Flag
		 call	MSEC_JOB		;frequent jobs to be done in 4ms 
		btfsC	Sec_Flag
		 call	ONESECJOB	;occasional jobs to be done
		btfsS	Button_Down	;if Button_Down, let it clear by MSEC_JOB
		 btfsS	Button_Port	
		GOTO	normal_loop
					; unrecognized Button_Down
		call	UPDE_BOUNCE	; glitch?

		GOTO	normal_loop
		END
