; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;==============================================================================
;File name: HSI_aka_morse.asm
;
;This program demonstrates how Human Serial Interface also known as 
;Morse Code with a buzzer and a pushbutton can be achieved. 
;
;
;
;==============================================================================
;author:	Gerhard Michael Drygas
;company:	Michaels Prototype
;date:		25/10/2006
;MPLAB version:	7.41
;
;==============================================================================        

;	list      p=12F675	; list directive to define processor
;	#include <p12f675.inc>	; processor specific variable definitions

;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.
	LIST P = 16F627, F=INHX8M
	#include<p16F627.inc>


	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT


;*** register bank limits
#define ram0_start 	0x20
#define ram0_end 	0x7f			; 5f 12P625
#define ram0_length 	ram0_end - ram0_start + 1

;==========================================================================
;       Variable Definition
;==========================================================================
TimerTick	EQU	ram0_start	;Used in delay routine
msTick		EQU	ram0_start+0x01	; "	"	"	
TimerFlag	EQU	ram0_start+0x02
PCLoffset	EQU	ram0_start+0x03
TemP		EQU	ram0_start+0x07 ; local var, not to be used outside call
Target		EQU	ram0_start+0x08
TextNmbr	EQU	ram0_start+0x09 ;
TextLetter	EQU	ram0_start+0x0A ;
NextEntry	EQU	ram0_start+0x0B
PauseLen	EQU	ram0_start+0x0C
BeepLen		EQU	ram0_start+0x0D
IndxI		EQU	ram0_start+0x0E	; indexing
TempIndexI	EQU	ram0_start+0x0F	;bitlength-1   0=1 length
TempOut		EQU	ram0_start+0x10	;bits to output
Seconds        	EQU     ram0_start+0x12  
Minutes		EQU     ram0_start+0x13

ErrorCode	EQU	ram0_start+0x14
OutputString	EQU     ram0_start+0x15	;always last variable
		;EQU     ram0_start+0x18
		;EQU     ram0_start+0x19
WTemp        	EQU     ram0_end-0x01      ; variable used for context saving 
StatusTemp   	EQU     ram0_end        ; variable used for context saving

#define		wrd_pause	.240	; 
#define		dot_time	.48	; 
#define		dash_time	.152	; 
#define		dash_thresh	.102	; 


#define 	Repeat_Morse	TimerFlag,0
#define 	Beep_On		TimerFlag,1
#define 	Beep_Event	TimerFlag,2
#define 	Button_Down	TimerFlag,3
#define 	Pause_Pending	TimerFlag,4
#define 	Fin_Target	TimerFlag,5
#define 	Msec_Flag 	TimerFlag,6
#define 	Sec_Flag 	TimerFlag,7


#define 	Button_Port 	 PORTA,3;GPIO,3 	

#define		Beeper_Port	PORTB,7	;GPIO,0	

	ORG	0		;Reset vector address
		nop
		GOTO	RESET		;GOTO RESET routine when boot.

;******************************************************************************
;INTERRUPT
;******************************************************************************


	ORG     0x004             ; interrupt vector location
		movwf   WTemp            ; save off current W register contents
		movf	STATUS,w          ; move status register into W register
		movwf	StatusTemp       ; save off contents of STATUS register


	; isr code can go here or be located as a call subroutine elsewhere


		movf    StatusTemp,w     ; retrieve copy of STATUS register
		movwf	STATUS            ; restore pre-isr STATUS register contents
		swapf   WTemp,f
		swapf   WTemp,w          ; restore pre-isr W register contents
		retfie                    ; RETURN from interrupt


;******************************************************************************
;MACRO
;******************************************************************************
;******************************************************************************
;any page table call
;******************************************************************************
tcall	macro	adress
					
	addlw 	low (adress+1)
	movwf	PCLoffset
	movlw	high (adress+1)
	skpnC
	 addlw 0x01
	movwf	PCLATH
	movfw	PCLoffset
	call	adress	
	endm
;******************************************************************************
;page 0 table call
;******************************************************************************
	
p0call	macro	adress
	
	clrf PCLATH	
	addlw	(low adress+1)
	call	adress
	endm

;******************************************************************************
;Subroutines & Functions
;******************************************************************************

;******************************************************************************
;tables to call
;******************************************************************************

zeroAF	       movwf 	PCL
		dt 	"0123456789ABCDEF",0	;textstring to output, 0 for endstring


text	       movwf 	PCL
		retlw	0
		GOTO	msg1
		GOTO	msg2
		GOTO	msg3
		retlw	0

msg1	       movfw	TextLetter		; fixed string 
		addwf 	PCL,f
		dt 	"TEST OK.",0		;textstring to output, 0 for endstring

msg2		movfw	TextLetter		;fixed string with added letter
		addwf 	PCL,f
		dt 	"SOS "			;textstring to output, 0 for endstring
		GOTO	ret_ErrorCode
		retlw	0
ret_ErrorCode  movfw	ErrorCode
		RETURN
msg3	       movlw	OutputString		; run time defined string
		addwf	TextLetter,w
		movwf	FSR
		movfw	INDF
		RETURN			

;******************************************************************************
;MORSE CODE
;******************************************************************************

GETCODE	       movwf TemP 		;w:= morsecode[w] for w in [0..9,A..Z,".",",","?"]
		sublw "." 	
		skpNZ 
		 GOTO fullstp
		movfw TemP 	
		sublw "," 	
		skpNZ 
		 GOTO comma
		movfw TemP 	
		sublw "?"	
		skpNZ 
		 GOTO query
		movfw TemP 	
		sublw "9"
		skpc
		 GOTO larger9
numeric	       movlw "0"		;PCLoffset in TemP
		subwf TemP,w
		addlw	.26
		tcall	aln_bin
		RETURN
larger9        movlw "A"
		subwf TemP,w
		tcall	aln_bin
		RETURN
	
aln_bin	movwf PCL		; coding : 0= dot 1=dash  5 dot/dash + 3bytes length
alpha	retlw b'01000001'  ; A .-
	retlw b'10000011'  ; B -...
	retlw b'10100011'  ; C -.-.
	retlw b'10000010'  ; D -..
	retlw b'00000000'  ; E .
	retlw b'00100011'  ; F ..-.
	retlw b'11000010'  ; G --.
	retlw b'00000011'  ; H ....
	retlw b'00000001'  ; I ..
	retlw b'01110011'  ; J .---
	retlw b'10100010'  ; K -.-
	retlw b'01000011'  ; L .-..
	retlw b'11000001'  ; M --
	retlw b'10000001'  ; N -.
	retlw b'11100010'  ; O ---
	retlw b'01100011'  ; P .--.
	retlw b'11010011'  ; Q --.-
	retlw b'01000010'  ; R .-.
	retlw b'00000010'  ; S ...
	retlw b'10000000'  ; T -
	retlw b'00100010'  ; U ..-
	retlw b'00010011'  ; V ...-
	retlw b'01100010'  ; W .--
	retlw b'10010011'  ; X -..-
	retlw b'10110011'  ; Y -.--
	retlw b'11000011'  ; Z --..

numset	retlw b'11111100'  ; 0 -----
	retlw b'01111100'  ; 1 .----
	retlw b'00111100'  ; 2 ..---
	retlw b'00011100'  ; 3 ...--
	retlw b'00001100'  ; 4 ....-
	retlw b'00000100'  ; 5 .....
	retlw b'10000100'  ; 6 -....
	retlw b'11000100'  ; 7 --...
	retlw b'11100100'  ; 8 ---..
	retlw b'11110100'  ; 9 ----.

fullstp retlw b'01010101'  ; ;Fullstop .-.-.- discrete char
comma	retlw b'11001110'  ; ;Comma --..--    discrete char
query	retlw b'00110111'  ; ;Query   ..--..   discrete char

;**********************************************************************
#define 	startsending 	0x01	; 
	
MORSE_OUTPUT	movf	NextEntry,f
		skpNZ
		 RETURN
		bsf	Beep_Event
		movfw	NextEntry
		tcall m_o
		RETURN
m_o		movwf	PCL
		GOTO	nomorebeep
		GOTO	start_sending		;entry = 1
		GOTO	nextlet			;2
		GOTO	here			;3
		GOTO	morbits			;4
		GOTO	nextchar		; entry=5

nomorebeep 	bcf 	Beep_Event
		clrf	NextEntry
		RETURN

start_sending	movfw	TextNmbr		; start events	
		clrf	TextLetter			; next_ entry = nextlet

nextlet		movfw	TextNmbr
		tcall	text
		addlw	0			; zero
		skpNZ
		 GOTO 	loopend			; RETURN no event; next entry = RETURN
		addlw	1x00 - " "
		skpz				; check for 'space'
		 GOTO	numlet
		movlw	wrd_pause
		movwf	PauseLen
		clrf	BeepLen
		GOTO	nextchar		; RETURN there

numlet		addlw	" "
		call	GETCODE				;morse code in W
		movwf	TempOut
		andlw	b'00000111'
		movwf	TempIndexI			;  
		clrf	IndxI			; IndxI:=0  =7th bit
noshift		movlw	0x03	
		movwf	NextEntry	; next entry = here
		btfsC	TempOut,7
		 GOTO	dash		; 
dot		movlw	dot_time		;RETURN event = dot/dash +pause
		movwf	PauseLen
		movwf	BeepLen
		RETURN			
dash		movlw	dot_time		;RETURN event = dot/dash +pause
		movwf	PauseLen
		movlw	dash_time
		movwf	BeepLen
		RETURN
	
here		movfw	TempIndexI			; 
		subwf	IndxI,w
		skpNZ				; IndxI=bits to do?
		 GOTO	nextchar
		movfw	IndxI
		sublw	4			; IndxI=4?
		skpz	
		 GOTO	morbits			; produce nextevent
	
		movlw	0x5
		movwf	NextEntry		; next entry = nextchar
		movfw	TempIndexI
		sublw	5			; TempIndexI=5?
		skpNZ	
		 GOTO	dash
		movfw	TempIndexI
		sublw	6			; TempIndexI=6?
		skpNZ	
		 GOTO	dash
		GOTO	dot			; TempIndexI = 7
	
morbits		incf	IndxI,f
		rlf	TempOut,f
		GOTO noshift
	
nextchar	movlw	0x02	
		movwf	NextEntry
		incf	TextLetter,f
		movlw	dot_time		;RETURN event = dot pause
		movwf	PauseLen
		clrf    BeepLen
		RETURN  		; NextEntry = nextlet

loopend 	movlw	wrd_pause
		movwf	PauseLen
		clrf	BeepLen	; NextEntry = 0 nomore
		clrf	NextEntry
		RETURN
;**********************************************************************
FIND_TARGET	clrf	IndxI
nexti	       movfw	IndxI		;while IndxI<36
		sublw	.36
		skpNZ
		 GOTO ffail
		movfw	IndxI
		tcall	aln_bin
		subwf	Target,w
		skpNZ
		 GOTO	fsucess
		incf	IndxI,f
		GOTO	nexti
fsucess		movfw	IndxI
		sublw	.25
		skpC	
		 GOTO	fnum
		movfw	IndxI
		addlw	"A"
		RETURN
fnum		movfw	IndxI
		addlw	"0"-.26
		RETURN
ffail	       movlw 	"."
		RETURN
;******************************************************************************
		
CLR_BEEP_PAUSE	incf	Target,f
		movfw	BeepLen
		sublw   dash_thresh	; BeepLen > dash_tresh ?
		skpnC 
		 GOTO 	was_dot
		movlw	0x80		;was dash
		movwf	TempIndexI
		movfw	Target
		andlw	0x07
		skpNZ
		 GOTO 	nextx
		;decf	IndxI,f
		movwf	IndxI
rotc		rrf	TempIndexI,f
		decfsz	IndxI,f
		 GOTO rotc
nextx		movfw	TempIndexI
		iorwf	Target,f		
was_dot		movf	PauseLen,f
		skpz
		 RETURN
		movfw	Target
		call	FIND_TARGET				;
		movwf	OutputString
		clrf	Target			; conversion finished
		decf	Target,f
		bsf	Fin_Target
		RETURN
;**********************************************************************
;pushbutton input
;******************************************************************************

DE_BOUNCE	movfw	TMR0
		addlw	.6
		movwf	TemP		;button up for 200us?
wait		movfw	TemP
		btfSC	Button_Port
		 GOTO 	fail
		subwf	TMR0,w
		skpz
		 GOTO wait
		bcf	Button_Down
		bcf	Beeper_Port
fail		RETURN

UPDE_BOUNCE	movfw	TMR0			;button down for 100us ?
		addlw	.3
		movwf	TemP
upwait		movfw	TemP
		btfSS	Button_Port
		 GOTO	upfail
		subwf	TMR0,w
		skpz
		 GOTO 	upwait
		bsf	Button_Down
		bsf	Beeper_Port
		bcf	Beep_Event	; prevent sending
		clrf	NextEntry	;prevent more code to come
		RETURN
upfail		bcf	Button_Down
		RETURN
;******************************************************************************
;time event routines
;******************************************************************************

MSEC_EVENT	movlw	.125		; 125* 32us = 4msec
		addwf	TimerTick,f
		bsf	Msec_Flag
		RETURN

MSEC_JOB        bcf	Msec_Flag
		btfss	Pause_Pending
		 GOTO	tst_btn_d	; *
		incfsz	PauseLen,f	; ! pause > 255?
		 GOTO	tst_btn_d	; !
		bcf	Pause_Pending	; !
		GOTO	CLR_BEEP_PAUSE	; ! RETURN from there
		RETURN			; !
					; !
tst_btn_d      btfss	Button_Down	; *
		 GOTO	betest
		incf	BeepLen,f
		btfsC	Button_Port
		 GOTO	nobeep
		call	DE_BOUNCE		; glitch?
		btfsC	Button_Down
		 GOTO	nobeep
		
						;button gone up
		bsf	Pause_Pending
		clrf	PauseLen
			
betest		btfss	Beep_Event		; if not Beep_Event
		 GOTO	nobeep
		movf	BeepLen,f		; beeplen != 0 ?
		skpNZ
		 GOTO	bedone
		btfss	Beep_On
		 bsf	Beeper_Port		; buzzer on
		bsf	Beep_On
		decfsz	BeepLen,f		; BeepLen expired ?
		 GOTO	nobeep
		bcf	Beeper_Port
		bcf	Beep_On			; buzzer off
bedone		movf	PauseLen,f
		skpNZ
		 GOTO	clrbeep	
		decfsz	PauseLen,f
		 GOTO	nobeep
clrbeep		bcf	Beep_Event


nobeep		decfsz	msTick,f
		RETURN
		movlw	.250		; 250 * 4ms = 1sec
		movwf	msTick
		bsf 	Sec_Flag
		RETURN

;**********************************************************************
ONESECJOB			
		bcf	Sec_Flag
		RETURN

;******************************************************************************
;
;******************************************************************************
;#define D0_1Tris	B'11001111'
;#define D0On		B'00010000'
;LED0
;	movlw	D0On		; data to forward bias LED0 and reverse bias LED1
;	movwf	GPIO		; send data to GPIO port
;	RETURN			; RETURN to calling routine
;
;	movlw	D0On
;	xorwf	GPIO,f
;
TEST_ONESECJOB	bcf	Sec_Flag	
		incf	Seconds,f
		skpz
		 RETURN		
		incf	Minutes,f
		movlw	.195		;		
		movwf	Seconds		;60 sec for next send
		btfsC	Beep_Event
		 RETURN
		movlw	OutputString	;produce two letter string
		movwf	FSR		;from byte Minutes
		movfw	Minutes
		andlw	0xF0
		skpNZ
		 GOTO	oneletter
		movwf	TemP
		swapf	TemP,w			
		tcall	zeroAF
		movwf	INDF
		incf	FSR,f
oneletter	movfw	Minutes
		andlw	0x0F
		tcall	zeroAF
		movwf	INDF
		incf	FSR,f
		clrf	INDF
		movlw	3
		movwf	TextNmbr
		movlw	1
		movwf	NextEntry	;start sending Minutes 
		
		RETURN

;**********************************************************************

TEST		movlw	"S"
		movwf	OutputString
;		movlw	"9"
;		movwf	OutputString+1
		clrf	OutputString+1
		movlw	startsending
		movwf   NextEntry
		movlw	0x03
		movwf	TextNmbr

test_loop	btfsC	Fin_Target
		 GOTO	finish		; exit after 1 letter
		
		btfss	Beep_Event
		 call	MORSE_OUTPUT
		movfw	TimerTick	
		subwf	TMR0,w		;w=TimerTick-timr0
		andlw	0C0H		;slack 63*32 cycles
		SKPNZ
		 call	MSEC_EVENT	; 125 timerticks more
		BTFSC	Msec_Flag
		 call	MSEC_JOB		;frequent jobs to be done in 4ms 
		BTFSC	Sec_Flag
		 call	TEST_ONESECJOB	;
 
		;GOTO	test_loop	;test

		btfss	Button_Down	;if Button_Down, let it clear by MSEC_JOB
		 BTFSS	Button_Port	
		GOTO	test_loop
		BTFSS	Pause_Pending	; unrecognized Button_Down
		 GOTO	new_beep	; was pause running?
		call	UPDE_BOUNCE	; glitch?
		btfss	Button_Down
		 GOTO	test_loop

		call	CLR_BEEP_PAUSE; remove previous beep/pause
		bcf	Pause_Pending
		clrf	BeepLen
		GOTO	test_loop

new_beep	call	UPDE_BOUNCE
		btfsC	Button_Down
		 clrf	BeepLen
		GOTO	test_loop

finish		clrf	OutputString+1
		movlw	startsending
		movwf   NextEntry
		movlw	0x03
		movwf	TextNmbr
		bcf	Fin_Target

	
		RETURN

;**********************************************************************


;**********************************************************************

INIT_GPR	movlw	.250
		movwf	Seconds		; 5 sec to overflow
		clrf	Minutes
		movlw	.250		; 250 * 4ms = 1sec
		movwf	msTick
		clrf	NextEntry
		clrf	PauseLen
		clrf	BeepLen
		clrf	TimerTick
	
		clrf	TimerFlag	; reset all flags
		clrf	Target
		decf	Target,f	
		RETURN
;******************************************************************************
;MAIN PROGRAM
;******************************************************************************


RESET
io_config	movlw	B'00000111'	;Disable Comparator module's
		movwf	CMCON
					; or
					;movlw 	b'00000010' 	;AN0 to C1, AN1 to C2, Internal
					;movwf 	CMCON
			   		;00 c2inv =0 c1inv=0 cis=0 2comps muxed
		banksel	OPTION_REG	;Switch to register bank 1
					;movlw 	VREF_LO 	;setpoint is vref_LOW			
					;movwf	VRCON
					
					;Disable pull-ups
					;INT on rising edge
					;TMR0 to CLKOUT (internal)
					;TMR0 Incr low2high trans.
					;Prescaler assign to Timer0
					;Prescaler rate is 1:32
		movlw	B'11010100'	;Set PIC options (See datasheet).
		movwf	OPTION_REG	;Write the OPTION register.
		;
		CLRF	INTCON		;Disable interrupts
		movlw	B'00000000'
		movwf	TRISB		;RB7 & RB6 are outputs.
					;RB5...RB0 are outputs.
		movlw	B'11111111'	;all RA ports are inputs
		movwf	TRISA
		banksel	PORTB	;Switch Back to reg. Bank 0
;if P==12P625
;
;Init
;	call    0x3FF      ; retrieve factory calibration value
;	; comment instruction if using simulator, ICD2, or ICE2000
;	BANKSEL	OSCCAL		; BANK1
;	movwf   OSCCAL		; update register with factory cal value 
;	movlw	B'00001000'	; set direction bits 
;	movwf	TRISIO		; all others are inputs (high-z)
;	movlw	B'11010100'	; Timer0 internal clock, 1:32 prescale
;	movwf	OPTION_REG	; set option register for Timer0 functions
;	clrf	ANSEL		; configure A/D I/O as digital
;	banksel	CMCON		; switch back to PORT memory bank
;	movlw	CM2 | CM1 | CM0 ; configure comparator inputs as digital I/O
;	movwf	CMCON		;
;	
;		
;**********************************************************************
		CLRF 	PORTB	; GPIO
	
		call INIT_GPR
			
		call TEST		; can be repeated to read pushbutton
	


;**********************************************************************

normal_loop	btfss	Beep_Event
		 call	MORSE_OUTPUT		

		movfw	TimerTick	
		subwf	TMR0,w		;w=TimerTick-timr0
		andlw	0C0H		;slack 63*32 cycles
		SKPNZ
		 call	MSEC_EVENT	; 125 timerticks more
		BTFSC	Msec_Flag
		 call	MSEC_JOB		;frequent jobs to be done in 4ms 
		BTFSC	Sec_Flag
quick_loop	 call	ONESECJOB	;occasional jobs to be done
		GOTO	normal_loop
		END
