;***********************************************************************
;*   This file is the firmware to implement a                          *
;*                                                                     *
;*    binary display of a register as low (0) and                      *
;*                                    high (1) 17microseconds pulses   *
;*                       starting with a 17 microsecond low pulse      *
;*                       ending in a high                              *
;*   at a output GPIO port = asynchronous byte of 57600 baud           *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G MICHAEL DRYGAS                                   *
;*                                    				       *
;*    Company:    MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)*
;*                 reg DE                                             *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3c                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  macros3c.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************


	cblock _MINRAM
	 SystemStatus,TimerVector,TimeCounter:2
	 x	 

	endc

#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define GPIOinit	b'00000110'	; all OUTPUT initiate as HIGH
#define TRISIOinit	b'11111011'	; configure GP1,2 as output 
#define	OPTIONinit	b'11000001'	; no wakup, no pullup, Clock 1:4
#define ANSELinit 	B'01111000' 	; ADC Frc clock, AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justify, chanel 03,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable



black2	macro
	movlw	TRISIOinit | b'00000100'	; port 2 input = black
	TRIS	TRISGPIO
	endm
red2	macro
	bcf	GPIO,2
	movlw	TRISIOinit & b'11111011'	; port 2 output,LOW = red
	TRIS	TRISGPIO
	endm
blue2	macro
	bsf	GPIO,2
	movlw	TRISIOinit & b'11111011'	; port 2 output,HIGH = blue
	TRIS	TRISGPIO
	endm
	
	nointr683
	init683
	goto	MAIN

zerocall retlw	0				


	
MAIN	
;	
;cycle	black2
;	settrap206B .6,sec,ADC,TimeCounter,TimerVector
;
;
;ploop	if_bit	TMR0,7			; software emulation of
;	 goto	set7			; timer 0 overflow
;	if_not	TMR07Bit		;
;	 goto	clred
;	bcf	TMR07Bit		; timer 0 has overflown within
;	decfsz	TimeCounter,F		;	127 timerticks
;	 goto	clred
;	decfsz	TimeCounter+1,F
;	 goto    clred			
;	 
;	movfw	TimerVector		; timer trap has sprung
;	movwf	PCL			; jump to destination
;
;set7	bsf	TMR07Bit
;
;
;clred					; timer loop
;	goto	ploop			; code max for 127 timerticks
;
;
if_zero	macro
	skpNZ
	endm
if_notzero macro
	skpZ
	endm
if_carry	macro
	skpNC
	endm
if_notcarry	macro
	skpC
	endm

delay2	macro	Cycles
 variable CyclesLeft ,LoopCycles,d_used           ;  Keep Track of Remaining Cycle
 local	iloop
CyclesLeft = Cycles

	if CyclesLeft > .327680 ; 0x5 * 0xffff
d_used = 3
	else
	 if Cycles > 3*0xFF
d_used = 2
	 else
d_used = 1
	 endif
	endif


	if	d_used == 3
LoopCycles = (Cycles-6-.10) / 7
CyclesLeft = (Cycles-6-.10) - (LoopCycles*7)

	endif
	if	d_used == 2
LoopCycles = (Cycles-4-6) / 5
CyclesLeft = (Cycles-4-6) - (LoopCycles*5)
	
	endif

	if	d_used == 1
LoopCycles = (Cycles-2-2) / 3
CyclesLeft = (Cycles-2-2) - (LoopCycles*3)
	endif

  if Cycles >=5

 	movlw   (LoopCycles & 0xFF)+1
  	movwf   STACK-0
	if d_used >=2
 	movlw   ((LoopCycles>>8) & 0xFF)+1
  	movwf   STACK-1
	endif
	if d_used >=3
 	movlw   ((LoopCycles>>.16) & 0xFF)+1
  	movwf   STACK-2
	endif
iloop
 	if d_used >=3
	 goto	$+1 
	endif
 	if d_used >=2
	 goto	$+1 
	endif

  	decfsz  STACK-0,F
   	 goto	iloop
 	if d_used >=2
  	decfsz  STACK-1,F
   	 goto	iloop+1
	endif
	if d_used >=3	
	decfsz  STACK-2,F
   	 goto	iloop+2
	endif
	

  endif

 while CyclesLeft >= 2          ;  Put in 2 Instruction Cycle Delays
  	goto    $ + 1
CyclesLeft = CyclesLeft - 2
 endw
 if CyclesLeft == 1             ;  Put in the Last Required Cycle
  	nop
 endif
        endm




	eq_	FSR,=,ADRESH,lit8

	setC
	clrf	x

ADC	delay2	.100

	delay2  .1000
	
	delay2	.1000000


	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1


#define port 2
baudnextbit	
		
	movfw	GPIO
	movwf	STACK
	movfw	x
	andwf	INDF,W
	if_zero			;or load GPIO,and mask,ior mask, save
	 bcf	STACK,port
	if_notzero
	 bsf	STACK,port
	movfw	STACK
	movwf	GPIO			; electrical change occurs now
;
;	btfss	x,3			; adjust timing 57600baud = 17.36us
;	 goto	noextradelay			; call	zerocall
;	goto	$+1			; bit 3 is 3 cycles longer
;	goto	$+1
;noextradelay
#define	looptime .14
	delay 	.17-looptime		; delay to adjust for other baud rates
	
	rlf	x,F
	if_notcarry
	 goto   baudnextbit
	delay	.17-.7			; last data bit

	bsf	GPIO,port		; start of stop bit

	
	goto	ADC
;
;waitforstartbit
;	clrwdt
;	btfsc	GPIO,port
;	 goto	$-2			;loop until start bit
;					; interrrupt necessary if rt os
;	
;	eq_	x,=,8,lit8
;#define looptime	.7
;	delay	looptime+ (.17/2) 		; 0.5 bits +2
;	
;receiveloop
;	delay	.10;.17-looptime		; 1 bit @ 57600 baud
;	clrC
;	btfsc	GPIO,port
;	 setC
;	rlf	INDF,F
;	decfsz	x,F
;	 goto	receiveloop
;	goto	waitforstartbit
;
;	eq_	x,=,b'10000000', lit8	; bit 7
;
;frstbit	movfw	x			; omit leading zeros
;	andwf	AL,W
;	bC	strtdis			; its a 1, start display
;	rrf	x,F
;	skpC				; underflow ?
;	 goto	frstbit
;	rlf	x,F			; send bit 0 anyway
;	
;strtdis	movfw	x
;	andwf	AL,W
;	skpNC	
;	 goto	long
;	settrap206B .200,msec,pause,TimeCounter,TimerVector
;	red2
; 	goto ploop
;long	settrap206B .800,msec,pause,TimeCounter,TimerVector
; 	blue2
; 	goto ploop	
;
;pause	settrap206B .200,msec,rsmedis,TimeCounter,TimerVector
;	black2
; 	goto ploop
; 	
;rsmedis	rrf	x,F	;	next bit?
;	bC	cycle	;	done, wait for next measurement
;	goto	strtdis	
;
	
	

	end