;**********************************************************************
;*                                                                    *
;* Software License Agreement                                         *
;*                                                                    *
;* The software supplied herewith by Microchip Technology             *
;* Incorporated (the "Company") is intended and supplied to you, the  *
;* Companys customer, for use solely and exclusively on Microchip    *
;* products. The software is owned by the Company and/or its supplier,*
;* and is protected under applicable copyright laws. All rights are   *
;* reserved. Any use in violation of the foregoing restrictions may   *
;* subject the user to criminal sanctions under applicable laws, as   *
;* well as to civil liability for the breach of the terms and         *
;* conditions of this license.                                        *
;*                                                                    *
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  *
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  *
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A        *
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  *
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         *
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                  *
;*                                                                    *
;**********************************************************************
;                                                                     *
;    Filename:	    WhiteLED.asm                                      *
;    Date:          21 May 2002                                       *
;    File Version:  1.0                                               *
;                                                                     *
;    Author:        w.r.brown                                         *
;    Company:	    Microchip Technology Incorporated                 *
;                                                                     * 
;    Modified:                                                        *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required: p16c781.inc                                      *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes: Switching driver for high intensity white LED's           *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************

	list      p=16c781      	; list directive to define processor
	#include <p16c781.inc>		; processor specific variable definitions

	__CONFIG  _BODEN_ON & _CP_OFF & _VBOR_27 & _PWRTE_ON & _MCLRE_OFF & _WDT_OFF & _INTRC_OSC_NOCLKOUT

Fosc		equ	D'4000000'
Fclk		equ	Fosc/4
T0Prescale	equ	D'64'
T0Freq	 	equ	Fclk/T0Prescale
FBounce		equ	D'100'		; 1/(10e-3)

T1Prescale	equ	D'8'
T1Freq		equ	Fclk/T1Prescale
FDimmer		equ	D'2'		; 1/(.5) .5 seconds to start dimmer mode
FDim		equ	D'255'/D'2'	; 2 seconds to try all 255 dimmer settings
FFlash1		equ	D'13'		; 1/.075 = .15 second flash period
FFlash2		equ	D'27'		; 1/.033 = .15 second flash period @ 25% DC

#define	Bank0		0x00
#define	Button		PORTA,5		; power button
BounceCount	equ	0x100-(T0Freq/FBounce) ; counts for Timer0 to overflow at 10 mSec
DimmerCount	equ	0x10000-(T1Freq/FDimmer)
Flash1Count	equ	0x10000-(T1Freq/FFlash1)
Flash2Count	equ	0x10000-(T1Freq/FFlash2)
DimCount	equ	0x10000-(T1Freq/FDim)

	CBLOCK	0x070
	Mode		; operation modes: Steady, Flash1, Flash2, Off
	Flags
	DACSave		; holds DAC value when flash mode is dark
	DCCount		; counter to control flash duty cycle

	ENDC

#define DimmerFlag	Flags,0
#define DimUpFlag	Flags,1

	org	0x000
	goto	Initialize

; Insert interrupt service routine here
	org	0x004
	retfie

Initialize

	BANKSEL	PORTA

	movlw	0x00		; Initial port value
	movwf	PORTA
	movlw	0x00		; Initial port value
	movwf	PORTB
	movlw	0x30		; Gate Disabled, Prescale 1:8, LP Osc Off, Sync Off,
				;  Clk: Fosc/4, Timer1 Off
	movwf	T1CON
	movlw	0x00		; ADC clk: Fosc/2, ADC Input: AN0, ADC Off
	movwf	ADCON0

	BANKSEL	ANSEL

	movlw	0x9B		; Analog pins: RB(0,3), RA(0,1,3)
	movwf	ANSEL
	movlw	0xCF		; PORTB Pullups: RB(0,1,2,3,6,7)
	movwf	WPUB
	movlw	0x2B		; Inputs: RA(0,1,3,5), Outputs: RA(2,4,6,7)
	movwf	TRISA
	movlw	0x09		; Inputs: RB(0,3), Outputs: RB(1,2,4,5,6,7)
	movwf	TRISB
	movlw	0x0C		; VR: On, VR Output: On
	movwf	REFCON
	movlw	0x00		; ADC Reference: AVDD
	movwf	ADCON1
	movlw	0xD5		; Pullups: Off, RB0/INT edge: Rising, TMR0 clk: Fosc/4,
				;  TMR0 edge: Falling, Prescaler: TMR0(1:64)
	movwf	OPTION_REG

	BANKSEL	DACON0

	movlw	0xFF		; DAC Value
	movwf	DAC
	movwf	DACSave
	movlw	0x81		; DAC: On, DAC output: Off, DAC Ref: VREF1
	movwf	DACON0
	movlw	0x8F		; C1: On, Output: Off, Non-Inverted, Speed: Normal,
				;  In(+): VDAC, In(-): RB3/AN7
	movwf	CM1CON0
	movlw	0x00		; C2: Off, Output: Off, Non-Inverted, Speed: Slow,
				;  In(+): RA2/VREF2, In(-): RB0/AN4
	movwf	CM2CON0
	movlw	0x00		; C2 sync to Timer1: Off
	movwf	CM2CON1
	movlw	0x81		; OpAmp: On, Mode: OpAmp, Speed: Fast
	movwf	OPACON
	movlw	0x00		; OpAmp calibration source: Internal 1.2V
	movwf	CALCON
	movlw	0xC8		; PSMC Fout: Fosc/16, Min PWM DC: 0%, Max PWM DC: 75%,
				;  PSM DC: 12.5%
	movwf	PSMCCON0
	movlw	0x82		; PSMC: On, PSMC1A: High true, PSMC1B: High true,
				;  Slope Compensation: Off, Output: Single, Mode: PWM, C1 only
	movwf	PSMCCON1
	
	banksel	Bank0
	clrf	Flags

; wait for power button to release
	call	Debounce

	call	Calibrate	; calibrate Op Amp offset

RunLoop
	btfss	Button		; enter next mode when button is pressed
	goto	RunLoop

	call	Debounce
	btfsc	DimmerFlag	; if button was used to dim lite then don't change mode
	goto	RunLoop		

Flash1Start
	call	StartT1		; initialize Timer1

Flash1Loop
	btfsc	Button		; enter next mode when button is pressed
	goto	Flash1Button

	btfss	PIR1,TMR1IF	; test for Timer1 overflow
	goto	Flash1Loop

	btfss	DCCount,0	; 50% duty cycle
	goto	Flash1Off

	call	FlashOn
	goto	Flash1Start

Flash1Off
	call	FlashOff
	goto	Flash1Start

Flash1Button
	call	FlashOn		; force lights on to prevent dark during button press timeout
	call	Debounce
	btfsc	DimmerFlag	; if button was used to dim lite then don't change mode
	goto	Flash1Start

Flash2Start
	call	StartT2		; initialize Timer1
Flash2Loop
	btfsc	Button		; enter next mode when button is pressed
	goto	Flash2Button

	btfss	PIR1,TMR1IF	; test for Timer1 overflow
	goto	Flash2Loop

	movlw	0x03		; 25% duty cycle
	andwf	DCCount,w
	btfss	STATUS,Z
	goto	Flash2Off

	call	FlashOn
	goto	Flash2Start

Flash2Off
	call	FlashOff
	goto	Flash2Start

Flash2Button
	call	FlashOn		; force lights on to prevent dark during button press timeout
	call	Debounce
	btfsc	DimmerFlag	; if button was used to dim lite then don't change mode
	goto	Flash2Start

; Unit power is maintained by RA4 low
; If button is pressed, wait for debounce then kill power by setting RA4 high
PowerOff
	bsf	PORTA,4		; 
	goto	PowerOff	; loop here until low voltage reset

Debounce
	bcf	DimmerFlag
DebounceRestart
	clrf	TMR0		; clear Timer0
	bcf	INTCON,T0IF	; clear Timer0 overflow flag
	bcf	T1CON,TMR1ON	; ensure Timer1 is off
	movlw	HIGH DimmerCount
	movwf	TMR1H
	movlw	LOW DimmerCount
	movwf	TMR1L
	bcf	PIR1,TMR1IF	; clear Timer1 overflow flag
	bsf	T1CON,TMR1ON	; start Timer1
DebounceLoop
	btfsc	PIR1,TMR1IF	; test if button held for dimming
	goto	Dimmer		; dimmer request

	movlw	BounceCount	; set debounce time
	movwf	TMR0

	btfsc	Button		; reset timer when button is pressed
	goto	DebounceLoop
DebounceTimeOut
	btfss	INTCON,T0IF	; test if debounce time is complete
	goto	DebounceTimeOut	; test for button bounces
	return

Dimmer
	bsf	DimmerFlag
DimTimerStart
	banksel	Bank0
	bcf	T1CON,TMR1ON	; ensure Timer1 is off
	movlw	HIGH DimCount
	movwf	TMR1H
	movlw	LOW DimCount
	movwf	TMR1L
	bcf	PIR1,TMR1IF	; clear Timer1 overflow flag
	bsf	T1CON,TMR1ON	; start Timer1

DimLoop
	bsf	DimmerFlag	; signal that dimmer was invoked
	btfsc	PIR1,TMR1IF	; change dim level every Timer1 overflow
	goto	DimNext

	btfss	Button		; stay in dimmer while button is pressed
	goto	DimExit		; exit when button released

	goto	DimLoop

DimNext
	banksel	DAC
	btfss	DimUpFlag	; test direction
	goto	DimDown

DimUp
	incfsz	DAC,f
	goto	DimTimerStart

	bcf	DimUpFlag
DimDown
	decfsz	DAC,f
	goto	DimTimerStart

	bsf	DimUpFlag
	goto	DimUp
DimExit
	banksel	DAC		; save dimmed value
	movf	DAC,w
	movwf	DACSave
	banksel Bank0
	goto	DebounceRestart	; exit through debounce

StartT1				; start Timer1 with flash time
	bcf	T1CON,TMR1ON	; ensure Timer1 is off
	movlw	HIGH Flash1Count
	movwf	TMR1H
	movlw	LOW Flash1Count
	movwf	TMR1L
	bcf	PIR1,TMR1IF	; clear Timer1 overflow flag
	bsf	T1CON,TMR1ON	; start Timer1
	incf	DCCount,f	; update duty cycle counter
	return
StartT2				; start Timer1 with flash time
	bcf	T1CON,TMR1ON	; ensure Timer1 is off
	movlw	HIGH Flash2Count
	movwf	TMR1H
	movlw	LOW Flash2Count
	movwf	TMR1L
	bcf	PIR1,TMR1IF	; clear Timer1 overflow flag
	bsf	T1CON,TMR1ON	; start Timer1
	incf	DCCount,f	; update duty cycle counter
	return

FlashOff
	banksel PSMCCON1
	bcf	PSMCCON1,SMCON
	banksel Bank0
	return

FlashOn
	banksel PSMCCON1
	bsf	PSMCCON1,SMCON
	banksel Bank0
	return

Calibrate
	banksel	CALCON
	bsf	CALCON,CAL	; initiate calibration
CalWait
	btfsc	CALCON,CAL	; 
	goto	CalWait		; loop until cal bit goes to zero

	banksel	Bank0
	return

	END
