
;Software License Agreement                                         
;                                                                    
;The software supplied herewith by 
;MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)             
;Incorporated (the "Company") is intended and supplied to you, the  
;Companys customer, for use solely and exclusively on Microchip    
;products. The software is owned by the Company and/or its supplier,
;and is protected under applicable copyright laws. All rights are   
;reserved. Any use in violation of the foregoing restrictions may   
;subject the user to criminal sanctions under applicable laws, as   
;well as to civil liability for the breach of the terms and         
;conditions of this license.                                        
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement 
;*   GPIO output driver                                *
;*    File Version:                                                 *
;*                                                                     *
;*    Author:       G Michael DRYGAS                                          *
;*                  Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683
#define TRISIOinit b'00011001';
;#define ANSELinit 	B'01110001' 	; ADC Frc clock, AN0 as analog
;#define ADCON0init	b'00000001'	; left justified , AN0, on

	nointr683
	init683

#define port	4	
	bsf	GPIO,port			; pnp
;	bcf	GPIO,port			;
	
	
	cblock	_MINRAM
	endc
#define	STACK	_MAXRAM

	cblock
	 DispCounter:2,DisprVector,x
	endc
	eq_	DispCounter,=,0x0101,	lit16
	movlw	initdis
	movwf	DisprVector

	eq_	FSR,=,STACK,		lit8	;variable to display

loop		
		banksel	TRISIO
		 bcf	TRISIO,port; 
		banksel	Bank0
		dlay	.10			; discharge C for next measurement
		
		banksel	TRISIO
		 bsf	TRISIO,port	; 
		banksel	Bank0
		mov	TMR0,STACK
		;btfsc	CMCON0,CMPOUT  	
		;btfss	GPIO,port
		btfsc	GPIO,port	; pnp
		 goto	$-1		; will hang if no wdt
		sub	STACK,TMR0,STACK
		goto	okmes
afterwdt	eq	STACK,.255	
okmes		
;		banksel	TRISIO
;		 bcf	TRISIO,port; 
;		banksel	Bank0
;					; discharge C for next measurement
;
	call	slinear


	eq_	x,=,b'10000000', lit8	
	
mblack	macro	Gbit
	make	Gbit, INPUT	; port  input = black
	endm   
mred	macro   Gbit
	bcf	GPIO,Gbit
	make	Gbit, OUTPUT    ; port  output,LOW = red
	endm
mblue	macro   Gbit
	bsf	GPIO,Gbit
	make	Gbit, OUTPUT	; port  output,HIGH = blue
	endm

solodis	
;anadis	macro	port, hicolor, locolor, offcolor

t0	if_not	INTCON,T0IF
	 goto	solodis
	bcf	INTCON,T0IF

	decfsz	DispCounter,F
	 goto	disp_xit
	if t_used > 1
	decfsz	DispCounter+1,F
	 goto   disp_xit
	endif 
	movfw	DisprVector
	movwf	PCL



initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	INDF,W
	bNZ	long			; its a 1, start display
	clrC
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway

strtdis	movfw	x
	andwf	INDF,W
	skpZ	
	 goto	long
	settrap .100,msec,pause,DispCounter,DisprVector
	mred 2	;locolor port
 	goto disp_xit

long	settrap .400,msec,pause,DispCounter,DisprVector
 	mred 2   ;hicolor port
 	goto disp_xit	

pause	settrap .200,msec,rsmedis,DispCounter,DisprVector
	mblue 2	;offcolor port
 	goto disp_xit
 	
rsmedis	clrC
	rrf	x,F	;	next bit?
	bNC	strtdis	
	
	settrap .5,sec,initdis,DispCounter,DisprVector

;
;
disp_xit

	

;	anadis 2, red,red,blue
	
	movf	x,F
	skpNZ
	 goto	loop
	goto	solodis
	

batADC	
		;eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
		;dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		retlw	0
	
battery
		call	batADC
		clrf	BatAvr+1
		movfw	BatAvr
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		movfw	ADRESH
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		retlw 0		

	cblock
	 EnerLevel
	endc	
		

apbatt		
		if_	BatAvr,<,0xB8,lit8	
		 goto	apx2
apblink		 settrap	2,sec,blinkon,TimerCounter,JumpVector; <11.8V
		 return
apx2
		if_	BatAvr,<,0xB0,	lit8	
		 goto	apx3	
		 bsf	Allw_OverV		; < 12.3
		 return

apx3		if_	BatAvr,<,0x8B,	lit8	
		 goto	apx4
		 


clrmaint	macro
		 bcf	Main_Tenance
		 call	effect			; switch off if necessary	
		 endm
decener		macro
		 decf	EnerLevel,F
		 do_	PR2,=,PR2,+,1,	lit8
		 do_	CCPR1L,=,CCPR1L,+,1,lit8	;pnp  
		endm
		movf	EnerLevel,F		; <13.6V hysteresis
		i_f	STATUS,Z,then,clrmaint,elseif,decener
		return
		  
apx4		if_	BatAvr,>,0x88,	lit8	
		 return				; <13.8V hysteresis
		 
		if_bit	Allw_OverV  		; >13.8V 
		 goto	apx5
apince		bsf	Main_Tenance 
		if_	PR2,<,.19,lit8
		 goto	apblink
		incf	EnerLevel,F

		if__	LED_On,not_or_not,PWM_On
		 call	linearze

		do_	PR2,=,PR2,-,1,lit8
		do_	CCPR1L,=,CCPR1L,-,1,lit8	;pnp
		call	effect			; switch on PWM if not already		
		return 
		 
		  
apx5		if_	BatAvr,>,0x32,lit8	
		 return
		bcf	Allw_OverV 		; hold @ 13.8V
		goto	apince			; V > 14.7 
		

	
slinear	
#define	howmany	1
#define lo1	0x32		; 14.7
#define rs1	0xFF
#define hi1	0xB6
#define rs2	.20
	variable  hicount
	; 11.9V	10110110   $B6
	; 12.6  10100101   $A5
	; 13.6  10001110   $8C
	; 14.1   1000011   $43	

	if_	STACK,<=,lo1,lit8
	 goto	lors1
	if_	STACK,>=,hi1,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lo1,lit8
	eq_	STACK,=,rs1,lit8
	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (hi1-lo1)	

	else
hicount = (rs1-rs2)*.256 / (hi1-lo1)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

linearze		
		eq_	STACK,=,BatAvr,	byte
		call	slinear
		eq_	PR2,=,STACK,	byte
		do_	CCPR1L,=,STACK,-,.10,lit8	;pnp
		bsf	PWM_On
	return

	 
#define	E1	0x1000		 
	eq_	x,=,.0,	(lit8)
;;
rpt	eq_	STACK,=,x,byte

	call	slinear
	e_q 	E1,[,x,byte,]=,STACK,byte
	incfsz	x,F
	 goto rpt
	goto $		
;;	
	end