
;Software License Agreement                                         
;                                                                    
;The software supplied herewith by 
; MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)             
;(the "Company") is intended and supplied to you, the  
;Companys customer, for use solely and exclusively on a 
; Microchip Technology Incorporated   
;product. The software is owned by the Company and/or its supplier,
;and is protected under applicable copyright laws. All rights are   
;reserved. Any use in violation of the foregoing restrictions may   
;subject the user to criminal sanctions under applicable laws, as   
;well as to civil liability for the breach of the terms and         
;conditions of this license.                                        
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 
;*   GPIO output driver, which inicates the content of a register
;*   in binary form. Here a analog to digital conversion on GPIO 0     *
;*   is performed and the content of the 8bit result is displayed      *
;*   on GPIO2, suited for an open collector PNP-transistor, (high=off) *
;*                                                                     *
;*    File Version: A, this is a new file                              *
;*                                                                     *
;*    Author:       G Michael DRYGAS                                   *
;*                  Applications Engineer                              *
;*    Company:      MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)*
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683
#define TRISIOinit 	b'00111011'	; GPIO2 as OUTPUT, GPIO 0,1,3,4,5 as INPUT
#define ANSELinit 	B'01110001' 	; ADC Frc clock, AN0 as analog
#define	ADCON0init	b'00000001'	; left justified , AN0, on

	nointr683			; no interrupts code
	init683				; initiation
	cblock	_MINRAM			; start of variables
	endc
	init_andis			; initiation analog data display
	eq_	FSR,=,ADRESH,	lit8	; variable to display in indirect register

loop	bsf	ADCON0,GO		; perform A/D
	btfsc	ADCON0,GO
	 goto	$-1	
	eq_	x,=,.128, lit8
	 
solodis	
t0	if_not	INTCON,T0IF
	 goto	solodis
	bcf	INTCON,T0IF

	anadis 2, red,red,blue		; analog data display, GPIO2,
					; long=low, short=low, off=high
	movf	x,F
	skpNZ
	 goto	loop			; to avoid overwrite of ADRESH
	goto	solodis			; wait until display is over
	
	end