
;Software License Agreement                                         
;                                                                    
;The software supplied herewith by 
; MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)             
;(the "Company") is intended and supplied to you, the  
;Companys customer, for use solely and exclusively on a 
; Microchip Technology Incorporated   
;product. The software is owned by the Company and/or its supplier,
;and is protected under applicable copyright laws. All rights are   
;reserved. Any use in violation of the foregoing restrictions may   
;subject the user to criminal sanctions under applicable laws, as   
;well as to civil liability for the breach of the terms and         
;conditions of this license.                                        
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 
;*   GPIO output driver, which inicates the content of a register
;*   in binary form. Here a analog to digital conversion on GPIO 0     *
;*   is performed and the content of the 8bit result is displayed      *
;*   on GPIO2, suited for an open collector PNP-transistor, (high=off) *
;*                                                                     *
;*    File Version: A, this is a new file                              *
;*                                                                     *
;*    Author:       G Michael DRYGAS                                   *
;*                  Applications Engineer                              *
;*    Company:      MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)*
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683
#define TRISIOinit 	b'00111011'	; GPIO2 as OUTPUT, GPIO 0,1,3,4,5 as INPUT
#define ANSELinit 	B'01110001' 	; ADC Frc clock, AN0 as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on

#define PR2init		.255
#define CCPR1Linit      .10
#define CCP1CONinit	b'00001100'	; enable pwm
#define T2CONinit       b'00000100'	; switch on TMR2


	nointr683			; no interrupts code
	init683				; initiation
	cblock	_MINRAM			; start of variables
	endc

	init_andis			; initiation analog data display





	eq_	FSR,=,ADRESH,	lit8	; variable to display in indirect register

loop	bsf	ADCON0,GO		; perform A/D
	btfsc	ADCON0,GO
	 goto	$-1	



#define lin.a	(byte /8)
#define lin.b	(byte /8)
;
;
	goto linearze


#define Lo_Intensity	.255
#define Hi_Intensity	.20
	
vtable	addwf	PCL,F
	dt	2* (1+1)-1
	dt 0x32,Lo_Intensity
	dt 0xB6,Hi_Intensity


#define	STACK	_MAXRAM
#define MdB	STACK-0
#define LoB	STACK-1
#define HiB	STACK-2

#define MdD	STACK-3
#define LoD	STACK-4
#define HiD	STACK-5
  
#define	AL	ADRESH
;#define AL	x	;test
 
linearze	eq_	MdB,=,.1,	lit8
		call	vtable
		movwf	LoB
		if_	AL,>,LoB,	byte
		 goto	bases
exbdry		do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	MdD
		goto done

bases		movlw	0
		call	vtable
		movwf	MdB
		call	vtable
		movwf	HiB
		if_	AL,>=,HiB,	byte
		 goto exbdry

basesearch	do_	MdB,=,MdB,-,(1+1),lit8 
		movfw	MdB
		call	vtable
		movwf	LoB
		if_	AL,>=,LoB,	byte
		 goto 	binsearch
		eq_	HiB,=,LoB,	byte
		goto	basesearch

binsearch	do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	LoD
		do_	MdB,=,MdB,+,(1+1),	lit8
		movfw	MdB
		call	vtable
		movwf	HiD

binloop		do_	MdB,=,LoB,+,HiB,	(byte)
		rrf	MdB,F
		do_	MdD,=,LoD,+,HiD,	(byte)
		rrf	MdD,F
		
		if_	AL,>,MdB,		(byte)
		 goto	higher

		skpNZ				; AL equal MdB
		 goto	done

		eq_	HiB,=,MdB,	byte
		eq_	HiD,=, MdD,	byte
		goto	binloop
higher		eq_	LoB,=,MdB,	byte
		eq_	LoD,=,MdD,	byte
		goto	binloop

done		eq_	PR2,=,MdD,	byte	;set frequency
		;eq_	CCPR1L,=,MdD,	byte







;	eq_	x,=,.128, lit8
	 
solodis	
t0	if_not	INTCON,T0IF
	 goto	solodis
	bcf	INTCON,T0IF

	anadis 5, blue,red,black		; analog data display, GPIO2,
					; long=low, short=low, off=high
	movf	x,F
	skpNZ
	 goto	loop			; to avoid overwrite of ADRESH
	goto	solodis			; wait until display is over
	
	end