;*****************************************************************************
;*          K8076 DEMO PROGRAM  "Blinking LED"                              **
;*****************************************************************************
;*          Copyright (C)VELLEMAN NV 2006, All rights reserved              **
;*          Hardware & software by Pascal De Petter           	            **
;*****************************************************************************
;*          Hardw. Rev: P8076'1          Revision..: 1.00                   **
;*          and also  : -                BUILD data: 060213F01              **
;*          PIC Controller: PIC10F200                                       **
;*          OSC.......: Int RC 4MHZ.     POWER.....: 5V                     **
;*****************************************************************************
;*****************************************************************************
;REVISION HISTORY
;++++++++++++++++
;1.00   13/02/2006      Start of project

        IFNDEF __10F200
           MESSG "Processor-header file mismatch.  Verify selected processor."
        ENDIF

;==========================================================================
;
;       Register Definitions
;
;==========================================================================

W                            EQU     H'0000'
F                            EQU     H'0001'

;----- Register Files -----------------------------------------------------

INDF                         EQU     H'0000'
TMR0                         EQU     H'0001'
PCL                          EQU     H'0002'
STATUS                       EQU     H'0003'
FSR                          EQU     H'0004'
OSCCAL                       EQU     H'0005'
GPIO                         EQU     H'0006'
CMCON0			EQU     H'0007'	

;----- STATUS Bits --------------------------------------------------------

GPWUF                        EQU     H'0007'
NOT_TO                       EQU     H'0004'
NOT_PD                       EQU     H'0003'
Z                            EQU     H'0002'
DC                           EQU     H'0001'
C                            EQU     H'0000'

;----- OPTION Bits --------------------------------------------------------

NOT_GPWU                     EQU     H'0007'
NOT_GPPU                     EQU     H'0006'
T0CS                         EQU     H'0005'
T0SE                         EQU     H'0004'
PSA                          EQU     H'0003'
PS2                          EQU     H'0002'
PS1                          EQU     H'0001'
PS0                          EQU     H'0000'

;----- OSCCAL Bits --------------------------------------------------------

CAL6                         EQU     H'0007'
CAL5                         EQU     H'0006'
CAL4                         EQU     H'0005'
CAL3                         EQU     H'0004'
CAL2                         EQU     H'0003'
CAL1                         EQU     H'0002'
CAL0		             EQU     H'0001'
FOSC4		             EQU     H'0000'



;==========================================================================
;
;       RAM Definition
;
;==========================================================================

    __MAXRAM H'1F'
	__BADRAM H'07'-H'0F'

;==========================================================================
;
;       Configuration Bits
;
;==========================================================================

_MCLRE_ON                    EQU     H'0FFF'
_MCLRE_OFF                   EQU     H'0FEF'
_CP_ON                       EQU     H'0FF7'
_CP_OFF                      EQU     H'0FFF'
_WDT_ON                      EQU     H'0FFF'
_WDT_OFF                     EQU     H'0FFB'
_IntRC_OSC                   EQU     H'0FFF';IntRC_OSC is the only option.
                                            ;It is here for backwards compatibility
                                            ;only.



	__CONFIG        _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC    
	__IDLOCS        H'8076'         ;Set MCU ID-code.  

;==========================================================================
;
;       I/O Definition
;
;==========================================================================

SYNC	                EQU     H'00'
TRIAC_OUT               EQU     H'01'

;==========================================================================
;
;       Variable Definition
 
;
;==========================================================================

TIMER1                  EQU     H'10'   ;Timer 1, 2  Used for general delay.		
TIMER2                  EQU     H'11'   ;"      "       "          


;==> PROGRAM STARTS HERE <==
;===========================    

                 ORG	0       			;PIC's reset vector
                 MOVWF	OSCCAL              		;Calibrate the Int RC osc.
                 GOTO	START                           ;Jump to START routine when boot.


;        	*********************************
;               * Delay  routine: time is 100mS *
;               *********************************
DELAY100MS   	CLRWDT
                MOVLW   D'255'          
                MOVWF   TIMER1          
DELAY2    	MOVLW	D'130'	
	        MOVWF	TIMER2
	        DECFSZ  TIMER2,F        
                GOTO    $-1                          
		DECFSZ	TIMER1,F
		GOTO	DELAY2	
	        RETLW   0



;              *********************************************
;	       *********************************************
;              **     R E S E T & Power UP routine        **
;              **   Will be executed when boot PIC MCU    **
;              *********************************************
;              *********************************************

START           CLRWDT          			;Clear the watchdog a power up.
               	BSF		OSCCAL,FOSC4	        ;GP2 as I/O !
            	MOVLW		B'11000110'	        ;->Config PIC options 
	        OPTION	   		                ; - 1 Disable wake Up
                                           	        ; - 0 Enable weak pull-ups
                                                	; - 0 TMR0 = Fosc/4  
                                                	; - 0 TMR0 increment from Low2high.
                                                	; - 0 Prescaler assign to TMR0.
                                                	; - 111 Prescaler rate = 1/256.       
 		MOVLw	B'11110001'
		MOVWF	CMCON0       
    	        MOVLW	B'11111100'			; GP0 & GP1 are outputs.
	        TRIS	GPIO			        ; bit 4-7 => Don't care.
                CLRF    GPIO				; Clear All output's.



		;Blink loop code start's here. 
		;-----------------------------               

LOOP		MOVLW	B'0010'				;Set +5V to GP1 (LD3 on K8076)
		MOVWF	GPIO			
		CALL	DELAY100MS			;Wait for 100mS
		CLRF	GPIO				;Clear the LED
		CALL	DELAY100MS			;Wait again 100mS
		;
		MOVLW	B'0001'				;Set +5V to GP0 (LD2 on K8076)
		MOVWF	GPIO
		CALL	DELAY100MS			;Wait for 100mS
		CLRF	GPIO				;Clear the LED
		CALL	DELAY100MS			;and wait again for 100mS
		GOTO	LOOP				;Do forever this loop....

                END                          		;End of source code.


 
