;***********************************************************************
;*   This file is the firmware to implement a                          *
;*                                                                     *
;*    binary display of a register as low (0) and                      *
;*                                    high (1) 17microseconds pulses   *
;*                       starting with a 17 microsecond low pulse      *
;*                       ending in a high                              *
;*   at a output GPIO port = asynchronous byte of 57600 baud           *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G MICHAEL DRYGAS                                   *
;*                                    				       *
;*    Company:    MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)*
;*                 reg DE                                             *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F222	; list directive to define processor
	#include  macros3b.asm
	config222
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************


	cblock _MINRAM
	 SystemStatus,TimerVector,TimeCounter:2
	 x	 

	endc

#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define GPIOinit	b'00000110'	; all OUTPUT initiate as HIGH
#define TRISIOinit	b'11111001'	; configure GP1,2 as output 
#define	OPTIONinit	b'11000001'	; no wakup, no pullup, Clock 1:4
#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable



black2	macro
	movlw	TRISIOinit | b'00000100'	; port 2 input = black
	TRIS	TRISGPIO
	endm
red2	macro
	bcf	GPIO,2
	movlw	TRISIOinit & b'11111011'	; port 2 output,LOW = red
	TRIS	TRISGPIO
	endm
blue2	macro
	bsf	GPIO,2
	movlw	TRISIOinit & b'11111011'	; port 2 output,HIGH = blue
	TRIS	TRISGPIO
	endm
	

	init2xx	
	goto	MAIN

zerocall retlw	0				


	
MAIN	
;	
;cycle	black2
;	settrap206B .6,sec,ADC,TimeCounter,TimerVector
;
;
;ploop	if_bit	TMR0,7			; software emulation of
;	 goto	set7			; timer 0 overflow
;	if_not	TMR07Bit		;
;	 goto	clred
;	bcf	TMR07Bit		; timer 0 has overflown within
;	decfsz	TimeCounter,F		;	127 timerticks
;	 goto	clred
;	decfsz	TimeCounter+1,F
;	 goto    clred			
;	 
;	movfw	TimerVector		; timer trap has sprung
;	movwf	PCL			; jump to destination
;
;set7	bsf	TMR07Bit
;
;
;clred					; timer loop
;	goto	ploop			; code max for 127 timerticks
;
;


	eq_	FSR,=,ADRES,lit8

	setC
	clrf	x

delay	macro	Cycles
 variable CyclesLeft ,LoopCycles           ;  Keep Track of Remaining Cycle
CyclesLeft = Cycles
  if Cycles >=5
LoopCycles = ((Cycles-2) /3)*3
  movlw   LoopCycles/3
  movwf   STACK-0
  decfsz  STACK-0,F
   goto	$-1
CyclesLeft = CyclesLeft - 1 - LoopCycles
  endif

 while CyclesLeft >= 2          ;  Put in 2 Instruction Cycle Delays
  goto    $ + 1
CyclesLeft = CyclesLeft - 2
 endw
 if CyclesLeft == 1             ;  Put in the Last Required Cycle
  nop
 endif
        endm

ADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1


#define port 1
baudnextbit	
		
	movfw	GPIO
	movwf	STACK
	movfw	x
	andwf	INDF,W
	skpZ			;or load GPIO,and mask,ior mask, save
	 bsf	STACK,port
	skpNZ
	 bcf	STACK,port
	movfw	STACK
	movwf	GPIO			; electrical change occurs now

	btfss	x,3			; adjust timing 57600baud = 17.36us
	 goto	noextradelay			; call	zerocall
	goto	$+1			; bit 3 is 3 cycles longer
	goto	$+1
noextradelay
;#define	looptime .17
;	delay 	.26-looptime		; delay to adjust for other baud rates
	
	rlf	x,F
	skpC	
	 goto   baudnextbit
	delay	.17-.6			; last data bit

	bsf	GPIO,port			; start of stop bit
#define	overhead	.13
	delay	.17-overhead	
	goto	ADC

waitforstartbit
	clrwdt
	btfsc	GPIO,port
	 goto	$-2			;loop until start bit
					; interrrupt necessary if rt os
	
	eq_	x,=,8,lit8
#define looptime	.7
	delay	looptime+ (.17/2) 		; 0.5 bits +2
	
receiveloop
	delay	.10;.17-looptime		; 1 bit @ 57600 baud
	clrC
	btfsc	GPIO,port
	 setC
	rlf	INDF,F
	decfsz	x,F
	 goto	receiveloop
	goto	waitforstartbit
;
;	eq_	x,=,b'10000000', lit8	; bit 7
;
;frstbit	movfw	x			; omit leading zeros
;	andwf	AL,W
;	bC	strtdis			; its a 1, start display
;	rrf	x,F
;	skpC				; underflow ?
;	 goto	frstbit
;	rlf	x,F			; send bit 0 anyway
;	
;strtdis	movfw	x
;	andwf	AL,W
;	skpNC	
;	 goto	long
;	settrap206B .200,msec,pause,TimeCounter,TimerVector
;	red2
; 	goto ploop
;long	settrap206B .800,msec,pause,TimeCounter,TimerVector
; 	blue2
; 	goto ploop	
;
;pause	settrap206B .200,msec,rsmedis,TimeCounter,TimerVector
;	black2
; 	goto ploop
; 	
;rsmedis	rrf	x,F	;	next bit?
;	bC	cycle	;	done, wait for next measurement
;	goto	strtdis	
;
	
	

	end