
;***********************************************************************
;* This file is the firmware to implement a 
;                           *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=16F627	; list directive to define processor
	#include  macros3c.asm
	config627
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	cblock _MINRAM
	 ChaR,x,xChaR,CgraM,DdraM
	endc
#define	E1	0x1000
;#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define Lo_Intensity	.8
#define Hi_Intensity	.28


;#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISAinit	b'00100011'	; configure 0,1,3,4,5 as       INPUT 
#define TRISBinit 	b'11000000'
#define	OPTIONinit	b'11000000'	; no wakeup, no pullup, clock 1:2
#define PR2init		.100		;.40
#define CCPR1Linit      .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

#define	LcdCntl_RS	PORTA,2 
#define LcdCntl_RW	PORTA,3
#define LcdCntl_E	PORTA,4
#define Lcd_Bit7	PORTA,7
#define Lcd_Bit6	PORTA,6

#define Input_1wire	PORTA,1

	nointr683

	init627
	goto	MAIN


busycheck
	eq_	TRISB,=,b'11111111',lit8
	eq_	TRISA,=,b'11100011',lit8
busyloop
	bcf	LcdCntl_RS
	bsf	LcdCntl_RW
	bsf	LcdCntl_E
	bcf	LcdCntl_E
	btfsc	Lcd_Bit7
	 goto	busyloop
	eq_	TRISB,=,b'11000000',lit8
	eq_	TRISA,=,b'00100011',lit8
	return
	
sendchar
	movwf	ChaR
	call	busycheck
	eq_	PORTB,=,ChaR,byte
	mov_bit	ChaR,7,Lcd_Bit7
	mov_bit	ChaR,6,Lcd_Bit6
		
	bcf	LcdCntl_RW
	bsf	LcdCntl_RS
	
	bsf	LcdCntl_E
	bcf	LcdCntl_E
	return
sendcmd
	movwf	ChaR
	call	busycheck

sendcmdchar
	eq_	PORTB,=,ChaR,byte
	mov_bit	ChaR,7,Lcd_Bit7
	mov_bit	ChaR,6,Lcd_Bit6
		
	bcf	LcdCntl_RW
	bcf	LcdCntl_RS
	
	bsf	LcdCntl_E
	bcf	LcdCntl_E
	return
	
DISP_ON 	EQU b'00001111'   ; Display on cursor on blinkin on	
CLR_DISP 	EQU b'00000001'
ENTRY_INC 	EQU b'00000110' ; increase not shifted
DD_RAM_ADDR 	EQU b'10000000'; adress 1st line
CG_RAM_ADDR 	EQU b'01000000'; adress 1st row
SET_FUNC   	EQU b'00111000'; 8 bit interface, 2 lines, 5x7
	
initdisplay
	dlay	.15000

;	bsf	Lcd_Bit7
;	dlay	.300000
;	bcf	Lcd_Bit7
;	dlay 	.300000
;	goto    initdisplay
;
	eq_	ChaR,=,SET_FUNC,lit8
	call	sendcmdchar
	dlay	.4100
	call	sendcmdchar
	delay	.100
	call	sendcmdchar
	delay	.42
	call	sendcmdchar
	
;
;	movfw	ChaR
;	call	sendcmd
;	
	movlw	DISP_ON
	call	sendcmd
	movlw	CLR_DISP
	call	sendcmd
	movlw	ENTRY_INC
	call	sendcmd
	return
	
	
	


afterwdt 








;t_used = 2
;getchar
;	incf	x,F
;	movlw	0x0f
;	andwf	x,W
;	addwf	PCL,F
;	dt	"Hello World12345"

hexchar andlw	0x0F
	addwf	PCL,F
	dt	"0123456789ABCDEF"

outchar	swapf	xChaR,W
	call	hexchar
	call	sendchar
	movfw	xChaR
	call	hexchar
	call	sendchar
	return

MAIN		

	call	initdisplay

	eq_	DdraM,=,DD_RAM_ADDR,	lit8

sendloop 
	if_not	Input_1wire		; wait for input high
	 goto	$-1
	eq_	xChaR,=,0x80,lit8
	if_bit	Input_1wire		; wait for input low
	 goto	$-1

#define	necesscycles	.8
	delay	.25-.17+necesscycles
nextbit
	delay	.17-necesscycles
	rrf	xChaR,F
	mov_bit Input_1wire, xChaR,7

	bnc	nextbit

	call	outchar
;
	do_	DdraM,=,DdraM,+,3,	lit8	   ; row += 3
	movlw	b'00111111'
	andwf	DdraM,W
	sublw	.12
	if_C	
	 goto	setddram
	do_	DdraM,=,DdraM,XOR,0x40,	lit8
	do_	DdraM,=,DdraM,AND,b'11000000',lit8 ;next line row 1
setddram	
	movfw	DdraM
	call	sendcmd
	
	goto	sendloop

	

	end