
;***********************************************************************
;* This file is the firmware to implement a 
;                           *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=16F627	; list directive to define processor
	#include  macros3c.asm
	config627
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	cblock _MINRAM
	 ChaR,x
	endc
#define	E1	0x1000
;#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define Lo_Intensity	.8
#define Hi_Intensity	.28


;#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISAinit	b'00100011'	; configure 0,1,3,4,5 as       INPUT 
#define TRISBinit 	b'11000000'
#define	OPTIONinit	b'11000000'	; no wakeup, no pullup, clock 1:2
#define PR2init		.100		;.40
#define CCPR1Linit      .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

#define	LcdCntl_RS	PORTA,2 
#define LcdCntl_RW	PORTA,3
#define LcdCntl_E	PORTA,4
#define Lcd_Bit7	PORTA,7
#define Lcd_Bit6	PORTA,6

	nointr683

	init627
	goto	MAIN


busycheck
	eq_	TRISB,=,b'11111111',lit8
	eq_	TRISA,=,b'11100011',lit8
busyloop
	bcf	LcdCntl_RS
	bsf	LcdCntl_RW
	bsf	LcdCntl_E
	bcf	LcdCntl_E
	btfsc	Lcd_Bit7
	 goto	busyloop
	eq_	TRISB,=,b'11000000',lit8
	eq_	TRISA,=,b'00100011',lit8
	return
	
sendchar
	movwf	ChaR
	call	busycheck
	eq_	PORTB,=,ChaR,byte
	mov_bit	ChaR,7,Lcd_Bit7
	mov_bit	ChaR,6,Lcd_Bit6
		
	bcf	LcdCntl_RW
	bsf	LcdCntl_RS
	
	bsf	LcdCntl_E
	bcf	LcdCntl_E
	return
sendcmd
	movwf	ChaR
	call	busycheck

sendcmdchar
	eq_	PORTB,=,ChaR,byte
	mov_bit	ChaR,7,Lcd_Bit7
	mov_bit	ChaR,6,Lcd_Bit6
		
	bcf	LcdCntl_RW
	bcf	LcdCntl_RS
	
	bsf	LcdCntl_E
	bcf	LcdCntl_E
	return
	
DISP_ON 	EQU b'00001111'   ; Display on cursor on blinkin on	
CLR_DISP 	EQU b'00000001'
ENTRY_INC 	EQU b'00000110' ; increase not shifted
DD_RAM_ADDR 	EQU b'10000000'; adress 1st line
SET_FUNC   	EQU b'00111000'; 8 bit interface, 2 lines, 5x7
	
initdisplay
	dlay	.15000

;	bsf	Lcd_Bit7
;	dlay	.300000
;	bcf	Lcd_Bit7
;	dlay 	.300000
;	goto    initdisplay
;
	eq_	ChaR,=,SET_FUNC,lit8
	call	sendcmdchar
	dlay	.4100
	call	sendcmdchar
	delay	.100
	call	sendcmdchar
	delay	.42
	call	sendcmdchar
	
;
;	movfw	ChaR
;	call	sendcmd
;	
	movlw	DISP_ON
	call	sendcmd
	movlw	CLR_DISP
	call	sendcmd
	movlw	ENTRY_INC
	call	sendcmd
	movlw	DD_RAM_ADDR+0
	call	sendcmd
	return
	
	
	
	
	
	 
slinear0	
#define	howmany	1
#define lowBoundary	0x20	;
#define rs1		0x01
#define highBoundary	0xE0	;
#define rs2		0xFF
	variable  hicount



	if_	STACK,<=,lowBoundary,lit8
	 goto	lors1
	if_	STACK,>=,highBoundary,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lowBoundary,lit8
	eq_	STACK,=,rs1,lit8

	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (highBoundary-lowBoundary)	

	else
hicount = (rs1-rs2)*.256 / (highBoundary-lowBoundary)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

slinear1	
;#define	howmany	1
;#define lowBoundary	0x20	;
#define rs11		0x01
;#define highBoundary	0xE0	;
#define rs12		0x20
;	variable  hicount



	if_	STACK,<=,lowBoundary,lit8
	 goto	lors11
	if_	STACK,>=,highBoundary,lit8
	 goto	hirs12
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lowBoundary,lit8
	eq_	STACK,=,rs11,lit8

	if	(rs12-rs11) >0
hicount = (rs12-rs11)*.256 / (highBoundary-lowBoundary)	

	else
hicount = (rs11-rs12)*.256 / (highBoundary-lowBoundary)
	endif
	 movlw	hicount	& 0xFF	

ad1loop
	while	(hicount >> 8) > 0
	 if	rs12-rs11 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs12-rs11 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto ad1loop 
	return
lors11	eq_	STACK,=,rs11,lit8
	return
hirs12	 eq_	STACK,=,rs12,lit8
	return
	
#define	NFET_Gate_Port	GPIO,2


afterwdt 








t_used = 2
getchar
	incf	x,F
	movlw	0x0f
	andwf	x,W
	addwf	PCL,F
	dt	"Hello World12345"

MAIN	

	call	initdisplay
sendloop	
	call	getchar
	call	sendchar
	dlay	.300000

	 goto	sendloop
	
	end