
;Software License Agreement                                         
;                                                                    
;The software supplied herewith by 
;MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)             
;(the "Company") is intended and supplied to you, the  
;Companys customer, for use solely and exclusively on Microchip Incorporated    
;products. The software is owned by the Company and/or its supplier,
;and is protected under applicable copyright laws. All rights are   
;reserved. Any use in violation of the foregoing restrictions may   
;subject the user to criminal sanctions under applicable laws, as   
;well as to civil liability for the breach of the terms and         
;conditions of this license.                                        
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************
;      macros
;	for  10F200/2/4/6 10F220/2
;	     12F629/675
;	     12F683
;
;	config200 config202 config204 config206 config220 config222
;	init2xx
;	
;	config629
;	config675
;	init629			works as well for 675
;
;	config683
;       nointr683
;	init683
;
;
;	mov_w			move any register (banked or eeprom) into W
;	mov_f			move W into any register (banked or eeprom) 
;	mov			move any register (banked or eeprom) into
; 				  any register (banked or eeprom)
;	mov_ Source,Target,Bits	
;				move multiple register (banked or eeprom) into
; 				  any register (banked or eeprom)
;			   Bits: byte 8bits ; word 16bits; wordbyte 24bits; longint 32bits
;
;
;	eq_   Target,=,Value, Bits
;
;
;	
;	do_	Target,=,Variable,[+ - * / & | ^],VarorConstant, bits
;				  [plus, minus, times, divided_by, AND, OR, XOR]
;
;	if_ 	Variable, bit, is_on ({true},{1}),	1 {singlebit}
;	if_	Variable,[ > < >= <= == !=],VarorConstant, bits
;	  1 executable instruction 
;
;	if_m	Variable,[ > < >= <= == !=],VarorConstant, bits
;	  many executable instructions
;	{else_m}
;	  many executable intructions
;	end_m
; 
;	if__		
;          1 executable instruction
;	if__m	
;	  many executable intructions
;	end_m
;
;	mov_bit
;
;	inv_bit
;
;
;
;	
;	settrap206		timer0 trap
;	settrap683
;

;
;	ADCON206 port		returns STACK-1:2
;	initSTACK
;	push
;	pop


	ERRORLEVEL -302				; Get rid of banking messages...


#define Bank0		0x00
#define	Bank1		0x80
#define DUMMY 0xFFFE
	variable	used_EEPROM = 0
	variable	changeOPTION = 0
	variable	elabcount = 0
	variable        ilabcount = 0
	variable	level = 0
	variable        maxlevel = 0
;	variable	elselevel = 0
;	variable        elsemaxlevel = 0
	variable	elseflag0 = 0
	variable	elseflag1 = 0
	variable	elseflag2 = 0
	variable	ifflag0 = 0
	variable	ifflag1 = 0
	variable	ifflag2 = 0

initSTACK macro	STACKposition		; STACK at the end of variables
	       movlw	STACKposition
	       movwf	FSR
	  endm

push	macro
	movwf	INDF
	decf	FSR,F
	endm
pop	macro
	movfw	INDF
	incf	FSR,F
	endm	


	
;**********************
config200	macro
	
	#include <p10f200.inc>	; processor specific variable definitions
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without watchdog timer
	#define	_MINRAM H'10'
	#define _MAXRAM H'1F'
	#define TRISGPIO 	6
		endm
config202	macro
	
	#include <p10f202.inc>	; processor specific variable definitions
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without watchdog timer
	#define	_MINRAM H'08'
	#define _MAXRAM H'1F'
	#define TRISGPIO 	6
		endm

config204	macro
	
	#include <p10f204.inc>	; processor specific variable definitions
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without WDT
#define TRISGPIO 	6		; 10F200family speciality
#define GP1_Porton	b'01110001'     ; configure comparator input=on, int ref, GP1
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0
	#define	_MINRAM H'10'
	#define _MAXRAM H'1F'
		endm
	

config206	macro
	
	#include <p10f206.inc>	; processor specific variable definitions

	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
		;bit 11-5 Unimplemented: Read as 0
		;bit 4 MCLRE: GP3/MCLR Pin Function Select bit
		;1 = GP3/MCLR pin function is MCLR
		;0 = GP3/MCLR pin function is digital I/O, MCLR internally tied to VDD
		;bit 3 CP: Code Protection bit
		;1 = Code protection off
		;0 = Code protection on
		;bit 2 WDTE: Watchdog Timer Enable bit
		;1 = WDT enabled
		;0 = WDT disabled
		;bit 1-0 Reserved: Read as 0
		;2: INTRC is the only oscillator mode offered on the PIC10F200/202/204/206
#define TRISGPIO 	6		; 10F200family speciality
#define GP1_Porton	b'01110001'     ; configure comparator input=on, int ref, GP1
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0
	#define	_MINRAM H'08'
	#define _MAXRAM H'1F'

		endm





config206B	macro
	
	#include <p10f206.inc>	; processor specific variable definitions

	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC   ; with WATCHDOG TIMER
	#define TRISGPIO 	6		; 10F200family speciality
	#define GP1_Porton	b'01110001'     ; configure comparator input=on
	#define GP0_Porton	b'01110011'     ; config comparator input=on, int ref, GP0
	#define	_MINRAM H'08'
	#define _MAXRAM H'1F'
	
		endm

config220	macro
	
	#include <p10f220.inc>	; processor specific variable definitions

	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _MCPU_OFF & _IOSCFS_4MHZ
		#define TRISGPIO 	6		; 10F200family speciality
	#define	_MINRAM H'10'
	#define	_MAXRAM H'1F'
	
		endm


config222	macro
	
	#include <p10f222.inc>	; processor specific variable definitions

	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _MCPU_OFF & _IOSCFS_4MHZ

		; switch _OFF by _ON and 4 by 8
	
		;
		;MCLRE CP WDTE MCPU IOSCFS
		;
		;bit 4 MCLRE: GP3/MCLR Pin Function Select bit
		;1 = GP3/MCLR pin function is MCLR
		;0 = GP3/MCLR pin function is digital I/O, MCLR internally tied to VDD
		;bit 3 CP: Code Protection bit
		;1 = Code protection off
		;0 = Code protection on
		;bit 2 WDTE: Watchdog Timer Enable bit
		;1 = WDT enabled
		;0 = WDT disabled
		;bit 1 MCPU: Master Clear Pull-up Enable bit(2)
		;1 = Pull-up disabled
		;0 = Pull-up enabled
		;bit 0 IOSCFS: Internal Oscillator Frequency Select bit
		;1 = 8 MHz
		;0 = 4 MHz
	

	#define TRISGPIO 	6		; 10F200family speciality
	#define	_MINRAM H'09'
	#define	_MAXRAM H'1F'
	
		endm



init2xx		macro
		ORG     0x000           ; start coding 
		btfsc	STATUS,NOT_PD	; Test for the first power up
		 goto	PWRUP
		goto	RESET

undoreset 		
			IFDEF	shdwTRISIO			
 			 movfw	shdwTRISIO
			else
			 IFDEF	TRISIOinit	;		
 			  movlw	TRISIOinit	;
			 else
			  movlw	b'00001011'; 01,3 =input 2=output
			 endif
			endif
			TRIS 	TRISGPIO
	
			IFDEF	shdwOPTION			
 			 movfw	shdwOPTION
			ELSE
			 ifdef	OPTIONinit
			  movlw	OPTIONinit
			 else
			  movlw	B'11001000'	
				; PIN wakeup disabled, weak pullup disabled
				; Timer0 internal clock, clock 1:1 (4ms), WDT 1:1 
			 endif
			ENDIF 
			OPTION	
			;bit 7 GPWU: Enable Wake-up on Pin Change bit (GP0, GP1, GP3)
			;1 = Disabled
			;0 = Enabled
			;bit 6 GPPU: Enable Weak Pull-ups bit (GP0, GP1, GP3)
			;1 = Disabled
			;0 = Enabled
			;bit 5 T0CS: Timer0 Clock Source Select bit
			;1 = Transition on T0CKI pin (overrides TRIS on the T0CKI pin)
			;0 = Transition on internal instruction cycle clock, FOSC/4
			;bit 4 T0SE: Timer0 Source Edge Select bit
			;1 = Increment on high-to-low transition on the T0CKI pin
			;0 = Increment on low-to-high transition on the T0CKI pin
			;bit 3 PSA: Prescaler Assignment bit
			;1 = Prescaler assigned to the WDT
			;0 = Prescaler assigned to Timer0
			;bit 2-0 PS<2:0>: Prescaler Rate Select bits
			;Bit Value	Timer0 Rate 	WDT Rate
			;000		1 : 2		1 : 1
			;001		1 : 4		1:2
			;010		1:8		1:4
			;011		1:16		1:8
			;100		1:32		1:16
			;101		1:64		1:32
			;110		1:128		1:64
			;111		1:256		1:128
				

	retlw	0


	
RESET	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	;GOTO	PWRUP		; goto error

PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 


	IFDEF	GPIOinit
	 movlw	GPIOinit	
	ELSE	
	 movlw	b'00000000'	; set portS to LOW
	ENDIF  
	movwf	GPIO
	
	
	IFDEF	shdwTRISIO			
 	 movlw	TRISIOinit	;    IOdir
	 movwf	shdwTRISIO
	ENDIF
		
	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	 ifdef	CMCON0init			
 	  movlw	CMCON0init
	 else
	  movlw	b'01110111'     ; configure comparator off and inputs as digital I/O
	 endif
	movwf	CMCON0		; for PIC10F204
			;REGISTER 8-1: CMCON0 REGISTER
			;R-1    R/W-1  R/W-1 R/W-1   R/W-1 R/W-1 R/W-1 R/W-1
			;CMPOUT COUTEN POL   CMPT0CS CMPON CNREF CPREF CWU
			;bit 7                                         bit 0

			;bit 7 CMPOUT: Comparator Output bit
			;1 = VIN+ > VIN-
			;0 = VIN+ < VINbit
			;6 COUTEN: Comparator Output Enable bit(1, 2)
			;1 = Output of comparator is NOT placed on the COUT pin
			;0 = Output of comparator is placed in the COUT pin
			;bit 5 POL: Comparator Output Polarity bit(2)
			;1 = Output of comparator not inverted
			;0 = Output of comparator inverted
			;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
			;1 = TMR0 clock source selected by T0CS control bit
			;0 = Comparator output used as TMR0 clock source
			;bit 3 CMPON: Comparator Enable bit
			;1 = Comparator is on
			;0 = Comparator is off
			;bit 2 CNREF: Comparator Negative Reference Select bit(2)
			;1 = CIN- pin(3)
			;0 = Internal voltage reference
			;bit 1 CPREF: Comparator Positive Reference Select bit(2)
			;1 = CIN+ pin(3)
			;0 = CIN- pin(3)
			;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
			;1 = Wake-up on comparator change is disabled
			;0 = Wake-up on comparator change is enabled.
			;Note 1: Overrides T0CS bit for TRIS control of GP2.
			;2: When the comparator is turned on, these control bits 
			; assert themselves. When the comparator is off, these
			;bits have no effect on the device operation and the other 
			;control registers have precedence.
			;3: PIC10F204/206 only.d	
	ENDIF	
	
	IFDEF __10F206	
	 ifdef	CMCON0init			
 	  movlw	CMCON0init
	 else
	  movlw	b'01110111'     ; configure comparator off and inputs as digital I/O
	 endif

	 movwf	CMCON0		; for PIC10F206
	ENDIF

	IFDEF __10F222	
	 ifdef	ADCON0init			
 	  movlw	ADCON0init
	 else
	  movlw	b'00001100'     ; configure AD inputs as digital I/O
	 endif

	movwf	ADCON0		; for PIC10F222
			;	REGISTER 7-1: ADCON0: A/D CONVERTER 0 REGISTER
			;R/W-1 R/W-1 U-0 U-0 R/W-1 R/W-1 R/W-0   R/W-0
			;ANS1  ANS0         CHS1 CHS0  GO/DONE ADON
			;bit 7                                 bit 0
			;
			;bit 7 ANS1: ADC Analog Input Pin Select bit
			;1 = GP1/AN1 configured for analog input
			;0 = GP1/AN1 configured as digital I/O
			;bit 6 ANS0: ADC Analog Input Pin Select bit(1), (2)
			;1 = GP0/AN0 configured as an analog input
			;0 = GP0/AN0 configured as digital I/O
			;bit 5-4 Unimplemented: Read as 0
			;bit 3-2 CHS<1:0>: ADC Channel Select bits(3)
			;00 = Channel 00 (GP0/AN0)
			;01 = Channel 01 (GP1/AN1)
			;1X = 0.6V absolute Voltage reference
			;bit 1 GO/DONE: ADC Conversion Status bit(4)
			;1 = ADC conversion in progress. Setting this bit starts an 
			;    ADC conversion cycle. This bit is automatically cleared
			;    by hardware when the ADC is done converting.
			;0 = ADC conversion completed/not in progress. Manually clearing 
			;    this bit while a conversion is in process
			;    terminates the current conversion.
			;bit 0 ADON: ADC Enable bit
			;1 = ADC module is operating
			;0 = ADC module is shut-off and consumes no power
			;Note 1: When the ANS bits are set, the channel(s) selected 
			; are automatically forced into analog mode regardless of the pin
			;function previously defined.
			;2: The ANS<1:0> bits are active regardless of the condition of ADON
			;3: CHS<1:0> bits default to 11 after any Reset.
			;4: If the ADON bit is clear, the GO/DONE bit cannot be set.
	ENDIF
	
	IFDEF __10F220	
	 ifdef	ADCON0init			
 	  movlw	ADCON0init
	 else
	  movlw	b'00001100'     ; configure AD inputs as digital I/O
	 endif

	 movwf	ADCON0		; for PIC10F220
	ENDIF


	
afterpin			; these labels should be relocated if sleep
;afterwdt			; or WDT is used
	endm


init206		macro
	error "init206 no longer in use init2xx instead"
;		ORG     0x000           ; start coding 
;		btfsc	STATUS,NOT_PD	; Test for the first power up
;		 goto	PWRUP
;		goto	RESET
;
;undoreset 		
;			IFDEF	shdwTRISIO			
; 			 movfw	shdwTRISIO
;			else
;			IFDEF	TRISIOinit	;IOdir			
; 			 movlw	TRISIOinit	;IOdir
;			else
;			 movlw	b'00001011'; 01,3 =input 2=output
;			endif
;			endif
;			TRIS 	TRISGPIO
;	
;			IFDEF	OPTIONinit
;			 movlw	OPTIONinit
;			else
;			 movlw	B'11000011'	
;				; PIN wakeup disabled, weak pullup disabled
;				; Timer0 internal clock, clock 1:16 (4ms), WDT 1:1 
;			endif
;			;bit 7 GPWU: Enable Wake-up on Pin Change bit (GP0, GP1, GP3)
;			;1 = Disabled
;			;0 = Enabled
;			;bit 6 GPPU: Enable Weak Pull-ups bit (GP0, GP1, GP3)
;			;1 = Disabled
;			;0 = Enabled
;			;bit 5 T0CS: Timer0 Clock Source Select bit
;			;1 = Transition on T0CKI pin (overrides TRIS on the T0CKI pin)
;			;0 = Transition on internal instruction cycle clock, FOSC/4
;			;bit 4 T0SE: Timer0 Source Edge Select bit
;			;1 = Increment on high-to-low transition on the T0CKI pin
;			;0 = Increment on low-to-high transition on the T0CKI pin
;			;bit 3 PSA: Prescaler Assignment bit
;			;1 = Prescaler assigned to the WDT
;			;0 = Prescaler assigned to Timer0
;			;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;			;Bit Value	Timer0 Rate 	WDT Rate
;			;000		1 : 2		1 : 1
;			;001		1 : 4		1:2
;			;010		1:8		1:4
;			;011		1:16		1:8
;			;100		1:32		1:16
;			;101		1:64		1:32
;			;110		1:128		1:64
;			;111		1:256		1:128
;				
;	OPTION	
;	retlw	0
;
;
;	
;RESET	call	undoreset
;	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
;	 goto	afterpin
;
;	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
;	 goto	afterwdt
;	
;	;GOTO	PWRUP		; goto error
;
;PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
;	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
;	movwf   OSCCAL          ; update register with factory cal value 
;
;
;	IFDEF	GPIOinit
;	 movlw	GPIOinit	
;	else	
;	 movlw	b'00000000'	; set portS to LOW
;	ENDIF  
;	movwf	GPIO
;	IFDEF	shdwTRISIO			
; 	 movlw	TRISIOinit;    IOdir
;	 movwf	shdwTRISIO
;	endif	
;	call	undoreset	; TRIS + OPTION
;
;	IFDEF __10F204	
;	IFDEF	CMCON0init			
; 	 movlw	CMCON0init
;	else
;	movlw	b'01110111'     ; configure comparator inputs as digital I/O
;	endif
;	movwf	CMCON0		; for PIC10F204
;	endif	
;	IFDEF __10F206	
;	IFDEF	CMCON0init			
; 	 movlw	CMCON0init
;	else
;	movlw	b'01110111'     ; configure comparator inputs as digital I/O
;	endif
;
;	movwf	CMCON0		; for PIC10F206
;	endif
;
;	IFDEF __10F222	
;	IFDEF	ADCON0init			
; 	 movlw	ADCON0init
;	else
;	movlw	b'00001100'     ; configure AD inputs as digital I/O
;	endif
;
;	movwf	ADCON0		; for PIC10F222
;	endif
;
;
;	
;afterpin
;;afterwdt
	endm
;



#define	usec	1
#define	msec	2
#define	sec	3


;
settrap206	macro	time,unit,vector ;,MaxTmr,TmrVector
;		;	uses one byte counter
;		;	changes OPTION, if not fitting
;		variable	optn,mxtmr,intime,k,changeoption
error "settrap206 no longer in use settrap instead, dont forget to set t_used variable"
;k=1
;	if unit == msec
;k=.1000
;	endif
;	if unit == sec
;k=.1000000
;	endif
;
;optn = 0		; prescale > 1 ?
;
;
;	IFDEF	OPTIONinit
;	 if ! (OPTIONinit & b'00001000')
;optn = 1 + (OPTIONinit & b'00000111')
;	 endif
; 	ENDIF
;mxtmr= time * k /.256 / (2 <<optn) 
;intime = time *k / (2 << optn)
;
;	while	mxtmr > .255	; increase prescaler until only 1 byte needed
;optn += 1
;mxtmr = mxtmr / 2
;intime = intime /2
;changeOPTION = 1		; global variable = OPTION changed
;	endw
;
;	if optn > .7
;	 error "Required Delay needs settrap206B (two byte option) !!"	 
;	else
;
;optn = (OPTIONinit & b'11110000') + optn
;
;	if changeOPTION		; done it once, do it always
;	movlw	optn
;	OPTION
;	endif
;
;	movlw	mxtmr+1
;	movwf	MaxTmr
;	movlw	0x00FF - (intime & 0xFF)
;	movwf	TMR0
;	mov_bit TMR0,7,TMR7bit
;	movlw	vector 
;	movwf	TmrVector
;	endif
;
	endm
;
settrap206B	macro	time,unit,vector,MaxTmr,TmrVector
;				; works for 12F6xx just as well
;
;		  variable	optn,mxtmr,intime,k, clow,chigh,chi2
error "settrap206B no longer in use settrap instead, dont forget to set t_used variable"
;k=1
;	if unit == msec
;k=.1000
;	endif
;	if unit == sec
;k=.1000000
;	endif
;
;
;optn = 0		; prescale > 1 ?
;
;	IFDEF	OPTIONinit
;	 if ! (OPTIONinit & b'00001000')
;optn = 1 + (OPTIONinit & b'00000111')
;	 endif
; 	ENDIF
;intime = time *k / (1 << optn)
;					; intime = intime + 65336
;clow =	intime	& 0xFF
;chigh=  (intime >> 8) &0xFF
;chi2  =  intime >> .16
;
;	if chi2 > .255
;	 
;	 error "Required Delay needs higher clock prescaler !!"	 
;	 
;	else
;
;	if	clow != 0
;chigh+=1
;	 if	chigh == .256
;chi2 +=1
;chigh==0
;	 endif
;	endif
;	if chigh !=0
;chi2 +=1
;	endif
;	if chi2 < 5
;	movlw	chigh
;	movwf	MaxTmr
;	endif
;	movlw	chi2
;	movwf	MaxTmr+1
;	endif
;	
;	
;	movlw	vector 
;	movwf	TmrVector
; 
;
	endm
;
;

	variable t_used = 0 

settrap	macro	time,unit,jumpto,MaxTmr,JVector
		  variable	optn,intime,k,clow,chigh,chi2,chi3,dus,tlab
		  
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif


	IFDEF	__12F683
				; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
	 IFDEF	OSCONinit
optn =	OSCONinit & b'01110000'
	 ELSE
optn =	b'01100001'
	 ENDIF

optn = optn >> 4
	
	 if	optn == 0
dus = 65
	 else
dus = 1<<(7-optn)
	 endif
	ELSE
dus = 2				; every other processor runs at 2 half microseconds (1MHz)
	ENDIF
	
	
optn = 0
 	IFDEF	OPTIONinit	
	 if ! (OPTIONinit & b'00001000')
optn = 1 + (OPTIONinit & b'00000111')
	endif	
	ENDIF
; OSCONinit * OPTIONinit

dus = dus << optn		; prescale from OSCON in half (0.5) microseconds 

	if unit == sec
k = k / dus 
intime = time *k * 2 	; number of timer ticks required
	else
intime = time * k / dus * 2
	endif			
clow =	intime	& 0xFF
chigh=  (intime >> 8) 
	if chigh > 0 
	 if t_used < 1		; determine maximum of variables to use for
t_used = 1			
	 endif
	endif 
chi2  =  (intime >> .16)
	if chi2 > 0 
	 if t_used < 2
t_used = 2
	 endif
	endif 
chi3  =  (intime >> .24)
	if chi3 > 0 
	 if t_used < 3
t_used = 3
	 endif
	endif
	 
	if chi3 > .255
	 error "Required Delay needs higher clock prescaler !!"	 
	else

	 if t_used > 0
	  if (intime >>8) < .1024		; omit if precise timing required
chigh = (chigh+1) & 0xFF
	  eq_ 	MaxTmr,=,chigh,		lit8	
	  endif
	 endif

	 if t_used > 1
	  if chi2 < .1024
chi2 = (chi2+1) & 0xFF
	 if	chi2 == chigh
	  movwf	MaxTmr+1
	 else

	   eq_ 	MaxTmr+1,=,chi2,	lit8
	   endif	
	  endif
	 endif
	 if t_used > 2
chi3 +=1
	 if	chi3 == chi2
	  movwf	MaxTmr+2
	 else
	  eq_ 	MaxTmr+2,=,chi3,	lit8	
	 endif
	 endif

	endif

	if      JVector != 0x00
	 movlw	jumpto
	 movwf	JVector
	endif
	
	if (chigh < 4) & (chi2 == 0) & (chi3 == 0) 
	 movlw	0x00FF - (clow)
	 movwf	TMR0

	 ifdef	__12F683
	  bcf	INTCON,T0IF
	 endif

	 ifdef	__10F206
	 ;	mov_bit TMR0,7,TMR7bit

	  bcf	TMR7bit
	  if_bit TMR0,7
	   bsf	TMR7bit
	  endif
	 endif  	

	
	endm


	variable TC0used


EVENT0in	macro	time,unit,jumpto
	variable	optn,intime,k,clow,chigh,chi2,chi3,dus,tlab
			

		  
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif


	IFDEF	__12F683
				; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
	 IFDEF	OSCONinit
optn =	OSCONinit & b'01110000'
	 ELSE
optn =	b'01100001'
	 ENDIF

optn = optn >> 4
	
	 if	optn == 0
dus = 65
	 else
dus = 1<<(7-optn)
	 endif
	ELSE
dus = 2				; every other processor runs at 2 half microseconds (1MHz)
	ENDIF
	
	
optn = 0
 	IFDEF	OPTIONinit	
	 if ! (OPTIONinit & b'00001000')
optn = 1 + (OPTIONinit & b'00000111')
	endif	
	ENDIF
; OSCONinit * OPTIONinit

dus = dus << optn		; prescale from OSCON in half (0.5) microseconds 

	if unit == sec
k = k / dus 
intime = time *k * 2 	; number of timer ticks required
	else
intime = time * k / dus * 2
	endif			
clow =	intime	& 0xFF
chigh=  (intime >> 8) 
	if chigh > 0 
	 if TC0used < 1		; determine maximum of variables to use for
	 error "Required Delay needs higher clock prescaler !!"			
	 endif
	endif 
chi2  =  (intime >> .16)
	if chi2 > 0 
	 if TC0used < 2
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif 
chi3  =  (intime >> .24)
	if chi3 > 0 
	 if TC0used < 3
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif
	 
	if chi3 > .255
	 error "Required Delay needs higher clock prescaler !!"	 
	else

	 if TC0used > 0
	  if (intime >>8) < .1024		; omit if precise timing required
chigh = (chigh+1) & 0xFF
	  eq_ 	TC0,=,chigh,		lit8	
	  endif
	 endif

	 if TC0used > 1
	  if chi2 < .1024
chi2 = (chi2+1) & 0xFF
	 if	chi2 == chigh
	  movwf	TC0+1
	 else

	   eq_ 	TC0+1,=,chi2,	lit8
	   endif	
	  endif
	 endif
	 if TC0used > 2
chi3 +=1
	 if	chi3 == chi2
	  movwf	TC0+2
	 else
	  eq_ 	TC0+2,=,chi3,	lit8	
	 endif
	 endif

	endif

;	if (chigh < 4) & (chi2 == 0) & (chi3 == 0) 

;	 movlw	0x00FF - (intime & 0xFF)
;	 movwf	TMR0
;
;	 ifdef	__12F683
;	  bcf	INTCON,T0IF
;	 endif
;
;	 ifdef	__10F206
;	 ;	mov_bit TMR0,7,TMR7bit
;
;	  bcf	TMR7bit
;	  if_bit TMR0,7
;	   bsf	TMR7bit
;	  endif
;	 endif 




	if      jumpto != 0xFF
	 movlw	jumpto
	 movwf	NmbrEvent0
;	endif
	
;	 
	  	
	    goto	end0MLOOP0
	endif
	endm
	


	variable TC1used


EVENT1in	macro	time,unit,jumpto
	variable	optn,intime,k,clow,chigh,chi2,chi3,dus,tlab
			

		  
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif


	IFDEF	__12F683
				; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
	 IFDEF	OSCONinit
optn =	OSCONinit & b'01110000'
	 ELSE
optn =	b'01100001'
	 ENDIF

optn = optn >> 4
	
	 if	optn == 0
dus = 65
	 else
dus = 1<<(7-optn)
	 endif
	ELSE
dus = 2				; every other processor runs at 2 half microseconds (1MHz)
	ENDIF
	
	
optn = 0
 	IFDEF	OPTIONinit	
	 if ! (OPTIONinit & b'00001000')
optn = 1 + (OPTIONinit & b'00000111')
	endif	
	ENDIF
; OSCONinit * OPTIONinit

dus = dus << optn		; prescale from OSCON in half (0.5) microseconds 

	if unit == sec
k = k / dus 
intime = time *k * 2 	; number of timer ticks required
	else
intime = time * k / dus * 2
	endif			
clow =	intime	& 0xFF
chigh=  (intime >> 8) 
	if chigh > 0 
	 if TC1used < 1		; determine maximum of variables to use for
	 error "Required Delay needs higher clock prescaler !!"			
	 endif
	endif 
chi2  =  (intime >> .16)
	if chi2 > 0 
	 if TC1used < 2
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif 
chi3  =  (intime >> .24)
	if chi3 > 0 
	 if TC1used < 3
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif
	 
	if chi3 > .255
	 error "Required Delay needs higher clock prescaler !!"	 
	else

	 if TC1used > 0
	  if (intime >>8) < .1024		; omit if precise timing required
chigh = (chigh+1) & 0xFF
	  eq_ 	TC1,=,chigh,		lit8	
	  endif
	 endif

	 if TC1used > 1
	  if chi2 < .1024
chi2 = (chi2+1) & 0xFF
	 if	chi2 == chigh
	  movwf	TC1+1
	 else

	   eq_ 	TC1+1,=,chi2,	lit8
	   endif	
	  endif
	 endif
	 if TC1used > 2
chi3 +=1
	 if	chi3 == chi2
	  movwf	TC1+2
	 else
	  eq_ 	TC1+2,=,chi3,	lit8	
	 endif
	 endif

	endif

	if      jumpto != 0xFF
	 movlw	jumpto
	 movwf	NmbrEvent1
;	endif
	
;	if intime < .1024
;	 movlw	0x00FF - (intime & 0xFF)
;	 movwf	TMR0
;
;	 ifdef	__12F683
;	  bcf	INTCON,T0IF
;	 endif
;
;	 ifdef	__10F206
;	 ;	mov_bit TMR0,7,TMR7bit
;
;	  bcf	TMR7bit
;	  if_bit TMR0,7
;	   bsf	TMR7bit
;	  endif
;	 endif 
;	 
	  	
	    goto	endMLOOP1
	endif
	endm
		

config627 macro
	#include <p16f627.inc>	; processor specific variable definitions
	#define	_MINRAM H'20'
	#define _MAXRAM H'7F'
 
	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT
	endm
	
	

config683 macro
	#include <p12f683.inc>	; processor specific variable definitions
	#define	_MINRAM H'20'
	#define _MAXRAM H'7F'
 __CONFIG  _CP_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

	endm

config683B macro
	#include <p12f683.inc>	; processor specific variable definitions
	#define	_MINRAM H'20'
	#define _MAXRAM H'7F'
 __CONFIG  _CP_OFF & _WDT_ON & _BOD_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

	endm
		
nointr683	macro
	org	0x00
	nop
	goto	0x05
	nop
	nop
	org 0x04
	return
	endm
	
init683	macro
	
	IFDEF	GPIOinit		
 	 movlw	GPIOinit
;	else
;	 movlw	b'00000000'
;	endif			; all GPIO LOW_ 
	movwf	GPIO
	endif
	
	BANKSEL	Bank1		; BANK1


	IFDEF	TRISIOinit;    IOdir			
 	 movlw	TRISIOinit;    IOdir
	else
	 movlw	b'00001011'; 0,1,3 =input 2,4,5=output
	endif   ; set direction bits 
	movwf	TRISIO		;
				; GP5	outp 
				; GP4	outp
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	inp
;	ifdef	shdwTRISIO
;	endif
 	IFDEF	OPTIONinit
	 movlw	OPTIONinit
	else
	 movlw	B'11001000'	; Timer0 internal clock, 1:1 prescale
	endif			; no pullup no wakeup
	movwf	OPTION_REG	; set option register for Timer0 functions
				;OPTION_REG  OPTION REGISTER (ADDRESS: 81h)
				;Note: To achieve a 1:1 prescaler assignment for
				;TMR0, assign the prescaler to the WDT by
				;setting PSA bit to 1 (Option<3>). See
				;Section 5.4 Prescaler.
				;R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1
				;GPPU INTEDG T0CS  T0SE   PSA   PS2   PS1   PS0
				;  7     6     5     4      3    2     1     0
				;bit 7 GPPU: GPIO Pull-up Enable bit
				;1 = GPIO pull-ups are disabled
				;0 = GPIO pull-ups are enabled by individual port latch 
				;   values   in WPU register
				;
				;bit 6 INTEDG: Interrupt Edge Select bit
				;1 = Interrupt on rising edge of GP2/INT pin
				;0 = Interrupt on falling edge of GP2/INT pin
				;
				;bit 5 T0CS: TMR0 Clock Source Select bit
				;1 = Transition on GP2/T0CKI pin
				;0 = Internal instruction cycle clock (CLKOUT)
				;
				;bit 4 T0SE: TMR0 Source Edge Select bit
				;1 = Increment on high-to-low transition on GP2/T0CKI pin
				;0 = Increment on low-to-high transition on GP2/T0CKI pin
				;
				;bit 3 PSA: Prescaler Assignment bit
				;1 = Prescaler is assigned to the WDT
				;0 = Prescaler is assigned to the Timer0 module
				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
				;Note 1: A dedicated 16-bit WDT postscaler is available 
				;for the PIC12F683. See
				;Section 12.6 Watchdog Timer (WDT) for more information.
				;
			
				;Bit Value   TMR0 Rate 	   WDT Rate(1)
				;000		1:2		1:1	
				;001		1:4		1 : 2
				;010		1:8		1:4
				;011		1:16		1:8
				;100		1:32		1:16
				;101		1:64		1:32
				;110		1:128		1:64
				;111		1:256		1:128
				;  1,000,000 /64 /125 /125 = 1sec
	;	

	IFDEF	ANSELinit
	 movlw	ANSELinit
	else
	 movlw	b'00110000'	;fRC clock, no analog bits
	endif
	movwf	ANSEL		; configure A/D 
				;ANSEL  ANALOG SELECT REGISTER (ADDRESS: 9Fh)
				;U-0 R/W-0 R/W-0 R/W-0 R/W-1 R/W-1 R/W-1 R/W-1
				;   ADCS2 ADCS1 ADCS0  ANS3  ANS2  ANS1  ANS0
				; 7     6    5     4     3      2     1  bit 0
				;bit 7 Unimplemented: Read as 0
				;bit 6-4 ADCS<2:0>: A/D Conversion Clock Select bits
				;000 = FOSC/2
				;001 = FOSC/8
				;010 = FOSC/32
				;x11 = FRC (clock derived from a dedicated internal 
				;		oscillator = 500 kHz max)
				;100 = FOSC/4
				;101 = FOSC/16
				;110 = FOSC/64
				;bit 3-0 ANS<3:0>: Analog Select bits
				;Analog select between analog or digital function on pins 
				;ANS<3:0>, respectively.
				;1 = Analog input. Pin is assigned as analog input(1).
				;0 = Digital I/O. Pin is assgn to port or special function.
				;Note1:Setting a pin to an analog input automatically 
				;	disables the digital input circuitry,
				;	weak pull-ups and interrupt-on-change if available. 
				;The corresponding TRISIO bit
				;must be set to input mode in order to allow external 
				;control of the voltage on the pin.

	IFDEF	OSCONinit
	 movlw	OSCONinit
	else
	 movlw	b'01100001'
	endif
	movwf	OSCCON		; 4MHz
				;OSCCON  OSCILLATOR CONTROL REGISTER (ADDRESS: 8Fh)
				;Note: Due to the wide range of oscillator start-up
				;times, the Fail-Safe circuit is not active
				;during oscillator start-up (i.e., after exiting
				;Reset or Sleep). After an appropriate
				;amount of time, the user should check the
				;OSTS bit (OSCCON<3>) to verify the
				;oscillator start-up and system clock
				;switchover has successfully completed.
				;U-0 R/W-1 R/W-1 R/W-0  R-1    R-0 R-0 R/W-0
				;   IRCF2 IRCF1 IRCF0 OSTS(1) HTS LTS SCS
				; 7    6     5     4     3      2   1   0
				;bit 7 Unimplemented: Read as 0
				;
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
				;
				;bit 3 OSTS: Oscillator Start-up Time-out Status bit
				;1 = Device is running from the external system clock 
				;    defined by FOSC<2:0>
				;0 = Device is running from the internal system clock 
				;    (HFINTOSC or LFINTOSC)
				;
				;bit 2 HTS: HFINTOSC (High Frequency  8 MHz to 125 kHz) 
				;1 = HFINTOSC is stable
				;0 = HFINTOSC is not stable
				;
				;bit 1 LTS: LFINTOSC (Low Frequency  31 kHz) Stable bit
				;1 = LFINTOSC is stable
				;0 = LFINTOSC is not stable
				;
				;bit 0 SCS: System Clock Select bit
				;1 = Internal oscillator is used for system clock
				;0 = Clock source defined by FOSC<2:0>
				;Note 1: Bit resets to 0 with Two-Speed Start-up and LP, 
				;XT or HS selected as the oscillator
				;mode or Fail-Safe mode is enabled.


	IFDEF	PIE1init
	 movlw	PIE1init
	 movwf	PIE1		;
	endif
	;			REGISTER 3-4: PIE1: PERIPHERAL INTERRUPT ENABLE REGISTER 1
	;			R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0
	;			EEIE  ADIE  CCP1IE   CMIE  OSFIE TMR2IE TMR1IE
	;			  7     6      5    4   3      2    1      0it 0

	;			bit 7 EEIE: EE Write Complete Interrupt Enable bit
	;			1 = Enables the EE write complete interrupt
	;			0 = Disables the EE write complete interrupt

	;			bit 6 ADIE: A/D Converter (ADC) Interrupt Enable bit
	;			1 = Enables the ADC interrupt
	;			0 = Disables the ADC interrupt

	;			bit 5 CCP1IE: CCP1 Interrupt Enable bit
	;			1 = Enables the CCP1 interrupt
	;			0 = Disables the CCP1 interrupt

	;			bit 4 Unimplemented: Read as 0

	;			bit 3 CMIE: Comparator Interrupt Enable bit
	;			1 = Enables the Comparator 1 interrupt
	;			0 = Disables the Comparator 1 interrupt

	;			bit 2 OSFIE: Oscillator Fail Interrupt Enable bit
	;			1 = Enables the oscillator fail interrupt
	;			0 = Disables the oscillator fail interrupt

	;			bit 1 TMR2IE: Timer2 to PR2 Match Interrupt Enable bit
	;			1 = Enables the Timer2 to PR2 match interrupt
	;			0 = Disables the Timer2 to PR2 match interrupt

	;			bit 0 TMR1IE: Timer1 Overflow Interrupt Enable bit
	;			1 = Enables the Timer1 overflow interrupt
	;			0 = Disables the Timer1 overflow interrupt


	banksel	Bank0		; switch back to PORT memory bank

	IFDEF	ADCON0init
	 movlw	ADCON0init
;	else
;	 movlw	b'00000000'	;left justified ,vdd, chanel 0 bits, off
;	endif
	movwf	ADCON0		; configure A/D 
	endif
;
		; REGISTER 9-1: ADCON0: A/D CONTROL REGISTER 0
		;R/W-0 R/W-0 U-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0
		;ADFM VCFG   CHS1 CHS0 GO/DONE ADON
		;bit 7 bit 0
		;Legend:
		;R = Readable bit W = Writable bit U = Unimplemented bit, read as 0
		;-n = Value at POR 1 = Bit is set 0 = Bit is cleared x = Bit is unknown
		;bit 7 ADFM: A/D Conversion Result Format Select bit
		;1 = Right justified
		;0 = Left justified
		;bit 6 VCFG: Voltage Reference bit
		;1 = VREF pin
		;0 = VDD
		;bit 5-4 Unimplemented: Read as 0
		;bit 3-2 CHS<1:0>: Analog Channel Select bits
		;00 = AN0
		;01 = AN1
		;10 = AN2
		;11 = AN3
		;bit 1 GO/DONE: A/D Conversion Status bit
		;1 = A/D conversion cycle in progress. Setting this bit starts an A/D conversion cycle.
		;This bit is automatically cleared by hardware when the A/D conversion has completed.
		;0 = A/D conversion completed/not in progress
		;bit 0 ADON: ADC Enable bit
		;1 = ADC is enabled
		;0 = ADC is disabled and consumes no operating current
		
	IFDEF	CMCON0init
	 movlw	CMCON0init
	else
	movlw	b'00000111'     ;comparator off
	endif
	movwf	CMCON0		
				; comparator enable input GP1 - Internal reference
				;CMCON0  COMPARATOR CONTROL REGISTER 0 (ADDRESS: 19h)
				;U-0 R-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;   COUT    CINV  CIS   CM2   CM1   CM0
				; 7    6  5     4    3     2     1     0
				;
				;bit 6 COUT: Comparator Output bit
				;When CINV = 0:
				;1 = VIN+ > VIN-
				;0 = VIN+ < VIN-
				;When CINV = 1:
				;1 = VIN+ < VIN-
				;0 = VIN+ > VINbit
				;
				;bit 4 CINV: Comparator Output Inversion bit
				;1 = Output inverted
				;0 = Output not inverted
				;
				;bit 3 CIS: Comparator Input Switch bit
				;When CM<2:0> = 110 or 101:
				;1 = VIN- connects to CIN+   GP0
				;0 = VIN- connects to CINbit GP1
				;
				;2 CM<2:0>: Comparator Mode bits
				;
				;FIGURE 8-3: COMPARATOR I/O OPERATING MODES
				;Note: Comparator interrupts should be disabled
				;during a Comparator mode change.
				;Otherwise, a false interrupt may occur.
				;Comparator Reset (POR Default Value  Low Power)         	
				;CM<2:0> = 000
				;                                                 
				;Comparator Off (Lowest Power)
				;CM<2:0> = 111

				;Comparator without Output                                	
				;CM<2:0> = 010 							
				;
				;Comparator w/o Output and with Internal Reference
				;CM<2:0> = 100
				;
				;Comparator with Output and Internal Reference 			
				;CM<2:0> = 011 							
				;
				;Multiplexed Input with Internal Reference and Output
				;CM<2:0> = 101
				;
				;Comparator with Output 					
				;CM<2:0> = 001 	
				
				;Multiplexed Input with Internal Reference
				;CM<2:0> = 110
				;
				
	IFDEF	INTCONinit
	 movlw	INTCONinit
	movwf	INTCON
	endif
;	else	movlw	b'00000000'	;disable interrupts
		;
	;			REGISTER 3-3: INTCON: INTERRUPT CONTROL REGISTER
	;			R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
	;			GIE   PEIE  T0IE  INTE  GPIE  T0IF  INTF  GPIF
	;			 7     6     5     4     3     2     1     0
	;			
	;			bit 7 GIE: Global Interrupt Enable bit
	;			1 = Enables all unmasked interrupts
	;			0 = Disables all interrupts

	;			bit 6 PEIE: Peripheral Interrupt Enable bit
	;			1 = Enables all unmasked peripheral interrupts
	;			0 = Disables all peripheral interrupts
	;
	;			bit 5 T0IE: Timer0 Overflow Interrupt Enable bit
	;			1 = Enables the Timer0 interrupt
	;			0 = Disables the Timer0 interrupt

	;			bit 4 INTE: GP2/INT External Interrupt Enable bit
	;			1 = Enables the GP2/INT external interrupt
	;			0 = Disables the GP2/INT external interrupt

	;			bit 3 GPIE: GPIO Change Interrupt Enable bit(1)
	;			1 = Enables the GPIO change interrupt
	;			0 = Disables the GPIO change interrupt

	;			bit 2 T0IF: Timer0 Overflow Interrupt Flag bit(2)
	;			1 = Timer0 register has overflowed 
	;			    (must be cleared in software)
	;			0 = Timer0 register did not overflow

	;			bit 1 INTF: GP2/INT External Interrupt Flag bit
	;			1 = The GP2/INT external interrupt occurred 
	;			(must be cleared in software)
	;			0 = The GP2/INT external interrupt did not occur

	;			bit 0 GPIF: GPIO Change Interrupt Flag bit
	;			1 = When at least one of the GPIO <5:0> pins changed state 
	;			(must be cleared in software)
	;			0 = None of the GPIO <5:0> pins have changed state

	;			Note 1: IOC register must also be enabled.
	;			2: T0IF bit is set when TMR0 rolls over. 
	;			TMR0 is unchanged on Reset 
	;			and should be initialized before
	;			clearing T0IF bit.
	;


	banksel	Bank1
	IFDEF	IOCinit
	 movlw	IOCinit
;	movlw	b'00000000'	;disable interrupt on change
	movwf	IOC
	endif
				;REGISTER 4-4: IOC  INTERRUPT-ON-CHANGE GPIO REGISTER 
				;(ADDRESS: 96h)
				;U-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;       IOC5  IOC4  IOC3  IOC2  IOC1  IOC0
				;bit 7 bit 0
				;bit 7-6 Unimplemented: Read as 0
				;bit 5-0 IOC<5:0>: Interrupt-on-change GPIO Control bit
				;1 = Interrupt-on-change enabled
				;0 = Interrupt-on-change disabled
				;Note 1: Global Interrupt Enable (GIE) must be enabled for
				;       individual interrupts to be recognized.

	IFDEF	WPUinit
	 movlw	WPUinit
	else
	 movlw	b'00000000'	;disable weak pullup 
	endif
	movwf	WPU

	IFDEF	PR2init
	 movlw	PR2init
;	else
;	 movlw	b'11111111'
;	endif
	movwf	PR2			; minimum frequency 
	endif
	
	banksel Bank0

	IFDEF	CCPR1Linit
	 movlw	CCPR1Linit
	else
	 movlw	b'00000001'
	endif
	MOVWF	CCPR1L	 ;  4 * prescaler = 16 values from 250ns to 4.750us

	IFDEF	CCP1CONinit
	 movlw	CCP1CONinit
;	else
;	 movlw	b'00000000'  ; disable PWM
;	endif

	movwf	CCP1CON	
	endif
;                     7  4   0   ;  17 duty cycle
			;CCP1CON  CCP CONTROL REGISTER 1 (ADDRESS: 15h)
		
			; U-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0   R/W-0  R/W-0
			;       DC1B1 DC1B0 CCP1M3 CCP1M2 CCP1M1 CCP1M0
			;  7    6   5     4     3      2      1      0     
			;bit7
			;Unimplemented: Read as 0
			;bit6
			;Unimplemented: Read as 0
			
			;bit5 , bit4
			;DC1B<1:0>: PWM Least Significant bits
			;Capture mode:
			;Unused.
			;Compare mode:
			;Unused.
			;PWM mode:
			;These bits are the two LSbs of the PWM duty cycle. 
			;The eight MSbs are found in CCPR1L.
			
			;bit 3
			;CCP1M<3:0>: CCP1 Mode Select bits
			;0000 = Capture/Compare/PWM disabled (resets CCP1 module)
			;0100 = Capture mode, every falling edge
			;0101 = Capture mode, every rising edge
			;0110 = Capture mode, every 4th rising edge
			;0111 = Capture mode, every 16th rising edge
			;1000 = Compare mode, set output on match (CCP1IF bit is set)
			;1001 = Compare mode, clear output on match (CCP1IF bit is set)
			;1010 = Compare mode, generate software interrupt on match 
			;	(CCP1IF bit is set,
			;	CCP1 pin is unaffected)
			;1011 = Compare mode, trigger special event (CCP1IF bit is set, 
			;	CCP1 pin is unaffected);
			;	CCP1 resets TMR1 and starts an A/D conversion 
			;	(if A/D module is enabled)
			;11xx = PWM mode
			;
	IFDEF	PIR1init
	 movlw	PIR1init
;	else
;	 movlw	b'00000000'
;	endif
	movwf	PIR1
	endif
			;REGISTER 3-5: PIR1: PERIPHERAL INTERRUPT REQUEST REGISTER 1
			;R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0
			;EEIF  ADIF  CCP1IF   CMIF  OSFIF TMR2IF TMR1IF
		
			;bit 7 EEIF: EEPROM Write Operation Interrupt Flag bit
			;1 = The write operation completed (must be cleared in software)
			;0 = The write operation has not completed or has not been started
			;bit 6 ADIF: A/D Interrupt Flag bit
			;1 = A/D conversion complete
			;0 = A/D conversion has not completed or has not been started
			;bit 5 CCP1IF: CCP1 Interrupt Flag bit
			;Capture mode:
			;1 = A TMR1 register capture occurred (must be cleared in software)
			;0 = No TMR1 register capture occurred
			;Compare mode:
			;1 = A TMR1 register compare match occurred 
			;         (must be cleared in software)
			;0 = No TMR1 register compare match occurred
			;PWM mode:
			;Unused in this mode
			;bit 4 Unimplemented: Read as 0
			;bit 3 CMIF: Comparator Interrupt Flag bit
			;1 = Comparator 1 output has changed (must be cleared in software)
			;0 = Comparator 1 output has not changed
			;bit 2 OSFIF: Oscillator Fail Interrupt Flag bit
			;1 = System oscillator failed, clock input has changed to INTOSC 
			;	(must be cleared in software)
			;0 = System clock operating
			;bit 1 TMR2IF: Timer2 to PR2 Match Interrupt Flag bit
			;1 = Timer2 to PR2 match occurred (must be cleared in software)
			;0 = Timer2 to PR2 match has not occurred
			;bit 0 TMR1IF: Timer1 Overflow Interrupt Flag bit
			;1 = Timer1 register overflowed (must be cleared in software)
			;0 = Timer1 has not overflowed



	IFDEF	T2CONinit
	 movlw	T2CONinit
;	else
;	 movlw	b'00000000'; switch off TMR2
;	endif
	movwf	T2CON	
	endif
	;		REGISTER 7-1: T2CON  TIMER2 CONTROL REGISTER (ADDRESS: 12h)
	;		U-0 R/W-0   R/W-0    R/W-0   R/W-0   R/W-0  R/W-0   R/W-0
	;		   TOUTPS3 TOUTPS2 TOUTPS1 TOUTPS0 TMR2ON T2CKPS1 T2CKPS0
	;		 7    6        5       4       3       2      1    bit 0
	;		bit 7 Unimplemented: Read as 0
	;		bit 6-3 TOUTPS<3:0>: Timer2 Output Postscale Select bits
	;		0000 = 1:1 postscale
	;		0001 = 1:2 postscale
	;		
	;		
	;		
	;		1111 = 1:16 postscale
	;		bit 2 TMR2ON: Timer2 On bit
	;		1 = Timer2 is on
	;		0 = Timer2 is off
	;		bit 1-0 T2CKPS<1:0>: Timer2 Clock Prescale Select bits
	;		00 = Prescaler is 1    <----- for spoton
	;		01 = Prescaler is 4    <----- for campinglight
	;		1x = Prescaler is 16
	;	


	endm
	
init627	macro
	
	IFDEF	PORTAinit		
 	 movlw	PORTAinit
;	else
;	 movlw	b'00000000'
;	endif			; all GPIO LOW_ 
	movwf	PORTA
	endif
	IFDEF	PORTBinit		
 	 movlw	PORTBinit
;	else
;	 movlw	b'00000000'
;	endif			; all GPIO LOW_ 
	movwf	PORTB
	endif
	
	BANKSEL	Bank1		; BANK1


	IFDEF	TRISAinit;    IOdir			
 	 movlw	TRISAinit;    IOdir
	else
	 movlw	b'00110011'; 0,1,4,5 =input 2,3,6,7=output
	endif   ; set direction bits 
	movwf	TRISA		;
	IFDEF	TRISBinit;    IOdir			
 	 movlw	TRISBinit;    IOdir
	else
	 movlw	b'11111111'; 
	endif   ; set direction bits 
	movwf	TRISB	;


;	ifdef	shdwTRISIO
;	endif
 	IFDEF	OPTIONinit
	 movlw	OPTIONinit
	else
	 movlw	B'11001000'	; Timer0 internal clock, 1:1 prescale
	endif			; no pullup no wakeup
	movwf	OPTION_REG	; set option register for Timer0 functions
				;OPTION_REG  OPTION REGISTER (ADDRESS: 81h)
		;Section 12.6 Watchdog Timer (WDT) for more information.
				;
			
				;Bit Value   TMR0 Rate 	   WDT Rate(1)
				;000		1:2		1:1	
				;001		1:4		1 : 2
				;010		1:8		1:4
				;011		1:16		1:8
				;100		1:32		1:16
				;101		1:64		1:32
				;110		1:128		1:64
				;111		1:256		1:128
				;  1,000,000 /64 /125 /125 = 1sec
	;	


	IFDEF	PIE1init
	 movlw	PIE1init
	 movwf	PIE1		;
	endif
	;			REGISTER 3-4: PIE1: PERIPHERAL INTERRUPT ENABLE REGISTER 1
	;			R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0


	banksel	Bank0		; switch back to PORT memory bank

	IFDEF	CMCONinit
	 movlw	CMCONinit
	else
	movlw	b'00000111'     ;comparator off
	endif
	movwf	CMCON		
				; comparator enable input GP1 - Internal reference
				;CMCON0  COMPARATOR CONTROL REGISTER 0 (ADDRESS: 19h)
				;U-0 R-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;   COUT    CINV  CIS   CM2   CM1   CM0
				; 7    6  5     4    3     2     1     0
				;
				;bit 6 COUT: Comparator Output bit
				;When CINV = 0:
				;1 = VIN+ > VIN-
				;0 = VIN+ < VIN-
				;When CINV = 1:
				;1 = VIN+ < VIN-
				;0 = VIN+ > VINbit
				;
				;bit 4 CINV: Comparator Output Inversion bit
				;1 = Output inverted
				;0 = Output not inverted
				;
				;bit 3 CIS: Comparator Input Switch bit
				;When CM<2:0> = 110 or 101:
				;1 = VIN- connects to CIN+   GP0
				;0 = VIN- connects to CINbit GP1
				;
				;2 CM<2:0>: Comparator Mode bits
				;
				;FIGURE 8-3: COMPARATOR I/O OPERATING MODES
				;Note: Comparator interrupts should be disabled
				;during a Comparator mode change.
				;Otherwise, a false interrupt may occur.
				;Comparator Reset (POR Default Value  Low Power)         	
				;CM<2:0> = 000
				;                                                 
				;Comparator Off (Lowest Power)
				;CM<2:0> = 111

				;Comparator without Output                                	
				;CM<2:0> = 010 							
				;
				;Comparator w/o Output and with Internal Reference
				;CM<2:0> = 100
				;
				;Comparator with Output and Internal Reference 			
				;CM<2:0> = 011 							
				;
				;Multiplexed Input with Internal Reference and Output
				;CM<2:0> = 101
				;
				;Comparator with Output 					
				;CM<2:0> = 001 	
				
				;Multiplexed Input with Internal Reference
				;CM<2:0> = 110
				;
				
	IFDEF	INTCONinit
	 movlw	INTCONinit
	movwf	INTCON
	endif
;	else	movlw	b'00000000'	;disable interrupts
		;
	;			REGISTER 3-3: INTCON: INTERRUPT CONTROL REGISTER
	;			R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
	;			GIE   PEIE  T0IE  INTE  GPIE  T0IF  INTF  GPIF
	;			 7     6     5     4     3     2     1     0
	;			
	;			bit 7 GIE: Global Interrupt Enable bit
	;			1 = Enables all unmasked interrupts
	;			0 = Disables all interrupts

	;			bit 6 PEIE: Peripheral Interrupt Enable bit
	;			1 = Enables all unmasked peripheral interrupts
	;			0 = Disables all peripheral interrupts
	;
	;			bit 5 T0IE: Timer0 Overflow Interrupt Enable bit
	;			1 = Enables the Timer0 interrupt
	;			0 = Disables the Timer0 interrupt

	;			bit 4 INTE: GP2/INT External Interrupt Enable bit
	;			1 = Enables the GP2/INT external interrupt
	;			0 = Disables the GP2/INT external interrupt

	;			bit 3 GPIE: GPIO Change Interrupt Enable bit(1)
	;			1 = Enables the GPIO change interrupt
	;			0 = Disables the GPIO change interrupt

	;			bit 2 T0IF: Timer0 Overflow Interrupt Flag bit(2)
	;			1 = Timer0 register has overflowed 
	;			    (must be cleared in software)
	;			0 = Timer0 register did not overflow

	;			bit 1 INTF: GP2/INT External Interrupt Flag bit
	;			1 = The GP2/INT external interrupt occurred 
	;			(must be cleared in software)
	;			0 = The GP2/INT external interrupt did not occur

	;			bit 0 GPIF: GPIO Change Interrupt Flag bit
	;			1 = When at least one of the GPIO <5:0> pins changed state 
	;			(must be cleared in software)
	;			0 = None of the GPIO <5:0> pins have changed state

	;			Note 1: IOC register must also be enabled.
	;			2: T0IF bit is set when TMR0 rolls over. 
	;			TMR0 is unchanged on Reset 
	;			and should be initialized before
	;			clearing T0IF bit.
	;



	IFDEF	PR2init
	 movlw	PR2init
;	else
;	 movlw	b'11111111'
;	endif
	movwf	PR2			; minimum frequency 
	endif
	
	banksel Bank0

	IFDEF	CCPR1Linit
	 movlw	CCPR1Linit
	else
	 movlw	b'00000001'
	endif
	MOVWF	CCPR1L	 ;  4 * prescaler = 16 values from 250ns to 4.750us

	IFDEF	CCP1CONinit
	 movlw	CCP1CONinit
;	else
;	 movlw	b'00000000'  ; disable PWM
;	endif

	movwf	CCP1CON	
	endif
;                     7  4   0   ;  17 duty cycle
			;CCP1CON  CCP CONTROL REGISTER 1 (ADDRESS: 15h)
		
			; U-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0   R/W-0  R/W-0
			;       DC1B1 DC1B0 CCP1M3 CCP1M2 CCP1M1 CCP1M0
			;  7    6   5     4     3      2      1      0     
			;bit7
			;Unimplemented: Read as 0
			;bit6
			;Unimplemented: Read as 0
			
			;bit5 , bit4
			;DC1B<1:0>: PWM Least Significant bits
			;Capture mode:
			;Unused.
			;Compare mode:
			;Unused.
			;PWM mode:
			;These bits are the two LSbs of the PWM duty cycle. 
			;The eight MSbs are found in CCPR1L.
			
			;bit 3
			;CCP1M<3:0>: CCP1 Mode Select bits
			;0000 = Capture/Compare/PWM disabled (resets CCP1 module)
			;0100 = Capture mode, every falling edge
			;0101 = Capture mode, every rising edge
			;0110 = Capture mode, every 4th rising edge
			;0111 = Capture mode, every 16th rising edge
			;1000 = Compare mode, set output on match (CCP1IF bit is set)
			;1001 = Compare mode, clear output on match (CCP1IF bit is set)
			;1010 = Compare mode, generate software interrupt on match 
			;	(CCP1IF bit is set,
			;	CCP1 pin is unaffected)
			;1011 = Compare mode, trigger special event (CCP1IF bit is set, 
			;	CCP1 pin is unaffected);
			;	CCP1 resets TMR1 and starts an A/D conversion 
			;	(if A/D module is enabled)
			;11xx = PWM mode
			;
	IFDEF	PIR1init
	 movlw	PIR1init
;	else
;	 movlw	b'00000000'
;	endif
	movwf	PIR1
	endif
			;REGISTER 3-5: PIR1: PERIPHERAL INTERRUPT REQUEST REGISTER 1
			;R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0
			;EEIF  ADIF  CCP1IF   CMIF  OSFIF TMR2IF TMR1IF
		
			;bit 7 EEIF: EEPROM Write Operation Interrupt Flag bit
			;1 = The write operation completed (must be cleared in software)
			;0 = The write operation has not completed or has not been started
			;bit 6 ADIF: A/D Interrupt Flag bit
			;1 = A/D conversion complete
			;0 = A/D conversion has not completed or has not been started
			;bit 5 CCP1IF: CCP1 Interrupt Flag bit
			;Capture mode:
			;1 = A TMR1 register capture occurred (must be cleared in software)
			;0 = No TMR1 register capture occurred
			;Compare mode:
			;1 = A TMR1 register compare match occurred 
			;         (must be cleared in software)
			;0 = No TMR1 register compare match occurred
			;PWM mode:
			;Unused in this mode
			;bit 4 Unimplemented: Read as 0
			;bit 3 CMIF: Comparator Interrupt Flag bit
			;1 = Comparator 1 output has changed (must be cleared in software)
			;0 = Comparator 1 output has not changed
			;bit 2 OSFIF: Oscillator Fail Interrupt Flag bit
			;1 = System oscillator failed, clock input has changed to INTOSC 
			;	(must be cleared in software)
			;0 = System clock operating
			;bit 1 TMR2IF: Timer2 to PR2 Match Interrupt Flag bit
			;1 = Timer2 to PR2 match occurred (must be cleared in software)
			;0 = Timer2 to PR2 match has not occurred
			;bit 0 TMR1IF: Timer1 Overflow Interrupt Flag bit
			;1 = Timer1 register overflowed (must be cleared in software)
			;0 = Timer1 has not overflowed



	IFDEF	T2CONinit
	 movlw	T2CONinit
;	else
;	 movlw	b'00000000'; switch off TMR2
;	endif
	movwf	T2CON	
	endif
	;		REGISTER 7-1: T2CON  TIMER2 CONTROL REGISTER (ADDRESS: 12h)
	;		U-0 R/W-0   R/W-0    R/W-0   R/W-0   R/W-0  R/W-0   R/W-0
	;		   TOUTPS3 TOUTPS2 TOUTPS1 TOUTPS0 TMR2ON T2CKPS1 T2CKPS0
	;		 7    6        5       4       3       2      1    bit 0
	;		bit 7 Unimplemented: Read as 0
	;		bit 6-3 TOUTPS<3:0>: Timer2 Output Postscale Select bits
	;		0000 = 1:1 postscale
	;		0001 = 1:2 postscale
	;		
	;		
	;		
	;		1111 = 1:16 postscale
	;		bit 2 TMR2ON: Timer2 On bit
	;		1 = Timer2 is on
	;		0 = Timer2 is off
	;		bit 1-0 T2CKPS<1:0>: Timer2 Clock Prescale Select bits
	;		00 = Prescaler is 1    <----- for spoton
	;		01 = Prescaler is 4    <----- for campinglight
	;		1x = Prescaler is 16
	;	


	endm

settrap683	macro	time,unit,vector,MaxTmr,TmrVector
		  variable	optn,intime,k,clow,chigh,chi2,dus
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif

	; watch out!
	; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
	IFDEF	OSCONinit
optn =	OSCONinit & b'01110000'
	ELSE
optn =	b'01100001'
	ENDIF

optn = optn >> 4
	
	
	if	optn == 0
dus = 65
	else
dus = 1<<(7-optn)
	endif
	
optn = 0
 	IFDEF	OPTIONinit	
	 if ! (OPTIONinit & b'00001000')
optn = 1 + (OPTIONinit & b'00000111')
	endif	
	ENDIF
; OSCONinit * OPTIONinit

dus = dus << optn		; prescale 


intime = time *k * 2 / dus 

mxtmr= intime /.256 


	while	mxtmr > .255	; increase prescaler until only 1 byte needed
optn += 1
mxtmr = mxtmr / 2
intime = intime /2
changeOPTION = 1		; global variable = OPTION changed
	endw

	if optn > .7
	 error "Required Delay needs settrap206B (two byte option) !!"	 
	else

optn = (OPTIONinit & b'11110000') + optn

	if changeOPTION		; done it once, do it always
				; WARNING: compiler will hang if non changing code
				; is followed by changing code
	movlw	optn
	OPTION
	endif

	movlw	mxtmr+1
	movwf	MaxTmr
	movlw	0x00FF - (intime & 0xFF)
	movwf	TMR0

	bcf	INTCON,T0IF		; test in calltrap
	
	
	movlw	vector 
	movwf	TmrVector
	endm 

settrap683B	macro	time,unit,vector,MaxTmr,TmrVector
		  variable	optn,intime,k,clow,chigh,chi2,dus
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif


	IFDEF	__12F683
	
		; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
	IFDEF	OSCONinit
optn =	OSCONinit & b'01110000'
	ELSE
optn =	b'01100001'
	ENDIF

optn = optn >> 4
	
	
	if	optn == 0
dus = 65
	else
dus = 1<<(7-optn)
	endif
	ELSE
dus = 2
	ENDIF
	
	
optn = 0
 	IFDEF	OPTIONinit	
	 if ! (OPTIONinit & b'00001000')
optn = 1 + (OPTIONinit & b'00000111')
	endif	
	ENDIF
; OSCONinit * OPTIONinit

dus = dus << optn		; prescale 


intime = time *k * 2 / dus 
					; intime = intime + 65336
clow =	intime	& 0xFF
chigh=  (intime >> 8) &0xFF
chi2  =  intime >> .16

	if chi2 > .255
	 
	 error "Required Delay needs higher clock prescaler !!"	 
	 
	else

	if	clow != 0
chigh+=1
	 if	chigh == .256
chi2 +=1
chigh==0
	 endif
	endif
	if chigh !=0
chi2 +=1
	endif
	if chi2 < 5
	 eq_ 	MaxTmr,=,chigh,		lit8	
	endif

	 eq_	MaxTmr+1,=,chi2,	lit8
	endif

	if intime < .1024
	 movlw	0x00FF - (intime & 0xFF)
	 movwf	TMR0
	endif
	bcf	INTCON,T0IF		; test in calltrap
	
	movlw	vector			; WARNING 
	movwf	TmrVector		; DOES NOT WORK ACROSS PCLATH boudaries 
 					; ONLY LOW PART OF PC changed
			
	; write this as Variable trap 1.1000 msec
	;				1..256sec		
			
			
	endm




config629 macro
	#include <p12f629.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _CPD_OFF & _BODEN_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	

				;
				;
				;REGISTER 9-1: CONFIG  CONFIGURATION WORD (ADDRESS: 2007h)
				;Note: Address 2007h is beyond the user program
				;memory space. It belongs to the special configuration
				;memory space (2000h - 3FFFh),
				;which can be accessed only during programming.
				;See PIC12F629/675 Programming
				;Specification for more information.
	;R/P-1 R/P-1 U-0 U-0 U-0 R/P-1 R/P-1 R/P-1 R/P-1 R/P-1 R/P-1 R/P-1 R/P-1 R/P-1
	; BG1   BG0            CPD    CP  BODEN MCLRE PWRTE WDTE  F0SC2 F0SC1 F0SC0
				;bit 13 bit 0
				;bit 13-12 BG1:BG0: Bandgap Calibration bits for 
				;BOD and POR voltage(1)
				;00 = Lowest bandgap voltage
				;11 = Highest bandgap voltage
				;bit 11-9 Unimplemented: Read as 0
				;bit 8 CPD: Data Code Protection bit(2)
				;1 = Data memory code protection is disabled
				;0 = Data memory code protection is enabled
				;bit 7 CP: Code Protection bit(3)
				;1 = Program Memory code protection is disabled
				;0 = Program Memory code protection is enabled
				;bit 6 BODEN: Brown-out Detect Enable bit(4)
				;1 = BOD enabled
				;0 = BOD disabled
				;bit 5 MCLRE: GP3/MCLR pin function select(5)
				;1 = GP3/MCLR pin function is MCLR
				;0 = GP3/MCLR pin function is digital I/O, 
				;    MCLR internally tied to VDD
				;bit 4 PWRTE: Power-up Timer Enable bit
				;1 = PWRT disabled
				;0 = PWRT enabled
				;bit 3 WDTE: Watchdog Timer Enable bit
				;1 = WDT enabled
				;0 = WDT disabled
				;bit 2-0 FOSC2:FOSC0: Oscillator Selection bits
				;111 = RC oscillator: CLKOUT function on 
				;       GP4/OSC2/CLKOUT pin, RC on GP5/OSC1/CLKIN
				;110 = RC oscillator: I/O function on GP4/OSC2/CLKOUT pin, 
				;      RC on GP5/OSC1/CLKIN
				;101 = INTOSC oscillator: CLKOUT function on 
				;	GP4/OSC2/CLKOUT pin, I/O function on GP5/OSC1/CLKIN
				;100 = INTOSC oscillator: I/O function on 
				;	GP4/OSC2/CLKOUT pin, I/O function on GP5/OSC1/CLKIN
				;011 = EC: I/O function on GP4/OSC2/CLKOUT pin, 
				;        CLKIN on GP5/OSC1/CLKIN
				;010 = HS oscillator: High speed crystal/resonator on 
				;	GP4/OSC2/CLKOUT and GP5/OSC1/CLKIN
				;001 = XT oscillator: Crystal/resonator on GP4/OSC2/CLKOUT 
				;	and GP5/OSC1/CLKIN
				;000 = LP oscillator: Low power crystal on GP4/OSC2/CLKOUT 
				;        and GP5/OSC1/CLKIN
				;Note 1: The Bandgap Calibration bits are factory 
				; programmed and must be read and saved prior to erasing
				;the device as specified in the PIC12F629/675 P
				; rogramming Specification. These bits are reflected
				;in an export of the configuration word. 
				; Microchip Development Tools maintain all calibration bits 
				;to
				;factory settings.
				;2: The entire data EEPROM will be erased when the code 
				;  protection is turned off.
				;3: The entire program memory will be erased, 
				; including OSCCAL value, when the code protection is
				;turned off.
				;4: Enabling Brown-out Detect does not automatically 
				; enable Power-up Timer.
				;5: When MCLR is asserted in INTOSC or RC mode, the 
				;  internal clock oscillator is disabled.
				;Legend:
				;P = Programmed using ICSP
				;R = Readable bit W = Writable bit U = Unimplemented bit, 
				;     read as 0
				;-n = Value at POR 1 = bit is set 0 = bit is cleared 
				; x = bit is unknown
				;
		#define	_MINRAM H'20'
		#define _MAXRAM H'5F'			
	endm

config629B macro
	#include <p12f629.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _CPD_OFF & _BODEN_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT

				;
		#define	_MINRAM H'20'
		#define _MAXRAM H'5F'			
	endm

config675 macro
	#include <p12f675.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _CPD_OFF & _BODEN_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
		#define	_MINRAM H'20'
		#define _MAXRAM H'5F'			
	endm



init629	macro				; works for 12F675 as well
	IFDEF	GPIOinit		
 	 movlw	GPIOinit
;	else
;	 movlw	b'00000000'
;	endif			; all GPIO LOW_ 
	movwf	GPIO
	ENDIF
	
	BANKSEL	Bank1		; BANK1


	IFDEF	TRISIOinit;    IOdir			
 	 movlw	TRISIOinit;    IOdir
	else
	 movlw	b'00001011'; 0,1,3 =input 2,4,5=output
	endif   ; set direction bits 
	movwf	TRISIO		;
				; GP5	outp 
				; GP4	outp
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	inp
 	IFDEF	OPTIONinit
	 movlw	OPTIONinit	; B'11010101'; 16ms
	else
	 movlw	B'11001000'	; Timer0 internal clock, 1:1 prescale
	endif
	movwf	OPTION_REG	; set option register for Timer0 functions
				;OPTION_REG  OPTION REGISTER (ADDRESS: 81h)
				;Note: To achieve a 1:1 prescaler assignment for
				;TMR0, assign the prescaler to the WDT by
				;setting PSA bit to 1 (OPTION<3>). See
				;Section 4.4.
				;R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1
				;GPPU INTEDG T0CS T0SE PSA PS2 PS1 PS0
				;bit 7 bit 0
				;bit 7 GPPU: GPIO Pull-up Enable bit
				;1 = GPIO pull-ups are disabled
				;0 = GPIO pull-ups are enabled by 
				;   individual port latch values
				;bit 6 INTEDG: Interrupt Edge Select bit
				;1 = Interrupt on rising edge of GP2/INT pin
				;0 = Interrupt on falling edge of GP2/INT pin
				;bit 5 T0CS: TMR0 Clock Source Select bit
				;1 = Transition on GP2/T0CKI pin
				;0 = Internal instruction cycle clock (CLKOUT)
				;bit 4 T0SE: TMR0 Source Edge Select bit
				;1 = Increment on high-to-low transition on GP2/T0CKI pin
				;0 = Increment on low-to-high transition on GP2/T0CKI pin
				;bit 3 PSA: Prescaler Assignment bit
				;1 = Prescaler is assigned to the WDT
				;0 = Prescaler is assigned to the TIMER0 module
				;bit 2-0 PS2:PS0: Prescaler Rate Select bits
				;Bit Value TMR0 Rate WDT Rate
				;000	1 : 2	1 : 1
				;001	1 : 4	1 : 2
				;010	1 : 8	1 : 4
				;011	1 : 16	1 : 8
				;100	1 : 32	1 : 16
				;101	1 : 64	1 : 32
				;110	1 : 128	1 : 64
				;111	1 : 256	1 : 128
				;
				;
				;
		
				;  1,000,000 /64 /125 /125 = 1sec
	;	
	IFDEF __12F675


	ifdef	ANSELinit
	 movlw	ANSELinit
	else
	 movlw	b'00110000'	;fRC clock
	endif
	movwf	ANSEL		; configure A/D 
				;REGISTER 7-2: ANSEL  ANALOG SELECT REGISTER (ADDRESS: 9Fh)
				;U-0 R/W-0 R/W-0 R/W-0 R/W-1 R/W-1 R/W-1 R/W-1
				; ADCS2 ADCS1 ADCS0 ANS3 ANS2 ANS1 ANS0
				;bit 7 bit 0
				;bit 7 Unimplemented: Read as 0.
				;bit 6-4 ADCS<2:0>: A/D Conversion Clock Select bits
				;000 = FOSC/2
				;001 = FOSC/8
				;010 = FOSC/32
				;x11 = FRC (clock derived from a dedicated internal 
				;	oscillator = 500 kHz max)
				;100 = FOSC/4
				;101 = FOSC/16
				;110 = FOSC/64
				;bit 3-0 ANS3:ANS0: Analog Select bits
				;(Between analog or digital function on pins AN<3:0>, 
				;  respectively.)
				;1 = Analog input; pin is assigned as analog input(1)
				;0 = Digital I/O; pin is assigned to port or 
				;     special function
				;
				;REGISTER 7-1: ADCON0  A/D CONTROL REGISTER (ADDRESS: 1Fh)
				;R/W-0 R/W-0 U-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0
				;ADFM VCFG   CHS1 CHS0 GO/DONE ADON
				;bit 7 bit 0
				;bit 7 ADFM: A/D Result Formed Select bit
				;1 = Right justified
				;0 = Left justified
				;bit 6 VCFG: Voltage Reference bit
				;1 = VREF pin
				;0 = VDD
				;bit 5-4 Unimplemented: Read as zero
				;bit 3-2 CHS1:CHS0: Analog Channel Select bits
				;00 = Channel 00 (AN0)
				;01 = Channel 01 (AN1)
				;10 = Channel 02 (AN2)
				;11 = Channel 03 (AN3)
				;bit 1 GO/DONE: A/D Conversion Status bit
				;1 = A/D conversion cycle in progress. Setting this bit 
				;      starts an A/D conversion cycle.
				;This bit is automatically cleared by hardware when the 
				;   A/D conversion has completed.
				;0 = A/D conversion completed/not in progress
				;bit 0 ADON: A/D Conversion STATUS bit
				;1 = A/D converter module is operating
				;0 = A/D converter is shut-off and consumes no 
				;  operating current
	ENDIF
;
;	IFDEF	OSCALinit
;	 movlw	OSCALinit
;	else
;	 call	0x3FF
;	endif
;	movwf	OSCCAL		
;	
		;	REGISTER 2-7: OSCCAL  OSCILLATOR CALIBRATION REGISTER 
		;           (ADDRESS: 90h)
		;
		;R/W-1 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 U-0 U-0
		;CAL5 CAL4 CAL3 CAL2 CAL1 CAL0  
		;bit 7 bit 0
		;bit 7-2 CAL5:CAL0: 6-bit Signed Oscillator Calibration bits
		;111111 = Maximum frequency
		;100000 = Center frequency
		;000000 = Minimum frequency
	IFDEF	PIE1init
	 movlw	PIE1init
	 movwf	PIE1		
	ENDIF			;
				;REGISTER 2-4: PIE1  PERIPHERAL INTERRUPT 
				;	ENABLE REGISTER 1 (ADDRESS: 8Ch)
				;Note: Bit PEIE (INTCON<6>) must be set to
				;enable any peripheral interrupt.
				;R/W-0 R/W-0 U-0 U-0 R/W-0 U-0 U-0 R/W-0
				;EEIE ADIE   CMIE   TMR1IE
				;bit 7 bit 0
				;bit 7 EEIE: EE Write Complete Interrupt Enable bit
				;1 = Enables the EE write complete interrupt
				;0 = Disables the EE write complete interrupt
				;bit 6 ADIE: A/D Converter Interrupt Enable bit 
				;	(PIC12F675 only)
				;1 = Enables the A/D converter interrupt
				;0 = Disables the A/D converter interrupt
				;bit 5-4 Unimplemented: Read as 0
				;bit 3 CMIE: Comparator Interrupt Enable bit
				;1 = Enables the comparator interrupt
				;0 = Disables the comparator interrupt
				;bit 2-1 Unimplemented: Read as 0
				;bit 0 TMR1IE: TMR1 Overflow Interrupt Enable bit
				;1 = Enables the TMR1 overflow interrupt
				;0 = Disables the TMR1 overflow interrupt
				;
	banksel	Bank0		; switch back to PORT memory bank

;#define GP1_Porton	b'00010110'; GP1     ; configure comparator input=on
;#define GP0_Porton	b'00011110'; GP0     ; configure comparator input=on, int ref, GP0
;	ifndef	VDD
;#define	VDD		.50
;	endif
;	
	
	IFDEF	CMCONinit
	 movlw	CMCONinit
	ELSE 
	movlw	b'00000111'     ;comparator off 00010110 GP0
	ENDIF
	movwf	CMCON		
				;REGISTER 6-1: CMCON  COMPARATOR CONTROL REGISTER 
				;     		(ADDRESS: 19h)
				;U-0 R-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;   COUT   CINV   CIS   CM2   CM1   CM0
				;bit 7 bit 0
				;bit 7 Unimplemented: Read as 0
				;bit 6 COUT: Comparator Output bit
				;When CINV = 0:
				;1 = VIN+ > VIN-
				;0 = VIN+ < VIN 
				;When
				;CINV = 1:
				;1 = VIN+ < VIN-
				;0 = VIN+ > VINbit
				;5 Unimplemented: Read as 0
				;bit 4 CINV: Comparator Output Inversion bit
				;1 = Output inverted
				;0 = Output not inverted
				;bit 3 CIS: Comparator Input Switch bit
				;When CM2:CM0 = 110 or 101:
				;1 = VIN- connects to CIN+ (GP0)
				;0 = VIN- connects to CINbit (GP1)
				;2-0 CM2:CM0: Comparator Mode bits
				;Figure 6-2 shows the Comparator modes and 
				;    CM2:CM0 bit settings
				;FIGURE 6-2: COMPARATOR I/O OPERATING MODES
				;Note: Comparator interrupts should be disabled
				;during a Comparator mode change.
				;Otherwise, a false interrupt may occur.
				;Comparator Reset (POR Default Value  Low Power)         	
				;CM<2:0> = 000
				;                                                 
				;Comparator Off (Lowest Power)
				;CM<2:0> = 111

				;Comparator without Output                                	
				;CM<2:0> = 010 							
				;
				;Comparator w/o Output and with Internal Reference
				;CM<2:0> = 100
				;
				;Comparator with Output and Internal Reference 			
				;CM<2:0> = 011 							
				;
				;Multiplexed Input with Internal Reference and Output
				;CM<2:0> = 101
				;
				;Comparator with Output 					
				;CM<2:0> = 001 	
				
				;Multiplexed Input with Internal Reference
				;CM<2:0> = 110
				;
	IFDEF	INTCONinit
	 movlw	INTCONinit						
	 movwf	INTCON		
	ENDIF			;
				;REGISTER 2-3: INTCON  INTERRUPT CONTROL REGISTER 
				;(ADDRESS: 0Bh OR 8Bh)
				;Note: Interrupt flag bits are set when an interrupt
				;condition occurs, regardless of the state of
				;its corresponding enable bit or the global
				;enable bit, GIE (INTCON<7>). User software
				;should ensure the appropriate
				;interrupt flag bits are clear prior to enabling
				;an interrupt.
				;R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;GIE PEIE T0IE INTE GPIE T0IF INTF GPIF
				;bit 7 bit 0
				;bit 7 GIE: Global Interrupt Enable bit
				;1 = Enables all unmasked interrupts
				;0 = Disables all interrupts
				;bit 6 PEIE: Peripheral Interrupt Enable bit
				;1 = Enables all unmasked peripheral interrupts
				;0 = Disables all peripheral interrupts
				;bit 5 T0IE: TMR0 Overflow Interrupt Enable bit
				;1 = Enables the TMR0 interrupt
				;0 = Disables the TMR0 interrupt
				;bit 4 INTE: GP2/INT External Interrupt Enable bit
				;1 = Enables the GP2/INT external interrupt
				;0 = Disables the GP2/INT external interrupt
				;bit 3 GPIE: Port Change Interrupt Enable bit(1)
				;1 = Enables the GPIO port change interrupt
				;0 = Disables the GPIO port change interrupt
				;bit 2 T0IF: TMR0 Overflow Interrupt Flag bit(2)
				;1 = TMR0 register has overflowed 
				;	(must be cleared in software)
				;0 = TMR0 register did not overflow
				;bit 1 INTF: GP2/INT External Interrupt Flag bit
				;1 = The GP2/INT external interrupt occurred 
				;	(must be cleared in software)
				;0 = The GP2/INT external interrupt did not occur
				;bit 0 GPIF: Port Change Interrupt Flag bit
				;1 = When at least one of the GP5:GP0 pins changed state 
				;	(must be cleared in software)
				;0 = None of the GP5:GP0 pins have changed state
	banksel	Bank1
	IFDEF	IOCinit
	 movlw	IOCinit
	 			;movlw	b'00000000'	;disable interrupt on change
	 movwf	IOC
	ENDIF
				;REGISTER 3-4: IOC  INTERRUPT-ON-CHANGE GPIO REGISTER 
				;		(ADDRESS: 96h)
				;Note: If a change on the I/O pin should occur
				;when the read operation is being executed
				;(start of the Q2 cycle), then the GPIF interrupt
				;flag may not get set.
				;U-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;       IOC5  IOC4  IOC3  IOC2  IOC1  IOC0
				;bit 7 bit 0
				;bit 7-6 Unimplemented: Read as 0
				;bit 5-0 IOC<5:0>: Interrupt-on-Change GPIO Control bit
				;1 = Interrupt-on-change enabled
				;0 = Interrupt-on-change disabled
				;Note 1: Global interrupt enable (GIE) must be enabled 
				;for individual interrupts to be
				;recognized.
	IFDEF	WPUinit
	 movlw	WPUinit
	ELSE
	movlw	b'00000000'	;disable weak pullup 
	ENDIF
	movwf	WPU
	IFDEF	VRCONinit
	 movlw	VRCONinit
	movwf	VRCON
	
					;REGISTER 6-2: 
					;VRCON  VOLTAGE REFERENCE CONTROL REGISTER 
					;(ADDRESS: 99h)
					;R/W-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
					;VREN      VRR        VR3   VR2   VR1   VR0
					;
					;bit 7 VREN: CVREF Enable bit
					;1 = CVREF circuit powered on
					;0 = CVREF circuit powered down, no IDD drain
					;bit 6 Unimplemented: Read as '0'
					;bit 5 VRR: CVREF Range Selection bit
					;1 = Low range
					;0 = High range
					;bit 4 Unimplemented: Read as '0'
					;bit 3-0 VR3:VR0: 
					;CVREF value selection 0 = VR [3:0] = 15
					;When VRR = 1: CVREF = (VR3:VR0 / 24) * VDD
					;When VRR = 0: CVREF = VDD/4 + (VR3:VR0 / 32) * VDD
 	ENDIF
	Banksel	Bank0
	IFDEF	PIR1init
	 movlw	PIR1init
	movwf	PIR1
	ENDIF
			;REGISTER 2-5: PIR1  PERIPHERAL INTERRUPT REGISTER 1 (ADDRESS: 0Ch)
			;Note: Interrupt flag bits are set when an interrupt
			;condition occurs, regardless of the state of
			;its corresponding enable bit or the global
			;enable bit, GIE (INTCON<7>). User
			;software should ensure the appropriate
			;interrupt flag bits are clear prior to enabling
			;an interrupt.
			;R/W-0 R/W-0 U-0 U-0 R/W-0 U-0 U-0 R/W-0
			;EEIF ADIF   CMIF   TMR1IF
			;bit 7 bit 0
			;bit 7 EEIF: EEPROM Write Operation Interrupt Flag bit
			;1 = The write operation completed (must be cleared in software)
			;0 = The write operation has not completed or has not been started
			;bit 6 ADIF: A/D Converter Interrupt Flag bit (PIC12F675 only)
			;1 = The A/D conversion is complete (must be cleared in software)
			;0 = The A/D conversion is not complete
			;bit 5-4 Unimplemented: Read as 0
			;bit 3 CMIF: Comparator Interrupt Flag bit
			;1 = Comparator input has changed (must be cleared in software)
			;0 = Comparator input has not changed
			;bit 2-1 Unimplemented: Read as 0
			;bit 0 TMR1IF: TMR1 Overflow Interrupt Flag bit
			;1 = TMR1 register overflowed (must be cleared in software)
			;0 = TMR1 register did not overflow
			;
	

	endm




ADCON206	macro	port
		local	loop100, exitloop100
	
	IFNDEF	STACK
	#define STACK _MAXRAM
	ENDIF

	
		bcf	GPIO,port	; 

		if port == 1
		 movlw	GP1_Porton     ; configure comparator input
		endif
		if port == 0
		movlw	GP0_Porton
		 endif
		movwf	CMCON0

		clrwdt
		ifdef	shdwTRISIO
		 movlw	((1<<port)) 
		 iorwf	shdwTRISIO,F 
		 movfw	shdwTRISIO   
		else
		 ifdef	TRISIOinit;    IOdir
		   movlw	((1<<port) ) | TRISIOinit;    IOdir
		 else
		   movlw	b'00001011'
		 endif
		endif
		bsf	CMCON0,CMPON	; comparator on

		clrf	STACK
		clrf	STACK-1		; 2 us
loop100		btfsc	CMCON0,CMPOUT  	;btfss	GPIO,port
		 goto	exitloop100test
		incfsz	STACK-1,F
		 goto	loop100		;timeout 1000us	
		incfsz	STACK,F
		 goto	loop100
		decf	STACK,F
		decf	STACK-1,F

exitloop100	bcf	CMCON0,CMPON	;comparator off
		bcf	GPIO,port			;test		
		ifdef	shdwTRISIO
		 movlw	(0x0F - (1<<port)) 
		 andwf	shdwTRISIO 
		 movfw	shdwTRISIO   
		else
		 ifdef	TRISIOinit;    IOdir
		   movlw	(0x0F - (1<<port) ) & TRISIOinit;    IOdir
		 else
		   movlw	b'00001011'
		 endif
		endif				; 
		TRIS	TRISGPIO
	endm	


ADCON206B		macro	port
				
		if port == 1
		 movlw	GP1_Porton     ; configure comparator input
		endif
		if port == 0
		movlw	GP0_Porton
		 endif
		movwf	CMCON0

		clrwdt
		ifdef	shdwTRISIO
		 movlw	((1<<port)) 
		 iorwf	shdwTRISIO,F
		 movfw	shdwTRISIO   
		else
		 ifdef	TRISIOinit;    IOdir
		   movlw	((1<<port) ) | TRISIOinit;    IOdir
		 else
		   movlw	b'00001011'
		 endif
		endif

		TRIS	TRISGPIO	;charge C
		mov	TMR0,STACK
		btfsc	CMCON0,CMPOUT  	;btfss	GPIO,port
		 goto	$-1
		sub	STACK,TMR0,STACK
		goto	okmes
afterwdt	eq	STACK,.255	
okmes		bcf	GPIO,port			;
		ifdef	shdwTRISIO
		 movlw	(0x0F - (1<<port)) 
		 andwf	shdwTRISIO,F
		 movfw	shdwTRISIO   
		else
		 ifdef	TRISIOinit;    IOdir
		   movlw	(0x0F - (1<<port) ) & TRISIOinit;    IOdir
		 else
		   movlw	b'00001011' & (0x0F - (1<<port))
		 endif	
		endif			; 
		TRIS	TRISGPIO
					; discharge C for next measurement
		endm


if_VLT29gtr	macro	Volt,port
		local	loop100, exitloop100,testloop
	


		if Volt > VDD / 4 
		 movlw	b'10000000' + (Volt*32 / VDD ) - (VDD/4)	; VREF ON,HIGH RANGE		
		else
		 movlw	b'10100000' + (Volt * 24 /VDD)		; Low Range
		endif
		banksel	Bank1
		movwf	VRCON
		banksel	Bank0
					;REGISTER 6-2: 
					;VRCON  VOLTAGE REFERENCE CONTROL REGISTER 
					;(ADDRESS: 99h)
					;R/W-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
					;VREN      VRR        VR3   VR2   VR1   VR0
					;
					;bit 7 VREN: CVREF Enable bit
					;1 = CVREF circuit powered on
					;0 = CVREF circuit powered down, no IDD drain
					;bit 6 Unimplemented: Read as '0'
					;bit 5 VRR: CVREF Range Selection bit
					;1 = Low range
					;0 = High range
					;bit 4 Unimplemented: Read as '0'
					;bit 3-0 VR3:VR0: 
					;CVREF value selection 0 = VR [3:0] = 15
					;When VRR = 1: CVREF = (VR3:VR0 / 24) * VDD
					;When VRR = 0: CVREF = VDD/4 + (VR3:VR0 / 32) * VDD
 
		if port == 1
		 movlw	GP1_Porton     ; configure comparator input
		endif
		if port == 0
		movlw	GP0_Porton
		 endif
		movwf	CMCON
		goto	$+1
		goto	$+1
		goto	$+1
		btfsc	CMCON,6
	endm

if_VLT29lwr	macro	Volt,port
		local	loop100, exitloop100,testloop

		if Volt > VDD / 4 
		 movlw	b'10000000' + (Volt*32 / VDD ) - (VDD/4)	; VREF ON,HIGH RANGE		
		else
		 movlw	b'10100000' + (Volt * 24 /VDD)		; Low Range
		endif
		banksel	Bank1
		movwf	VRCON
		banksel	Bank0
		if port == 1
		 movlw	GP1_Porton     ; configure comparator input
		endif
		if port == 0
		movlw	GP0_Porton
		 endif
		movwf	CMCON
		goto	$+1
		goto	$+1
		goto	$+1
		btfss	CMCON,6
	endm



ADCON629	macro	port
		local	loop100, exitloop100,testloop

		movlw	b'10101000'
		banksel	Bank1
		movwf	VRCON
		banksel	Bank0
					;REGISTER 6-2: 
					;VRCON  VOLTAGE REFERENCE CONTROL REGISTER 
					;(ADDRESS: 99h)
					;R/W-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
					;VREN      VRR        VR3   VR2   VR1   VR0
					;
					;bit 7 VREN: CVREF Enable bit
					;1 = CVREF circuit powered on
					;0 = CVREF circuit powered down, no IDD drain
					;bit 6 Unimplemented: Read as '0'
					;bit 5 VRR: CVREF Range Selection bit
					;1 = Low range
					;0 = High range
					;bit 4 Unimplemented: Read as '0'
					;bit 3-0 VR3:VR0: 
					;CVREF value selection 0 = VR [3:0] = 15
					;When VRR = 1: CVREF = (VR3:VR0 / 24) * VDD
					;When VRR = 0: CVREF = VDD/4 + (VR3:VR0 / 32) * VDD
 
		if port == 1
		 movlw	GP1_Porton     ; configure comparator input
		endif
		if port == 0
		movlw	GP0_Porton
		 endif
		movwf	CMCON

				
;		movbit	CMCON,6, GPIO,4
;		eq	STACK,.15		
;testloop	if_not	CMCON,6		; VREF < VIN
;		 goto	exitloop100
;		inc_	VRCON		,(byte)
;		goto	$+1
;		goto	$+1
;		goto	$+1
;		goto	$+1
;
;		
;		decfsz	STACK,F
;		 goto	testloop
;		goto	exitloop100
;;
		bcf	GPIO,port	;

		ifdef	TRISIOinit;    IOdir
		movlw	((1<< port) ^ 0xFF) & TRISIOinit;    IOdir
		else
		movlw	((1<< port) ^ 0xFF) & b'00001011'
		endif
		call	subtrisio

		movlw	.4
		movwf	STACK		; 15 us
		decfsz	STACK,F
		 goto	$-1		; 
		clrwdt

		ifdef	TRISIOinit;    IOdir
		 movlw   TRISIOinit;    IOdir | (1<<port)
		else
		movlw	b'00001011'
		endif			;  GP,x is input
		call	subtrisio
		
		clrf	STACK
		clrf	STACK-1		; 2 us
loop100		btfsc	CMCON,6 	;btfss	GPIO,port
		 goto	exitloop100
		incfsz	STACK-1,F
		 goto	loop100		
		clrwdt			;timeout 1000us	
		incfsz	STACK,F
		 goto	loop100
		decf	STACK,F
		decf	STACK-1,F	
exitloop100	bsf	CMCON,0		;comparator off



;		mov	VRCON,STACK-1
;		bcf	GPIO,port			;test		
;		movlw	((1<< port) ^ 0xFF) & TRISIOinit;    IOdir;test
;		BANKSEL	Bank1		; BANK1
;		movwf	TRISIO		; 
;		banksel	Bank0		; let C charge
; 		discharge C	;test

	endm




delay	macro	Cycles
 variable CyclesLeft ,LoopCycles,d_used           ;  Keep Track of Remaining Cycle
 local	iloop
CyclesLeft = Cycles

	if CyclesLeft > .327680 ; 0x5 * 0xffff
d_used = 3
	else
	 if Cycles > 3*0xFF
d_used = 2
	 else
d_used = 1
	 endif
	endif


	if	d_used == 3
LoopCycles = (Cycles-6-.10) / 7
CyclesLeft = (Cycles-6-.10) - (LoopCycles*7)

	endif
	if	d_used == 2
LoopCycles = (Cycles-4-6) / 5
CyclesLeft = (Cycles-4-6) - (LoopCycles*5)
	
	endif


  if Cycles >=5
	if	d_used == 1
LoopCycles = (Cycles-2-2) / 3
CyclesLeft = (Cycles-2-2) - (LoopCycles*3)
	endif

 	movlw   (LoopCycles & 0xFF)+1
  	movwf   STACK-0
	if d_used >=2
 	movlw   ((LoopCycles>>8) & 0xFF)+1
  	movwf   STACK-1
	endif
	if d_used >=3
	if ((LoopCycles>>.16) > .255 )
 error "Required Delay is longer than 'delay' Macro can support"
	endif
 	movlw   ((LoopCycles>>.16) & 0xFF)+1
  	movwf   STACK-2
	endif
iloop
 	if d_used >=3
	 goto	$+1 
	endif
 	if d_used >=2
	 goto	$+1 
	endif

  	decfsz  STACK-0,F
   	 goto	iloop
 	if d_used >=2
  	decfsz  STACK-1,F
   	 goto	iloop+1
	endif
	if d_used >=3	
	decfsz  STACK-2,F
   	 goto	iloop+2
	endif
	

  endif

 while CyclesLeft >= 2          ;  Put in 2 Instruction Cycle Delays
  	goto    $ + 1
CyclesLeft = CyclesLeft - 2
 endw
 if CyclesLeft == 1             ;  Put in the Last Required Cycle
  	nop
 endif
        endm

; asmDlay Myke Predko 04.09.22



dlay Macro Cycles
 variable CyclesLeft            ;  Keep Track of Remaining Cycles
 variable LargeNum

	
	IFNDEF	STACK
	#define STACK _MAXRAM
	ENDIF


CyclesLeft = Cycles

 local LongLoop
 if Cycles > 0x04FFFF00         ;  Can't Handle the Anything > 83 Seconds (@ 4 MHz)
 error "Required Delay is longer than 'Dlay' Macro can support"
 endif
 if Cycles > .327681             ;  Need Large Loop?  
LargeNum = CyclesLeft / .327681
  movlw   LargeNum
  movwf   STACK-2         ;  Calculate Number of Loops
LongLoop:                       ;  Repeat for Each Loop
  clrf    STACK-1         ;  Do Maximum Possible Loop Count
  clrf    STACK-0
  decf    STACK-0, f
  btfsc   STATUS, Z
   decfsz STACK-1, f
    goto  $ - 3
  decfsz  STACK-2, f      ;  Repeat Loop
   goto   LongLoop
CyclesLeft = CyclesLeft - ((LargeNum * .327681) + 1 + (LargeNum * 3))
 endif  ;  Need Large Loop

 if Cycles > .14                 ;  Will a Loop be required? 
;	movlw	CyclesLeft
  movlw   high (((CyclesLeft - 3) / 5) + .256)
  movwf   STACK-1
  movlw   low (((CyclesLeft - 3)/ 5) + .256)
  movwf   STACK-0
  decf    STACK-0, f          ;  5 Cycle Constant Delay Loop
  btfsc   STATUS, Z
   decfsz STACK-1, f
    goto  $ - 3
CyclesLeft = CyclesLeft - (3 + (5 * ((CyclesLeft - 3)/ 5)))
 endif                          ;  Finished with Loop Code

 while CyclesLeft >= 2          ;  Put in 2 Instruction Cycle Delays
  goto    $ + 1
CyclesLeft = CyclesLeft - 2
 endw
 if CyclesLeft == 1             ;  Put in the Last Required Cycle
  nop
 endif
 endm


Xtrap206	macro	var,unit,UseReg,TrapVector,bits
	local EX14
	variable sign
  if	bits	< 0
sign = -1
  else
sign = 1
  endif
	if unit == msec 
	eq	STACK,.2
	endif
	if unit == sec
	eq 	STACK,.12			;
	endif

;	if sign < 0
;	movlw	var & 0xFF
;	movwf	UseReg
;	movlw	var >>8
;	movwf	UseReg+1	; or mov	var+1,UseReg+1
;	else
;	 
;	endif

	eq_	UseReg,=,var,bits
	if bits == -.8 
	 clrf	UseReg+1
	endif




;	ifdef	shdwOPTION		; else assumes TMRO running 1:1
;        
;	 if_bit	shdwOPTION,3
;          goto	EX14
;
;	  movlw b'00000111'
;	  andwf	shdwOPTION,W
;	  subwf	STACK,F
;	  decf	STACK,F	  	; 1:2
;	else

;	ifdef	OPTION_init		; else assumes TMRO running 1:1
;        
;	 if ! OPTION_init & 1>>3
;          
;
;	  movlw b'00000111' & Option_init
;
;	  subwf	STACK,F
;	  decf	STACK,F	  	; 1:2
;	 endif
;	endif

;	endif
EX14	
	clrC
	rlf UseReg,F
	rlf UseReg+1,F
	decfsz	STACK,F
	 goto EX14

        movf	UseReg,F
	skpZ
          incf  UseReg+1,F
	movlw	TrapVector
	movwf	TmrVector
    endm

ctrap206 macro  UseReg
		if_bit	TMR0,7
	 	 goto	t7hi
		if_bit	SystemStatus,7
	  	 bsf	SystemStatus,6     	; Timer0 Interrrupt Overflow Flag
		bcf	SystemStatus,7 		; replacement for test TMR0IF
		if_not	SystemStatus,6
		 retlw	0
		bcf	SystemStatus,6
		decfsz	UseReg,F
		 retlw 0
		decfsz	UseReg+1,F
		 retlw 0
		movfw	TmrVector
		movwf	PCL				; must run into a retlw 0!
t7hi		bsf    SystemStatus,7    	; Timer0 bit 7 copy
		retlw 0
	 endm	




Xtrap	macro	var,unit,UseReg,TrapVector,bits
	local EX14
	variable sign
  if	bits	< 0
sign = -1
  else
sign = 1
  endif
	if unit == msec 
	eq	STACK,.2
	endif
	if unit == sec
	eq 	STACK,.12			;
	endif

;	if sign < 0
;	movlw	var & 0xFF
;	movwf	UseReg
;	movlw	var >>8
;	movwf	UseReg+1	; or mov	var+1,UseReg+1
;	else
;	 
;	endif

	eq_	UseReg,=,var,bits
	if bits == -.8 
	 clrf	UseReg+1
	endif


	banksel	OPTION_REG
	if_bit	OPTION_REG,3
	 goto EX14

	  movlw b'00000111'
	  andwf	OPTION_REG,W
	banksel Bank0
	  subwf	STACK,F
	  decf	STACK,F	  	; 1:2

EX14	
	Banksel Bank0
	clrC
	rlf UseReg,F
	rlf UseReg+1,F
	decfsz	STACK,F
	 goto EX14

        movf	UseReg,F
	skpZ
          incf  UseReg+1,F
	movlw	TrapVector
	movwf	TmrVector
    endm

ctrap macro  UseReg
;		if_bit	TMR0,7
;	 	 goto	t7hi
;		if_bit	SystemStatus,7
;	  	 bsf	SystemStatus,6     	; Timer0 Interrrupt Overflow Flag
;		bcf	SystemStatus,7 		; replacement for test TMR0IF
;		if_not	SystemStatus,6
	        if_not	TMR0IF
		 retlw	0
		bcf	TMR0IF
;		bcf	SystemStatus,6
		decfsz	UseReg,F
		 retlw 0
		decfsz	UseReg+1,F
		 retlw 0
		movfw	TmrVector
		movwf	PCL				; must run into a retlw 0!
t7hi		bsf    SystemStatus,7    	; Timer0 bit 7 copy
		retlw 0
	 endm	



if_C	macro	
	 btfsc	STATUS,C
	endm
if_NC   macro	
	 btfss	STATUS,C
	endm
if_Z	macro	
	 btfsc	STATUS,Z
	endm
if_NZ   macro	
	 btfss	STATUS,Z
	endm

if_b	macro	base,bit
	if	base >= Bank1 
	   error "macro not for variables > Bank0 !"
	endif
	 btfsc	base,bit
	endm
if_not	macro	base,bit
	if	base >= Bank1 
	   error "macro not for variables > Bank0 !"
	endif 
	 btfss	base,bit
	endm
#define elseif 0xFF
#define _ 0x00
#define nil 0x00

i_f	macro	base,bit,then,macro1,elsif,macro2
	  local	ex1,ex2
	  btfss base,bit
           if elsif == elseif
	    goto ex1
	   else
            goto ex2
	   endif
	macro1
	if elsif == elseif
	  goto ex2 
ex1	macro2
        endif
ex2
	endm


if_bit	macro	base,bit
	 btfsc	base,bit
	endm

i_f_not	macro	base,bit,then,macro1,elsif,macro2
	  local	ex1,ex2
	  btfsc base,bit
           if elsif == elseif
	    goto ex1
	   else
            goto ex2
	   endif
	macro1
	if elsif == elseif
	  goto ex2 
ex1	macro2
        endif
ex2
	endm
;************************************************************
else_m  macro
elseflag#v(level-1)=1
 goto	elselab#v(elabcount)
 
iflab#v(ifflag#v(level-1))	
;ilabcount+=1
	;andlw	ifflag#v(level-1)
	endm
;************************************************************
end_m   macro
	if elseflag#v(level-1) != 0

elselab#v(elabcount)
elseflag#v(level-1) = 0
elabcount +=1 

	else
	 ;andlw	ifflag#v(level-1)
iflab#v(ifflag#v(level-1))
;ilabcount+=1

       endif


level-=1
;	 if level==0
;ilabcount+=maxlevel
;maxlevel=0
;	 endif
	endm
;************************************************************

pwmdisplay	macro	port

		goto	floop
flip		movlw	1<<port
		xorwf	GPIO
		comf	ALT,F
		movfw	ALT
		movwf	TMR0
		retlw	0


floop		if__	TMR0,7 ,not_but, STATUS,DC
		 call flip
		movbit	TMR0,7,  STATUS,DC
		if_	TMR0, grtr, .240
		 goto floop

		movfw	AL
		if_b	GPIO,port
		 comf	AL,W
		movwf	ALT
		endm

#define		INPUT 	1
#define		OUTPUT	0

make		macro	port,in_or_out

		IF	in_or_out == OUTPUT
		
		
			IFDEF __10F206 
			 ifdef	shdwTRISIO
			  movlw	1<<port
			  iorwf	shdwTRSISIO,F
			  movfw	shdwTRISIO
			 else 
			  IFDEF	TRISIOinit;    IOdir			
 			   movlw	TRISIOinit & (0xFF - (1<<port))
			  ELSE
			   movlw	b'00001011'& (0xFF - (1<<port));
			  ENDIF
			 endif 
			 TRIS 	TRISGPIO
			ELSE
			 banksel TRISIO
			 bcf	 TRISIO,port
			 banksel Bank0
			ENDIF
		ENDIF
		
		IF	in_or_out == INPUT		
			IFDEF __10F206 
			 ifdef	shdwTRISIO
			  movlw	1<<port
			  iorwf	shdwTRSISIO,F
			  movfw	shdwTRISIO
			 else 
			  IFDEF	TRISIOinit;    IOdir			
 			   movlw	TRISIOinit | ( 1<<port)
			  ELSE
			   movlw	b'00001011'| ( 1<<port);
			  ENDIF
			 endif 
			 TRIS 	TRISGPIO
			ELSE
			 banksel TRISIO
			 bsf	 TRISIO,port
			 banksel Bank0
			ENDIF

		ENDIF

		endm

	
init_andis macro
		cblock
	 	 DispCounter:2,DisprVector,x
		endc
	   endm

	
black	macro	Gbit
	make	Gbit, INPUT	; port  input = black
	endm   
red	macro   Gbit
	bcf	GPIO,Gbit
	make	Gbit, OUTPUT    ; port  output,LOW = red
	endm
blue	macro   Gbit
	bsf	GPIO,Gbit
	make	Gbit, OUTPUT	; port  output,HIGH = blue
	endm


anadis	macro	port, hicolor, locolor, offcolor
	decfsz	DispCounter,F
	 goto	disp_xit
	decfsz	DispCounter+1,F
	 goto   disp_xit
 
	movfw	DisprVector
	movwf	PCL



initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	INDF,W
	bNZ	long			; its a 1, start display
	clrC
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway

strtdis	movfw	x
	andwf	INDF,W
	skpZ	
	 goto	long
	settrap .100,msec,pause,DispCounter,DisprVector
	locolor port
 	goto disp_xit

long	settrap .400,msec,pause,DispCounter,DisprVector
 	hicolor port
 	goto disp_xit	

pause	settrap .200,msec,rsmedis,DispCounter,DisprVector
	offcolor port
 	goto disp_xit
 	
rsmedis	clrC
	rrf	x,F	;	next bit?
	bNC	strtdis	
	
	settrap .5,sec,initdis,DispCounter,DisprVector

;
;
disp_xit
	endm


pwanadis	macro	
	decfsz	DispCounter,F
	 goto	disp_xit
	decfsz	DispCounter+1,F
	 goto   disp_xit
 
	movfw	DisprVector
	movwf	PCL



initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	INDF,W
	bNZ	long			; its a 1, start display
	clrC
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway

strtdis	movfw	x
	andwf	INDF,W
	skpZ	
	 goto	long
	settrap .250,msec,pause,DispCounter,DisprVector
loco		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	   
 	goto disp_xit

long	settrap .900,msec,pause,DispCounter,DisprVector
 	goto	loco      ;hicolor port
 	goto disp_xit	

pause	settrap .200,msec,rsmedis,DispCounter,DisprVector
	 	movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
 	goto disp_xit
 	
rsmedis	clrC
	rrf	x,F	;	next bit?
	bNC	strtdis	
	
	settrap .5,sec,initdis,DispCounter,DisprVector

;
;
disp_xit
	endm


	
#define		DOWN	10
#define		UP	11
#define		DOWN_UP	12
#define		UP_DOWN	13

wait		macro	bit, up_or_down
			if (up_or_down == DOWN) | (up_or_down == DOWN_UP)
			 btfsc	GPIO,bit		
			  goto	$-1
			endif
			if (up_or_down == UP) | (up_or_down == UP_DOWN)
			 btfss	GPIO,bit		
			  goto	$-1
			endif
			if (up_or_down == DOWN_UP)
			 btfss	GPIO,bit		
			  goto	$-1
			endif
			if (up_or_down == UP_DOWN)
			 btfsc	GPIO,bit		
			  goto	$-1
			endif

		endm

#define		HIGH_	1
#define		LOW_	0


output		macro port,high_or_low
			if high_or_low = LOW_
			 bcf	GPIO,port 
			else
			 bsf	GPIO,port
			endif
		endm

bitdisplay	macro	port,clock,register

		make	port,INPUT
		mov	register, STACK-1
		wait	clock,DOWN_UP		;i2c start
		eq	STACK,.8
nextbit		wait	clock,DOWN		;i2c change allowed
		shl	STACK-1
		movbit	STATUS,C,GPIO,port
		
		make	port,OUTPUT		; manual display
		wait	clock,UP
		make	port,INPUT		; manual display
	
		decfsz	STACK,F
		 goto	nextbit
	;	make	port,INPUT		; i2c display
		endm

;*********************************************************************************


;************************************************************* 

movEEAdl macro	data1	
		
		movlw	data1
		banksel	EEADR	
		movwf	EEADR
	endm	
movEEDtl	macro	data1	

		movlw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm


movEEDt	macro	data1	
		banksel	data1
		movfw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm

movEEAD	macro	adr, data1
		banksel	adr
		movfw	adr
		banksel	EEADR	
		movwf	EEADR
		banksel	data1
		movfw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm
readEE	macro	adrl,var

		banksel	EEADR
		movlw	adrl
		movwf	EEADR
		bsf	EECON1,RD
		movfw	EEDAT
		banksel	var
		movwf	var
	endm

readEEDAT	macro	adrl

		banksel	EEADR
		movlw	adrl
		movwf	EEADR
		bsf	EECON1,RD
		endm


wrtEE	macro
		BSF	EECON1,WREN		; Bank1 is selected after MovEE macros
	;	banksel 0
	;	BCF	INTCON,GIE		;if fworking with interrupts
	;	BTFSC	INTCON,GIE
	;	 GOTO	$-2
	;	banksel 1
		MOVLW	55h
		MOVWF	EECON2
		MOVLW	0xAA
		MOVWF	EECON2
		BSF	EECON1,WR
		btfsc   EECON1,WR		;  write finished?
		 goto 	$-1

		bcf 	EECON1,WREN		;
	;	banksel	INTCON			; enable interrupts
	;	BSF	INTCON,GIE
	endm	
	;return
	



mov_w	macro Source
		if Source < Bank1
		 movfw	Source
		else
		 if Source < 0x1000
		  banksel	Bank1
		  movfw	Source
		  banksel	Bank0
		 else
		  banksel	EEADR
		  if Source < 0xFFFF
		  movlw	Source & 0xFF
		  movwf	EEADR
		  endif
		  bsf	EECON1,RD
		  movfw	EEDAT
		  banksel Bank0	
		 endif
		endif
	endm


mov_f macro Target
		
		if Target < Bank1
		 movwf	Target
		else
		 if Target < 0x1000
		  banksel	Bank1
		  movwf	Target
		  banksel	Bank0
		 else
		  if	used_EEPROM==0 
		   goto $+.11
cwrtEE		  wrtEE
		  return
used_EEPROM=1
		  endif

		  banksel	EEDAT	
		  movwf	EEDAT
		  if Target < 0xFFFF
		  movlw	Target & 0xFF
		  movwf EEADR
		  endif
		  call	cwrtEE
		  banksel Bank0
		 endif
		endif
	endm


mov	macro Source, Target

	 mov_w Source
	 mov_f Target
	endm


#define	bit		.1
#define	byte		.8;
#define	word		.16;
#define	wordbyte	.24;
#define	bit24		.24;
#define	longint		.32;
#define	bit32		.32;
#define	byteconst	-.8;
#define	lit8		-.8;
#define	wordconst	-.16;
#define	lit16		-.16;
#define	wordbyteconst	-.24;
#define	lit24		-.24;
#define	longintconst	-.32;
#define	lit32		-.32;

mov_	macro Source, Target, bits
	 variable	bitc
bitc = 0
	while bitc<bits
	  if Source == INDF
	   mov Source, Target + (bitc / 8)
	  else
	   if Target == INDF
	    mov Source+ (bitc / 8), Target
           else 
 	    mov	Source+(bitc / 8), Target + (bitc / 8)
	   endif
	  endif
bitc += 8
	 if ((Source == INDF) | (Target==INDF)) & (bitc < bits)
	   incf	FSR,F
	  endif 
 
	endw
bitc=8
	 if ((Source == INDF) | (Target==INDF)) 
	   while (bitc < bits)
	   decf	FSR,F
bitc +=8
	   endw
	  endif 
 
	endm

	
clrf_	macro Target, bits
	 variable	bitc

	 if Target >= 0x1000 
bitc = 0
	  while bitc<bits
	   movlw	0
	   mov_f Target+ (bitc / 8)			
bitc += 8
	  endw

	 else

	  if Target >= Bank1 
	   banksel Bank1
          endif
bitc = 0
	while bitc<bits
	 if Target == INDF
	  clrf	Target
	 else 
	  clrf	Target+ (bitc / 8)
	 endif
bitc += 8
	 if (Target== INDF) & (bitc < bits)
	  incf	FSR,F
	 endif
	endw

	  if Target >= Bank1 
	   banksel Bank0 	
          endif
	 endif
bitc=8
	 if (Target==INDF) 
	   while (bitc < bits)
	   decf	FSR,F
bitc +=8
	   endw
	  endif 

	endm



eq_ 	    macro var, EqualSign,val,bits
		variable	bitc,const
	variable sign
 variable _aai = 7, _aaj

const = val
 
_aaj EqualSign _aai
 if (_aai != _aaj)
  error "No Equals ('=') in Assignment Statement
 else                        ;  Equals Present	
	
  if	bits	< 0
sign = -1
  else
sign = 1
  endif
  
  if sign > 0		     ; variables
   mov_	val,var, bits
  else
		
   if const == 0  	     ;clrf
    clrf_ var,-bits	
   else

    if var >= 0x1000 		; EEPROM
bitc = 0
     while bitc<bits*sign
      movlw (const >> bitc ) & 0xFF
      mov_f var+ (bitc / 8)		; 
bitc += 8
     endw
    else
     if var >= Bank1 
      banksel Bank1
     endif	
bitc = 0
     while bitc<bits*sign
       if (const >>bitc) & 0xFF
	movlw	(const >> bitc ) & 0xFF
   	if var == INDF
	 movwf	INDF
	else
        movwf	var+ (bitc / 8)
	endif
       else
        if var == INDF
	 clrf INDF
	else
	 clrf	var+ (bitc / 8)
	endif
       endif
bitc += 8

 	if (var == INDF) & (bitc < bits*sign)
	  incf	FSR,F
	 endif
     endw
     if var >= Bank1 
      banksel Bank0
     endif
bitc=8
     if (var==INDF) 
	   while (bitc < bits*sign)
	   decf	FSR,F
bitc +=8
     	   endw
     endif
    endif			;EEPROM  
   endif		; clrf
  endif		; variables
 endif		; Equals present
 
 	    endm

eq	macro	var, val
	    eq_ var,=, val,lit8
	endm


e_q 	    macro var,lB,index,bits,rB,val,bitorlit


	if (bits>0) & (bits <7)	;table call
 
bitc =0
	while	bitc<bits
	  if bitorlit < 0
		movlw	index+bitc
	  else
	      if bitc >0
		movlw bitc
	        addwf index
	      else
		movfw
	      endif
	  endif
	  call index
	  movw_f var
bitc+=1
	 endw


else
	
	  if	bitorlit	< 0	; index is constant
	    eq_ var+index,=,val,bits 
	  else	
	     if var >= 0x1000
		mov_w	index
		banksel	EEADR
		movwf	EEADR
		movlw	var & 0xFF
		addwf   EEADR,F	
		banksel	Bank0
		eq_	0xFFFF,=,val,bits
	     else		
		movlw var
		movwf FSR
		movfw index
		addwf FSR,F
		eq_	INDF,=,val,bits
	      endif
	
	  endif
	
	endif		;  
 endm


e_q_ 	    macro var,lB,index,bits,rB,val,bitorlit


; else
;   if index >= 0x1000
;	mov_w	val
;	banksel	EEADR
;	movwf	EEADR
;	movlw	index & 0xFF
;	addwf   EEADR,F	
;	banksel	Bank0
;	eq_	var,=,0xFFFF,bits
;     else		
;	movlw index
;	movwf FSR
;	movfw val
;	addwf FSR,F
;	eq_   var,=,INDF,bits
;      endif
;                        
 	
	endm


suball  macro	Diff, SubEnd
		if SubEnd < Bank1 
		 if Diff != SubEnd
		  subwf	SubEnd,W
		 else
		  subwf SubEnd,F
		 endif
		else
		 if SubEnd < 0x1000
		 Banksel Bank1
		 if Diff != SubEnd
		  subwf	SubEnd,W
		 else
		  subwf SubEnd,F
		 endif
		 Banksel Bank0
		 else
		  movwf	STACK
		  banksel	EEADR
		  movlw	SubEnd & 0xFF
		  movwf	EEADR
		  bsf	EECON1,RD
		  banksel	Bank0
		  movfw	STACK
		  Banksel Bank1
		  if Diff != SubEnd
		  subwf	EEDAT,W
		 else
		  subwf EEDAT,F
		  call	wrtEE
		 endif
		  banksel Bank0
		 endif
                endif
	endm

sub	macro	Diff, SubEnd, SubTor



		mov_w	SubTor
		suball	Diff,SubEnd
		if	Diff != SubEnd
		 mov_f	Diff
		endif
	endm


dec_ 	    macro var,bits
		variable	bitc
		local		noincEE,ex18
		
	    if var >= 0x1000 		; EEPROM
bitc = 0
	 
	     while bitc<bits
             readEEDAT	(var+ (bitc / 8) & 0xFF)
	     nop			; ???? is read fast enough ???
	     decf	EEDAT,F
	     call cwrtEE		; expects a mov_f call first eg.(eq_ E,=,1,lit8)
	     if bits >8
	      incfsz	EEDAT,W
	       goto noincEE		; overflow chain ended
	     endif
bitc += 8
	     endw
noincEE  
	     banksel Bank0

	    else			; Bank0&1

	     if var >= Bank1 
	      banksel Bank1
  	     endif

	     
bitc = 0
	     while bitc<bits
	      if bitc <bits-8
		decf (var + bitc / 8),F	
	       incfsz (var + bitc / 8),W
	        goto ex18      ;$+(bits /8)+1
	      else
	       decf (var + bitc / 8),F 	; last decrement in chain
	      endif
bitc += 8

	     endw
ex18    		
	
	
	     if var >= Bank1 
	      banksel Bank0
	     endif
	    endif
 	endm


decl_	macro	var1,val,bits
	 incl_	var1,-val,bits
	endm



sub_    macro Dif, SubEnd,SubTor,bits
	
	variable	bitc, sign,const	
	
	if	bits	< 0
sign = -1
	else
sign = 1
	endif

bitc = 0
	if (sign < 0) & (Dif == SubEnd)
		  if (SubTor == 1) & (SubEnd != INDF)
		   dec_ Dif, bits*sign		; decrement
		  else
		    decl_ Dif,SubTor,bits*sign	; literal
		  endif
	endif

	if (sign > 0) | (Dif != SubEnd)	
	   if	sign < 0			; SubTor is literal	 
	      while bitc < (bits * sign)
	         if_b1 SubEnd		
		 if SubEnd >= 0x1000			; Subend is EEPROM
		    	movlw	 (SubEnd+(bitc/8)) & 0xFF
			movwf	EEADR
			bsf	EECON1,RD
		 endif
const = SubTor;		  
		   movlw	((const >> bitc) & 0xFF)
		   if bitc > 0
		    skpNC
		     goto	$+2
		    if ((const >>bitc)+1) & 0xFF
		     movlw	((const >>bitc)+1) & 0xFF
		    else
		     goto $+2
		    endif
		   endif
; 
		   if SubEnd >= 0x1000			; Subend is EEPROM
		    subwf	EEDAT,W       		;
		   else
		    if SubEnd == INDF
	  		subwf SubEnd,W
         	    else
	  		subwf	SubEnd+(bitc /8),W
	 	    endif	 		; subend is variable
		   endif
	          
		   if_b0 SubEnd

		   if Dif == INDF
		    movwf	INDF
		   else					; 
	 	    mov_f	Dif+(bitc/8)		; Dif is EEPROM or variable
		   endif
		
		   if bitc+8 < bits*sign
		    if (SubEnd == INDF) | (Dif== INDF)
	  		incf	FSR,F
                    endif
		   endif
bitc+=8			
		  endw
	
	          if (SubEnd == INDF) | (Dif == INDF)
bitc=8
	           while bitc<bits*sign
	            decf	FSR,F
bitc+=8	 
	           endw
		  endif
	  endif

	  if  sign > 0				 ;SubTor is vari
; 
 if  (SubEnd<0x1000) & (SubTor<0x1000) & ((SubEnd & 0x80) == (SubTor & 0x80))
									; identical Banks	
		while bitc<bits
		   if_b1 SubEnd

		   if SubTor == INDF
		     movfw	INDF
		   else
 		    movfw 	SubTor+(bitc /8)
		   endif

		   if bitc > 0
		    skpC
		    if SubTor == INDF
		     incfsz	INDF,W
		    else	
		     incfsz	SubTor+(bitc /8),W
                    endif
		   endif

	 	   if Dif == SubEnd
		    if SubEnd == INDF
		     subwf	INDF,F
		    else
		     subwf	SubEnd+(bitc / 8),F
		    endif
		   else
		    if SubEnd == INDF
		     subwf	INDF,W
		    else
		     subwf	SubEnd+(bitc / 8),W
		    endif
                  endif
		  
		  if Dif != SubEnd
		   if_b0 SubEnd
 
		   if Dif == INDF
		     movwf	INDF
		   else					; INDF??
	 	     mov_f	Dif+(bitc/8)		; Dif is EEPROM or variable
		   endif
     		  endif
 
	    	  if bitc+8 < bits*sign
		    if ((SubTor == INDF) | (SubEnd == INDF) | (Dif == INDF)
		      incf FSR,F
		    endif
		  endif
bitc +=8
		  endw
bitc=8		 
		  if ((SubTor == INDF) | (SubEnd == INDF)) | (Dif == INDF)

		   while bitc < bits*sign
		    decf FSR,F
bitc+=8
		   endw
		  endif
;
	         else					;mixed banks or eeprom 
		  while bitc<bits
		   if SubEnd >= 0x1000			; Subend is EEPROM

		     if SubTor >= 0x1000			; SubTor is EEPROM too
;		   
		       readEEDAT	(SubTor+(bitc / 8)) & 0xFF
			movlw (SubEnd+(bitc / 8)) & 0xFF
	               movwf	EEADR
		       movfw	EEDAT			; subTor in W
		       bsf	EECON1,RD		; SubEnd in EEDAT
		 	
;		       banksel Bank0
;		       movfw	STACK				; STK = SubTor =W
;		       Banksel Bank1
;		       XORWF  EEDAT,F
;        	       XORWF  EEDAT,W
;        	       XORWF  EEDAT,F
;		      Banksel Bank0

		     else

 		      readEEDAT	(SubEnd+(bitc / 8)) & 0xFF
		      banksel Bank0
		      mov_w	SubTor+ (bitc/8)	;  
		     endif
                   else
		    mov_w	SubTor+ (bitc/8)	; Subend not EEPROM
		   endif
		   if bitc > 8
		   movwf	STACK
		   endif
;
 		   if SubEnd >= 0x1000				;Subend is	EEPROM
;			;************************ limitations on INDF

		    if bitc > 0
		     skpC	
			goto $+3
		      incf	STACK,W	
		    endif

		    Banksel Bank1
		    subwf	EEDAT,F
		    movfw	EEDAT
		    banksel	Bank0

		   else
		  if_b1 SubEnd
                    if bitc > 0				; Subend is Bank0&1
		    skpC	
		     incfsz	STACK,W	
		    endif
		    subwf	SubEnd+(bitc / 8),W
		  if_b0 SubEnd
		   endif


		   
		   if Dif == INDF
		     movwf	INDF
		   else					; INDF??
	 	     mov_f	Dif+(bitc/8)		; Dif is EEPROM or variable
		   endif
     		   
	    	   if bitc+8 < bits*sign
		    if ((SubTor == INDF) | (SubEnd == INDF) | (Dif == INDF)
		      incf FSR,F
		    endif
		   endif

bitc += 8
;		   
	 	  endw
bitc=8		 
		  if ((SubTor == INDF) | (SubEnd == INDF)) | (Dif == INDF)

		   while bitc < bits*sign
		    decf FSR,F
bitc+=8
		   endw
		  endif
		 endif				; identical blocks	       				; variables
         
          endif					; variables
	endif					; not  incremental
      endm

;
;sub_	    macro Diff, SubEnd,SubTor,bits
;		variable	bitc, sign	
;	
;		if	bits	< 0
;sign = -1
;		else
;sign = 1
;		endif
;
;bitc = 0
;		if (sign < 0) & (Diff == SubEnd)
;		  if SubTor == 1 
;		   dec_ Diff, bits*sign		; increment
;		  else
;		    incl_ Diff,-SubTor,bits*sign	; literal
;		  endif
;		
;		else		
;		 if	sign < 0			; SubTor is literal	 
;		  while bitc < (bits * sign)
;		
;
;		   if SubEnd >= Bank1
;		    Banksel Bank1
;		   endif
;
;		   if SubEnd >= 0x1000			; Subend is EEPROM
;		    	movlw	 (SubEnd+(bitc/8)) & 0xFF
;			movwf	EEADR
;			bsf	EECON1,RD
;		   endif
;		  
;		   movlw	((SubTor >> bitc) & 0xFF)
;
;		   if bitc > 0
;		    skpC
;		     goto	$+2
;		    if ((SubTor >>bitc)+1) & 0xFF
;		     movlw	((SubTor >>bitc)+1) & 0xFF
;		    else
;		     goto $+2
;		    endif
;		   endif
; 
;		   if SubEnd >= 0x1000			; Subend is EEPROM
;		    subwf	EEDAT,W       			;subend is	EEPROM
;		   else
;		    subwf	SubEnd,W	 		; subend is variable
;		   endif
;		   if SubEnd >= Bank1
;		    Banksel Bank0
;		   endif
;		  
;	 	   mov_f	Diff+(bitc/8)		; diff is EEPROM or variable
;bitc+=8
;		  endw
;
;		else				 ;SubTor is variable
;
; if  (SubEnd <0x1000) & (SubTor <0x1000) & ((SubEnd & 0x80) == (SubTor & 0x80))
;			; identical Banks
;
;	
;		  while bitc<bits
;		  if (SubEnd >=Bank1) 
;		   banksel Bank1
;		  endif
;
;		   movfw 	SubTor+(bitc /8)
;		   if bitc > 0
;		   skpNC	
;		    incfsz	SubTor+(bitc /8),W
;		   endif
;	 	   if Diff == SubEnd
;		   subwf	SubEnd+(bitc / 8),F
;		   else
;		   subwf	SubEnd+(bitc / 8),W
;		 if (SubEnd >=Bank1) 
;		   banksel Bank0
;		 endif
;
;		   mov_f	Diff+(bitc / 8)
;         	   endif
;bitc +=8
;		 endw
;
;		else
;		 while bitc<bits
;
;		if SubEnd >= 0x1000			; Subend is EEPROM
;		 readEEDAT	(SubEnd+(bitc / 8)) & 0xFF
;		 banksel Bank0
;
;		 if SubTor >= 0x1000			; SubTor is EEPROM too
;		  movwf	STACK				; STK = Subend
;		  readEEDAT	(SubTor+(bitc / 8)) & 0xFF
;		  banksel Bank0
;		  movfw	STACK				; STK = SubTor =W
;		  Banksel Bank1
;		  XORWF  EEDAT,F
;        	  XORWF  EEDAT,W
;        	  XORWF  EEDAT,F
;		  Banksel Bank0
;		 else
;		  mov_w	SubTor+ (bitc/8)	;  
;		 endif
;
;		else
;		  mov_w	SubTor+ (bitc/8)
;		endif
;		movwf	STACK
;;
;
;;		
;		if SubEnd >= 0x1000				;Subend is	EEPROM
;
;		 Banksel Bank1
;		 if bitc > 0
;		   skpNC	
;		     incfsz	STACK,W	
;		  endif
;		   subwf	EEDAT,F
;		   movfw	EEDAT
;		  banksel	Bank0
;		else
;		  if SubEnd >=Bank1
;		   banksel Bank1
;		  endif
;                  if bitc > 0				; Subend is Bank0&1
;		   skpNC	
;		     incfsz	STACK,W	
;		  endif
;		   subwf	SubEnd+(bitc / 8),W
;		  if SubEnd >=Bank1
;		   banksel Bank0
;		  endif
;		endif
;
;		mov_f	Diff+(bitc / 8)
;bitc += 8
;	 	endw
;		endif
;		endif					; identical blocks
;	       endif				; variables
;
;	    endm

;
;decC	    macro	Target
;		skpC
;		 decf	Target,F
;	    endm
;
;
addall  macro	Sum,AddEnd

		if AddEnd <Bank1 
		 if Sum != AddEnd
		  addwf	AddEnd,W
		 else
		  addwf AddEnd,F
		 endif
		else
		 if AddEnd < 0x1000
		 Banksel Bank1
		if Sum != AddEnd
		  addwf	AddEnd,W
		 else
		  addwf AddEnd,F
		 endif
		 Banksel Bank0
		 else
		  movwf	STACK
		  banksel	EEADR
		  movlw	AddEnd & 0xFF
		  movwf	EEADR
		  bsf	EECON1,RD
		  banksel	Bank0
		  movfw	STACK
		  Bankseadd_ != AddEnd
		  addwf	EEDAT,W
		 else
		  addwf EEDAT,F
		  call	wrtEE
		 endif
		  banksel Bank0
		 endif
                endif
	endm

;

add	    macro result, var1, var2
		mov_w	var2
		addall	result, var1
		if	result != var1
		 mov_f	result
		endif
	    endm


incl_	macro	var1,val,bits
	variable bitc,const
const = val
	if var1 >= 0x1000 
bitc = 0
				;EEPROM
	 while bitc<bits
          readEEDAT	(var1+ (bitc / 8)) & 0xFF
	  movlw	((const >> bitc) & 0xFF)

	  if bitc > 0
	  skpC
	   goto	$+2
	  if ((const >>bitc)+1) & 0xFF
	   movlw ((const >> bitc)+1) & 0xFF
	  else
	   goto $+3
	  endif
	  endif
	  addwf	EEDAT,F
	  call	cwrtEE
bitc += 8
	 endw
	Banksel Bank0

	else				; Bank0&1
bitc = 0

	if var1 >= Bank1 
	   banksel Bank1
  	 endif
	 while bitc<bits
	  
	  movlw	((const >> bitc) & 0xFF)
	  if bitc > 0
	    if var1 == INDF	
	     incf	FSR,F
	    endif
	   skpC
	    goto	$+2
	   if ((const >>bitc)+1) & 0xFF
	    movlw	((val >>bitc)+1) & 0xFF
	   else
	    goto $+2
	   endif
	  endif
	 if var1 == INDF
	  addwf var1,F
         else
	  addwf	var1+(bitc /8),F
	 endif
bitc +=8
	endw
	if var1 >= Bank1 
	   banksel Bank0
  	 endif
	if var1 == INDF
bitc=8
	while bitc<bits
	 decf	FSR,F
bitc+=8	 
	endw
	endif

	endif
	endm

inc_ 	    macro var,bits
		variable	bitc
		local		noincEE,ex18
		
	    if var >= 0x1000 		; EEPROM
bitc = 0
	 
	     while bitc<bits
             readEEDAT	(var+ (bitc / 8) & 0xFF)
	     nop			; ???? is read fast enough 
	     incf(EEDAT),F
	     call cwrtEE		; expects a mov_f call first eg.(eq_ E,=,1,lit8)
	     if bits >8
	      skpZ
	       goto noincEE		; overflow chain ended
	     endif
bitc += 8
	     endw
noincEE  
	     banksel Bank0

	    else			; Bank0&1

	     if var >= Bank1 
	      banksel Bank1
  	     endif

	     
bitc = 0
	     while bitc<bits
	      if bitc <bits-8
	       incfsz (var + bitc / 8),F
	        goto ex18      ;$+(bits /8)+1
	      else
	       incf (var + bitc / 8),F 	; last increment in chain
	      endif
bitc += 8

	     endw
ex18    		
	
	
	     if var >= Bank1 
	      banksel Bank0
	     endif
	    endif
 	endm


if_b1	macro  dEnd
		   if dEnd >= Bank1
		    Banksel Bank1
		   endif
	endm

if_b0	macro  dEnd
		   if dEnd >= Bank1
		    Banksel Bank0
		   endif
	endm


add_    macro Sum, AddEnd,AddTor,bits
	
	variable	bitc, sign,const	
	
	if	bits	< 0
sign = -1
	else
sign = 1
	endif

bitc = 0
	if (sign < 0) & (Sum == AddEnd)
		  if (AddTor == 1) & (AddEnd != INDF)
		   inc_ Sum, bits*sign		; increment
		  else
		    incl_ Sum,AddTor,bits*sign	; literal
		  endif
	endif

	if (sign > 0) | (Sum != AddEnd)	
	   if	sign < 0				; AddTor is literal	 
	      while bitc < (bits * sign)	
	         if_b1 AddEnd				
		 if AddEnd >= 0x1000			; Addend is EEPROM
		    	movlw	 (AddEnd+(bitc/8)) & 0xFF
			movwf	EEADR
			bsf	EECON1,RD
		 endif
const = AddTor		  
		   movlw ((const >> bitc) & 0xFF)		; WARNING
		   if bitc > 0					;  COMBINED VALUES
		    skpC					; LIKE (VAL & b'11110111')
		     goto	$+2
		    if ((const >>bitc)+1) & 0xFF
		     movlw	((const >>bitc)+1) & 0xFF
		    else
		     goto $+2
		    endif
		   endif
; 
		   if AddEnd >= 0x1000			; Addend is EEPROM
		    addwf	EEDAT,W       		;
		   else
		    if AddEnd == INDF
	  		addwf AddEnd,W
         	    else
	  		addwf	AddEnd+(bitc /8),W
	 	    endif	 		; addend is variable
		   endif
	          
		   if_b0 AddEnd

		   if Sum == INDF
		    movwf	INDF
		   else					; 
	 	    mov_f	Sum+(bitc/8)		; sum is EEPROM or variable
		   endif
		
		   if bitc+8 < bits*sign
		    if (AddEnd == INDF) | (Sum== INDF)
	  		incf	FSR,F
                    endif
		   endif
bitc+=8			
		  endw
	
	          if (AddEnd == INDF) | (Sum == INDF)
bitc=8
	           while bitc<bits*sign
	            decf	FSR,F
bitc+=8	 
	           endw
		  endif
	  endif

	  if  sign > 0				 ;AddTor is vari
; 
 if  (AddEnd<0x1000) & (AddTor<0x1000) & ((AddEnd & 0x80) == (AddTor & 0x80))
									; identical Banks	
		while bitc<bits
		   if_b1 AddEnd

		   if AddTor == INDF
		     movfw	INDF
		   else
 		    movfw 	AddTor+(bitc /8)
		   endif

		   if bitc > 0
		    skpNC
		    if AddTor == INDF
		     incfsz	INDF,W
		    else	
		     incfsz	AddTor+(bitc /8),W
                    endif
		   endif

	 	   if Sum == AddEnd
		    if AddEnd == INDF
		     addwf	INDF,F
		    else
		     addwf	AddEnd+(bitc / 8),F
		    endif
		   else
		    if AddEnd == INDF
		     addwf	INDF,W
		    else
		     addwf	AddEnd+(bitc / 8),W
		    endif
                  endif
		  
		  if AddEnd != Sum
		
		   if_b0 AddEnd
 
		   if Sum == INDF
		     movwf	INDF
		   else					; INDF??
	 	     mov_f	Sum+(bitc/8)		; sum is EEPROM or variable
		   endif
     		  endif

	    	   if bitc+8 < bits*sign
		    if ((AddTor == INDF) | (AddEnd == INDF)) | (Sum == INDF)
		      incf FSR,F
		    endif
		   endif
bitc +=8
		  endw
bitc=8		 
		  if ((AddTor == INDF) | (AddEnd == INDF)) | (Sum == INDF)

		   while bitc < bits*sign
		    decf FSR,F
bitc+=8
		   endw
		  endif
;
	         else					;mixed banks or eeprom 
		  while bitc<bits
		   if AddEnd >= 0x1000			; Addend is EEPROM
		     readEEDAT	(AddEnd+(bitc / 8)) & 0xFF
		     banksel Bank0

		     if AddTor >= 0x1000			; AddTor is EEPROM too
		       movwf	STACK				; STK = Addend
		       readEEDAT	(AddTor+(bitc / 8)) & 0xFF
		       banksel Bank0
		       movfw	STACK				; STK = AddTor =W
		       Banksel Bank1
		       XORWF  EEDAT,F
        	       XORWF  EEDAT,W
        	       XORWF  EEDAT,F
		      Banksel Bank0
		     else
		      mov_w	AddTor+ (bitc/8)	;  
		     endif
                   else
		    mov_w	AddTor+ (bitc/8)	;
		   endif
		   if bitc > 8
		   movwf	STACK
		   endif
;
 		   if AddEnd >= 0x1000				;Addend is	EEPROM
;			;************************ limitations on INDF

		    if bitc > 0
		     skpC	
			goto $+3
		      incf	STACK,W	
		    endif

		    Banksel Bank1
		    addwf	EEDAT,F
		    movfw	EEDAT
		    banksel	Bank0

		   else
		  if_b1 AddEnd
                    if bitc > 0				; Addend is Bank0&1
		    skpNC	
		     incfsz	STACK,W	
		    endif
		    addwf	AddEnd+(bitc / 8),W
		  if_b0 AddEnd
		   endif


		   
		   if Sum == INDF
		     movwf	INDF
		   else					; INDF??
	 	     mov_f	Sum+(bitc/8)		; sum is EEPROM or variable
		   endif
     		   
	    	   if bitc+8 < bits*sign
		    if ((AddTor == INDF) | (AddEnd == INDF) | (Sum == INDF)
		      incf FSR,F
		    endif
		   endif

bitc += 8
;		   
	 	  endw
bitc=8		 
		  if ((AddTor == INDF) | (AddEnd == INDF)) | (Sum == INDF)

		   while bitc < bits*sign
		    decf FSR,F
bitc+=8
		   endw
		  endif
		 endif				; identical blocks	       				; variables
         
          endif					; variables
	endif					; not  incremental
      endm


;
;
;rzprg	macro	DiviDend, bits
;		local	exit,lloopp,do_div,morerot,moreadd
;		variable bitdc, v1 ,v2,v3
;v1 =   (bits-8)/8
;v2 =	v1 + (bits/8)
;v3 =	v2 + (bits/8)
;		STK_Dend =	STACK-v1 
;		STK_Cntr = STACK-v2
;		STK_R = STACK-v3

;
;		 if_	DiviDend, lss_eql, .1, (-bits)
;		  goto	exit
;		mov_	DiviDend,STK_Dend,bits
;		eq_	STK_Cntr,.1,bits
;lloopp		btfsc	STK_Dend,7
;		 goto	do_div
;		shl_	STK_Dend,bits
;		shl_	STK_Cntr,bits
;		goto lloopp
;do_div		clrf_	DiviDend,bits
;		clrf_	STK_R,bits
;moreadd	sub_	STK_R, STK_R,STK_Dend,bits
;		add_	DiviDend,DiviDend, STCK_Cntr,bits
;morerot	btfsc	STK_Cntr,0
;		 goto	exit
;		shr_	STK_Cntr,bits
;		shr_	STK_Dend,bits
;		if_	STK_Dend,grtr,STK_R,bits
;		 goto morerot
;		goto moreadd
;exit
;		endm


mul_	macro Result,MultiKator,bits, useSTACK ;bits/8 +1
	local	mu1,mu2
	variable sign, bitspos

  if	bits	< 0
sign = -1
  else
sign = 1 
  endif
bitspos = bits*sign
	
	#define	rg22 useSTACK- ((bitspos-8) /8)
	#define	rg21 useSTACK- (bitspos)/8

	eq_	rg22,=,0, -bitspos
	eq_	rg21,=,bitspos, lit8
	shr_	Result,bitspos
mu1	bNC	 mu2
	add_	rg22,rg22,MultiKator,bits

mu2     ror_	rg22,bitspos
	ror_	Result,bitspos
	decfsz	rg21,F
	 goto mu1
;	
	endm

div_ macro	Result,DiviSor,bits, useSTACK
	variable sign, bitspos
	local	di1,di2
  if	bits	< 0
sign = -1
  else
sign = 1 
   endif
bitspos = bits*sign

	#define	remainder useSTACK- ((bitspos-8) /8)
	#define	counter useSTACK- (bitspos)/8


	eq_	remainder,=,0,-bitspos
	eq_	counter,=,bitspos+1,lit8
	clrC
di1
	rol_	Result,bitspos
	decfsz  counter,F
	 goto	di2
	 goto dixit
di2
	rol_	remainder,bitspos
	sub_	remainder,remainder,DiviSor,bits
	skpNC
	 goto	di1				;carry set		
	add_	remainder,remainder,DiviSor,bits
	clrC
	goto di1

dixit
	endm


ior_w	macro	Dest,Var

		if Var <Bank1 
		 if Dest != Var
		  iorwf	Var,W
		 else
		  iorwf Dest,F
		 endif
		else
		 if Var < 0x1000
		  Banksel Bank1			; Bank 1 variable
		  if Dest != Var
		   iorwf	Var,W
		  else
		   iorwf Dest,F
		  endif
		 else
		  push				; EEPROM Variable
		  banksel	EEADR
		  movlw	AddEnd & 0xFF		; read EEPROM
		  movwf	EEADR
		  bsf	EECON1,RD
		  banksel	Bank0
		  pop
		  Banksel Bank1
		  iorwf	EEDAT,W			; will be stored back
		 endif
		 banksel Bank0
		endif
                
	endm

ior_	    macro Dest, Var,IoTor,bits
		variable	bitc, sign	
	
		if	bits	< 0
sign = -1
		else
sign = 1
		endif
	

bitc = 0
		while bitc < (bits * sign)
	
		 if	sign < 0
		  movlw	((IoTor >> bitc) & 0xFF)
		 else
		  mov_w	IoTor+(bitc/8)
		 endif

		ior_w	Dest+(bitc / 8),Var+(bitc / 8)
		
		if  (Dest != Var) | (Dest >= 0x1000)
		 mov_f	Dest+(bitc / 8)
		endif
bitc += 8
	 	endw

	    endm

and_w	macro	Dest,Var

		if Var <Bank1 
		 if Dest != Var
		  andwf	Var,W
		 else
		  andwf Dest,F
		 endif
		else
		 if Var < 0x1000
		  Banksel Bank1			; Bank 1 variable
		  if Dest != Var
		   andwf	Var,W
		  else
		   andwf Dest,F
		  endif
		 else
		  push				; EEPROM Variable
		  banksel	EEADR
		  movlw	AddEnd & 0xFF		; read EEPROM
		  movwf	EEADR
		  bsf	EECON1,RD
		  banksel	Bank0
		  pop
		  Banksel Bank1
		  andwf	EEDAT,W			; will be stored back
		 endif
		  banksel Bank0
		endif
                
	endm

and_	    macro Dest, Var,AndTor,bits
		variable	bitc, sign	
	
		if	bits	< 0
sign = -1
		else
sign = 1
		endif
	

bitc = 0
		while bitc < (bits * sign)
	
		 if	sign < 0
		  movlw	((AndTor >> bitc) & 0xFF)
		 else
		  mov_w	AndTor+(bitc/8)
		 endif

		and_w	Dest+(bitc / 8),Var+(bitc / 8)
		
		if  (Dest != Var) | (Dest >= 0x1000)
		 mov_f	Dest+(bitc / 8)
		endif
bitc += 8
	 	endw

	    endm


xor_w	macro	Dest,Var

		if Var <Bank1 
		 if Dest != Var
		  xorwf	Var,W
		 else
		  xorwf Dest,F
		 endif
		else
		 if Var < 0x1000
		  Banksel Bank1			; Bank 1 variable
		  if Dest != Var
		   xorwf	Var,W
		  else
		   xorwf Dest,F
		  endif
		 else
		  push				; EEPROM Variable
		  banksel	EEADR
		  movlw	AddEnd & 0xFF		; read EEPROM
		  movwf	EEADR
		  bsf	EECON1,RD
		  banksel	Bank0
		  pop
		  Banksel Bank1
		  xorwf	EEDAT,W			; will be stored back
		 endif
		 banksel Bank0
		endif
                
	endm

xor_	    macro Dest, Var,IoTor,bits
		variable	bitc, sign	
	
		if	bits	< 0
sign = -1
		else
sign = 1
		endif
	

bitc = 0
		while bitc < (bits * sign)
	
		 if	sign < 0
		  movlw	((IoTor >> bitc) & 0xFF)
		 else
		   if IoTor == INDF
		    movfw	INDF
		   else
		    mov_w	IoTor+(bitc/8)
		   endif
		 endif
	        
		if Dest	== INDF				; looks OTT !
		  xor_w	Dest,Var+(bitc / 8)
		else
                 if Var == INDF
                  xor_w	Dest+(bitc / 8),Var
		 else
		  xor_w	Dest+(bitc / 8),Var+(bitc / 8)
		 endif
		endif

		if  (Dest != Var) | (Dest >= 0x1000)
		 if Dest	== INDF				; looks OTT !
		  movwf	INDF
		  if bitc+8 < bits*sign
		   incf	FSR,F
		  endif
		 else
      		  mov_f	Dest+(bitc / 8)
                 endif
		endif
bitc += 8
	 	endw

	    endm



#define	plus	+				; verbose
#define	minus	-
#define	times	*
#define divided_by /
#define	OR	|				
#define	AND	&				;
#define	XOR	^				; operators


do_	macro  Dest, EqualSign, Source1, Oper, Source2,bits

	
	IFNDEF	STACK
	#define STACK _MAXRAM
	ENDIF


 variable _aai = 7, _aaj
_aaj EqualSign _aai
 if (_aai != _aaj)
  error "No Equals ('=') in Assignment Statement
 else                        ;  Equals Present

 if ((7 Oper 11) == 77)   ;  Multiplication Operator

     if Dest != Source1
	if bits > 0
	 eq_ Dest,=,Source1,bits
	else
	 eq_ Dest,=,Source1,-bits
	endif
     endif	
     mul_ Dest,Source2,bits,STACK
   else
  if ((77 Oper 11) == 7)   ;  Division Operator
     if Dest != Source1
	if bits > 0
	 eq_ Dest,=,Source1,bits
	else
	 eq_ Dest,=,Source1,-bits
	endif
     endif	

     div_ Dest,Source2,bits,STACK
   else
  

 if ((1 Oper 1) == 2)      ;  Addition Operator
     add_ Dest,Source1,Source2,bits
   else
    if ((47 Oper 25) == 22)   ;  Subtraction Operator
      sub_ Dest,Source1,Source2,bits
    else
     if ((3 Oper 2) == 3)     ;  OR Operator
       ior_ Dest,Source1,Source2,bits
     else
      if ((3 Oper 2) == 2)    ;  AND Operator
        and_ Dest,Source1,Source2,bits
      else
       if ((3 Oper 2) == 1)   ;  XOR Operator
         xor_ Dest,Source1,Source2,bits
       else
        error "Unknown Operator"
       endif
      endif
     endif
    endif
   endif

  endif
  endif

  endif 
 endm




calc macro Dest, EqualSign, Source1, Oper, Source2,bits
 variable _aai = 7, _aaj
_aaj EqualSign _aai
 if (_aai != _aaj)
  error "No Equals ('=') in Assignment Statement
 else                        ;  Equals Present


  if (bits > 0 )          ;  Variable Direct
   if (Source2 >= Bank1)
     bsf STATUS, RP0         ;  Bank 1 Variable
   endif
     movf Source2 & 0x7F, w
   if (Source2 > 0x7F)
     bcf STATUS, RP0         ;  Bank 1 Variable
   endif
  else                       ;  Literal
     movlw Source2
  endif
  
   if (Source1 > 0x7F)
     bsf STATUS, RP0         ;  Bank 1 Variable
   endif
  
 if ((1 Oper 1) == 2)      ;  Addition Operator
     addwf Source1 & 0x7F, w
   else
    if ((47 Oper 25) == 22)   ;  Subtraction Operator
      subwf Source1 & 0x7F, w
    else
     if ((3 Oper 2) == 3)     ;  OR Operator
       iorwf Source1 & 0x7F, w
     else
      if ((3 Oper 2) == 2)    ;  AND Operator
        andwf Source1 & 0x7F, w
      else
       if ((3 Oper 2) == 1)   ;  XOR Operator
         xorwf Source1 & 0x7F, w
       else
        error "Unknown Operator"
       endif
      endif
     endif
    endif
   endif

   if (Dest > 0x7F)
     bsf STATUS, RP0         ;  Bank 1 Variable
   endif
     movwf Dest & 0x7F
   if (Dest > 0x7F)
     bcf STATUS, RP0         ;  Bank 1 Variable
   endif

  endif 
 endm

;
;inc_ 	    macro var,bits
;		variable	bitc
;		local		noincEE
;		
;	if var >= 0x1000 
;bitc = 0
;	 
;	 while bitc<bits
;          mov_w	var+ (bitc / 8)
;	   inc(EEDAT),F
;	  mov_f var+ (bitc / 8)
;	  if bits >8
;	  skpZ
;	   goto noincEE
;	  endif
;
;bitc += 8
;	 endw
;noincEE
;	else
;	 if var >= Bank1 
;	   banksel Bank1
;  	 endif
;
;	if bits >8
;bitc = 0
;	 while bitc<bits
;	   incfsz(var + bitc / 8),F
;	    goto ex18      ;$+(bits /8)+1
;
;bitc += 8
;
;	 endw
;ex18
;	else
;	 incf	var,F
;	endif
;
;	 if var >= Bank1 
;	   banksel Bank0
;	 endif
;	endif
; 	endm
;;
;;

incl	    macro result, val
		movlw	val
		addwf	result,F
	    endm

;
;incl_	macro	var1,val,bits
;	variable bitc
;	if var >= 0x1000 
;bitc = 0
;	clrC
;	 while bitc<bits
;          mov_w	var+ (bitc / 8)
;	  movlw	((val >> bitc) & 0xFF)
;	  skpC
;	   goto	$+2
;	  if ((val >>bitc)+1) & 0xFF
;	   movlw ((val >> bitc)+1) & 0xFF
;	  else
;	   goto $+2
;	  endif
;	  addwf	EEDAT,F
;	  mov_f var+ (bitc / 8)
;bitc += 8
;	 endw
;	else
;bitc = 0
;	clrC
;	 while bitc<bits
;	  movlw	((val >> bitc) & 0xFF)
;	  skpC
;	   goto	$+2
;	  if ((val >>bitc)+1) & 0xFF
;	   movlw	((val >>bitc)+1) & 0xFF
;	  else
;	   goto $+2
;	  endif
;
;	 if var >= Bank1 
;	   banksel Bank1
;  	 endif
;	 addwf	var+(bitc /8),F
;bitc +=8
;	endw
;
;	endm
;


decl	    macro result, val
		incl	result, -val
	    endm		
;
;swapwf      MACRO  REG
;            	XORWF  REG,F
;        	XORWF  REG,W
;        	XORWF  REG,F
;            ENDM
;swap_ macro	var1,var2,bits
;	variable bitc
;bitc =0
;		while	bitc < bits
;	 if var1 >= Bank1 
;	   banksel Bank1
;  	 endif
;		movf_w	var1 + (bitc / 8)
;	EEPROM

;	 if (var2 >= Bank1) & (var1 <Bank1) 
;	   banksel Bank1
;  	 endif
;		xorwf	var2+ (bitc / 8),F
;		xorwf	var2+ (bitc / 8),w
;		xorwf	var2+ (bitc / 8),F
;	 if (var2 >= Bank1) & (var1 <Bank1) 
;	   banksel Bank0
;  	 endif
;		movwf	var1+ (bitc / 8)
;	 if (var1 >= Bank1) 
;	   banksel Bank0
;  	 endif
;bitc +=8
;		endw
;	endm
;

;shml	macro	Target, shifts, bits
;	local	loop
;	variable bitc
;		movlw	shifts
;		movwf	STACK
;loop		clrC
;bitc =0		
;		while bitc < bits
;		rlf	Target+(bitc /8),F
;bitc +=8	
;		endw
;		decfsz	STACK,F
;		 goto	loop
;		endm
;
;
;
;pwrof2 macro	Target, shifts,Counter,bits
;	  shml	 Target, shifts,Counter,bits
;	endm
;
;shmr	macro	Target, shifts, bits
;	local	loop
;	variable bitc
;	
;		movlw	shifts
;		movwf	STACK
;loop		clrC
;		if (Target >= Bank1)  
;	   	 banksel Bank1
;  	 	endif
;bitc =0		
;		while bitc < bits
;		rrf	Target+(bitc /8),F
;bitc +=8	
;		endw
;		if (Target >= Bank1) 
;	   	 banksel Bank0
;  	 	endif
;		decfsz	STACK,F
;		 goto	loop
;
;
;		endm
;
;
ror_	macro	Target,bits
	 variable bitc

		if Target == INDF
bitc =8		
		 while bitc < bits 
		  incf	FSR,F
bitc +=8
		 endw
		endif


		if (Target >= Bank1) 
	   	 banksel Bank1
  	 	endif
bitc =0		
		
		while bitc < bits
 		 if Target == INDF
		  rrf	Target
		  if bitc > 0
		   decf	FSR,F
		  endif
		 else
		  rrf	Target+((bits-bitc-8) /8),F
		 endif
bitc +=8	
		endw

		if (Target >= Bank1) 
	   	 banksel Bank0
  	 	endif

	endm


shr_	macro Target,bits
	    ClrC
	    ror_ Target,bits
	endm

mshr_	macro Target,shiftby,bits,useSTACK
	   local repeat
			variable sign
  if	bits	< 0
sign = -1
  else
sign = 1 

	   eq_	useSTACK,=,shiftby,bits
repeat	   shr_ Target,bits*sign
	   decfsz	useSTACK,F
	    goto repeat

	endm

;
;
;
;divby2  macro   Target,bits
; 	 	shrr 	Target,bits
;	endm


;mult2	macro   Target
; 	 	shl 	Target
;	endm
;
rol_	macro	Target,bits
	 variable bitc

		if (Target >= Bank1) 
	   	 banksel Bank1
  	 	endif
bitc =0		
		
		while bitc < bits
		if Target == INDF
		 rlf	Target
		 if bitc > 0
		  incf	FSR,F
		 endif
		else
		 rlf	Target+(bitc /8),F
		endif
bitc +=8	
		endw
		if (Target >= Bank1) 
	   	 banksel Bank0
  	 	endif
		if Target == INDF
bitc =8		
		 while bitc < bits 
		  decf	FSR,F
bitc +=8
		 endw
		endif

	endm


shl_	macro Target,bits
	    ClrC
	    rol_ Target,bits
	endm

mshl_	macro Target,shiftby,bits,useSTACK
	   local repeat
			variable sign
  if	bits	< 0
sign = -1
  else
sign = 1 

	   eq_	useSTACK,=,shiftby,bits
repeat	   shl_ Target,bits*sign
	   decfsz	useSTACK,F
	    goto repeat

	endm
;
;skpge	    macro var1, var2	;skip next instr if var1 greater equal var2
;
;		mov_w	var2
;		suball	DUMMY,var1
;		skpC
;	    endm
;
;exels	    macro var1, var2	;execute next instr if var1 less var2
;             	skpge var1,var2
;	    endm
;
;
;

skpgevv	    macro var1, var2,bits	;skip next instr if var1 greater equal var2 
		variable bitc
		local decide
bitc = bits
		while bitc > 0	
		 mov_w	var2+((bitc-8) /8)
		suball  DUMMY,	var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide
		endif
bitc -=8
		endw
		
decide		skpC
;		 conditional code (less)
	    endm

exelsvv	    macro var1, var2,bits
		skpgevv	var1,var2,bits
	    endm
;
;skple	    macro var1,var2
;	     skpge var2,var1
;	    endm	
;skplev	    macro var1,var2
;	     skpgev var2,var1
;	    endm	
skplevv	    macro var1,var2,bits
	     skpgevv var2,var1,bits
	    endm	
;
;exegr	    macro var1,var2
;		skple	var1,var2
;	    endm
;
exegrvv	    macro var1, var2,bits
		skplevv	var1,var2,bits
	    endm
;
;skpgr	    macro var1, var2
;		movfw	var1
;		subwf	var2,W
;		skpNC
;	    endm
;
;skpgrv	    macro var1,var2	;skip next instr if var1 greater  var2
;		movfw	var1
;		subwf	var2,W
;		skpNC
;	    endm

skpgrvv	    macro var2, var1,bits	;skip next instr if var1 greater  var2 (16bit LSB-MSB)
		variable bitc
		local decide

bitc = bits
		while bitc > 0	
		 mov_w	var2+((bitc-8) /8)
		suball	DUMMY,var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide
		endif
bitc -=8
		endw

decide		skpNC
;		 conditional code
	    endm

;
;
;exele	    macro var1,var2
;		skpgr	var1,var2
;	    endm
;exelev	    macro var1,var2
;		skpgrv	var1,var2
;	    endm
exelevv	    macro var1,var2,bits
		skpgrvv	var1,var2,bits
	    endm
;
;
;exege	    macro var1,var2
;		skpgr	var2,var1
;	    endm
;exegev	    macro var1,var2
;		skpgrv	var2,var1
;	    endm
exegevv	    macro var1,var2,bits
		skpgrvv	var2,var1,bits
	    endm

;skpeq	    macro var1, var2
;		movf_w	var1
;		suball	DUMMY,var2
;		skpZ
;	    endm
;
skpeqq	    macro var1, var2,bits
		variable bitc
		local decide
bitc = bits
		while bitc > 0	
		 mov_w	var2+((bitc-8) /8)
		suball	DUMMY, var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide +1
		endif
bitc -=8
		endw

decide		skpZ
;		 not equal cod
	    endm

;exeneq      macro var1, var2	;execute next instr if var1 not equal var2
;             	skpeq var1,var2
;	    endm
exenevv     macro var1, var2,bits	;execute next instr if var1 not equal var2  (16bit)
             	skpeqq var1,var2,bits
	    endm
;
;skpneq	    macro var1, var2
;		movf_w	var1
;		suball	DUMMY,var2
;		skpNZ
;	    endm
;
skpneqvv    macro var1, var2,bits
		variable bitc
		local decide
bitc = bits
		while bitc > 0	
		 mov_w	var2+((bitc-8) /8)
		suball	DUMMY,var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide +2
		endif
bitc -=8
		endw

decide		skpNZ
;		 is equal cod
	    endm
;
;exeeq      macro var1, var2	;execute next instr if var1 equal var2
;             	skpneq var1,var2
;	    endm

exeeqvv     macro var1, var2,bits	;execute next instr if var1 equal var2  (16bit)
             	skpneqvv var1,var2,bits
	    endm

;
;skpeql	    macro var1, val	;skip var1  equal literal
;		movlw	val
;		suball	DUMMY,var1
;		skpZ
;	    endm

skpeqll	    macro var1, val, bits
		variable bitc,const
		local decide
bitc = -bits
const = val
		while bitc > 0	
		 movlw	(const >> (bitc-8) ) & 0xFF
		suball	DUMMY,var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide +1
		endif
bitc -=8
		endw

decide		skpZ
;		 not equal cod
	    endm
;
;exeneql      macro var1, val	;execute next instr if var1 not equal val
;             	skpeql var1,val
;	    endm
exeneqll     macro var1, val,bits	;execute next instr if var1 not equal val  (16bit)
             	skpeqll var1,val,bits
	    endm
;
;skpneql	    macro var1, val		;skip var1  not equal literal
;		movlw	val
;		suball	DUMMY,var1
;		skpNZ
;	    endm

skpneqll    macro var1, val, bits
		variable bitc,const
		local decide
bitc = -bits
const = val
		while bitc > 0	
		 movlw	(const >> (bitc-8) ) & 0xFF
		suball	DUMMY,var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide +2
		endif
bitc -=8
		endw

decide		skpNZ
;		 equal cod
	    endm

;exeeql      macro var1, val	;execute next instr if var1 equal val
;             	skpneql var1,val
;	    endm

exeeqll     macro var1, val,bits	;execute next instr if var1 equal val  (16bit)
             	skpneqll var1,val,bits
	    endm

;exeelll    macro var1, val,bits	;execute next instr if var1 equal val (24bit)
;             	skpneqlll var1,val
;	    endm
;
;skpgel	    macro var1, val		;skip var1 greater equal literal
;		movlw	val
;		suball	DUMMY,var1
;		skpC
;	    endm
;
skpgell	    macro var1, val, bits
		variable bitc,const
		local decide
bitc = -bits
const = val
		while bitc > 0	
		 movlw	(const >> (bitc-8) ) & 0xFF
		suball	DUMMY,var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide 
		endif
bitc -=8
		endw

decide		skpC
;		 less code
	    endm

;exelsl     macro var1, val	;execute var1 less  literal 
;		skpgel var1,val
;	   endm
;
exelsll     macro var1, val,bits	;execute var1 less  literal 
		skpgell var1,val,bits
	   endm

;skpgrl	   macro var1,val
;		skpgel var1, val+1
;	   endm
;
skpgrll	   macro var1,val,bits
		skpgell var1, val+1,bits
	   endm
;
;
;exelel     macro var1, val	;execute var1 less  literal 
;		skpgel var1,val+1
;	   endm
;
exelell     macro var1, val,bits	;execute var1 less  literal 
		skpgrll var1,val,bits
	   endm
;
;skplsl	    macro var1, val	;skip var1 less  literal
;		movlw	val
;		suball	DUMMY,var1
;		skpNC
;	    endm


skplsll	    macro var1, val, bits
		variable bitc,const
		local decide
bitc = -bits
const = val
		while bitc > 0	
		 movlw	(const >> (bitc-8) ) & 0xFF
		suball	DUMMY,var1+((bitc-8) /8)
		if bitc > 8
		skpZ
		 goto decide 
		endif
bitc -=8
		endw

decide		skpNC
;		 greater equal cod
	    endm

;exegel	    macro var1, val
;		skplsl var1, val
;	    endm

exegell	    macro var1,val,bits
		skplsll var1,val,bits
	    endm

;
;skplel	    macro var1, val	;skip var1 less equal literal
;                skplsl var1, val-1
;	    endm
;
;skplell	    macro var1, val,bits		;skip var1 less literal 16bit
;	        skplsll var1, val-1,bits
;	    endm
;
#define		grtr	>
#define		grtr_eql	>=
#define		lss	<
#define		lss_eql	<=
#define		eql	==
#define		not_eql	!=

#define		singlebit	1	

#define		is_on	1	
#define		is_off	0

if_	Macro var1, Comp, var2, bits

 if	bits == 1		; just one bit: syntax if_ base,bit,is_on,	bit
  if var2			;                                   is_off
   btfsc var1,Comp
  else
    btfss var1,Comp
  endif

 else
 if (1 Comp 0)                  ;  Check for "!="/">"/">="
  if (0 Comp 1)                 ;  "!="
  		 if bits > 0 
		   exenevv var1,var2,bits
		 else
	 	   exeneqll var1,var2,bits
	    	 endif

  else                          ;  Else ">"/">="
   if (1 Comp 1)                ;  ">="
 		 if bits > 0 
		   exegevv var1,var2,bits
		 else
	 	   exegell var1,var2,bits
	    	 endif
   else                         ;  ">"
        if bits > 0 
		   exegrvv var1,var2,bits
		 else
	 	   exegell var1,var2+1,bits
	endif
   endif
  endif
 else
  if (0 Comp 1)                 ;  Check for "<"/"<="
   if (1 Comp 1 )               ;  "<="
		 if bits > 0 
		   exelevv var1,var2,bits
		 else
	 	   exelell var1,var2,bits
	    	 endif
  else                         ;  "<"
 		 if bits > 0 
		   exelsvv var1,var2,bits
		 else
	 	   exelsll var1,var2,bits
	    	 endif
   endif
  else
   if (1 Comp 1)                ;  "=="
		 if bits > 0 
		   exeeqvv var1,var2,bits
		 else
	 	   exeeqll var1,var2,bits
	    	 endif
   else
    error Unknown "if" Condition
   endif
  endif
 endif
 endif
   		; conditional code goto  Dest
 endm

;inverted operators
if_m	Macro var1, Comp, var2, bits

 if	bits == 1		; just one bit: syntax if_m base,bit,is_on,	bit
  if var2			;                                   is_off
   btfss var1,Comp
  else
    btfsc var1,Comp
  endif

 else


 if (1 Comp 0)                  ;  Check for "!="/">"/">="
  if (0 Comp 1)                 ;  "!="
  		 if bits > 0 
		   exeeqvv var1,var2,bits
		 else
	 	   exeeqqll var1,var2,bits
	    	 endif

  else                          ;  Else ">"/">="
   if (1 Comp 1)                ;  ">="
 		 if bits > 0 
		   exelsvv var1,var2,bits
		 else
	 	   exelsll var1,var2,bits
	    	 endif
   else                         ;  ">"
        if bits > 0 
		   exelevv var1,var2,bits
		 else
	 	   exelell var1,var2,bits
	endif
   endif
  endif
 else
  if (0 Comp 1)                 ;  Check for "<"/"<="
   if (1 Comp 1 )               ;  "<="
		 if bits > 0 
		   exegrvv var1,var2,bits
		 else
	 	   exegell var1,var2+1,bits
	    	 endif
  else                         ;  "<"
 		 if bits > 0 
		   exegevv var1,var2,bits
		 else
	 	   exegell var1,var2,bits
	    	 endif
   endif
  else
   if (1 Comp 1)                ;  "=="
		 if bits > 0 
		   exenevv var1,var2,bits
		 else
	 	   exenell var1,var2,bits
	    	 endif
   else
    error Unknown "if" Condition
   endif
  endif
 endif
 endif
ifflag#v(level)=ilabcount
	;movlw	ifflag#v(level)
	goto iflab#v(ilabcount)
ilabcount+=1
level+=1  	
 endm


i_f_	Macro var1, Comp, var2,bits, then,macro1,elsif,macro2
		; execute one of two macros (no parameters!)


  local ex1,ex2
 

 if (1 Comp 0)                  ;  Check for "!="/">"/">="
  if (0 Comp 1)                 ;  "!="
  		 if bits > 0 
		   exeeqvv var1,var2,bits
		 else
	 	   exeeqll var1,var2,bits
	    	 endif

  else                          ;  Else ">"/">="
   if (1 Comp 1)                ;  ">="
 		 if bits > 0 
		   exelsvv var1,var2,bits
		 else
	 	   exelsll var1,var2,bits
	    	 endif
   else                         ;  ">"
        if bits > 0 
		   exelevv var1,var2,bits
		 else
	 	   exelell var1,var2,bits
	endif
   endif
  endif
 else
  if (0 Comp 1)                 ;  Check for "<"/"<="
   if (1 Comp 1 )               ;  "<="
		 if bits > 0 
		   exegrvv var1,var2,bits
		 else
	 	   exegell var1,var2+1,bits
	    	 endif
  else                         ;  "<"
 		 if bits > 0 
		   exegevv var1,var2,bits
		 else
	 	   exegell var1,var2,bits
	    	 endif
   endif
  else
   if (1 Comp 1)                ;  "=="
		 if bits > 0 
		   exenevv var1,var2,bits
		 else
	 	   exeneqll var1,var2,bits
	    	 endif
   else
    error Unknown "if" Condition
   endif
  endif
 endif
     if elsif == elseif
	    goto ex1
	   else
            goto ex2
	   endif
	  macro1
	if elsif == elseif
	  goto ex2 
ex1	macro2
        endif
ex2	
 endm






if_old	    macro var1,oprtr,var2,bits

		if (oprtr == grtr) 
		 if bits > 0 
		   exegrvv var1,var2,bits
		 else
	 	   exegell var1,var2+1,bits
	    	 endif
	        endif
	
		if (oprtr == grtr_eql) 
		 if bits > 0 
		   exegevv var1,var2,bits
		 else
	 	   exegell var1,var2,bits
	    	 endif
		endif
		if (oprtr == lss) 
		 if bits > 0 
		   exelsvv var1,var2,bits
		 else
	 	   exelsll var1,var2,bits
	    	 endif
		endif
		if (oprtr == lss_eql) 
	 
		 if bits > 0 
		   exelevv var1,var2,bits
		 else
	 	   exelell var1,var2,bits
	    	 endif
		endif
		if (oprtr == eql) 	 
		 if bits > 0 
		   exeeqvv var1,var2,bits
		 else
	 	   exeeqll var1,var2,bits
	    	 endif
		endif
		if (oprtr == not_eql) 	 
		 if bits > 0 
		   exenevv var1,var2,bits
		 else
	 	   exeneqll var1,var2,bits
	    	 endif
		endif


	    endm

;

;****************************************** now legal macros **********************



old_skp_ornot   macro	base1, bit1, base2, bit2;bit1	bit2 result
		btfss	base1, bit1		; 1      0     skp
		 btfss	base2, bit2		; 1      1     skp
		goto	$+2			; 0      0     skp
				;       	; 0      1     
				; execute not(bit1) and  bit2
	    endm

skp_ornot   macro	base1, bit1, base2, bit2
		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfss	base1, bit1	
		else
		 btfss	STACK,bit1
		endif
		if base2 < Bank1
		 btfss	base2, bit2	
		else
		 btfss	STACK-1,bit2
		endif
		goto	$+2			
				
			
	    endm


if_but    macro base1, bit1, base2, bit2
		skp_ornot base1, bit1, base2, bit2
	   endm

old_skp_fault	macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfsc	base1, bit1		; 1      0     skp
		 btfss	base2, bit2		; 1      1
		goto	$+2			; 0      0     skp
				;       	; 0      1     skp
				; execute (bit1) and (bit2)
	endm


skp_fault   macro	base1, bit1, base2, bit2
		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfsc	base1, bit1	
		else
		 btfsc	STACK,bit1
		endif
		if base2 < Bank1
		 btfss	base2, bit2	
		else
		 btfss	STACK-1,bit2
		endif
		goto	$+2			
				
			
	    endm




if_both    macro base1, bit1, base2, bit2
		skp_fault base1, bit1, base2, bit2
	   endm


old_skp_any	macro	base1, bit1, base2, bit2	;base1, bit1	bit2 result
		btfss	base1, bit1		; 1      0   skp
		 btfsc	base2, bit2		; 1      1   skp	
		goto	$+2			; 0      0 
						; 0      1   skp
				;exeute not (bit1 or bit 2)
	endm

skp_any   macro	base1, bit1, base2, bit2
		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfss	base1, bit1	
		else
		 btfss	STACK,bit1
		endif
		if base2 < Bank1
		 btfsc	base2, bit2	
		else
		 btfsc	STACK-1,bit2
		endif
		goto	$+2			
				
			
	    endm




if_none    macro base1, bit1, base2, bit2
		skp_any base1, bit1, base2, bit2
	   endm





;execaornotb
old_skp_but macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		  				; 1      1     
		 btfss	base2, bit2		; 0      0     
		      				; 0      1     skp
				;
				; execute bit1 or not(bit2)
	endm

skp_but   macro	base1, bit1, base2, bit2
		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfss	base1, bit1	
		else
		 btfss	STACK,bit1
		endif
		if base2 < Bank1
		 btfss	base2, bit2	
		else
		 btfss	STACK-1,bit2
		endif					
			
	    endm

if_ornot    macro base1, bit1, base2, bit2
		skp_but base1, bit1, base2, bit2
	   endm




;execaorb
old_skp_none	macro	base1, bit1, base2, bit2;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		 btfsc	base2, bit2		; 1      1     
						; 0      0     skp
				;       	; 0      1     
				; execute not(bit1) and  not(bit2)
	endm
skp_none   macro	base1, bit1, base2, bit2
		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfss	base1, bit1	
		else
		 btfss	STACK,bit1
		endif
		if base2 < Bank1
		 btfsc	base2, bit2	
		else
		 btfsc	STACK-1,bit2
		endif			
				
			
	    endm



if_any    macro base1, bit1, base2, bit2
		skp_none base1, bit1, base2, bit2
	   endm
	
			
;execnandb
old_skp_both macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfsc	base1, bit1		; 1      0     
		     				; 1      1     skp     
		 btfss	base2, bit2		; 0      0     
		 				; 0      1     
				;
				;execute bit1 or bit2
	endm
skp_both   macro	base1, bit1, base2, bit2
		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfsc	base1, bit1	
		else
		 btfsc	STACK,bit1
		endif
		if base2 < Bank1
		 btfss	base2, bit2	
		else
		 btfss	STACK-1,bit2
		endif
				
				
			
	    endm



if_fault    macro base1, bit1, base2, bit2
		skp_both base1, bit1, base2, bit2
	   endm


;execxorb 
old_skp_equal macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		 goto  	$+4			; 1      1    skp
		btfss	base2, bit2		; 0      0    skp
		 goto   $+3			; 0      1    
		goto	$+3
		btfsc   base2, bit2
					;execute    bit1 xor bit2
	endm

skp_equal macro	base1, bit1, base2, bit2	;bit1	bit2 result

		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfss	base1, bit1	
		else
		 btfss	STACK,bit1
		endif
		 goto	$+4
		if base2 < Bank1
		btfss	base2, bit2	
		else
		 btfss	STACK-1,bit2
		endif
		 goto   $+3			; 0      1    
		goto	$+3
		if base2 < Bank1
		btfsc	base2, bit2	
		else
		 btfsc	STACK-1,bit2
		endif
			; conditional code
	endm



if_either    macro base1, bit1, base2, bit2
		skp_equal base1, bit1, base2, bit2
	   endm


;execeqb 
old_skp_either macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0    skp 
		 goto  	$+4			; 1      1    
		btfsc	base2, bit2		; 0      0    
		 goto   $+3			; 0      1    skp
		goto	$+3
		btfss   base2, bit2
					;
				;execute    bit1 eq bit2
	endm

skp_either macro	base1, bit1, base2, bit2	;bit1	bit2 result

		if base1 >= Bank1
		 mov	base1, STACK
		endif
		if base2 >= Bank1
		 mov    base2, STACK-1
		endif
		if base1 < Bank1
		btfss	base1, bit1	
		else
		 btfss	STACK,bit1
		endif
		 goto	$+4
		if base2 < Bank1
		btfsc	base2, bit2	
		else
		 btfsc	STACK-1,bit2
		endif
		 goto   $+3			; 0      1    
		goto	$+3
		if base2 < Bank1
		btfss	base2, bit2	
		else
		 btfss	STACK-1,bit2
		endif
			; conditional code
	endm



if_equal    macro base1, bit1, base2, bit2
		skp_either base1, bit1, base2, bit2
	   endm

#define not_but 0
#define and 1
#define nor 2
#define or_not 3
#define or 4
#define not_or_not 5
#define either_or 6
#define equal 7
  


if__	macro base1, bit1, oprtr, base2, bit2
	  if oprtr == not_but
		if_but base1, bit1, base2, bit2
	  endif
	  if oprtr == and
		if_both base1, bit1, base2, bit2
	  endif
	  if oprtr == nor
		if_none base1, bit1, base2, bit2
	  endif
	  if oprtr == or_not
		if_ornot base1, bit1, base2, bit2
	  endif
	  if oprtr == or
		if_any base1, bit1, base2, bit2
	  endif
	  if oprtr == not_or_not
		if_fault base1, bit1, base2, bit2
	  endif
	  if oprtr == either_or
		if_either base1, bit1, base2, bit2
	  endif
	  if oprtr == equal
		if_equal base1, bit1, base2, bit2
	  endif

	
	endm

if__m	macro base1, bit1, oprtr, base2, bit2
	  if oprtr == not_but
		if_ornot base1, bit1, base2, bit2
	  endif
	  if oprtr == and
		if_none base1, bit1, base2, bit2
	  endif
	  if oprtr == nor
		if_both base1, bit1, base2, bit2
	  endif
	  if oprtr == or_not
		if_notbut base2, bit2, base1, bit1
	  endif
	  if oprtr == or
		if_fault base1, bit1, base2, bit2
	  endif
	  if oprtr == not_or_not
		if_any base1, bit1, base2, bit2
	  endif
	  if oprtr == either_or
		if_none base1, bit1, base2, bit2
	  endif
	  if oprtr == equal
		if_either base1, bit1, base2, bit2
	  endif
ifflag#v(level)=ilabcount
	goto iflab#v(ilabcount)
level+=1 	
ilabcount+=1

	endm

mov_bit	macro Source,Sbit, Target, Tbit
	  local setb,movtarget
		if (Source & 0x80 ) == (Target & 0x80)
		if Target >=Bank1
		 banksel	Bank1
		endif
		btfss	Source,Sbit
		 bcf	Target,Tbit
                btfsc Source,Sbit
		 bsf	Target,Tbit
		if Target >=Bank1
		 banksel	Bank0
		endif
		else
;		 mov	Source,STACK
;		 btfss STACK,Sbit
;		  goto setb
;		 mov Target,STACK	; not to be recommended
;		 bcf STACK,Tbit
;		 goto movtarget
;setb		mov Target,STACK
;		bsf	STACK,Tbit
;movtarget	mov STACK,Target
		endif
	endm
inv_bit	macro  Target, Tbit
	 movlw	1 << Tbit
	 xorwf	Target,F
	endm



sqrt	macro	Value	; :2 bytes


#define	DigitCount STACK 
#define	Odd	   STACK-2

  clrf   DigitCount
  clrf   Odd + 1                ;  Initialize the Different Values
  movlw  1      
  movwf  Odd


Loop:                           ;  Repeat Here until 
  movf   Odd + 1, w             ;  Calculate Value - Odd
  subwf  Value + 1, f           ;   Note, Result Stored Back in "Value"
  movf   Odd, w
  subwf  Value, f
  btfss  STATUS, C
   decf  Value + 1, f

  btfsc  Value + 1, 7           ;  If MSB of "Value" Set, Value is Negative
   goto  SqRootDone

  movlw  2                      ;  Go to the Next Odd Number
  addwf  Odd, f
  btfsc  STATUS, C
   incf  Odd + 1, f

  incf   DigitCount, f

  goto   Loop                   ;  Increment the Value of the Square Root

SqRootDone:    mov DigitCount,Value                 ;  Completed

	endm

sqrt_	macro	Result,var,bits
;	local done
;	variable	v1,v2,VB,DIF
;	v1 =  ((bits)-8)/8
;	v2 =  v1 + (bits/8)
;	VB = STACK-v1
;	DIF = STACK-v2
;	; first estimate
;	; shr	Value_B
;	; shl	Result
;	; inc shifts
;	; until	Result > Value_B
;	; 
;	; Odd = Result * 2 -1
;	; Result = Result * 2^shifts
;	; while	Result >Value
;	;	subtract	Odd
;	;       dec Result
;	;	dec_ Odd,2
;
;	mov_ 	var,VB,bits	
;	eq_	Result,-1,bits
;	shr_	Result,bits
;;***************************************** estimate
;
;;***************************************** estimate
;	mov_	Result,DIF,bits
;	inc_	DIF,bits
;	shr_	Result,bits
;	if_	VB,==,var
;	 goto	done
;	 add_	Result,DIF,bits
;	 add_   DIF,2,-bits
	endm

	
sqr_	macro	Result,var,bits
	variable	v1,v2,VB,DIF
	v1 =  ((2* bits)-8)/8
	v2 =  v1 + 2*(bits/8)
	VB = STACK-v1
	DIF = STACK-v2

	eq_	Result,.1,-bits*2
	eq_	VB,.1,-bits*2

pwr2est	shl_	VB,bits*2
; ************************************************* estimate
	if_	VB,==,0,bits		; var > maxbyte /2
	 goto	estok
	if_	VB, >=, var,bits
         goto  estok
	 mshl_	Result,2,bits
	 goto 	pwr2
; ***************************************************** estimate
estok	mov_	VB,DIF,bits*2
	inc_	DIF,bits*2		; difference = 2*base+1
	shr_	VB,bits*2
snglstp	if_	VB,==,var,bits
	 goto	done
	add_	Result,Result,DIF
	add_	DIF,DIF,2
	goto	snglstp
done
	endm	


;  Subroutines
LFSR macro		; random (shuffled) numbers


                        ;  LFSR the "Seed" Value
  movf    INDF, w            ;  Save the "Seed" Value for XORing Later
  decf	   FSR,F
  movwf   INDF
  rlf     INDF, f            ;  Shift Seed Up by 2
  rlf     INDF, f            ;  This is "B5 Tap"
  rlf     INDF, w            ;  Shift Seed Up by 3 for Second Value
  decf    FSR,F
  movwf   INDF              ;  This is the "B4 Tap"
  rlf     INDF, w           ;  This is the "B3 Tap"
  xorwf   INDF, w           ;  Combine B3 and B4 Taps
  incf    FSR,F
  xorwf   INDF, w            ;  Combine B5 Tap with B3 adn B4 Taps
  incf    FSR,F
  xorwf   INDF, w            ;  Combine B7 with B3, B4 and B5 Taps
  decf    FSR,F
  movwf   INDF
  rlf     INDF, f            ;  Put LSB into Carry
  incf    FSR,F
  rlf     INDF, f            ;  and Pass it to the Shifted Seed Value
;  return
  endm


LFSR2 macro

                       ;  LFSR the "Seed" Value
  rlf     INDF, w            ;  Get Bit 7 of "Seed"
 decf    FSR,F
  rlf     INDF, f            ;   and Save as Bit 0 of "Temp"
 incf    FSR,F 
 rrf     INDF, w            ;  Shift Down to Right
 decf    FSR,F
  xorwf   INDF, f            ;  Bit 1 -> Bit 0 for Operation
 decf    FSR,F
  movwf   INDF
  rrf     INDF, f           ;  Bit 2 -> Bit 0 for Operation
  rrf     INDF, w           ;  Bit 3 -> Bit 0 for Operation
  xorwf   INDF, w           ;  Bit 0 <- Bit 2 ^ Bit 3
 incf    FSR,F
  xorwf   INDF, f            ;  Temp.0 <- Bit 2 ^ Bit 3 ^ Bit 1 ^ Bit 7
  rrf     INDF, f            ;  C <- Temp.0
 incf    FSR,F 
 rlf     INDF, f            ;  Shift Up Seed with New LSB
;  return
 endm

linearize	macro result,equalsign,var

;	#define linlo   STACK-((lin.a+lin.b)*3)+1
;	#define linhi   STACK-2*lin.a-3*lin.b +1 
;        #define datlo   STACK-((lin.a+lin.b)*2)+1
;	#define dathi   STACK-lin.a-2*lin.b+1
;	#define	linmid	STACK-lin.a-lin.b +1
;	#define datmid	STACK-lin.b+1

   cblock	STACK-((lin.a+lin.b)*3)+1
	linlo:lin.a,linhi:lin.a,datlo:lin.b,dathi:lin.b,linmid:lin.a,datmid:lin.b
   endc

	local gtr,done,nxtbl,tsok,bins

		eq_	linmid,.1
		e_q	linlo,=,lin,[,.1,lit8,	lin.a

		if_	var,>,linlo,	lin.a
		 goto	bases
exbdry		do_	linmid,=,linmid,+,lin.a,	lit8
		e_q	datmid,=,lin,[,linmid,byte,	lin.b
		goto done

bases		e_q	linmid,=,lin,[,.0,lit8,	1
		e_q	linhi,=,lin,[,linmid,byte, lin.a
		
		if_	var,>=,linhi,	lin.a*8
		 goto exbdry

basesearch	do_	linmid,=,linmid,-,(lin.a+lin.b),lit8 
		e_q	linlo,=,lin,[,linmid,byte,lin.a
		
		
		if_	var,>=,linlo,	lin.a*8
		 goto 	binsearch
		eq_	linhi,=,linlo,	lin.a*8
		goto	basesearch


;	movlw	0
;	call	lin		; max value
;	movwf	STACK-1
;	decf	STACK-1,F
;
; 	
;	eq	FSR,linhi
;	eq	STACK,	lin.a+lin.b+lin.a	; eq_ INDF =  lin.a(stack)

;nxtbl	call lin
;	movwf	linhi
;	if lin.a >1 
;	incf	STACK,F
;	movfw	STACK
;	call 	lin
;	movwf	linhi+1
;	endif
;	;	repeat until lin.a
;	
;	if_	X,<,linhi, 	(lin.a*8)
;	 goto tsok
;	movlw	(lin.b+1)
;	addwf	STACK,F
;	movfw	STACK
;	decfsz  STACK-1,F			; check maximum entries
;	 goto	nxtbl
;	decl_	STACK,lin.a,	(lin.a*8)	; else return maximum result
;	movfw	STACK
;	call	lin
;	movwf	datmid
;		; repeat	(lin.a*8)
;	goto	done
;
;tsok	;movfw	STACK
;	;call	lin
;	;movwf	linhi	;INDF;incf FSR
;	incf	STACK,F 
;	movfw	STACK
;	call	lin
;	movwf	dathi	; repeat  until lin.b
;	
;	decl_	STACK, (lin.a+lin.b+lin.b),	(8)
;	movfw	STACK
;	call	lin
;	movwf	linlo	;INDF;incf FSR
;
;	incf	STACK,F ; repeat until lin.a
;	movfw	STACK	; repeat until lin.a
;	call	lin
;	movwf	datlo	; repeat  until lin.b
;
;	if_	X,>,linlo,	(lin.a*8)
;	 goto	bins				; check if X > linlo
;	eq_	datmid,=,datlo,	lin.b*8		; else return datlo
;	goto	done

binsearch	do_	linmid,=,linmid,+,lin.a,	lit8
		e_q	datlo,=,lin,[,linmid,byte,lin.b
	
		do_	linmid,=,linmid,+,(lin.a+lin.b),	lit8
		e_q	dathi,=,lin,[,linmid,byte,lin.b


bins	add_	datmid,datlo,dathi,	(lin.b*8)
	ror_	datmid,			(lin.b*8) ;repeat until lin.b
	add_	linmid,linlo,linhi,	(lin.a*8)
	ror_	linmid,			(lin.a*8);        until lin.a
	if_	linmid,>,var,lin.a*8
         goto gtr
	skpNZ
         goto done
	eq_	linlo,=,linmid,	lin.a*8
	eq_	datlo,=,datmid,	lin.b*8
	goto	bins
gtr	eq_	linhi,=,linmid,	lin.a*8
	eq_	dathi,=,datmid,	lin.b*8
	goto	bins
done	eq_	result,=,datmid,lin.b*8
	endm




mul	macro Result,MultiKator,bits, useSTACK ;bits/8 +1

	variable sign, bitspos

  if	bits	< 0
sign = -1
  else
sign = 1 
  endif
bitspos = bits*sign
	
	#define	rg22 useSTACK- ((bitspos-8) /8)
	#define	rg21 useSTACK- (bitspos)/8

	eq_	rg22,=,0, -bitspos
	eq_	rg21,=,bits, lit8
	shr_	Result,bitspos
mu1	bNC	 mu2
	add_	rg22,rg22,MultiKator,bits
mu2     ror_	rg22,bitspos
	ror_	Result,bitspos
	decfsz	rg21,F
	 goto mu1
;	
	endm

div macro	Result,DiviSor,bits, useSTACK
	variable sign, bitspos

  if	bits	< 0
sign = -1
  else
sign = 1 
   endif
bitspos = bits*sign

	#define	remainder useSTACK- ((bitspos-8) /8)
	#define	counter useSTACK- (bitspos)/8


	eq_	remainder,=,0,-bitspos
	eq_	counter,=,bits+1,lit8
	clrC
di1
	rol_	Result,bitspos
	decfsz  counter,F
	 goto	di2
	 goto dixit
di2
	rol_	remainder,bitspos
	sub_	remainder,remainder,DiviSor,bits
	skpNC
	 goto	di1				;carry set		
	add_	remainder,remainder,DiviSor,bits
	clrC
	goto di1

dixit
	endm