	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
 
 
 
 	ORG 0x00
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts

	



#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH  ;pnp
#define ANSELinit 	B'01111000' 	; ADC Frc clock, ((AN0,))AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on

#define PR2init		.255
#define CCPR1Linit      PR2init - .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2


#define 	PIR_Port	GPIO,5
#define 	PIR_Port_Number	5
#define 	Z_Detect_Port	GPIO,3	
#define 	LDR_Port	GPIO,0	
#define 	Relay_Port	GPIO,1	
#define 	LED_Port	GPIO,2	

;****************************************************************************************


	cblock	_MINRAM			; start of variables
	 SyS1,SyS2,BatAvr:5,AcAvr,shdwTRISIO,ACdbncE,LdrAvr
	    CasE
	 x,dispdata

	endc
#define	STACK	_MAXRAM	

TC0used = 3
TC1used = 1	


#define		AC_is_On	SyS1,7
#define		AC_is_High	SyS1,6
#define		Read_Out	SyS1,5
#define		PIR_Function	SyS1,4
#define		PIR_Operational	SyS1,3
#define		Dis_Ldr		SyS1,2
#define		Dis_Ldr_Bit	2	
#define		Test_Bit	SyS1,1

#define		MAINS_On	CasE,7
#define		LED_On		CasE,6
#define		Stay_Awake	CasE,5


#define		Allw_OverV	SyS2,7
#define		Main_Tenance	SyS2,6
#define		PWM_On		SyS2,5
#define		Manu_Overrd	SyS2,4

#define		LDR_Switched	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0
			       ;.60
#define		fkt		.15	
			       ;.1 test
dis_pwm		macro
		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	        ;make sure transistor is HIGH
;		bcf	LED_On
		endm

en_pwm		macro
		movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
;		bsf	LED_On
		endm	


JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0
			#define	LEDlight 0
		 goto	EVENT1
		 	#define blinkon	 1
		 	
		 goto	EVENT2
		        #define blinkoff 2
		 	
		 goto	EVENT3
		 goto	EVENT4
			
		 goto	EVENT5
			
		 goto	EVENT6
	
		 goto	EVENT7
		 

		 goto	EVENT8
	
		 goto	EVENT9
		 

		 goto	EVENT10
	
		 goto	EVENT11
		 
		 goto	EVENT12
		 
		 goto	EVENT13
		 
		 goto	EVENT14
		 
		 goto	EVENT15


ldrADC		eq_ 	ANSEL,=, B'01111001',lit8; ADC Frc clock, (AN0,AN3(GP4) as analog
 		eq_	ADCON0,=,b'00000001',lit8; left justified , AN0, on
		dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		
		eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
 		eq_ 	ANSEL,=, B'01111000',lit8; ADC Frc clock, (AN3(GP4) as analog
 
		retlw	0

batADC	
		;eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
		;dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		retlw	0
	
battery	
		call	batADC
		eq_	BatAvr,=,ADRESH,byte
;		goto	avrof4

avrof4		clrf	BatAvr+1
		movfw	BatAvr+2
		addwf	BatAvr,F		; 
		skpNC
		 incf	BatAvr+1,F
		movfw	BatAvr+3
		addwf	BatAvr,F		; 
		skpNC
		 incf	BatAvr+1,F
		movfw	BatAvr+4
		addwf	BatAvr,F		; 
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F

		eq_	BatAvr+4,=,BatAvr+3,byte
		eq_	BatAvr+3,=,BatAvr+2,byte
		eq_	BatAvr+2,=,ADRESH,byte

		retlw 	0
		
avrwith4		clrf	BatAvr+1
		movfw	INDF
		addwf	INDF,F		; not on ADRESH !
		skpNC
		 incf	BatAvr+1,F
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		movfw	ADRESH
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	INDF,F
		clrC
		rrf	BatAvr+1,F
		rrf	INDF,F
		retlw 0		

ldr		movlw	LdrAvr
		movwf	FSR
		call	ldrADC
;		eq_	LdrAvr,=,ADRESH,byte
;		retlw	0
		goto	avrwith4

effect		if_not	MAINS_On
		 bsf	Relay_Port		;Pnp
		if_bit	Main_Tenance
		 goto	enpwm
		if_bit	LED_On
		 goto	ledon
		dis_pwm
		goto	mainson
ledon		if_bit	PWM_On 			
		 goto	enpwm
		bcf	LED_Port		;pnp
		goto	mainson 
enpwm		
		en_pwm
mainson		if_bit	MAINS_On
		 bcf	Relay_Port		;Pnp
		return
	
		


		
slinear	
#define	howmany	1
#define V147	0x5E		;0x80;0x75  ;0x80		; 14.7
#define rs1	0xFF
#define V119	0xAA	;	0xB6;0xB3  ;0xB6
#define rs2	.20
	variable  hicount

	; calibrate
	; 11.9V 10101010   $AA	
	; 12.6  10100101   $A5
	; 13.6  10001110   $8C
	; 14.7   1011110   5E	

	if_	STACK,<=,V147,lit8
	 goto	lors1
	if_	STACK,>=,V119,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,V147,lit8
	eq_	STACK,=,rs1,lit8

	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (V119-V147)	

	else
hicount = (rs1-rs2)*.256 / (V119-V147)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

linearze		
		eq_	STACK,=,BatAvr,	byte
		call	slinear
		eq_	PR2,=,STACK,	byte
		do_	CCPR1L,=,STACK,-,.10,lit8	;pnp
		bsf	PWM_On
	return


cafterpwrup	
		call	battery
		bcf	Batt_Detect
		bcf	PWM_On
		if_ BatAvr, <,V147-10,lit8	;if capacitor > 14.7V
		 return
		bsf	Batt_Detect
		bsf	PWM_On
		return

BATtest		if_not	Batt_Detect
 		 return
 		call	battery			; update battery,LDR,PIR every 4 seconds
		if__	Main_Tenance,not_but,LED_On	
		 call	linearze

		return

		

acon		bcf	Read_Out		; read GPIO port
		btfsc	Z_Detect_Port		; store it
		 bsf    Read_Out
		movlw	b'00010000' 		; if equal to previous reading
		if_bit	Stay_Awake
		 movlw	b'00001000' 
		if__    Read_Out,equal,AC_is_High
	  	 goto	aconeq
	  	 iorwf  AcAvr,F			; change detected
	  	 if_not	ACdbncE,3
	      	  incf	ACdbncE,F
	      	 if_bit	ACdbncE,3
	      	 bsf	AC_is_On				
aconeq		 
		clrC
		rrf	AcAvr,F		; average hits
		movf	AcAvr,F

aconisZ	   macro     
		bcf	AC_is_On
		clrf	ACdbncE
	   endm	      	 	   
		i_f	STATUS,Z,then,aconisZ,_,_
	          
		bcf	AC_is_High		
		btfsc   Read_Out  		; store for next reading
		 bsf    AC_is_High	
		retlw	0
	 


	org	0x100
	
MLOOP	

MLOOP	clrwdt 			;8msec
	if_not	INTCON,T0IF
	 goto	$-2		; or go somewhere else
			
	goto	PERIODIC8
	
MLOOP0

	cblock
	 TC0:TC0used

	endc
	 #define PrjP0 CasE
	 	 
	decfsz	TC0,F
	 goto	endMLOOP0
	goto	PERIODIC2048
MLOOP01
	if TC0used > 1	
		movlw	0x07
		andwf	TC0+1,W
		addlw	-7
		skpnZ
		 goto	PERIODIC16sec
MLOOP017
		decfsz	TC0+1,F
	 	 goto	endMLOOP0
	endif

	if TC0used > 2
		decfsz	TC0+2,F
	 	 goto	endMLOOP0
	endif 

	movfw	PrjP0
	goto	JMPTable 
	 

end0MLOOP0
	call	effect
endMLOOP0	 

	cblock
	 TC1:TC1used,PrjP1
	endc

	decfsz	TC1,F
	 goto	endMLOOP1
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	movfw	PrjP1
	goto	JMPTable 
	 
endMLOOP1	 

	
	goto	MLOOP
	
	
	
ACcameon	bsf	AC_Detect
		call	cafterpwrup


		if_not	Manu_Overrd
		 goto	swC6

		movlw	b'11000000'	; if Mon or Lon
		andwf	CasE,W		
		skpnz
		 goto	swC6
;		sublw	b'01000000'
;		skpnz
		btfsc	LED_On
		 goto	EVENT6
	;	addlw	-5
		movlw	b'00001111'
		andwf	CasE,W
		addlw	-8
		skpNZ
		 goto	EVENT9 
		goto	EVENT0
	
swC6	
	
ACcase		if_bit	LED_On		; level dark
		 goto	EVENT6

;		movlw	b'01110000'	 ;M off, L on, ,wake, switch case 0
;		movwf	CasE
		if_	LdrAvr,>,0x80,lit8	;if_bit	LDR_Port
		 goto	EVENT6
		goto	EVENT0
	
;		
ACwentoff	bcf	AC_Detect
		bsf	Relay_Port	;pnp
		dis_pwm
;		movlw	0x1F
;		andwf	CasE,F		; Moff, Loff,sleep, no case change
;		if_not	LDR_Switched
		 bsf	Manu_Overrd

		EVENT0in	.5,sec,0xFF
		movlw	0xF0
		andwf	CasE,F
		movlw	0x05
		iorwf	CasE,F
		goto	endMLOOP0
	
	
	org	0x200


PWRUP	
		eq	SyS1,0
		eq	SyS2,0
		eq	CasE,0
		eq	AcAvr,0
		clrf	ACdbncE
		call	acon
afterwdt	init683

		call	ldrADC
		eq_	LdrAvr,=,ADRESH,byte

		bcf	Allw_OverV
		clrf	EnerLevel


		call	batADC
		eq_	BatAvr,=,ADRESH,byte
		movwf	BatAvr+2
		movwf	BatAvr+3
		movwf	BatAvr+4
			 
	

	

	EVENT0in	.400,msec,0xFF
	eq_		CasE,=,3,lit8



	eq_		x,=,1,lit8
	EVENT1in	1,msec,.15		 


PERIODIC8	
;		if_not	Test_Bit
;		 goto	nottestbit
;		en_pwm
;nottestbit
		call	acon
		if__	AC_Detect,not_but,AC_is_On
		 goto	ACcameon
		if__	AC_is_On,not_but,AC_Detect
		 goto	ACwentoff
;
pirdetect			
;		if_bit	PIR_Port
;		 bsf	GPIO,1
;		if_not	PIR_Port
;		 bcf	GPIO,1
;		goto	MLOOP0
;
		eq_	shdwTRISIO,=,TRISIO,byte
			; set Used_as_Output
		if_not	shdwTRISIO,PIR_Port_Number
		 goto	pirnotusable

		if_bit	PIR_Port
		 goto	pirishigh
		if_not	PIR_Function
		 goto	pirnotusable	; PIR was never high
		bsf	PIR_Operational 
					; PIR function detected
		if__	MAINS_On,or,LED_On
		 goto	pira
					; running enersave or darkPIR
		if_	LdrAvr,<,0xA0,lit8	; LED on level
		 goto	EVENT0
		if_not	AC_Detect
		 goto	pirnotusable
				;call	ldrADC 
				;if_	ADRESH,<,0xC0,lit8
		if_	LdrAvr,<,0xD9,lit8	; MAINSon level
 		 goto 	EVENT8
 		goto	pirnotusable
t_used = TC0used 				;.15*.60
pira		settrap	.15*fkt,sec,0,STACK-2,0				 
		if_	STACK-1,<,TC0+1,word
		 goto	pirnotusable
		eq_	TC0+1,=,STACK-1,word 
			 		 
pirishigh	bsf	PIR_Function
pirnotusable 
		goto MLOOP0

PERIODIC2048    ;call	ldr

		call	BATtest
		if_bit	Batt_Detect
		 goto	apbatt
		
		goto	MLOOP01
		
PERIODIC16sec	;bsf	Test_Bit
		;dis_pwm
		call	ldr
		if__	Manu_Overrd,or,LDR_Switched	
		 goto	nochange

		if_	LdrAvr,>,0xF0,lit8	
		 goto   alloff

		if_	LdrAvr,>,0xD0,lit8	
		 goto   ledoff_notmains

		if_	LdrAvr,>,0xB0,lit8	; Mains on by LDR	
		 goto   ledoff_mainson

nochange	

		goto	MLOOP017	
				 

ledoff_notmains if_bit	MAINS_On 				;too bright for LED ?
		 goto	nochange
		;else

alloff		bsf	LDR_Switched		 
		EVENT0in .17*fkt,sec,b'00000100'	; dark 


ledoff_mainson  if__	PIR_Operational,not_but,AC_Detect
		 goto	tston
		
		if_	LdrAvr,>,0xB9,lit8	; LED off by LDR
		 goto 	ledoff_notmains
		goto	nochange
		
tston		bsf	LDR_Switched		 
		EVENT0in .60*fkt,sec,b'10100000'; Mon, Loff,wake,>>0>>5>>4





EVENT0		bcf	LDR_Switched
		if_bit	Batt_Detect
		 call	linearze
	 		;.15*.60
		EVENT0in .17*fkt,sec,b'01100101'; Moff, Lon,wake,>>5>>4
	

EVENT1		en_pwm
		EVENT1in .100,msec,blinkoff

		

EVENT2		dis_pwm
		EVENT1in 2,sec,blinkon		
		
EVENT3		call	cafterpwrup
		goto	EVENT0 

EVENT4		bcf	LDR_Switched
		bcf	Manu_Overrd
		EVENT0in .120*fkt,sec,b'00000100';M off, L off, ,wake, >>Evt4

EVENT5		bcf	LDR_Switched
		bcf	Manu_Overrd
		if_not	Batt_Detect
 		 goto	EVENT4
 		eq_	PR2,=,.255,lit8
 		eq_	CCPR1L,=,.253,lit8	;pnp 
 		EVENT0in .240*fkt,sec,0xFF
		eq_	CasE,=,b'00100100',lit8	;M off, L off, ,wake, >>Evt4
 		goto	endMLOOP0		; without effect

EVENT6		EVENT0in 5,sec,	b'10110111'	;M on, L off, ,wake, >>Evt7

EVENT7		EVENT0in .10,sec,b'10111000'	;M on, L off, ,wake, >>Evt8

EVENT8		EVENT0in .120*fkt,sec,b'10110101';M on, L off, ,wake, >>Evt5

EVENT9		EVENT0in .17,sec,b'10111010'	;M on, L off, ,wake, >>10

EVENT10		

loopuntildark	incf	STACK,F
		if_	LdrAvr,<,0x90,lit8
		 goto	dark
		EVENT0in .17,sec,b'00111010'	;M off, L on, ,wake, >> 10

		
dark		swapf	STACK,W
		movwf	TC0+1
		andlw	0x07
		movwf	TC0+2
		do_	TC0+2,=,TC0+2,+,.1,lit8
		eq_	CasE,=,b'10111100',lit8	 ;M on, L off, ,wake, case 11		
		goto	end0MLOOP0

EVENT11		
		EVENT0in	.120*fkt,sec,b'01111100';M off, L on, ,wake, case 12


EVENT12	
untilbright	if_	LdrAvr,>,0xE0,lit8
		 goto	EVENT10
		EVENT0in .17*fkt,sec,b'01111100'	;M off, L on, ,wake, case 12

		
		
		
	cblock
	 EnerLevel
	endc	
		
		
	variable	volco,Volt

voltok
Volt = .141		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,	<, volco,lit8		; too high
		 goto	MLOOP01
Volt = .123		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,	>, volco,lit8		; too low
		 goto	MLOOP01

		EVENT1in	.1,msec,.15	; reset
		


apbatt		movlw	blinkoff
		subwf	PrjP1,W
		skpnZ
		 goto	voltok
		movlw	blinkon
		subwf	PrjP1,W
		skpnZ 
		 goto	voltok
		 
Volt = .118		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))
		if_	BatAvr,<,volco,lit8	
		 goto	apx2

apblink		 goto	EVENT1; <11.8V
		 
apx2
Volt = .123		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,<,volco,	lit8	
		 goto	apx3	
		bsf	Allw_OverV		; < 12.3
		goto	MLOOP01

apx3	

Volt = .136		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		 
apx3b		if_	BatAvr,<,volco,	lit8	
		 goto	apx4
		 


clrmaint	macro
		 bcf	Main_Tenance
		 ;i_f_not LED_On,then,dis_pwm			; switch off if necessary	
		 endm
decener		macro
		 decf	EnerLevel,F
		 eq_	STACK,=,BatAvr,byte
		 call	slinear
		 if_	STACK,<,PR2,byte
		  goto	ignore
		 do_	PR2,=,PR2,+,1,	lit8
		 do_	CCPR1L,=,CCPR1L,+,1,lit8	;pnp  
ignore
		endm
		movf	EnerLevel,F		; <13.6V hysteresis
		i_f	STATUS,Z,then,clrmaint,elseif,decener
		goto	MLOOP01
Volt = .138		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		  
apx4		if_	BatAvr,>,volco,	lit8	
		 goto	MLOOP01				; <13.8V hysteresis
		 
		if_bit	Allw_OverV  		; >13.8V 
		 goto	apx5
apince		bsf	Main_Tenance 
		if_	PR2,<,.19,lit8
		 goto	apblink
		incf	EnerLevel,F

		if__	LED_On,not_or_not,PWM_On
		 call	linearze

		do_	PR2,=,PR2,-,1,lit8
		do_	CCPR1L,=,CCPR1L,-,1,lit8	;pnp
		en_pwm			; switch on PWM if not already		
		goto	MLOOP01 
Volt = .147		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		 
		  
apx5		if_	BatAvr,>,volco,lit8	
		 goto	MLOOP01
		bcf	Allw_OverV 		; hold @ 13.8V
		goto	apince			; V > 14.7 
		











EVENT13
strtdis	movfw	x
	andwf	dispdata,W
	skpZ	
	 goto	long
	red 	5 
	EVENT1in .100,msec,.14

long	blue 	5
	EVENT1in .500,msec,.14

EVENT14 
pause	black	5
	EVENT1in .250,msec,.15

EVENT15 goto	endMLOOP1		; maximum Timer, no action

rsmedis	clrC
	rrf	x,F	;	next bit?
	bnC	strtdis	
	 
;		bsf	ADCON0,GO
;		btfsc	ADCON0,GO
;		 goto	$-1
;			 	;	pick up data
	movlw	1<<Dis_Ldr_Bit
	xorwf	SyS1,F
	movfw	BatAvr
	if_bit	Dis_Ldr
	 movfw	LdrAvr
	movwf	dispdata
	shr_	dispdata,byte
	shr_	dispdata,byte
	shr_	dispdata,byte
	shr_	dispdata,byte

;	eq_	dispdata,=,,byte
initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	dispdata,W
	bNZ	p0xit			; its a 1, start display
	clrC
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway
p0xit	
	black	5
	if_bit	Dis_Ldr
	 goto	shortpause
	EVENT1in 2,sec,.13	
shortpause
	EVENT1in .700,msec,.13


	
		end