;*   This file is the firmware to implement a LED and AC lamp switch, based on 		*
;*   the PIC12F683.  It monitors the zero crossing of the AC waveform,                  *
;*   and switches off the mains after 2 hours
;*
;*	CONNECT IT TO BATTERY, 15 MINUTES OF LED LIGHT, AFTER THAT DIM LED LIGHT
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    mcos 1.2.1                              		                *
;*    Date:         November, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3b.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*			\5\trafo-HU5-6-2t.brd         					*
;*                               							*
;*                                                                     			*
;*                  matching \5\smd+6+16.brd           					*
;*                                                                     			*
;****************************************************************************************







	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH
#define ANSELinit 	B'01111000' 	; ADC Frc clock, ((AN0,))AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on

#define PR2init		.255
#define CCPR1Linit      PR2init - .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

#define 	Z_Detect_Port	GPIO,3	
#define 	LDR_Port	GPIO,0	
#define 	Relay_Port	GPIO,1	
#define 	LED_Port	GPIO,2	

;****************************************************************************************


	cblock	_MINRAM			; start of variables

	    SyS1,SyS2,BatAvr:2
	    CasE
	    TimerCounter:3,JumpVector

	endc
#define	STACK	_MAXRAM	
	
	
#define		AC_Sumbit	AC_Avr,2
#define		AC_is_On	SyS1,5
#define		AC_is_High	SyS1,4
#define		Read_Out	SyS1,1

#define		MAINS_On	CasE,7
#define		LED_On		CasE,6
#define		Stay_Awake	CasE,5


#define		Allw_OverV	SyS2,7
#define		Main_Tenance	SyS2,6
#define		PWM_On		SyS2,5


#define		LDR_Bright	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0

;****************************************************************************************
;***** RESET VECTOR AND START OF CODE

	ORG     0x000           ; start coding 
        nop
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts

dis_pwm		macro
		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	        ;make sure transistor is HIGH
;		bcf	LED_On
		endm

en_pwm		macro
		movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
;		bsf	LED_On
		endm	


PWRUP
	
;	init_andis			; initiation analog data display
	eq_	FSR,=,BatAvr,lit8


		eq	SyS2,0
		eq	CasE,0
t_used = 3		
	 	settrap	.1 ,msec,tstlight,TimerCounter,JumpVector
afterwdt	init683
		call	batADC
		eq_	BatAvr,=,ADRESH,byte
		bsf	Allw_OverV
		clrf	EnerLevel
;		call	acon	; reset	readout
;		eq	ACAvr,0
;****************************************************************************************
		
MLOOP	if_not	Stay_Awake
	 goto	slpslp
	clrwdt 			;8msec
	if_not	INTCON,T0IF
	 goto	$-2		; or go somewhere else
	bcf	INTCON,T0IF 
	goto	afterslp
	
slpslp	sleep			; 35msec
	sleep			; not precise for on	


		
afterslp  	
		
;		call	acon
;		if__	AC_Detect,not_but,AC_is_On
;		 goto	ACcameon
;		if__	AC_is_On,not_but,AC_Detect
;		 goto	ACwentoff

;t_used = 2	
;		pwanadis 		; analog data display, GPIO5,
;t_used = 3				; long=high, short=low, off=hi Z
;

	
		decfsz	TimerCounter,F
	 	 goto	MLOOP			; 8 msec

 		call	battery			; update battery,LDR,PIR every 4 seconds


 		if_not	Main_Tenance	
		 call	linearze

		call	apbatt


		
		decfsz	TimerCounter+1,F
		 goto	MLOOP		

		 
		decfsz	TimerCounter+2,F
	 	 goto   MLOOP  			; expired counter

 	

		movfw	JumpVector
		movwf	PCL			; must be in first 256 bytes


dark	eq	CasE,b'00000000'	; Moff, Loff,sleep,case0
	call	effect
	goto	MLOOP			; ignore further timers, wait for power down

blinkon	;eq	CasE,b'01100000'	; Moff, Lon,wake,case0
	; bcf	PWM_On
;	call	effect
	bsf	Stay_Awake
	call	ledon
;		 clrwdt
;		 goto $-1
	settrap	.50,msec,blinkoff,TimerCounter,JumpVector
	goto	MLOOP	
			; 
blinkoff	;eq	CasE,b'00000000'	; Moff, Loff,sleep,case0
	dis_pwm
	bcf	Stay_Awake
		; do not use 2/4,sec !!!
	settrap	.2000/.4,msec,blinkon,TimerCounter,JumpVector
	goto	MLOOP			; 

tstlight bsf	PWM_On	
	eq	CasE,b'01100000'	; Moff, Lon,wake,case0
	call	effect
	settrap	200,sec,tstlight,TimerCounter,JumpVector
	goto	MLOOP


ledlight 	
	eq	CasE,b'01100000'	; Moff, Lon,wake,case0
	call	effect
		;.15
	settrap	.15*.60,sec,enersave,TimerCounter,JumpVector
	goto	MLOOP			; 

enersave  
	eq_	CCPR1L,=,.245,lit8	
	eq_	PR2,=,.255,lit8		;pnp
	goto	MLOOP			; ignore further timers, wait for power down

;ACcameon	bsf	AC_Detect

;switchcase	macro
;		 nop
;		end
;
case6	macro		
	 eq_	CasE,=,b'10110110',lit8	 ;M on, L off, ,wake, case 6
			;.120*.60
	 settrap	.30,sec,enersave,TimerCounter,JumpVector
 	endm
; 	
;case0	macro
;	 eq_	CasE,=,b'01110000'	 ;M off, L on, ,wake, case 0 
;
;	endm
;		
;c0or6   macro
;		 i_f	LDR_Port,then, case6, elseif, case0				
;	endm
;	
;		i_f	Preserv_Case,then,switchcase,elseif,c0or6
;	
;	
;		case0
;		call	effect

;		goto	MLOOP

;****************************************************************************************

;
;acon		bcf	Read_Out		; read GPIO port
;		btfsc	Z_Detect_Port		; store it
;		 bsf    Read_Out
;		bsf	AC_Sumbit		; if equal to previous reading
;		if__    Read_Out,equal,AC_is_High
;	  	 bcf	AC_Sumbit		; no change detected
;		bsf	AC_is_On
;		clrC
;		rrf	AC_Avr,F		; average hits
;		movf	AC_Avr,F
;		skpnZ
;	          bcf	AC_is_On
;		bcf	AC_is_High		
;		btfsc   Read_Out  		; store for next reading
;		 bsf    AC_is_High	
;		retlw	0
;		
		
		
		
effect		if_not	MAINS_On
		 bsf	Relay_Port		;Pnp
		if_bit	Main_Tenance
		 goto	enpwm
		if_bit	LED_On
		 goto	ledon
		dis_pwm
		goto	mainson
ledon		if_bit	PWM_On 			
		 goto	enpwm
		bcf	LED_Port		;pnp
		goto	mainson 
enpwm		en_pwm
mainson		if_bit	MAINS_On
		 bcf	Relay_Port		;Pnp
		return
		
slinear	
#define	howmany	1
#define V147	0x80		; 14.7
#define rs1	0xFF
#define V119	0xB6
#define rs2	.20
	variable  hicount
	; 11.9V	10110110   $B6
	; 12.6  10100101   $A5
	; 13.6  10001110   $8C
	; 14.1   1000011   ???$43	

	if_	STACK,<=,V147,lit8
	 goto	lors1
	if_	STACK,>=,V119,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,V147,lit8
	eq_	STACK,=,rs1,lit8
	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (V119-V147)	

	else
hicount = (rs1-rs2)*.256 / (V119-V147)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

linearze		
		eq_	STACK,=,BatAvr,	byte
		call	slinear
		eq_	PR2,=,STACK,	byte
		do_	CCPR1L,=,STACK,-,.10,lit8	;pnp
		bsf	PWM_On
	return
		
		
		

batADC	
		;eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
		;dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		retlw	0
	
battery
		call	batADC
		clrf	BatAvr+1
		movfw	BatAvr
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		movfw	ADRESH
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		retlw 0		



		org 0x100
	cblock
	 EnerLevel
	endc	
		
		
	variable	volco,Volt

voltok
Volt = .141		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,	<, volco,lit8		; too high
		 return
Volt = .123		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,	>, volco,lit8		; too low
		 return

		settrap	.100,msec,PWRUP,TimerCounter,JumpVector	; reset
		return


apbatt		movlw	blinkoff
		subwf	JumpVector,W
		skpnZ
		 goto	voltok
		movlw	blinkon
		subwf	JumpVector,W
		skpnZ 
		 goto	voltok
		 
Volt = .118		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))
		if_	BatAvr,<,volco,lit8	
		 goto	apx2

apblink		 settrap  .100,msec,blinkoff,TimerCounter,JumpVector; <11.8V
		 return
apx2
Volt = .123		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,<,volco,	lit8	
		 goto	apx3	
		 bsf	Allw_OverV		; < 12.3
		 return

apx3	

Volt = .136		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		 
apx3b		if_	BatAvr,<,volco,	lit8	
		 goto	apx4
		 


clrmaint	macro
		 bcf	Main_Tenance
		 call	effect			; switch off if necessary	
		 endm
decener		macro
		 decf	EnerLevel,F
		 eq_	STACK,=,BatAvr,byte
		 call	slinear
		 if_	STACK,<,PR2,byte
		  goto	ignore
		 do_	PR2,=,PR2,+,1,	lit8
		 do_	CCPR1L,=,CCPR1L,+,1,lit8	;pnp  
ignore
		endm
		movf	EnerLevel,F		; <13.6V hysteresis
		i_f	STATUS,Z,then,clrmaint,elseif,decener
		return
Volt = .138		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		  
apx4		if_	BatAvr,>,volco,	lit8	
		 return				; <13.8V hysteresis
		 
		if_bit	Allw_OverV  		; >13.8V 
		 goto	apx5
apince		bsf	Main_Tenance 
		if_	PR2,<,.19,lit8
		 goto	apblink
		incf	EnerLevel,F

		if__	LED_On,not_or_not,PWM_On
		 call	linearze

		do_	PR2,=,PR2,-,1,lit8
		do_	CCPR1L,=,CCPR1L,-,1,lit8	;pnp
		call	effect			; switch on PWM if not already		
		return 
Volt = .147		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		 
		  
apx5		if_	BatAvr,>,volco,lit8	
		 return
		bcf	Allw_OverV 		; hold @ 13.8V
		goto	apince			; V > 14.7 
		

	

;		 
;	cblock
;	 x
;	endc
;		 
;#define	E1	0x1000		 
;	eq_	x,=,.0,	(lit8)
;;;
;rpt	eq_	STACK,=,x,byte
;
;	call	slinear			; 10Khz @ 0x8A = 13.5V 20kHz @ 12.6V
;	e_q 	E1,[,x,byte,]=,STACK,byte
;	incfsz	x,F
;	 goto rpt
;	goto $		
;;;				
			
	end