;*   This file is the firmware to implement a LED and AC lamp switch, based on 		*
;*   the PIC12F683.  It monitors the zero crossing of the AC waveform,                  *
;*   and switches off the mains after 2 hours
;*
;*	
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    mcos 1.3.3                              		                *
;*    Date:         November, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3b.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*			\5\trafo-HU5-6-2t.brd         					*
;*                               							*
;*                                                                     			*
;*                  matching \5\smd+6+16.brd           					*
;*                                                                     			*
;****************************************************************************************







	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH
#define ANSELinit 	B'01111000' 	; ADC Frc clock, ((AN0,))AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on

#define PR2init		.255
#define CCPR1Linit      PR2init - .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2


#define 	PIR_Port	GPIO,5
#define 	Z_Detect_Port	GPIO,3	
#define 	LDR_Port	GPIO,0	
#define 	Relay_Port	GPIO,1	
#define 	LED_Port	GPIO,2	

;****************************************************************************************


	cblock	_MINRAM			; start of variables

	    SyS1,SyS2,BatAvr:2,AcAvr,ACdbncE,LdrAvr
	    CasE
	    TimerCounter:3,JumpVector,TC2:3,JpV2

	endc
	init_andis			; initiation analog data display	
#define	STACK	_MAXRAM	
	
	


#define		AC_is_On	SyS1,7
#define		AC_is_High	SyS1,6
#define		Read_Out	SyS1,5
#define		PIR_Function	SyS1,4
#define		PIR_Operational	SyS1,3

#define		MAINS_On	CasE,7
#define		LED_On		CasE,6
#define		Stay_Awake	CasE,5
#define		Switch_Case	CasE,4


#define		Allw_OverV	SyS2,7
#define		Main_Tenance	SyS2,6
#define		PWM_On		SyS2,5


#define		LDR_Switched	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0

#define		fkt		.60

;****************************************************************************************
;***** RESET VECTOR AND START OF CODE

	ORG     0x000           ; start coding 
 
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts


dis_pwm		macro
		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	        ;make sure transistor is HIGH
;		bcf	LED_On
		endm

en_pwm		macro
		movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
;		bsf	LED_On
		endm	


		
MLOOP	if_not	Stay_Awake
	 goto	slpslp
	clrwdt 			;8msec
	if_not	INTCON,T0IF
	 goto	$-2		; or go somewhere else
	bcf	INTCON,T0IF 
	goto	afterslp
	
slpslp	sleep			; 35msec
	sleep			; not precise for on	


		
afterslp  	
		
		call	acon
		if__	AC_Detect,not_but,AC_is_On
		 goto	ACcameon
		if__	AC_is_On,not_but,AC_Detect
		 goto	ACwentoff


t_used = 2	
;		eq_	FSR,=,LdrAvr,lit8
;		anadis 	5,blue,red,black	; analog data display, GPIO5,
t_used = 3				; long=high, short=low, off=hi Z
		goto	pirdect

tc2inc		decfsz	TC2,F
	 	 goto	tc			; 8 msec

;		movlw	0x07
;		andwf	TC2+1,W
;		addlw	-7
;		skpnZ
		 call	ldr
		 
		decfsz	TC2+1,F
	 	 goto	tc			; 

		decfsz	TC2+2,F
	 	 goto	tc			; 


		movfw	JpV2
		movwf	PCL

	
tc		decfsz	TimerCounter,F
	 	 goto	MLOOP			; 8 msec

		movlw	0x03
		andwf	TimerCounter+1,W
		addlw	-3
		skpnZ
  		 CALL	BATtest

		
tc1		decfsz	TimerCounter+1,F
		 goto	MLOOP		

		 
		decfsz	TimerCounter+2,F
	 	 goto   MLOOP  			; expired counter
;
; 		dis_pwm
; 		
;		clrwdt
;		decfsz	STACK,F
;		 goto	$-2
;		en_pwm
;		
		movfw	JumpVector
		movwf	PCL			; must be in first 256 bytes

timedout	movlw	0x0F
		andwf	CasE,W
		addwf	PCL,F
		 goto	LEDlight	; case 0>>enersave>>darkPIR		
		 goto	tocase2		;1
		 goto	tocase3         ;2
		 goto	tocase0         ;3
		 goto	tocase0         ;4
		 goto	tocase0         ;5
		 goto	tocase7         ;6
		 goto	tocase8         ;7
		 goto	tocase0      	;8
		 goto	tocase10	;9
		 goto	loopuntildark   ;10
		 goto	tocase12   	;11
		 goto	untilbright     ;12
		 goto	tocase10      	;13



;****************************************************************************************


darkPIR	eq	CasE,b'00000000'	; Moff, Loff,sleep,case0

	movlw	darkPIR
	movwf	JumpVector
	call	effect
	goto	MLOOP			; ignore further timers, wait for power down

blinkon	;eq	CasE,b'01100000'	; Moff, Lon,wake,case0
	; bcf	PWM_On
;	call	effect
	bsf	Stay_Awake
	call	ledon
;		 clrwdt
;		 goto $-1

	settrap	.50,msec,blinkoff,TC2,JpV2
	goto	MLOOP	
			; 
blinkoff	;eq	CasE,b'00000000'	; Moff, Loff,sleep,case0
	dis_pwm
	bcf	Stay_Awake
		; do not use 2/4,sec !!!
	settrap	.2000/.4,msec,blinkon,TC2,JpV2
	goto	MLOOP			; 
t_used=3

tstlight bsf	PWM_On	
	eq	CasE,b'01100000'	; Moff, Lon,wake,case0
	call	effect
	settrap	200,sec,tstlight,TimerCounter,JumpVector
	goto	MLOOP


LEDlight 		;.15*.60
	settrap	.15*fkt,sec,enersave,TimerCounter,JumpVector
	
;
; 		dis_pwm
; 		
;		clrwdt
;		decfsz	STACK,F
;		 goto	$-2
;		decfsz	STACK-1,F
;		 goto	$-4
;		en_pwm
;		
	
		
	movlw	LEDlight
	if_not	Batt_Detect
	 movwf	JumpVector
ll2	eq	CasE,b'01100000'	; Moff, Lon,wake,case0
	if_bit	Batt_Detect		;
	 call	linearze			; to avoid stepping 
	call	effect

	goto	MLOOP			; 

enersave if_not	Batt_Detect
	  goto	darkPIR 
	eq	CasE,b'00100000'	; semaphore
	eq_	CCPR1L,=,.253,lit8	
	eq_	PR2,=,.255,lit8		;pnp
		;.120*.60
	settrap	.300*fkt,sec,darkPIR,TimerCounter,JumpVector
	goto	MLOOP			; 
;****************************************************************************************

ACcameon	bsf	AC_Detect
;		movlw	afterpwrup
;		subwf	JpV2,W
;		skpnZ
		 call	cafterpwrup


		if_not	Switch_Case
		 goto	swC6



soff		movlw	0x0F
		andwf	CasE,W
		addwf	PCL,F
		 goto	makecase1		; 0
		 goto	makecase0		; 1
		 goto	makecase4		; 2
		 goto	makecase0		; 3	
		 goto	makecase0		; 4
		 goto	makecase0		; 5
		 goto	makecase0		; 6
		 goto	makecase9		; 7
		 goto	makecase0		; 8
		 goto	makecase0		; 9
		 goto	makecase0		;10
		 goto	makecase0		;11
		 goto	makecase0		;12
		 goto	makecase0		;13


;****************************************************************************************

tstl4		settrap .20,sec,tstLDR,TC2,JpV2
		bcf	LDR_Switched
		goto 	tc
		
tstLDR		if_bit	LDR_Switched
		 goto	tstl4
		goto	tstl1
		
afterpwrup	call cafterpwrup
		if_not	Batt_Detect
		 goto	MLOOP
		goto	LEDlight
;****************************************************************************************

		org 0x100
;****************************************************************************************

tstl1		;call	ldr				; call	analog LDR
		if_	LdrAvr,<,0xF3,lit8	
		 goto   tstl2
		
tstoff		bsf	LDR_Switched
		settrap	.60/4,sec,0,TC2,0		; really bright
		goto	darkPIR




tstl2		if_not	LED_On 				;too bright for LED ?
		 goto tstl4
		if_	LdrAvr,<,0xD9,lit8
		 goto	tstl4
		if__	PIR_Operational,not_but,AC_Detect
		 goto	tston				; 
		goto	tstoff


tston		settrap	.15*fkt,sec,0,TC2,0		; 
		eq_	CasE,=,b'10111000',lit8	 ;M on, L off, ,wake,switch, case 8
		call	effect
			;.30*.60
		settrap	.30*fkt,sec,darkPIR,TimerCounter,JumpVector

		goto	MLOOP

swC6


tc120m	macro
         settrap .120*fkt,sec,tstl4,TC2,JpV2
         bcf	LDR_Switched
        endm
tc20	macro
	 settrap .20,sec,tstLDR,TC2,JpV2
	endm	
		i_f	LDR_Switched,then,tc120m,elseif,tc20

			
	 	settrap	.5,sec,timedout,TimerCounter,JumpVector
 	
ACcase		movlw	b'01110000'	 ;M off, L on, ,wake, switch case 0
		movwf	CasE
		if_bit	LED_On
		 goto	AC6case
		if_	LdrAvr,<,0x80,lit8
		 goto nocase 				
AC6case		 movlw	b'10110110'	 ;M on, L off, ,wake, switch case 6
		movwf	CasE
nocase		call	BATtest
		call	effect
		
		goto	MLOOP
		


		
ACwentoff	bcf	AC_Detect
	
		movlw	0x1F
		andwf	CasE,F		; Moff, Loff,sleep, no case change
		if_not	LDR_Switched
		 bsf	Switch_Case
		call	effect
		settrap	.5/4,sec,darkPIR,TimerCounter,JumpVector
					; 5 seconds time for AC to come on
		goto	MLOOP		
		
slinear	
#define	howmany	1
#define V147	0x80		; 14.7
#define rs1	0xFF
#define V119	0xB6
#define rs2	.20
	variable  hicount
	; 11.9V	10110110   $B6
	; 12.6  10100101   $A5
	; 13.6  10001110   $8C
	; 14.1   1000011   ???$43	

	if_	STACK,<=,V147,lit8
	 goto	lors1
	if_	STACK,>=,V119,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,V147,lit8
	eq_	STACK,=,rs1,lit8
	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (V119-V147)	

	else
hicount = (rs1-rs2)*.256 / (V119-V147)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

linearze		
		eq_	STACK,=,BatAvr,	byte
		call	slinear
		eq_	PR2,=,STACK,	byte
		do_	CCPR1L,=,STACK,-,.10,lit8	;pnp
		bsf	PWM_On
	return
		


;****************************************************************************************
		
cafterpwrup	call	battery
		bsf	Batt_Detect
		if_ BatAvr, <,V147-10,lit8	;if capacitor > 14.7V
		 bcf	Batt_Detect
;		bcf	PWM_On
;		if_bit	Batt_Detect
;		 bsf	PWM_On 
;	
;	
	 settrap .20,sec,tstLDR,TC2,JpV2
		return

PWRUP	
;	eq_	DispCounter,=,0x0101,	lit16
;	movlw	initdis
;	movwf	DisprVector

	
		eq	SyS1,0
		eq	SyS2,0
		eq	CasE,0
		
	 	settrap	.500 /4,msec,afterpwrup,TC2,JpV2
	 	movlw	MLOOP
		movwf	JumpVector

afterwdt	init683
		eq	AcAvr,0
		clrf	ACdbncE
		call	acon

		call	batADC
		eq_	BatAvr,=,ADRESH,byte
		
		call	ldrADC
		eq_	LdrAvr,=,ADRESH,byte
			 
		bsf	Allw_OverV
		clrf	EnerLevel
		goto	MLOOP
		

		
;****************************************************************************************


ldrADC		eq_ 	ANSEL,=, B'01111001',lit8; ADC Frc clock, (AN0,AN3(GP4) as analog
 		eq_	ADCON0,=,b'00000001',lit8; left justified , AN0, on
		dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		
		eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
 		eq_ 	ANSEL,=, B'01111000',lit8; ADC Frc clock, ((AN0,))AN3(GP4) as analog
 
		retlw	0





acon		bcf	Read_Out		; read GPIO port
		btfsc	Z_Detect_Port		; store it
		 bsf    Read_Out
		movlw	b'00010000' 		; if equal to previous reading
		if_bit	Stay_Awake
		 movlw	b'00001000' 
		if__    Read_Out,equal,AC_is_High
	  	 goto	aconeq
	  	 iorwf  AcAvr,F			; change detected
	  	 if_not	ACdbncE,3
	      	  incf	ACdbncE,F
	      	 if_bit	ACdbncE,3
	      	 bsf	AC_is_On				
aconeq		 
		clrC
		rrf	AcAvr,F		; average hits
		movf	AcAvr,F

aconisZ	   macro     
		bcf	AC_is_On
		clrf	ACdbncE
	   endm	      	 	   
		i_f	STATUS,Z,then,aconisZ,_,_
	          
		bcf	AC_is_High		
		btfsc   Read_Out  		; store for next reading
		 bsf    AC_is_High	
		retlw	0
		
pirdect		;if_bit	PIR_Port
		; bsf	GPIO,1
		;if_not	PIR_Port
		; bcf	GPIO,1
		if_bit	PIR_Port
		 goto	tc0
		if_not	PIR_Function
		 goto	tc0+1
		bsf	PIR_Operational 
		if__	MAINS_On,or,LED_On
		 goto	tpira
					; running enersave or darkPIR
		if_	LdrAvr,<,0x80,lit8
		 goto	LEDlight
		if_not	AC_Detect
		 goto	tc0
		;call	ldrADC 
		;if_	ADRESH,<,0xC0,lit8
		if_	LdrAvr,<,0xD4,lit8
 		 goto 	AC6case
 		goto	tc0
 			;.15*.60
tpira		settrap	.15*fkt,sec,0,STACK-2,0				 
		if_	STACK-1,<,TimerCounter+1,word
		 goto	tc0
		eq_	TimerCounter+1,=,STACK-1,word 
			 		 
tc0		bsf	PIR_Function
		goto	tc2inc	
		
		
effect		if_not	MAINS_On
		 bsf	Relay_Port		;Pnp
		if_bit	Main_Tenance
		 goto	enpwm
		if_bit	LED_On
		 goto	ledon
		dis_pwm
		goto	mainson
ledon		if_bit	PWM_On 			
		 goto	enpwm
		bcf	LED_Port		;pnp
		goto	mainson 
enpwm		en_pwm
mainson		if_bit	MAINS_On
		 bcf	Relay_Port		;Pnp
		return
		
batADC	
		;eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
		;dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		retlw	0
	
battery		movlw	BatAvr
		movwf	FSR
		call	batADC
		
avrof4		clrf	BatAvr+1
		movfw	INDF
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		movfw	ADRESH
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	INDF,F
		clrC
		rrf	BatAvr+1,F
		rrf	INDF,F
		retlw 0		

ldr		movlw	LdrAvr
		movwf	FSR
		call	ldrADC
		goto	avrof4

BATtest		if_not	Batt_Detect
 		 return
 		call	battery			; update battery,LDR,PIR every 4 seconds
		if__	Main_Tenance,not_but,LED_On	
		 call	linearze
		call	apbatt
		return

		
		
		
	cblock
	 EnerLevel
	endc	
		
		
	variable	volco,Volt

voltok
Volt = .141		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,	<, volco,lit8		; too high
		 return
Volt = .123		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,	>, volco,lit8		; too low
		 return

		settrap	.100,msec,0x00,TimerCounter,JumpVector	; reset
		return


apbatt		movlw	blinkoff
		subwf	JumpVector,W
		skpnZ
		 goto	voltok
		movlw	blinkon
		subwf	JumpVector,W
		skpnZ 
		 goto	voltok
		 
Volt = .118		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))
		if_	BatAvr,<,volco,lit8	
		 goto	apx2

apblink		 settrap  .100,msec,blinkoff,TimerCounter,JumpVector; <11.8V
		 return
apx2
Volt = .123		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119)) 
		if_	BatAvr,<,volco,	lit8	
		 goto	apx3	
		 bsf	Allw_OverV		; < 12.3
		 return

apx3	

Volt = .136		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		 
apx3b		if_	BatAvr,<,volco,	lit8	
		 goto	apx4
		 


clrmaint	macro
		 bcf	Main_Tenance
		 ;i_f_not LED_On,then,dis_pwm			; switch off if necessary	
		 endm
decener		macro
		 decf	EnerLevel,F
		 eq_	STACK,=,BatAvr,byte
		 call	slinear
		 if_	STACK,<,PR2,byte
		  goto	ignore
		 do_	PR2,=,PR2,+,1,	lit8
		 do_	CCPR1L,=,CCPR1L,+,1,lit8	;pnp  
ignore
		endm
		movf	EnerLevel,F		; <13.6V hysteresis
		i_f	STATUS,Z,then,clrmaint,elseif,decener
		return
Volt = .138		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		  
apx4		if_	BatAvr,>,volco,	lit8	
		 return				; <13.8V hysteresis
		 
		if_bit	Allw_OverV  		; >13.8V 
		 goto	apx5
apince		bsf	Main_Tenance 
		if_	PR2,<,.19,lit8
		 goto	apblink
		incf	EnerLevel,F

		if__	LED_On,not_or_not,PWM_On
		 call	linearze

		do_	PR2,=,PR2,-,1,lit8
		do_	CCPR1L,=,CCPR1L,-,1,lit8	;pnp
		en_pwm			; switch on PWM if not already		
		return 
Volt = .147		
volco = V119-  ((Volt-.119) * (V119-V147) / (.147-.119))		 
		  
apx5		if_	BatAvr,>,volco,lit8	
		 return
		bcf	Allw_OverV 		; hold @ 13.8V
		goto	apince			; V > 14.7 
		
makecase0	; goto LEDlight
		eq_	CasE,=,b'01100000',lit8	 ;M off, L on, ,wake, case 0 
	 	settrap	.15*.60,sec,enersave,TimerCounter,JumpVector
sweff		call	effect
		goto	MLOOP
		
cmakecase1	settrap	5,sec,timedout,TimerCounter,JumpVector
		eq_	CasE,=,b'10110001',lit8	 ;M on, L off, ,wake, case 1
		return

makecase1	call	cmakecase1
		goto	sweff

makecase4	eq_	CasE,=,b'01110100',lit8	 ;M off, L on, ,wake, case 4
t120		settrap	.120*fkt,sec,timedout,TimerCounter,0
		goto	sweff		

makecase9	eq_	CasE,=,b'10111001',lit8	 ;M on, L off, ,wake, case 9
		settrap	.15,sec,timedout,TimerCounter,0
		goto	sweff		

	
tocase0		goto	LEDlight
		
;		if_bit	Batt_Detect
;		 goto	darkPIR
;		goto	ledPIR

tocase2		incf	CasE,F
		settrap	.10,sec,timedout,TimerCounter,0		
		goto	MLOOP

tocase3		incf	CasE,F
		 	;.60*.60			
		settrap	.15*fkt,sec,timedout,TimerCounter,0
		goto	MLOOP
;
;tocase4		movlw	0xF0
;		andwf	CasE,F
;		movlw	4
;		addwf	CasE,F
;		settrap	.120*.60,sec,timedout,TimerCounter,0
;		goto	MLOOP
;
tocase7		incf	CasE,F	; 6->7
		settrap	.10,sec,timedout,TimerCounter,0
		goto	MLOOP

tocase8		incf	CasE,F	; 7->8
			;.60 * .120 - .120*.60
		settrap	.120*fkt,sec,timedout,TimerCounter,0		
		goto	MLOOP

tocase10	eq_	CasE,=,b'01111010',lit8	 ;M off, L on, ,wake, case 10
t15		settrap	.15,sec,timedout,TimerCounter,0
		goto	sweff


loopuntildark	incf	STACK,F
		;call	ldrADC
		;if_	ADRESH,<,0x90,lit8
		if_	LdrAvr,<,0x90,lit8
		 		;btfss	LDR_Port
		 goto	dark
		goto t15
		;settrap	15,sec,timedout,TimerCounter,0
		;goto	MLOOP
		
dark		eq_	CasE,=,b'10111011',lit8	 ;M on, L off, ,wake, case 11		
		swapf	STACK,W
		movwf	TimerCounter+1
		andlw	0x07
		movwf	TimerCounter+2
		do_	TimerCounter+2,=,TimerCounter+2,+,.1,lit8
;		call 	set120mintime		;test
		goto	sweff

tocase12	eq_	CasE,=,b'01111100',lit8	 ;M off, L on, ,wake, case 12
		goto	t120


untilbright	if_	LdrAvr,<,0xE0,lit8
		;call	ldrADC
		;if_	ADRESH,<,0xC0,lit8
		;btfss	LDR_Port
		 goto	t15
bright		goto	tocase10

;
;ldrADC		eq_ 	ANSEL,=, B'01111001',lit8; ADC Frc clock, (AN0,AN3(GP4) as analog
; 		eq_	ADCON0,=,b'00000001',lit8; left justified , AN0, on
;		dlay	6
;		bsf	ADCON0,GO
;		btfsc	ADCON0,GO
;		 goto	$-1
;		
;		eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
; 		eq_ 	ANSEL,=, B'01111000',lit8; ADC Frc clock, ((AN0,))AN3(GP4) as analog
; 
;		retlw	0
;
;	

;		 
;	cblock
;	 x
;	endc
;		 
;#define	E1	0x1000		 
;	eq_	x,=,.0,	(lit8)
;;;
;rpt	eq_	STACK,=,x,byte
;
;	call	slinear			; 10Khz @ 0x8A = 13.5V 20kHz @ 12.6V
;	e_q 	E1,[,x,byte,]=,STACK,byte
;	incfsz	x,F
;	 goto rpt
;	goto $		
;;;				
			
	end