;****************************************************************************************
;*   This file is the firmware to implement 
;*	2 timers, which on expiration can trigger 16 different single event routines
;*      furthermore the possibility of insertion of code into periodic routines 
;*	which occur every 64 microseconds, 8 milliseconds, 2 seconds and 16 seconds
;*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    MICROCHIP OS for 12F629.asm                              		                *
;*    Date:         December, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                  EU TAX ID  263676163                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3c.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=12F629	; list directive to define processor
	#include  macros3c.asm
	config629
 	ORG 0x00
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts
	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00111000'	; GPIO0,1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;****************************************************************************************
	cblock	_MINRAM			; start of variables
	 SyS1,SyS2
	 PeriodTimer,TonPeriod,ToN
	endc
#define	STACK	_MAXRAM	
#define	Si_Lence	SyS1,0

PWRUP	
		eq	SyS1,0
		eq	SyS2,0

afterwdt		init629

TC0used = 3					; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
		EVENT0in	.500,msec,0xFF  ; set time @ 500 milliseconds
		clrf	NmbrEvent0		; set execution  for EVENT0
TC1used = 2
	cblock
	 TC1:TC1used,NmbrEvent1
	endc
		EVENT1in	1,msec,.15	;EVENT15 in 1 msec, goto MLOOP	 

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

soundtable	andlw	0x07
		addwf   PCL,F
		 retlw .250	; A	;retlw .218  ; H
		 retlw .188	; B
	         retlw .159	; C	;retlw .133  ; C#
		 retlw .108	; D	;
		 retlw .61	; E     ;retlw .83   ; D#
		 retlw .40	; F	
		 retlw	.0      ; G	;retlw .19   ; F#
		 		; add	318 for microseconds
	org	0x100
	
MLOOP	clrwdt
	decfsz	PeriodTimer,F
	 goto	n64MLO
	decfsz	PeriodTimer+1,F
	 goto	n64MLO
	if_not_m	Si_Lence
	 movlw	4				; sound produce 
	 xorwf	GPIO,F	
	 eq_	PeriodTimer,=,TonPeriod,lit16		
	else_m
	 bcf	GPIO,2
	end_m
;
;	if_not	TMR0,0			;example for very short periodic events
;	 goto	n64MLO
;	goto	PERIODIC64usec
exitPERIODIC64usec		
;	if_bit	TMR0,0			; avoid multiple P64u's
;	 goto	exitPERIODIC64usec
;
n64MLO	
	if_not	INTCON,T0IF		; wait for timer TMR0 to time out
	 goto	MLOOP
	bcf	INTCON,T0IF			
	goto	PERIODIC8		; which is 8 milliseconds
exitPERIODIC8
	decfsz	TC0,F
	 goto	endMLOOP0
	goto	PERIODIC2048		; after first TC0 expired, 2048 milliseconds 
exitPERIODIC2048			; have passed
	if TC0used > 1
	movlw	0x07			;example for very long periodic events
	andwf	TC0+1,W
	addlw	-7
	skpnZ
	 goto	PERIODIC16sec		; every 16 seconds (Event0 must be later!)
exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	NmbrEvent0		; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		; now jump to loaded Event
end0MLOOP0	 
endMLOOP0				; and continue execution here	 

	decfsz	TC1,F			; analogous as TC0
	 goto	endMLOOP1
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	movfw	NmbrEvent1
	goto	JMPTable 
	 
endMLOOP1	 
	goto	MLOOP

	org	0x200
PERIODIC64usec			
		goto	exitPERIODIC64usec

PERIODIC8
		goto	exitPERIODIC8			

PERIODIC2048	
		goto	exitPERIODIC2048
		
PERIODIC16sec	
		goto	exitPERIODIC16sec	
				 
EVENT0		
		
EVENT1	

EVENT2			
		
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
		EVENT0in .60,sec,0	;loop

EVENT13		eq_	TonPeriod,=,.318,	lit16
		movfw	ToN
		call	soundtable
		addwf	TonPeriod,F
		if_C
		 incf 	TonPeriod+1,F
	
		EVENT1in .500,msec,.14

EVENT14 	bsf	Si_Lence
	
		EVENT1in .30,msec,.15

EVENT15         bcf	Si_Lence
		incf	ToN,F
		if_	ToN,>,6,	lit8
	         clrf	ToN
		EVENT1in .30,msec,.13	



	
		end