;****************************************************************************************
;*   This file is the firmware to implement NFET gate driver, based on 		*
;*   the PIC12F629.  It monitors the battery voltage and indicates
;*   the voltage on a LED with long and short pulses
;*
;*	CALIBRATE 13.6 VOLTS WITH 4 DASHES (4 LONG PULSES)
;*		
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    629.3.1.asm                              		                *
;*    Date:         December, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3b.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                  needs 10nF @ GPIO0 and the resistor to resulting Voltage             							*
;*             like                                                        			*
;*          D:\eagle-5.4.0\projects\3w12\vr2                   					*
;*                                                                     			*
;****************************************************************************************
	list      p=12F629	; list directive to define processor
	#include  macros3b.asm
	config629
 	ORG 0x00
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts

	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define TRISIOinit 	b'00101000'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000000'	; GPIO 2 all LOW 
#define VRCONinit	b'10101000'	; enable,low range,8/24 Volts ofVDD
#define GP1_Porton	b'00010110'; GP1     ; configure comparator input=on
#define GP0_Porton	b'00011110'; GP0     ; configure comparator input=on, int ref, GP0
#define CMCONinit	GP0_Porton

#define	NFET_Port	GPIO,2

;****************************************************************************************


	cblock	_MINRAM			; start of variables
	 SyS1,SyS2,BatAvr:2,EnerLevel
	 x,dispdata

	endc
#define	STACK	_MAXRAM	
#define	ADRESH	STACK




#define		Allw_OverV	SyS2,7
#define		Main_Tenance	SyS2,6
#define		PWM_On		SyS2,5

#define		fkt		.60



PWRUP	
		eq	SyS1,0
		eq	SyS2,0

afterwdt		init629
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt1

		call	batADC
		eq_	BatAvr,=,ADRESH,byte
		
			 
		bsf	Allw_OverV
		clrf	EnerLevel
	



dis_pwm		macro
		bcf	PWM_On
		endm

en_pwm		macro
		bsf	PWM_On
		endm	

	
TC0used = 3
	EVENT0in	.500,msec,0xFF
	clrf	PrjP0
;
	eq_	x,=,1,lit8
TC1used = 2

	EVENT1in	1,msec,.15		 

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0
			
		 goto	EVENT1

		 goto	EVENT2
	
		 goto	EVENT3
		 goto	EVENT4
			
		 goto	EVENT5
			
		 goto	EVENT6
	
		 goto	EVENT7
		 

		 goto	EVENT8
	
		 goto	EVENT9
		 

		 goto	EVENT10
	
		 goto	EVENT11
		 
		 goto	EVENT12
		 
		 goto	EVENT13
		 
		 goto	EVENT14
		 
		 goto	EVENT15


;ldrADC		eq_ 	ANSEL,=, B'01111001',lit8; ADC Frc clock, (AN0,AN3(GP4) as analog
; 		eq_	ADCON0,=,b'00000001',lit8; left justified , AN0, on
;		dlay	6
;		bsf	ADCON0,GO
;		btfsc	ADCON0,GO
;		 goto	$-1
;		
;		eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
; 		eq_ 	ANSEL,=, B'01111000',lit8; ADC Frc clock, ((AN0,))AN3(GP4) as analog
; 
;		retlw	0
;
ADCON629B	macro	port
		
;		eq_	VRCON,=,b'10101000',lit8	; enable,low range,8/24 Volts ofVDD
;		;movlw	b'10101000'
;		;banksel	Bank1
;		;movwf	VRCON
;		;banksel	Bank0
;					;REGISTER 6-2: 
;					;VRCON  VOLTAGE REFERENCE CONTROL REGISTER 
;					;(ADDRESS: 99h)
;					;R/W-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
;					;VREN      VRR        VR3   VR2   VR1   VR0
;					;
;					;bit 7 VREN: CVREF Enable bit
;					;1 = CVREF circuit powered on
;					;0 = CVREF circuit powered down, no IDD drain
;					;bit 6 Unimplemented: Read as '0'
;					;bit 5 VRR: CVREF Range Selection bit
;					;1 = Low range
;					;0 = High range
;					;bit 4 Unimplemented: Read as '0'
;					;bit 3-0 VR3:VR0: 
;					;CVREF value selection 0 = VR [3:0] = 15
;					;When VRR = 1: CVREF = (VR3:VR0 / 24) * VDD
;					;When VRR = 0: CVREF = VDD/4 + (VR3:VR0 / 32) * VDD
;
;#define GP1_Porton	b'00010110'; GP1     ; configure comparator input=on
;#define GP0_Porton	b'00011110'; GP0     ; configure comparator input=on, int ref, GP0

;
;		if port == 1
;		 movlw	GP1_Porton     ; configure comparator input
;		endif
;		if port == 0
;		movlw	GP0_Porton
;		 endif
;		movwf	CMCON
;
		movlw	(OPTIONinit & 0xF0) | 0x01	; 1:4 Timer
		mov_f	OPTION_REG
		clrwdt

		banksel	TRISIO
		 bsf	TRISIO,port
		banksel GPIO
;
;		ifdef	shdw_TRISIO
;		 movlw	((1<<port)) 
;		 iorwf	shdw_TRISIO,W
;		 mov_f	shdw_TRISIO   
;		else
;		 ifdef	TRISIOinit
;		   movlw	((1<<port) ) | TRISIOinit;    IOdir
;		 else
;		   movlw	b'00001011'
;		 endif
;		endif
;		if	TRISIO <> shdw_TRISIO
;		mov_f	TRISIO
;		endif
;
;		mov	TMR0,STACK
		clrf	TMR0
		bcf	INTCON,T0IF	
		btfss	CMCON,COUT  	;btfss	GPIO,port
		 goto	$-1
		eq_	STACK,=,TMR0,byte
		movlw	0xFF
		if_bit	INTCON,T0IF
		 movwf	STACK
;		sub	STACK,TMR0,STACK
	
		goto	okmes
afterwdt1	eq	STACK,.255	
okmes		bcf	GPIO,port			;

;
;		ifdef	shdw_TRISIO
;		 movlw	(0x0F - (1<<port)) 
;		 andwf	shdw_TRISIO,F
;		 movfw	shdw_TRISIO   
;		else
;		 ifdef	TRISIOinit;    IOdir
;		   movlw	(0x3F - (1<<port) ) & TRISIOinit;    IOdir
;		 else
;		   movlw	b'00001011' & (0x3F - (1<<port))
;		 endif	
;		endif			; 
;		mov_f	TRISIO
		banksel	TRISIO
		 bcf	TRISIO,port
		banksel GPIO
;							; discharge C for next measurement
		movlw	OPTIONinit ; 1:4 Timer off
		mov_f	OPTION_REG
		endm

#define		V147	b'00001010'
#define		V138	b'00001110'
#define		V136	b'00001111'
#define		V125	b'00110011'

batADC		clrf	STACK
		decfsz	STACK,F
		 goto	$-1
		ADCON629B	0
		;eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
		;dlay	6
		;bsf	ADCON0,GO
		;btfsc	ADCON0,GO
		; goto	$-1
		retlw	0
	
battery		movlw	BatAvr
		movwf	FSR
		call	batADC
		eq_	BatAvr,=,ADRESH,byte		
		retlw	0

avrof4		clrf	BatAvr+1
		movfw	INDF
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		movfw	ADRESH
		addwf	INDF,F
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	INDF,F
		clrC
		rrf	BatAvr+1,F
		rrf	INDF,F
		retlw 0		
;
;ldr		movlw	LdrAvr
;		movwf	FSR
;		call	ldrADC
;		goto	avrof4
;


	 



	org	0x100
	
MLOOP	clrwdt
	if_not	TMR0,0
	 goto	n64MLO

	goto	PERIODIC64u
eMLOOP	if_bit	TMR0,0		; avoid multiple P64u's
	 goto	eMLOOP

n64MLO	if_not	INTCON,T0IF
	 goto	MLOOP
	bcf	INTCON,T0IF
			
	goto	PERIODIC8
	
MLOOP0

	cblock
	 TC0:TC0used
	 PrjP0
	endc

	 
	 
	decfsz	TC0,F
	 goto	endMLOOP0
	goto	PERIODIC2048
MLOOP01
	 
	 
	if TC0used > 1
	
		movlw	0x07
		andwf	TC0+1,W
		addlw	-7
		skpnZ
		 goto	PERIODIC16sec
MLOOP017
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
	if TC0used > 2
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	PrjP0
	goto	JMPTable 
	 

end0MLOOP0
	;call	effect
endMLOOP0	 

	cblock
	 TC1:TC1used,PrjP1
	endc

	decfsz	TC1,F
	 goto	endMLOOP1
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	movfw	PrjP1
	goto	JMPTable 
	 
endMLOOP1	 

	
	goto	MLOOP
	
	

	
	org	0x200
PERIODIC64u	if_not	PWM_On
		 goto	eMLOOP

		bsf	NFET_Port
		dlay	.10
		bcf	NFET_Port
			
		goto	eMLOOP

PERIODIC8	if_	BatAvr,>,V125,lit8
		 bsf	Allw_OverV	
		if_	BatAvr,>,V136,lit8
		 goto	less13.6
		if_	BatAvr,<,V138,lit8
		 goto	over13.8
		goto	MLOOP0

over13.8	if_not	Allw_OverV
		 bcf	PWM_On
		if_	BatAvr,<=,V147,lit8
		 goto	over14.7
		goto	MLOOP0
	
over14.7	bcf	PWM_On
		bcf	Allw_OverV
		goto	MLOOP0			

less13.6	bsf	PWM_On
		goto MLOOP0

PERIODIC2048	call	battery
		goto	MLOOP01
		
PERIODIC16sec	
	
nochange	goto	MLOOP017	
				 




EVENT0		
		EVENT0in .60,sec,b'01100000'; Moff, Lon,wake,>>5>>4
	

EVENT1
		

EVENT2			
		
EVENT3
		 

EVENT4		


EVENT5		
		

EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		


EVENT11		


EVENT12	


EVENT13
strtdis	movfw	x
	andwf	dispdata,W
	skpZ	
	 goto	long
	blue 5 
	EVENT1in .100,msec,.14

long	blue 5
	EVENT1in .500,msec,.14

EVENT14 
pause	black	5
	EVENT1in .300,msec,.15

EVENT15 
rsmedis	clrC
	rrf	x,F	;	next bit?
	bnC	strtdis	
	 
;		bsf	ADCON0,GO
;		btfsc	ADCON0,GO
;		 goto	$-1
;	call	battery			;	pick up data
	eq_	dispdata,=,BatAvr,byte	

initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	dispdata,W
	bNZ	p0xit			; its a 1, start display
	clrC
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway
p0xit	
	black	5
	EVENT1in 2,sec,.13	



	
		end