
;Software License Agreement                                         
;                                                                    
                                                                   
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 1kHz Signal on          *
;*   GPIO2 Port2, increased by each pushbutton action                  *
;*    File Version: A                                                  *
;*                                                                     *
;*    Author:       G M DRYGAS                                         *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   m0.asm (macros)                                *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F200	; list directive to define processor

	#include  m0-1.asm

	config200		; reasonable configuration bits

#define	OPTIONinit	b'11000101'	; no wakup, no pullup, Clock 1:64
#define TRISIOinit b'00001011'	; all ports input bar GP2	
#define CMCON0init b'01111011'  ; no COUTpin,not invert,not source
								; ON,int ref,GP0,no wkup 		
	

	init2xx			; reasonable initiation of special function registers 

	cblock _MINRAM
	 Sys1, HiCount,DutyCase,Bcounter
	endc
#define	GPis_on		Sys1,0
#define	GPwas_on	Sys1,1
#define	TMR07Bit	Sys1,7

	goto	start

long		bsf		GPIO,2				;3

short		bsf		GPIO,2				;3

veryshort	bsf		GPIO,2				;3
			delay	.8
			retlw 0




start
	eq_	HiCount,=,.128,			lit8
;	vardelay	Bcounter, .750
;	eq_	Bcounter ,=,0xC1,		lit8		; 970 cycles 1kHz
	eq_	DutyCase,=,b'00001101',			lit8 
loop        
	if_bit	TMR0,7			; software emulation of
	 goto	set7			; timer 0 overflow
	if_not	TMR07Bit		;
	 goto	set7+1
	bcf	TMR07Bit			; timer 0 has overflown 


	if_m	GPIO,3,is_on,		singlebit

	 if_m	HiCount,>,.128+5,	lit8		; 5*64*256us = 500us
	  bsf	GPis_on
	 else_m
	  incf	HiCount,F
	 end_m
	  
	else_m
	  
	 if_m	HiCount,<,.128-5,	lit8		; after 10*100us = 1ms
	  bcf	GPis_on
	 else_m
	  decf	HiCount,F
	 end_m

	end_m

	if__ GPis_on,not_but,GPwas_on
	  bcf	GPwas_on

	if__m GPwas_on,not_but,GPis_on
 ;    do_    Bcounter,=,Bcounter,*,.181,     (lit8); freq = freq * 1.4
;	 eq_	Bcounter,=,STACK,byte
;	 decf	DutyCase,F
	movlw	b'00000010'			; toggle 13 and 15
	xorwf	DutyCase,F
	 bsf	GPwas_on
	end_m 

	goto	set7+1

set7	bsf	TMR07Bit


;puls 
;	btfsc	CMCON0,7
;	 goto	nopulse				;	wait until voltage is low
		
	movlw	.15
	andwf	DutyCase,W
	addwf	PCL,F
	bsf	    GPIO,2			;0
	bsf	    GPIO,2			;1
	bsf	    GPIO,2		;2
	bsf	    GPIO,2				;3
	bsf	    GPIO,2				;4
	bsf	    GPIO,2				;5
	bsf	    GPIO,2				;6
	bsf	    GPIO,2				;7
	bsf	    GPIO,2				;8
	bsf	    GPIO,2				;9
	bsf	    GPIO,2				;10
	bsf	    GPIO,2				;11
	bsf	    GPIO,2				;12
	bsf	    GPIO,2				;13
	call	veryshort				;14
	bcf	    GPIO,2					;15

nopulse
	; exec_vardelay 	Bcounter		; maximal off time 1msec
	delay	.20

	goto loop					
	
	end