
;Software License Agreement                                         
;                                                                    
                                                                   
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 1kHz Signal on          *
;*   GPIO2 Port2, increased by each pushbutton action                  *
;*    File Version: A                                                  *
;*                                                                     *
;*    Author:       G M DRYGAS                                         *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   m0.asm (macros)                                *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F206	; list directive to define processor
	#include  m0.asm
	config206		; reasonable configuration bits
#define	OPTIONinit	b'11000101'	; no wakup, no pullup, Clock 1:64
#define TRISIOinit b'00001011'	; all ports input bar GP2	
#define CMCON0init b'01111011'  ; no COUTpin,not invert,not source
								; ON,int ref,GP0,no wkup 		
	

	init2xx			; reasonable initiation of special function registers 

	cblock _MINRAM
	 Sys1, HiCount,Bcounter
	endc
#define	GPis_on		Sys1,0
#define	GPwas_on	Sys1,1
#define	TMR07Bit	Sys1,7

	goto	start

long		bsf		GPIO,2				;3

short		bsf		GPIO,2				;3

veryshort	bsf		GPIO,2				;3
			delay	.6
			retlw 0




start
	eq_	HiCount,=,.128,			lit8
;	eq_ DutyCase,=,.15,			lit8
	eq_	Bcounter ,=,0xC1,		lit8		; 970 cycles 1kHz
;	eq_	DutyCase,=,.12,			lit8 
loop        
	if_bit	TMR0,7			; software emulation of
	 goto	set7			; timer 0 overflow
	if_not	TMR07Bit		;
	 goto	set7+1
	bcf	TMR07Bit			; timer 0 has overflown 


	if_m	GPIO,3,is_on,		singlebit

	 if_m	HiCount,>,.128+5,	lit8		; 5*64*256us = 500us
	  bsf	GPis_on
	 else_m
	  incf	HiCount,F
	 end_m
	  
	else_m
	  
	 if_m	HiCount,<,.128-5,	lit8		; after 10*100us = 1ms
	  bcf	GPis_on
	 else_m
	  decf	HiCount,F
	 end_m

	end_m

	if__ GPis_on,not_but,GPwas_on
	  bcf	GPwas_on

	if__m GPwas_on,not_but,GPis_on
     do_    Bcounter,=,Bcounter,*,.181,     (lit8); freq = freq * 1.4
	 
	 bsf	GPwas_on
	end_m 

	goto	puls

set7	bsf	TMR07Bit


puls 
	btfsc	CMCON0,7
	 goto	nopulse				;	wait until voltage is low
;		
;	movlw	.15
;	andwf	DutyCase,W
;	addwf	PCL,F
;	call	long			;0
;	call	short			;1
;	call	veryshort		;2
;	call	veryshort				;3
;	call	veryshort				;4
;	call	veryshort				;5
;	call	veryshort				;6
;	call	veryshort				;7
;	call	veryshort				;8
;	call	veryshort				;9
;	call	veryshort				;10
;	call	veryshort				;11
;	call	veryshort				;12
;	call	veryshort				;13
;	call	veryshort				;14
	bsf		GPIO,2
	bcf	    GPIO,2					;15

nopulse
	eq_		STACK,=,Bcounter,		byte

	GOTO	$+1
	DECFSZ	STACK,F
	GOTO	$-2


	goto loop					
	
	end