

	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683B
	
#define OPTIONinit	B'11000101';	; clock 1:64 , WDT 1:1 ,	
#define TRISIOinit 	b'00111001'	; GPIO1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000110'	; GPIO1,2 HIGH
#define ANSELinit 	B'01111000' 	; ADC Frc clock, ((AN0,))AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on

#define PR2init		.128
#define CCPR1Linit      PR2init - .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2


	cblock	_MINRAM			; start of variables

	    SystemStatus,SyS2		; byte that holds vital flags
	    CasE
	    DeadCount,IsDead
	    TimerCounter:3,JumpVector
	    AL
	    BatAvr:2
	endc
	#define STACK	_MAXRAM
	

;***** CONSTANT DEFINITIONS

#define		Active_Flag	SystemStatus,7
#define		After_Pwrup	SystemStatus,6
#define		AC_is_ON	SystemStatus,5
#define		AC_is_High	SystemStatus,4
#define		Ovr_Load	SystemStatus,3
#define		Read_Out	SystemStatus,2

;#define		Twice_Pass	Sys2,3
;#define		twicebit	b'00001000'
;*****************T W I C E **************************************************
;#define		TWCES		0
;*****************************************************************************
#define		LED_On		SyS2,7
#define		PWM_On		SyS2,6
#define		MAINS_On	SyS2,5


#define		LDR_bright	SyS2,2
#define		Batt_Detect	SyS2,1
#define		AC_Detect	SyS2,0




	;#define	mainsbit	b'00000001'

;******************************************************************************

#define 	LDR_Port	GPIO,0
#define 	LED_Port	GPIO,2
#define 	PIR_Port	GPIO,5
#define 	Relay_Port	GPIO,1

#define 	Z_Detect_Port	GPIO,3		
;
;#define		pat0	b'01010101'	;11	; pattern switching
;#define		pat1	b'00110011'	;10
;#define		pat2	b'01110100'	;01
;#define		pat3	b'00111001'     ;00
;#define		pat4	b'00011110'
;


;******************************************************************************

		
		
dis_pwm		macro
		movlw	b'11110011'	; disable pwm
		andwf	CCP1CON,F
		bsf	GPIO,2	        ;make sure transistor is HIGH
		bcf	LED_On
		endm

en_pwm		macro
		movlw	b'00001100'	; enable pwm
		iorwf	CCP1CON,F
		bsf	LED_On
		endm





;***** RESET VECTOR AND START OF CODE

	ORG     0x000           ; start coding 
        nop
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts


#define Lo_Intensity	.255
#define Hi_Intensity	.20
	
vtable	addwf	PCL,F
	dt	2* (1+1)-1
	dt 0x32,Lo_Intensity
	dt 0xB6,Hi_Intensity

	; 11.9V	10110110   $B6
	; 12.6  10100101   $A5
	; 13.6  10001110   $8C
	; 14.1   1000011   $43	
		
		clrf	TMR0
		bcf 	INTCON,T0IF
inloop		clrwdt
		call	acon
		if_bit AC_is_ON
		 bsf	Active_Flag		;anytime	
		if_not	INTCON,T0IF
		 goto	inloop
		bcf	INTCON,T0IF	
		decfsz	TimerCounter,F
	 	 goto	ACexpect		; 16 msec
		
		decfsz	TimerCounter+1,F
		 goto	tstLDR			; update battery,LDR,PIR every 4 seconds
 
t_used = 3
		decfsz	TimerCounter+2,F
	 	 goto   inloop  		; expired counter
 	
		movfw	JumpVector
		movwf	PCL			; must be in first 256 bytes
		
ACexpect	if_not	AC_Detect
		 goto	ACup
		if_not	Active_Flag
		 goto	pwrlost		
ACcont		bcf	Active_Flag
		goto	inloop
ACup		if_not	Active_Flag
		 goto	inloop
		bsf	AC_Detect
		call	cmakecase1
		goto	ACcont	 		
		
						; update battery,LDR,PIR
tstLDR		if_not	LDR_Port		; if	PIR on and dark enough
		 goto	tstbatt			; WARNING LDR not triggered by LED light
		if_not	Batt_Detect
		 goto	tstPIR
		if_bit 	LED_On
		 goto	darkPIR			; too bright for LED		


tstbatt		if_not	Batt_Detect
		 goto	tstPIR
		call	battery
		if_	BatAvr,>, 0xBF,		lit8
		 goto	nobatt			;	if BatAver > 11.8V
		goto	apbatt
		
tstPIR		btfsc	PIR_Port		;	15 minutes timertrap
		 goto inloop
		settrap	.5*.60,sec,darkPIR,TimerCounter,0
		goto	inloop

nobatt		bcf	MAINS_On
		bcf	LED_On
		call	effect
		settrap	2,sec, checkcharge,TimerCounter,JumpVector
		goto	inloop		; 
checkcharge	call	battery
		if_	BatAvr,>, 0xA5,		lit8
		 goto	nobatt			;	if BatAver > 11.8V
		goto	MAIN
		

soff		movfw	CasE
		addwf	PCL,F
		 goto	makecase1		; 0
		 goto	makecase0		; 1
		 goto	makecase4		; 2
		 goto	makecase0		; 3	
		 goto	makecase0		; 4
		 goto	makecase0		; 5
		 goto	makecase0		; 6
		 goto	makecase9		; 7
		 goto	makecase0		; 8
		 goto	makecase0		; 9
		 goto	makecase0		;10
		 goto	makecase0		;11
		 goto	makecase0		;12
		 goto	makecase0		;13




timedout	movfw	CasE
		addwf	PCL,F
		 goto	tocase0		; case 0->> loop		
		 goto	tocase2		;1
		 goto	tocase3         ;2
		 goto	tocase0         ;3
		 goto	tocase0         ;4
		 goto	tocase0         ;5
		 goto	tocase7         ;6
		 goto	tocase8         ;7
		 goto	tocase0      	;8
		 goto	tocase10	;9
		 goto	loopuntildark   ;10
		 goto	tocase12   	;11
		 goto	untilbright     ;12
		 goto	tocase10      	;13






undoreset
	
;	init_andis			; initiation analog data display

	init683				; initiation

	return
;******************************************************************************

godead		decfsz	IsDead,f
		 goto	moreslp		;preserve case	
		eq	CasE,.0
		bcf	MAINS_On
		bsf	LED_On
moreslp		eq_	DeadCount,=,.100/.16,lit8
gsleep		sleep
;******************************************************************************
afterwdt 	decfsz	DeadCount,F		; 
		 goto	gsleep			; wait for DeadCount*18ms

		btfsc	After_Pwrup		; 
		 goto	a_pwrup

		call	acon
		if_not	AC_is_ON
		 call	poll11msAC
		if__	AC_Detect,not_but,AC_is_ON
		 goto	chkswich		; wakeup throu AC
	 	movf	IsDead,F
	 	skpZ
	 	 goto	godead			; blackloop
		if_not 	PIR_Port
		 goto	MAIN			; wakeup throu PIR
		goto	moreslp			; loop in sleep
	

darkPIR		bcf	LED_On
		bcf	MAINS_On
		call	effect
		goto	moreslp

MAIN	
		call 	poll11msAC
		if_not	AC_is_ON
		 call 	poll11msAC
		mov_bit	AC_is_ON,AC_Detect

		mov_bit	LDR_Port,LDR_bright

		call	battery
		bsf	Batt_Detect
		if_ BatAvr, <,0x32,lit8	;if capacitor > 14.7V
		 bcf	Batt_Detect
		; case 0 or 6  to start with
		clrf	TMR0			; 16.384 msec
		eq 	DeadCount, .3		; max16+54 ms timeout
		
;;************************************************detect batt******************************
;disp		clrwdt
;		if_not	INTCON,T0IF
;		 goto	disp
;		bcf	INTCON,T0IF
;	eq_	FSR,=,SyS2,	lit8	; variable to display in indirect register
;	
;t_used=2	
;		anadis 2, red,red,blue	; analog data display, GPIO2,long=low,
;
;		movf	x,f
;		skpZ
;		goto disp
;		goto MAIN
;t_used=3
;;******************************************************************************


case_W_6	movfw	SyS2
		andlw	0x07	
		addwf	PCL,F			;	bright batt AC
		 goto	 moreslp 		;	0       0   0
		 goto	 drknobac		;	0       0   1 
		 goto    drkbanoac		;	0       1   0
		 goto	 drkbaac		;       0       1   1
		 goto	 moreslp	
		 goto	 brtnobac		;       1       0   1
		 goto	 brtbanoac		;	1	1   0
		 goto	 brtbaac		;       1       1   1
		
drknobac	clrf	CasE
		bcf	MAINS_On
		bcf	PWM_On
		bsf	LED_On 				; dark, nobatt, ac
		settrap	.15*.60,sec,timedout,TimerCounter,JumpVector 
		goto	ewl 
		 
drkbaac		clrf	CasE				; dark, batt, ac
		settrap	.5*.60,sec,timedout,TimerCounter,JumpVector

cwwl		bcf	MAINS_On
		bsf	LED_On
		call	linearze
ewl		call	effect
		goto	inloop

drkbanoac	clrf	CasE				; dark,batt, noac
		settrap	.5,sec,darkPIR,TimerCounter,JumpVector 		
		goto	cwwl		
				
brtbaac		call	linearze	 		; bright, batt, ac
		goto	brt6
		
brtnobac	bcf	PWM_On				; bright, nobatt, ac
		
brt6		eq	CasE,.6			
		bsf	MAINS_On
		bcf	LED_On
		settrap	.5,sec,timedout,TimerCounter,JumpVector 
		goto	ewl 
						

							; bright, batt, noAC
brtbanoac	eq	CasE,.6
		goto	darkPIR

PWRUP		call	undoreset		; reset WDT	
		clrf	SystemStatus		; clr all flags incl Mains_On
		clrf	SyS2
		clrf	IsDead
gomain		bsf	After_Pwrup		; wait 18*3 msec
		eq	DeadCount,.3		; for sufficient voltage
		goto	gsleep


a_pwrup		call undoreset			; pwrup sequence
		call	batADC
		eq_	BatAvr,=,ADRESH,byte
		bcf	After_Pwrup
		goto MAIN
		
		

;notfirst
;		call acon
;		if_bit	AC_is_ON	
;		 goto	blu
;		red 5
;		clrwdt
;		goto notfirst
;blu		blue 5
;		
;		clrwdt
;		decfsz	STACK,F
;		 goto $-2
;		goto notfirst
;

	
;		anadis 5, blue,red,black	; analog data display, GPIO5,
						; long=high, short=low, off=hi Z
;		goto	afterpin	

pwrlost		

		call	poll11msAC		; check if AC is really dead
		btfsc	AC_is_ON
		 goto	inloop-2			; resume
switchedoff	eq	IsDead,.75		; blackloop 7.5 sec
;
;	#ifdef TWCES				; switch only
;		movlw	twicebit		;
;		xorwf	SystemStatus,F		; every second pass
;		btfsc	Twice_Pass		;
;		 goto	godead 
;	#endif
;		
		bcf 	MAINS_On		; switch off relay
		bcf	AC_Detect				; pwm
		bcf	LED_On			; disable pwm
		call	effect
			        		; make sure transistor is HIGH - pnp
;		red 5
		goto	soff

;*************************************************************test
;		call	flic
;*************************************************************test		


chkswich	call	effect			; switch mains or led
;**********************************************************************
		bsf	AC_Detect
		goto	inloop

makecase0	eq	CasE,.0
		bcf	MAINS_On
		bsf	LED_On
;		clrf	TimerCounter+2		;test
		;call	set5sectime		;test
;		bcf	Dim_LED
		goto	godead
cmakecase1	settrap	5,sec,timedout,TimerCounter,JumpVector
		eq	CasE,.1
		bcf	LED_On
		bsf	MAINS_On
		return

makecase1	call	makecase1
		goto	godead




makecase4	eq	CasE,.4
		bsf	MAINS_On
		settrap	.120*.60,sec,timedout,TimerCounter,JumpVector
		goto	godead		

makecase9	eq	CasE,.9
		settrap	.15,sec,timedout,TimerCounter,JumpVector

		goto	godead		



	
tocase0		clrf	CasE
		bcf	MAINS_On
		if_bit	Batt_Detect
		 goto	darkPIR
		goto	drknobac


tocase2		eq	CasE,.2
		settrap	.10,sec,timedout,TimerCounter,JumpVector

;		bsf	MAINS_On		
		goto	inloop

tocase3		eq	CasE,.3
		settrap	.15*.60,sec,timedout,TimerCounter,JumpVector

;		bsf	MAINS_On		
		goto	inloop

tocase4		eq	CasE,.4
		settrap	.120*.60,sec,timedout,TimerCounter,JumpVector

;		bsf	MAINS_On		
		goto	inloop

tocase7		eq	CasE,.7
		settrap	.10,sec,timedout,TimerCounter,JumpVector

;		bsf	MAINS_On		
		goto	inloop

tocase8		eq	CasE,.8
		settrap	.120*.60,sec,timedout,TimerCounter,JumpVector

;		bsf	MAINS_On		
		goto	inloop

tocase10	eq	CasE,.10
t15		settrap	.15,sec,timedout,TimerCounter,JumpVector

		bcf	MAINS_On
;		bsf	Dim_LED		
		goto	inloop


loopuntildark	incf	AL,F
		btfss	LDR_Port
		 goto	dark
		settrap	15,sec,timedout,TimerCounter,JumpVector
	
		goto	inloop
dark		eq	CasE,.11

		swapf	AL,W
		movwf	TimerCounter+1
		andlw	0x0F
		movwf	TimerCounter+2
		incl	TimerCounter+2,.16
;		call 	set120mintime		;test

		bsf	MAINS_On
		goto	inloop

tocase12	eq	CasE,.12
		settrap	.120*.60,sec,timedout,TimerCounter,JumpVector

		bcf	MAINS_On
;		bsf	Dim_LED		
		goto	inloop



untilbright	btfss	LDR_Port
		 goto	t15
bright		goto	tocase10


;******************************************************************************
;
;
;set15mintime	eq_	TimerCounter+1,=,0x0101+ (.100 * .60 * .15 / .256),lit16;   	
;		retlw	0
;
;set120mintime	eq_	TimerCounter+1,=,0x0101+ (.100 * .60 * .120 / .256),lit16;   	
;		retlw	0
;
;set5sectime	eq_	TimerCounter,=,0x010101+ (.105 * .5 ),lit24; <5 seconds   	
;		retlw	0
;
;set15sectime
;set10sectime	eq_	TimerCounter,=,0x010101+ (.105 * .10  ),lit24; <10 seconds   	
;		retlw	0
;
;


acon		bcf	Read_Out		; read GPIO port
		btfsc	Z_Detect_Port		; store it
		 bsf    Read_Out
		bsf	AC_is_ON		; if equal to previous reading
		if__    Read_Out,equal,AC_is_High
	  	 bcf	AC_is_ON		; no change detected
		bcf	AC_is_High		
		btfsc   Read_Out  		; store for next reading
		 bsf    AC_is_High	
		retlw	0	
	
	
poll11msAC	eq	TMR0,.86
wakeloop	clrwdt
		call	acon
		btfsc	AC_is_ON
		 retlw	0	
		incf	TMR0,W
		skpZ
		 goto	wakeloop
		retlw	0

;************************************** test
;flic		movfw	CasE
;		movwf	BHH
;		setc
;		rlf	BHH,F	;1..3..5
;		movlw	b'0000110'		 
;		xorwf	GPIO,F
;flicloop	clrwdt
;		decfsz	BL,F
;		 goto	$-2
;		decfsz	BH,F
;		 goto	$-4
;		xorwf	GPIO,F
;		decfsz	BHH,F
;		 goto	flicloop
;		retlw	0
;;************************************** test


batADC	
		;eq_	ADCON0,=,b'00001101',lit8; left justified , AN3, on
		;dlay	6
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		retlw	0
	
battery
		call	batADC
		clrf	BatAvr+1
		movfw	BatAvr
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		movfw	ADRESH
		addwf	BatAvr,F
		skpNC
		 incf	BatAvr+1,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		clrC
		rrf	BatAvr+1,F
		rrf	BatAvr,F
		retlw 0		
		
apbatt		
						; if battery voltage > 14.7
						; switch on LED regardless, overloaded
		if_bit	Ovr_Load
		 goto	atstmaint
		if_	BatAvr,>,0x32,lit8
		 goto	atstmaint
		bsf	Ovr_Load
		call	linearze
		bsf	LED_On
		call	effect
		goto	tstPIR			; wait for next cycle
						; if overloaded and voltage > 13.8
						; switch on LED regardless
				
atstmaint	if_	BatAvr,>,0xB0,	lit8	
		 bcf	Ovr_Load		; 12.3V allow overload battery  
		if_	BatAvr,<,0x80,	lit8	; 13.8V
		 goto	inc_intsy
		if_	BatAvr,>,0x8C,	lit8	; 13.6V hysteresis
		 goto	tstPIR
		if_	PR2,<,0xFF,	lit8
		 goto	ats2
		if_	CCPR1L,>=,0xFE,	lit8
		 goto	ats3
		do_	CCPR1L,=,CCPR1L,+,1,lit8	;pnp
		goto 	tstPIR
	 
ats3		bcf	LED_On 
		goto	tstPIR    

ats2		do_	PR2,=,PR2,+,1,	lit8
		do_	CCPR1L,=,CCPR1L,+,1,lit8	;pnp  
		goto	tstPIR
		
inc_intsy	if_	PR2,>,.18,	lit8
		 goto	ats4
		bcf	LED_On			; faulty / wrong battery
		bcf	Batt_Detect
		goto	tstPIR
				 
ats4		do_	PR2,=,PR2,-,1,lit8
		do_	CCPR1L,=,CCPR1L,-,1,lit8	;pnp 		
		goto	tstPIR
		
		
effect		if_not	MAINS_On
		 bsf	Relay_Port		;Pnp
		if_bit	LED_On
		 goto	ledon
		dis_pwm
		goto	mainson
ledon		if_bit	PWM_On 			
		 goto	enpwm
		bcf	LED_Port		;pnp
		goto	mainson 
enpwm		en_pwm
mainson		if_bit	MAINS_On
		 bcf	Relay_Port		;Pnp
		return



;apdistr	btfsc	AC_is_High		; after PIN wakeup do 1firing cycle
;   	 	 goto start8plus		;
;		goto	start8minus
;
;
;
;
;
;;
;;	eq Q3wait,.40
;;	;eq	Q1Wait,.35	
;start8minus	
;	mov	StarTer,BL
;	goto	$+1
;	goto	$+1
;	goto	$+1
;	goto	$+1
;	decfsz	BL,F
;	 goto	$-5
;	decfsz	BH,F
;	 goto	nodec
;	eq	BH,.5	
;	decfsz	StarTer,F
;	 decf	StarTer,F
;	incf	StarTer,F	
;nodec	eq	IndeX,.10	;delay to zerocross
;	decfsz	IndeX,F
;	 goto $-1
;	
;;	skpneq	MinusT,MaxTmr
;;	 goto	inloop		; dont fire
;;	movf	MinusT,F
;;	skpnZ
;	 goto	fire		; fire now
;;	mov	TMR0,StartupCount
;;	inc	StartupCount,MinusT
;;	goto	timetoc
;
;start8plus	mov	StarTer,BL
;	goto	$+1
;	goto	$+1
;	goto	$+1
;	goto	$+1
;	decfsz	BL
;	 goto	$-5
;
;	eq	IndeX,.50	;delay to zerocross
;	decfsz	IndeX,F
;	 goto $-1
;;	skpneq	PlusT,MaxTmr
;;	 goto	inloop			; dont fire
;;	movf	PlusT,F
;;	skpnZ
;	 goto	fire		; fire now
;;	mov	TMR0,StartupCount
;;	inc	StartupCount,PlusT
;;timetoc	clrwdt	
;;	skpeq	TMR0,StartupCount
;;	 goto	timetoc
;fire	bcf	Relay_Port
;	clrwdt
;	eq	IndeX, 8
;	decfsz	IndeX,F		;1
;	 goto	$-1		;2,3 *8 =24us
;	bsf	Triac_Port

	goto	inloop		;



;#define	STACK	_MAXRAM
#define MdB	STACK-0
#define LoB	STACK-1
#define HiB	STACK-2

#define MdD	STACK-3
#define LoD	STACK-4
#define HiD	STACK-5
  
;#define	AL	BatAvr
;#define AL	x	;test
 
linearze	eq_	AL,=,BatAvr,	byte
		eq_	MdB,=,.1,	lit8
		call	vtable
		movwf	LoB
		if_	AL,>,LoB,	byte
		 goto	bases
exbdry		do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	MdD
		goto done

bases		movlw	0
		call	vtable
		movwf	MdB
		call	vtable
		movwf	HiB
		if_	AL,>=,HiB,	byte
		 goto exbdry

basesearch	do_	MdB,=,MdB,-,(1+1),lit8 
		movfw	MdB
		call	vtable
		movwf	LoB
		if_	AL,>=,LoB,	byte
		 goto 	binsearch
		eq_	HiB,=,LoB,	byte
		goto	basesearch

binsearch	do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	LoD
		do_	MdB,=,MdB,+,(1+1),	lit8
		movfw	MdB
		call	vtable
		movwf	HiD

binloop		do_	MdB,=,LoB,+,HiB,	(byte)
		rrf	MdB,F
		do_	MdD,=,LoD,+,HiD,	(byte)
		rrf	MdD,F
		
		if_	AL,>,MdB,		(byte)
		 goto	higher

		skpNZ				; AL equal MdB
		 goto	done

		eq_	HiB,=,MdB,	byte
		eq_	HiD,=, MdD,	byte
		goto	binloop
higher		eq_	LoB,=,MdB,	byte
		eq_	LoD,=,MdD,	byte
		goto	binloop

done		eq_	PR2,=,MdD,	byte	;set frequency
		do_	CCPR1L,=,MdD,-,.10,lit8 ; for PNP-transistor
	
		; switch on LED with linearizer
		; if	PIR_on 15 minutes timertrap
		;	else
		;	 step out this routine
		; endw

		; if AC goes on while no PIR = case 0/6
		;	else case 6
		bsf	PWM_On
		return





rblink		clrwdt
		decfsz	STACK,F
		 goto $-2
		decfsz	STACK-1,F
		 goto $-4

		red	5
		clrwdt
		decfsz	STACK,F
		 goto $-2
		decfsz	STACK-1,F
		 goto $-4

	return


	end
