        list p=16F628a
	#include<p16F628a.inc>


	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT
			;			_XT_OSC;
;==========================================================================
;       Variable Definition
;==========================================================================
SW1		EQU     H'00'		;SW1 is triggering RA0
SW2		EQU     H'01'		;SW2 is triggering RA1
SW3		EQU     H'02'		;SW3 is triggering RA2
SW4		EQU     H'03'		;SW4 is triggering RA3
TIMERTICK	EQU	H'20'		;Used in delay routine
mstick		EQU	H'21'		; "	"	"	
counterbase	EQU	H'22'
op_case		EQU	H'23'		;Flags for next operation
counter60	EQU	H'24'		;counter 60 sec
counter10	EQU	H'25'		;counter 10 sec
	#define		OUTPUT		PORTA,6

button		equ 	0
batt1		equ	1

count10		equ	3
count60		equ	4

msec_flag	equ	6
sec_flag	equ	7

		ORG	0		;Reset vector address
		GOTO	RESET		;goto RESET routine when boot.


;		*********************************************
;		*  Example of a time event routine          *
;		*********************************************
initiate	movlw	0
		movwf	op_case
		movlw	D'60'
		movwf	counter60
		movwf	counterbase
		bcf 	op_case,batt1	; switch off batt1
		return
setcount10 	bsf	op_case,count10
		movlw	D'10'
		movwf	counter10
		return

button_pressed	bcf	op_case,button
		movlw	D'60'
		movwf	counter60
		movwf	counterbase
		bcf 	op_case,batt1	; switch off batt1
	
		
		return

ccount60	decfsz	counter60,F
		goto 	calcdiff
		movlw	.60
		movwf	counter60
		
		bcf 	op_case,batt1	; switch off batt1
		
		movlw 	1
		subwf	counterbase,w	; if counterbase > 1 then
		skpz			;	dec(counterbase)
		decf	counterbase,f
		return
calcdiff	movfw	counter60	; if counter60 < counterbase then
		subwf	counterbase,w	;	switch on batt1
		skpc
		return
		bsf	op_case,batt1
		return
MSEC_event	movlw	.125		; 125* 32us = 4msec
		addwf	TIMERTICK,f
		bsf	op_case,msec_flag
		return

msecjob         bcf	op_case, msec_flag
		decfsz	mstick,f
		return
		movlw	.250		; 250 * 4ms = 1sec
		movwf	mstick
		bsf 	op_case,sec_flag
		return
onesecjob	bcf	op_case,sec_flag
		MOVLW	B'00000001'	;toggle LED1 (RB0)
		XORWF	PORTB,F
		;BTFSC	PORTA,SW1
		;call	button_pressed	;INPUT
		
		;btfsc	op_case,count60
		call	ccount60
		BTFSC	op_case,batt1
		bcf	OUTPUT		; output lo=ON
                nop
		btfss	op_case,batt1   ; RELAIS= use opener
		bsf	OUTPUT		; output hi=OFF
	
		return

;	       **********************************
;              **  RESET :  main boot routine  **
;              **********************************

RESET		
		BSF	STATUS,RP0	;Switch to register bank 1
					;Disable pull-ups
					;INT on rising edge
					;TMR0 to CLKOUT
					;TMR0 Incr low2high trans.
					;Prescaler assign to Timer0
					;Prescaler rate is 1:32
		MOVLW	B'11010100'	;Set PIC options (See datasheet).
		MOVWF	OPTION_REG	;Write the OPTION register.
		;
		CLRF	INTCON		;Disable interrupts
		MOVLW	B'11000000'
		MOVWF	TRISB		;RB7 & RB6 are inputs.
					;RB5...RB0 are outputs.
		MOVLW	B'10111111'	;all RA ports are inputs
		MOVWF	TRISA
		BCF	STATUS,RP0	;Switch Back to reg. Bank 0
		MOVLW	B'00000111'	;Disable Comparator module's
		MOVWF	CMCON
		;
		MOVLW	B'00001100'     ;Use PORTB in 'sink' mode
		MOVWF   PORTB		; so high is off , lo is on
					;using PB2 + 3
		call	initiate	;initiate variables
		;bsf	op_case,count60
main_loop	movfw	TIMERTICK	
		subwf	TMR0,w		;w=TIMERTICK-timr0
		andlw	0C0H		;slack 63*32 cycles
		SKPNZ
		call	MSEC_event	; 125 timerticks more
		BTFSC	op_case,msec_flag
		call	msecjob		;frequent jobs to be done in 4ms 
		BTFSC	op_case,sec_flag
		call	onesecjob	;occasional jobs to be done
		
		GOTO	main_loop


		END
