        list p=12F629
	#include<c:\velleman\k8048\p12F629.inc>


	__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT  
;==========================================================================
;       Variable Definition
;==========================================================================
SW1		EQU     H'00'		;SW1 is triggering RA0
SW2		EQU     H'01'		;SW2 is triggering RA1
SW3		EQU     H'02'		;SW3 is triggering RA2
SW4		EQU     H'03'		;SW4 is triggering RA3
TIMERTICK	EQU	H'20'		;Used in delay routine
mstick		EQU	H'21'		; "	"	"	
counterbase	EQU	H'22'
op_case		EQU	H'23'		;Flags for next operation
counter60	EQU	H'24'		;counter 60 sec
counter10	EQU	H'25'		;counter 10 sec
button		equ 	0
batt1		equ	1

count10		equ	3
count60		equ	4

msec_flag	equ	6
sec_flag	equ	7

		ORG	0		;Reset vector address
		GOTO	RESET		;goto RESET routine when boot.


;		*********************************************
;		*  Example of a time event routine          *
;		*********************************************
initiate	movlw	0
		movwf	op_case
		movlw	D'60'
		movwf	counter60
		movwf	counterbase
		bcf 	op_case,batt1	; switch off batt1
		return
setcount10 	bsf	op_case,count10
		movlw	D'10'
		movwf	counter10
		return

button_pressed	bcf	op_case,button
		movlw	D'60'
		movwf	counter60
		movwf	counterbase
		bcf 	op_case,batt1	; switch off batt1
	
		
		return

ccount60	decfsz	counter60,F
		goto 	calcdiff
		movlw	.60
		movwf	counter60
		
		bcf 	op_case,batt1	; switch off batt1
		
		movlw 	1
		subwf	counterbase,w	; if counterbase > 1 then
		skpz			;	dec(counterbase)
		decf	counterbase,f
		return
calcdiff	movfw	counter60	; if counter60 < counterbase then
		subwf	counterbase,w	;	switch on batt1
		skpc
		return
		bsf	op_case,batt1
		return
MSEC_event	movlw	.125		; 125* 32us = 4msec
		addwf	TIMERTICK,f
		bsf	op_case,msec_flag
		return

msecjob         bcf	op_case, msec_flag
		decfsz	mstick,f
		return
		movlw	.250		; 250 * 4ms = 1sec
		movwf	mstick
		bsf 	op_case,sec_flag
		return
onesecjob	bcf	op_case,sec_flag
		MOVLW	B'00000001'	;toggle LED1 (RB0)
		XORWF	GPIO,F
		;BTFSC	PORTA,SW1
		;call	button_pressed	;INPUT
		
		;btfsc	op_case,count60
		call	ccount60
		BTFSC	op_case,batt1
		bcf	GPIO,5		; output lo=ON
                nop
		btfss	op_case,batt1   ; RELAIS= use opener
		bsf	GPIO,5		; output hi=OFF
	
		return

;	       **********************************
;              **  RESET :  main boot routine  **
;              **********************************

RESET	BANKSEL TRISIO
	movlw	b'00011110'	;GP0-OUTPUT, GP1-Input, GP2-Input, GP3-input, GP4-input,GP5-output
	movwf	TRISIO		
				;	clrf	ANSEL	for 765	
	clrf	VRCON		;Turn Off VREF
	BANKSEL	CMCON		;BANK 0

	movlw	.7		;Turn Off comparator
	movwf	CMCON

	BANKSEL	OPTION_REG	;BANK 1	
	movlw	b'01000100'	;Pull Ups Enabled, Rising Edge, Assigned to TMR0 , Prescaler is 1:32 
	movwf	OPTION_REG	
	;bsf	WPU,2		;GP2 - Pullup Enabled	
	;bsf	WPU,1		;GP1 - Pullup Enabled
	BANKSEL	GPIO		;BANK0
	clrf	GPIO

main_loop	movfw	TIMERTICK	
		subwf	TMR0,w		;w=TIMERTICK-timr0
		andlw	0C0H		;slack 63*32 cycles
		SKPNZ
		call	MSEC_event	; 125 timerticks more
		BTFSC	op_case,msec_flag
		call	msecjob		;frequent jobs to be done in 4ms 
		BTFSC	op_case,sec_flag
		call	onesecjob	;occasional jobs to be done
		
		GOTO	main_loop


		END
