;       list p=16F628
	#include<p16F628.inc>


	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT

;==========================================================================
;       Variable Definition
;==========================================================================
SW1		EQU     H'00'		;SW1 is triggering RA0
SW2		EQU     H'01'		;SW2 is triggering RA1
SW3		EQU     H'02'		;SW3 is triggering RA2
SW4		EQU     H'03'		;SW4 is triggering RA3
TIMER1		EQU	H'20'		;Used in delay routine
TIMER2		EQU	H'21'		; "	"	"	
TIMER3		EQU	H'22'
op_case		EQU	H'23'		;Flags for next operation
counter60	EQU	H'24'		;counter 60 sec
counter10	EQU	H'25'		;counter 10 sec
button		equ 	0
ac230_on	equ	1
generator_off	equ	2
count10		equ	3
count60		equ	4
ac230_off	equ	5

		ORG	0		;Reset vector address
		GOTO	RESET		;goto RESET routine when boot.


;		*********************************************
;		*  Example of a delay routine               *
;		*********************************************

DELAY_ROUTINE   MOVLW   D'6'         ; Generate approx 1sec delay at 4Mhz CLK
                MOVWF   TIMER3

DEL_LOOP0 	MOVLW   D'230'         ;
                MOVWF   TIMER2
DEL_LOOP1       MOVLW   D'255'	       ;	
                MOVWF   TIMER1
DEL_LOOP2       DECFSZ  TIMER1,F
                GOTO    DEL_LOOP2
		DECFSZ  TIMER2,F
                GOTO    DEL_LOOP1
 		BTFSC	PORTA,SW1
		BSF	op_case,0	; check INPUT
		DECFSZ  TIMER3,F
                GOTO    DEL_LOOP0
		RETURN

setcount10	movlw	0
		movwf	op_case
		bsf	op_case,count10
		movlw	D'10'
		movwf	counter10
		return

button_pressed	bcf	op_case,button
		bcf	op_case,count10	; abort countdown start
		bsf	op_case,count60
		movlw	D'60'
		movwf	counter60
		bsf	op_case,ac230_off
		bsf	PORTB,5		;testing
		return
off_ac		bcf 	PORTB,1
		bcf	op_case,ac230_off
		return
on_ac		bsf 	PORTB,1
		bcf	op_case,ac230_on
		bcf	op_case,count10
		return
off_gen		bsf	PORTB,2
		
		return
ccount10	decfsz	counter10,F
		return
		bsf 	op_case,ac230_on
		return
ccount60	decfsz	counter60,F
		return
		bsf 	op_case,generator_off
		return

;	       **********************************
;              **  RESET :  main boot routine  **
;              **********************************

RESET		MOVLW	B'00000111'	;Disable Comparator module's
		MOVWF	CMCON
		;
		BSF	STATUS,RP0	;Switch to register bank 1
					;Disable pull-ups
					;INT on rising edge
					;TMR0 to CLKOUT
					;TMR0 Incr low2high trans.
					;Prescaler assign to Timer0
					;Prescaler rate is 1:256
		MOVLW	B'11010111'	;Set PIC options (See datasheet).
		MOVWF	OPTION_REG	;Write the OPTION register.
		;
		CLRF	INTCON		;Disable interrupts
		MOVLW	B'11000000'
		MOVWF	TRISB		;RB7 & RB6 are inputs.
					;RB5...RB0 are outputs.
		MOVLW	B'11111111'	;all RA ports are inputs
		MOVWF	TRISA
		BCF	STATUS,RP0	;Switch Back to reg. Bank 0
		CLRF	PORTB		
		;
		call	setcount10
EFFECT_1	MOVLW	B'00000001'	;Activate LD1 (RB0)
		XORWF	PORTB,F
		CALL	DELAY_ROUTINE
		BTFSC	op_case,button	
               	call	button_pressed
		BTFSC	op_case,ac230_off
		call	off_ac
		btfsc	op_case,ac230_on
		call	on_ac
		btfsc	op_case,generator_off
		call	off_gen
		btfsc	op_case,count10
		call	ccount10
		btfsc	op_case,count60
		call	ccount60
		GOTO	EFFECT_1


		MOVLW	B'00000010'	;Activate LD2 (RB1)
		MOVWF	PORTB
		CALL	DELAY_ROUTINE
		MOVLW	B'00000100'	;Activate LD3 (RB2)
		MOVWF	PORTB
		CALL	DELAY_ROUTINE
		MOVLW	B'00001000'	;Activate LD4 (RB3)
		MOVWF	PORTB
		CALL	DELAY_ROUTINE
		MOVLW	B'00010000'	;Activate LD5 (RB4)
		MOVWF	PORTB
		CALL	DELAY_ROUTINE
		MOVLW	B'00100000'	;Activate LD6 (RB5)
		MOVWF	PORTB
		CALL	DELAY_ROUTINE
		GOTO	EFFECT_1
		END
