
;Software License Agreement                                         
;                                                                    
;The software supplied herewith by 
;MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)             
;Incorporated (the "Company") is intended and supplied to you, the  
;Companys customer, for use solely and exclusively on Microchip    
;products. The software is owned by the Company and/or its supplier,
;and is protected under applicable copyright laws. All rights are   
;reserved. Any use in violation of the foregoing restrictions may   
;subject the user to criminal sanctions under applicable laws, as   
;well as to civil liability for the breach of the terms and         
;conditions of this license.                                        
;                                                                    
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement 
;*   GPIO output driver                                *
;*    File Version:                                                 *
;*                                                                     *
;*    Author:       G Michael DRYGAS                                          *
;*                  Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683
#define TRISIOinit b'00011001';
;#define ANSELinit 	B'01110001' 	; ADC Frc clock, AN0 as analog
;#define ADCON0init	b'00000001'	; left justified , AN0, on

	nointr683
	init683

#define port	4	
	bsf	GPIO,port			; pnp
;	bcf	GPIO,port			;
	
	
	cblock	_MINRAM
	endc
#define	STACK	_MAXRAM

	cblock
	 DispCounter:2,DisprVector,x
	endc
	eq_	DispCounter,=,0x0101,	lit16
	movlw	initdis
	movwf	DisprVector

	eq_	FSR,=,STACK,		lit8	;variable to display

loop		
		banksel	TRISIO
		 bcf	TRISIO,port; 
		banksel	Bank0
		dlay	.10			; discharge C for next measurement
		
		banksel	TRISIO
		 bsf	TRISIO,port	; 
		banksel	Bank0
		mov	TMR0,STACK
		;btfsc	CMCON0,CMPOUT  	
		;btfss	GPIO,port
		btfsc	GPIO,port	; pnp
		 goto	$-1		; will hang if never
		sub	STACK,TMR0,STACK
		goto	okmes
afterwdt	eq	STACK,.255	
okmes		
;		banksel	TRISIO
;		 bcf	TRISIO,port; 
;		banksel	Bank0
;					; discharge C for next measurement
;

	eq_	x,=,b'10000000', lit8	
	
mblack	macro	Gbit
	make	Gbit, INPUT	; port  input = black
	endm   
mred	macro   Gbit
	bcf	GPIO,Gbit
	make	Gbit, OUTPUT    ; port  output,LOW = red
	endm
mblue	macro   Gbit
	bsf	GPIO,Gbit
	make	Gbit, OUTPUT	; port  output,HIGH = blue
	endm

solodis	
;anadis	macro	port, hicolor, locolor, offcolor

t0	if_not	INTCON,T0IF
	 goto	solodis
	bcf	INTCON,T0IF

	decfsz	DispCounter,F
	 goto	disp_xit
	if t_used > 1
	decfsz	DispCounter+1,F
	 goto   disp_xit
	endif 
	movfw	DisprVector
	movwf	PCL



initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	INDF,W
	bNZ	long			; its a 1, start display
	clrC
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway

strtdis	movfw	x
	andwf	INDF,W
	skpZ	
	 goto	long
	settrap .100,msec,pause,DispCounter,DisprVector
	mred 2	;locolor port
 	goto disp_xit

long	settrap .400,msec,pause,DispCounter,DisprVector
 	mred 2   ;hicolor port
 	goto disp_xit	

pause	settrap .200,msec,rsmedis,DispCounter,DisprVector
	mblue 2	;offcolor port
 	goto disp_xit
 	
rsmedis	clrC
	rrf	x,F	;	next bit?
	bNC	strtdis	
	
	settrap .5,sec,initdis,DispCounter,DisprVector

;
;
disp_xit

	

;	anadis 2, red,red,blue
	
	movf	x,F
	skpNZ
	 goto	loop
	goto	solodis
	end