
;Software License Agreement                                         
;                                                                    
                                                                   
;THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,  
;WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED  
;TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A       
;PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,  
;IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR         
;CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.       
;************************************************************************

;***********************************************************************
;*   This file is the firmware to implement a 10Hz Signal on all Output*
;*   GPIO Ports                                                        *
;*    File Version: A                                                  *
;*                                                                     *
;*    Author:       G M DRYGAS                                         *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   m0.asm (macros)                                *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F206	; list directive to define processor
	#include  m0.asm
	config206		; reasonable configuration bits

#define TRISIOinit b'00001011'	; all ports output bar GP2	

	init2xx			; reasonable initiation of special function registers 
	cblock _MINRAM
	 Sys1, HiCount,DutyCase
	endc
#define	GPis_on	Sys1,0
#define	GPwas_on	Sys1,1

	eq_	HiCount,=,.128,			lit8
	eq_ DutyCase,=,.15,			lit8

loop        
	if_m	GPIO,3,is_on,		singlebit

	 if_m	HiCount,>,.128+5,	lit8
	  bsf	GPis_on
	 else_m
	  incf	HiCount,F
	 end_m
	  
	else_m
	  
	 if_m	HiCount,<,.128-5,	lit8
	  bcf	GPis_on
	 else_m
	  decf	HiCount,F
	 end_m

	end_m

	if__ GPis_on,not_but,GPwas_on
	  bcf	GPwas_on

	if__m GPwas_on,not_but,GPis_on
     do_    DutyCase,=,DutyCase,-,1,     (lit8)      
	 bsf	GPwas_on
	end_m 
		
	movlw	.15
	andwf	DutyCase,W
	addwf	PCL,F
	call	long			;0
	call	short			;1
	call	veryshort		;2
	bsf		GP2				;3








	bcf	    GP2


	do_	GPIO,=,GPIO,XOR,b'00000100',	(lit8)	; flip Port2every port bar GP3
	delay	.100000								; wait 100 milli seconds
	goto loop					
	
	end