;****************************************************************************************
;*   This file is the firmware to implement NFET gate driver, based on 		*
;*   the PIC12F629.
;*		
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    629.3.1.asm                              		                *
;*    Date:         December, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3c.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                    					*
;*                                                                     			*
;****************************************************************************************
	list      p=12F629	; list directive to define processor
	#include  macros3c.asm
	config629
 	ORG 0x00
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts

	
#define OPTIONinit	B'11000100';	; clock 1:32 , WDT 1:1 ,	
#define LED3TRIS    b'00101011'
#define TRISIOinit  b'00101000'	; GPIO0,1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define LED3ON      b'00000100'
#define GPIOinit    b'00000000'	; GPIO  all LOW 

;****************************************************************************************


	cblock	_MINRAM			; start of variables
	 SyS1,SyS2
	x,Intens0,Direct0,Intens1,Direct1,Intens2,Direct2
	S0C,S1C,S2C,O0C,O1C,O2C
	endc
#define	STACK	_MAXRAM	


PWRUP	
		init629

		eq	SyS1,0
		eq	SyS2,0

		eq	Intens0,.255
		eq	Direct0,.1
		eq	Intens1,.128
		eq	Direct1,.1
		eq	Intens2,.1
		eq	Direct2,.1
		eq	S0C,.255
		eq	S1C,.254
		eq	S2C,.253
		goto	MAIN

dlay333		delay .120000
		return
MAIN
afterwdt	eq	x,.90

rawloop
		bsf	GPIO,0
		call	dlay333
		bcf	GPIO,0
		bsf	GPIO,1
		call	dlay333
		bcf	GPIO,1
		bsf	GPIO,2
		call	dlay333
		bcf	GPIO,2
		decfsz	x,F
		 goto	rawloop

softloop
		incfsz	S0C,F
		 goto	i1
		eq_	O0C,=,Intens0,byte
		bsf	GPIO,0

i1		decfsz	O0C,F
		 goto	c1	 
		bcf	GPIO,0
		eq_	S0C,=,Intens0,byte

c1
		incfsz	S1C,F
		 goto	i2
		eq_	O1C,=,Intens1,byte
		bsf	GPIO,1

i2		decfsz	O1C,F
		 goto	c2	 
		bcf	GPIO,1
		eq_	S1C,=,Intens1,byte

c2
		incfsz	S2C,F
		 goto	i3
		eq_	O2C,=,Intens2,byte
		bsf	GPIO,2

i3		decfsz	O2C,F
		 goto	i4	 
		bcf	GPIO,2
		eq_	S2C,=,Intens2,byte

i4		decfsz	x,F
		 goto	softloop

testi		do_	Intens0,=,Intens0,+,Direct0,byte
		if_NZ
		 goto	i5
		movlw	2
		btfss	Direct0,7
		 goto	i4b
		addwf	Direct0,F
		goto	testi
i4b		subwf	Direct0,F
		goto	testi

i5		do_	Intens1,=,Intens1,+,Direct1,byte
		if_NZ
		 goto	i6
		movlw	2
		btfss	Direct1,7
		 goto	i5b
		addwf	Direct1,F
		goto	i5
i5b		subwf	Direct1,F
		goto	i5

i6		do_	Intens2,=,Intens2,+,Direct2,byte
		if_NZ
		 goto	i6c
		movlw	2
		btfss	Direct2,7
		 goto	i6b
		addwf	Direct2,F
		goto	i6
i6b		subwf	Direct2,F
		goto	i6
		
i6c		;goto	testi

		goto	softloop
		goto	rawloop
		end