;****************************************************************************************
;*   This file is the firmware to implement NFET gate driver on GPIO 2,4,5              *
;*   depending on position of 2 potentiometers on GPIO 0 (color) GPIO1(saturation)      *
;*   based on 		                                                                *
;*   the PIC12F675
;*		
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    blink675rgb.0.asm                              		        *
;*    Date:         June, 2010                                   			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3D1.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        pulses are PWM ranging from 2% to 98% duty cycle                    *
;*		         								*
;*                    									*
;*                                                                     			*
;****************************************************************************************
	list      p=12F675	; list directive to define processor
	#include  macros3D1.asm
	config675
 	ORG 0x00
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	MOVWF   W_TEMP        ; save off current W register contents
        MOVF    STATUS,w      ; move status register into W register
        MOVWF   STATUS_TEMP   ; save off contents of STATUS register


		incfsz	S0C,F
		 goto	i1
		eq_	O0C,=,ReD,byte
		bsf	GPIO,4

i1		decfsz	O0C,F
		 goto	c1	 
		bcf	GPIO,4
		eq_	S0C,=,ReD,byte

c1
		incfsz	S1C,F
		 goto	i2
		eq_	O1C,=,GreeN,byte
		bsf	GPIO,5

i2		decfsz	O1C,F
		 goto	c2	 
		bcf	GPIO,5
		eq_	S1C,=,GreeN,byte

c2
		incfsz	S2C,F
		 goto	i3
		eq_	O2C,=,BluE,byte
		bsf	GPIO,2

i3		decfsz	O2C,F
		 goto	i4	 
		bcf	GPIO,2
		eq_	S2C,=,BluE,byte

i4		; isr code can go here or be located as a call subroutine elsewhere
	bcf	INTCON,T0IF
	eq_	TMR0,=,-.20   ,lit8; 20 timerticks outside befor returning 	
        MOVF    STATUS_TEMP,w ; retrieve copy of STATUS register
        MOVWF   STATUS        ; restore pre-isr STATUS register contents
        SWAPF   W_TEMP,f
        SWAPF   W_TEMP,w      ; restore pre-isr W register contents

        RETFIE                ; return from interrupt
	return			; disable interrupts


#define OPTIONinit	b'11001000'    ; no pullup, clock 1:1
#define INTCONinit		b'11100000'    ; enable GIE, PIE, T0IE
#define TRISIOinit  	b'00001011'	; GPIO0,1,3 as INPUT, GPIO 2,4,5 as OUTPUT
#define LED3ON      	b'00000100'
#define GPIOinit    	b'00000000'	; GPIO  all LOW 
#define ANSELinit 	B'01110011' 	; ADC Frc clock, AN0,AN1 as analog
#define ADCON0init	b'00000001'	; left justified , AN0, on

;****************************************************************************************


	cblock	_MINRAM			; start of variables
	 SyS1,SyS2,W_TEMP,STATUS_TEMP
	x,ReD,GreeN,BluE
	S0C,S1C,S2C,O0C,O1C,O2C
	endc
#define	STACK	0x3F  ;_MAXRAM	



PWRUP	
		init629

		eq	SyS1,0
		eq	SyS2,0

		eq	S0C,.255
		eq	S1C,.254
		eq	S2C,.253
		goto	MAIN

slinear	
#define	howmany	1
#define lo1     0x0A
#define rs1	0x00
#define hi1	0xF6
#define rs2	0xFF

	if_	STACK,<=,lo1,lit8
	 goto	lors1
	if_	STACK,>=,hi1,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lo1,lit8
	eq_	STACK,=,rs1,lit8

	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (hi1-lo1)	

	else
hicount = (rs1-rs2)*.256 / (hi1-lo1)
	endif

	 movlw	hicount	& 0xFF	
adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return


value
	clrf	STACK-2
	movfw	STACK
	if__	STACK-1,0,or,STACK-1,1
	 movwf	STACK-2
	if_	STACK-1,1,is_on,	singlebit
	 comf	STACK-2,F
	if_m	STACK-1,1,is_on,	singlebit
	 clrf	STACK-1
	else_m
	 incf	STACK-1,F
	end_m
	return




calcrgb
	clrf    STACK-1
	addwf	STACK,F
	if_C	
 	 incf	STACK-1,F
	addwf	STACK,F	
	if_C	
 	 incf	STACK-1,F
	call value
	eq_	BluE,=,STACK-2,byte

	call value
	eq_ 	GreeN,=,STACK-2,byte

	call	value
	eq_	ReD, =,STACK-2,byte
	return	

tloop	eq_ STACK,=,x,byte
	call	calcrgb
	incf	x,F
	goto	tloop


dlay333		delay .120000
		return



MAIN
afterwdt	
		eq	x,.90

rawloop
		bsf	GPIO,4
		call	dlay333
		bcf	GPIO,4
		bsf	GPIO,5
		call	dlay333
		bcf	GPIO,5
		bsf	GPIO,2
		call	dlay333
		bcf	GPIO,2
		decfsz	x,F
		 goto	rawloop

softloop       
		

		decfsz	x,F
		 goto	softloop


		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		eq_	ADCON0,=,b'00000101',lit8;next: left justified , AN1, on
	
		eq_	STACK,=,ADRESH,byte
		call	slinear
		call	calcrgb


		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		eq_	ADCON0,=,b'00000001',lit8; next: left justified , AN0, on

		eq_	STACK,=,ADRESH,byte
		call	slinear


		do_	ReD,=,ReD,+,STACK,byte
		movlw	.255
		if_C
		 movwf	ReD
	
		do_	GreeN,=,GreeN,+,STACK,byte
		movlw	.255
		if_C
		 movwf	GreeN
	
		do_	BluE,=,BluE,+,STACK,byte
		movlw	.255
		if_C
		 movwf	BluE
	

		goto	softloop


	end