; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;==============================================================================
;File name: blinker.asm
;
;This program demonstrates how to
;verify the processor is working 
;
;
;
;==============================================================================
;author:	Gerhard Michael Drygas
;company:	Michaels Prototype
;date:		25/10/2006
;MPLAB version:	7.41
;
;==============================================================================        

;	list      p=12F675	; list directive to define processor
;	#include <p12f675.inc>	; processor specific variable definitions

;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.


	LIST P = 16F627, F=INHX8M
	#include<p16F627.inc>


	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT


;*** register bank limits
#define ram0_start 	0x20
#define ram0_end 	0x7f			; 5f 12P625
#define ram0_length 	ram0_end - ram0_start + 1

TIMER1          EQU     ram0_start   	;Timer 1, Used for general delay.		
TIMER2          EQU     ram0_start+1   	;Timer 2, used for delay !
EFFECT		EQU	ram0_start+2	;Used to store pattern
WTemp        	EQU     ram0_end-0x01   ; variable used for context saving 
StatusTemp   	EQU     ram0_end        ; variable used for context saving




	ORG	0			;Reset vector address
		nop			; for ICD
		GOTO	RESET		;GOTO RESET routine when boot.

;******************************************************************************
;INTERRUPT
;******************************************************************************


	ORG     0x004             ; interrupt vector location
		movwf   WTemp            ; save off current W register contents
		movf	STATUS,w          ; move status register into W register
		movwf	StatusTemp       ; save off contents of STATUS register


	; isr code can go here or be located as a call subroutine elsewhere


		movf    StatusTemp,w     ; retrieve copy of STATUS register
		movwf	STATUS            ; restore pre-isr STATUS register contents
		swapf   WTemp,f
		swapf   WTemp,w          ; restore pre-isr W register contents
		retfie                    ; RETURN from interrupt


	
		
;		**************************	;Delay routine.
;               *        delay  routine: *
;               **************************

DELAY	       MOVLW   D'250'          ;*	;Put 150 decimal in the 'TIMER1' register.
                MOVWF   TIMER1          ;*
                ;
delay2	       MOVLW	D'250'			;Put 150 decimal in the 'TIMER2' register.
		MOVWF	TIMER2
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		DECFSZ  TIMER2,F        ;*	;Timer2 = Timer2 -1, skip next instruction if Timer2 = 0.
                 GOTO    $-5            ;*	;Jump back upto 6 instructions.
                
		DECFSZ	TIMER1,F		;Timer1 = Timer1 - 1, skip next instruction if Timer1 = 0
		 GOTO	delay2			;Jump to 'DELAY2' routine	
		RETLW   0			;Return (jump back to main) and load W-reg with 0.


;		**************************
;               *     main routine:      *
;               **************************

						;Program starts here !!!		
RESET		MOVLW	B'00000111'	;Disable Comparator module's
		MOVWF	CMCON
		;
		BSF	STATUS,RP0	;Switch to register bank 1
					;Disable pull-ups
					;INT on rising edge
					;TMR0 to CLKOUT
					;TMR0 Incr low2high trans.
					;Prescaler assign to Timer0
					;Prescaler rate is 1:256
		MOVLW	B'11010111'	;Set PIC options (See datasheet).
		MOVWF	OPTION_REG	;Write the OPTION register.
		;
		CLRF	INTCON		;Disable interrupts
		MOVLW	B'00000000'
		MOVWF	TRISB		;RB7 & RB6 are
					;RB5...RB0 are outputs.
		MOVLW	B'11111111'	;all RA ports are inputs
		MOVWF	TRISA
		BCF	STATUS,RP0	;Switch Back to reg. Bank 0
		CLRF	PORTB		
		;

Loop1
	movlw b'10000001'	; toggle	PORTB,0 and PORTB,7
	xorwf PORTB,f
	call DELAY
	goto Loop1
	end
