
	#include p10f204.inc
	#include macros.inc
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC

	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x10
		AL,PeriodCounter			; Define all user varables starting at location 0x10 for 10F200
		SystemStatus			; byte that holds system flags
		PeriodReg
		DutyTime,DutyCounter
		TimeCounter:4
		WdtCounter,ReEntry
	endc
	IFDEF __10F202
	cblock 0x08
	 
	endc
	ENDIF

;******************************************************************************
;***** CONSTANT DEFINITIONS
 
#define Lo_Intensity	.254
#define Hi_Intensity	.3


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
#define 	TRISGPIO 	6

#define Up_Port		GPIO,0				; 
#define Down_Port	GPIO,1				; 
#define	FET_Gate_Port	GPIO,2				; 
#define Power_On_Port	GPIO,3				; 
#define Button_Port	GPIO,3				; 

undoreset			
 
	movlw	b'11111111'	; configure FET_Gate_Port  as input GPIO0,1,3 are input
	TRIS 	TRISGPIO
	movlw	B'11001000'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 64:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO

	call	undoreset
		
	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	goto 	MAIN	

afterpin
afterwdt decfsz	WdtCounter,F
	 sleep
	incf	WdtCounter,F	; leave at no delay
	movfw	ReEntry
	movwf	PCL

MAIN		clrwdt
		eq	WdtCounter, .1
		eq	ReEntry, waitinp
waitinp		btfsc	Button_Port
		 sleep
		eq	ReEntry,waitnoinp
waitnoinp 	btfss	Button_Port
		 sleep
		eq	WdtCounter,.60
		eq	ReEntry,pulse
		sleep
pulse		eq	DutyCounter, (.100 /.3)	; 100 us
		bsf	FET_Gate_Port
		movlw	b'11111011'	; configure FET_Gate_Port  as output GPIO0,1,3 are input
		TRIS 	TRISGPIO
		decfsz	DutyCounter,F	
		 goto	$-1
		movlw	b'11111111'	; configure FET_Gate_Port  as input GPIO0,1,3 are input
		TRIS 	TRISGPIO
		bcf	FET_Gate_Port
		goto	MAIN		
	end
