        list p=16F627
	#include<p16F627.inc>


	__CONFIG        _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT
			;			_XT_OSC;

;*** register bank limits
#define ram0_start 	0x20
#define ram0_end 	0x7f
#define ram0_length 	ram0_end - ram0_start + 1
#define ram1_start 	0xa0
#define ram1_end 	0xef
#define ram1_length 	ram1_end - ram1_start + 1
;
;==========================================================================
;       Variable Definition
;==========================================================================

#define		lenbit	INDF,0
byte_ctr	EQU	ram0_start
TEMP		EQU	ram0_start+1; bank 1?
func_nmbr	EQU	ram0_start+2
#define		OVERFLOW	FLAG,0
FLAG		EQU	ram0_start+3; bank 1?	
heap_ptr	EQU	ram0_start+4
rotctr		EQU	ram0_end-0x04 ; bank 1?
aarg		EQU	ram0_end-0x03; bank 1?
v3		EQU	ram0_end-0x02; bank 1?
v1		EQU	ram0_end-0x01; bank 1?
v2		EQU	ram0_end; bank 1?

		ORG	0		;Reset vector address
		GOTO	RESET		;goto RESET routine when boot.
initiate	RETURN

unary_func	movwf	FSR		; [w] 
		btfsc	lenbit
		 goto	not7bit
		call	function
		btfsc	OVERFLOW
		 goto	expand7_23
		bcf	lenbit
		RETURN	
		
not7bit		rrf	INDF,f		; adress is upper 7bits 
		movfw	INDF
		movwf	FSR
		btfsc	lenbit
		 goto	not23bit
		movlw	0x03
		movwf	byte_ctr
		goto	top_down
not23bit	movlw	0x08
		movwf	byte_ctr
		movfw	FSR
		movfw	TEMP
		CALL	top_down
		movfw	TEMP
		movwf	FSR
		bsf	lenbit
		RETURN
top_down	movfw	func_nmbr
		sublw	0x02
		skpz
		 goto mltpl_call
		movfw	byte_ctr
		addwf	FSR
		decf	FSR,f
		goto	mlttd_call
mltpl_call	call	function 	; call function
		INCF	FSR,f

		DECFSZ	byte_ctr,f
		 GOTO	mltpl_call
		RETURN
mlttd_call	call	function 	; call function
		DECF	FSR,f

		DECFSZ	byte_ctr,f
		 GOTO	mlttd_call
		RETURN


expand7_23	movfw	FSR
		movwf	TEMP
		movfw	heapptr
		movwf	FSR
		movlw	0x03
		subwf	INDF,w		;space

		RETURN

function	movfw	func_nmbr
		addwf	PCL,f
		goto 	function0
		goto	function1
		goto	function2

function0	clrf	INDF
		return
function1	rlf	INDF
		return
function2	rrf	INDF
		return

times2		movwf	FSR	;[w] :=[w] * 2
		btfsc	lenbit
		 goto	t2_not7bit
		bcf	CARRY
		rlf	INDF
		btfsc	CARRY
		 call	expand7_23
		RETURN	
t2_not7bit	movfw	INDF
	
		movwf	FSR
		rrf	FSR
		bcf	TEMP,C
		btfsc	CARRY
		 bsf	TEMP,C
		bcf	CARRY
		rlf	INDF
		RETURN		
div2		RETURN

v2INDF		movwf	TEMP
		btfss	CARRY
		 goto	no_carry
		incf	TEMP
		incf	TEMP			; store Carry in bit0
no_carry	movfw	v2
		addwf	byte_ctr,w
		movwf	FSR
		movfw	TEMP	;
		return
v3INDF		movwf	TEMP
		movfw	v3
		movwf	FSR
		movfw	TEMP
		return
add		BCF	STATUS,C;add (v3)=[v1]+(v2)
		clrf	byte_ctr
moreadd		movfw	v1
		addwf	byte_ctr,w	
		movwf	FSR
		movfw	INDF
		btfsc	INDF,0
		 incf	byte_ctr
		btfss	INDF,0
		 clrf	byte_ctr
		call	v2INDF
		addwf	INDF,w
		call	v3INDF		
		movwf	INDF
				; cases v1=8bit v2=8bit no overflow = EXIT
				;	v1>8bit v2=8bit copy bits + possible overflow to v3
				;	v1=8bit v2>8bit
				;	v3=8bit and there is overflow
				;	v1>8bit and v2>8bit
		movf	byte_ctr,f
		skpnz
		 goto	moreadd
		RETURN

sub		BSF	STATUS,C;subtract (v3)=(v1)-(v2)
		movlw	bpn
		movwf	byte_ctr
moresub		movwf	v2	
		movwf	FSR
		movfw	INDF
		movwf	subtra
		movwf	v1	
		movwf	FSR
		movfw	INDF
		subwf	subtra,f
		movwf	v3	
		movwf	FSR
		movfw	subtra
		movwf	INDF
		decfsz	byte_ctr,f
		goto	moresub
		RETURN
compare		movlw	bpn	;numeric compare (HI to LO)
		movwf	byte_ctr		
moretocompare	movfw	v2	; compare indirect(v1) and (v2)
		movwf	FSR
		movfw	byte_ctr
		decf	byte_ctr,w	; adress := v2+bitcounter-1 
		addwf	FSR,f
		movfw	INDF
		movwf	zwr	; zwr := (adress)
		movfw	v1
		movwf	FSR
		movfw	byte_ctr
		decf	byte_ctr,w	; 
		addwf	FSR,f
		movfw	INDF
		subwf	zwr,w	; w:= zwr - (v1);
		skpz
		goto 	notzero
		decfsz	byte_ctr,f
		goto	moretocompare
		BSF	STATUS,Z
		RETURN
notzero		BCF	STATUS,Z	; carry if v2>v1
		RETURN			; not carry if v2<v1
mult		RETURN

divide		clrf 	rotctr		;reuslt:=(v1)/(v2)
		movlw	zwr
		call	clear
		movlw	1
		movwf	zwr_longint	; for bpn = 8;
morerotl	incf	rotctr,f
		movlw	zwr
		call	times2		
		movlw   v2
		call	times2		; multiply v2 until
		call	compare		; v2>=v1
		skpZ
		goto 	v1_le_v2
		skpC
		goto 	morerotl
		movlw	v2
		call	div2
		movlw	zwr
		call	div2
		decf	rotctr,f
v1_le_v2	call	compare		;v1<=v2
		skpZ
		goto	next_input
		skpC
		goto	next_input
		BSF	result_longint,0;
					;result:=result *2;
next_input	movlw	zwr		;(v1):=(v1)-zwr
		movwf	v2
		call	sub
					; zwr:=zwr div2
					;v2:=v2 div2
		decfsz	divctr
		goto v1_le_v2
		RETURN

RESET0		MOVLW	B'00000111'	;Disable Comparator module's
		MOVWF	CMCON
		;
		BSF	STATUS,RP0	;Switch to register bank 1
					;Disable pull-ups
					;INT on rising edge
					;TMR0 to CLKOUT
					;TMR0 Incr low2high trans.
					;Prescaler assign to Timer0
					;Prescaler rate is 1:32
		MOVLW	B'11010100'	;Set PIC options (See datasheet).
		MOVWF	OPTION_REG	;Write the OPTION register.
		;
		CLRF	INTCON		;Disable interrupts
		MOVLW	B'11000000'
		MOVWF	TRISB		;RB7 & RB6 are inputs.
					;RB5...RB0 are outputs.
		MOVLW	B'11111111'	;all RA ports are inputs
		MOVWF	TRISA
		BCF	STATUS,RP0	;Switch Back to reg. Bank 0
		MOVLW	B'00001100'     ;Use PORTB in 'sink' mode
		MOVWF   PORTB		; so high is off , lo is on
					;using PB2 + 3
		call	initiate	;initiate variables
RESET		movlw	heapptr
		movwf	FSR
		incf	INDF,f
		incf	heapptr
		movlw	ram0_length-0x08; maxavail
		movwf	INDF	
		incf	FSR
		clrf	INDF		; last sector
main_loop	movlw	.4
		movwf	x+06h
		movlw	.2
		movwf	y+06h			
		movlw	x
		movwf	v1
		movlw	y
		movwf	v2
		call	divide

		call	compare
		goto main_loop
		END
